/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.security.trust.TrustInternalDB;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class CleanTrustedCodeDBTask
implements Job {
    @Autowired
    private TrustInternalDB trustInternalDB;

    public CleanTrustedCodeDBTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            this.trustInternalDB.cleanupOldEntries(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(365L));
        }
        catch (SQLException e) {
            throw new JobExecutionException("Cleanup failed", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

