/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.activity.GitCommitsAnalyzer;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class GitCommitsAnalysisTask
implements Job {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.maint.git");

    public GitCommitsAnalysisTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            List<String> pkeys;
            logger.info((Object)"Collecting stats about last Git commits");
            try (Transaction t = this.transactionService.beginRead();){
                pkeys = this.projectsService.listProjectKeys();
            }
            GitCommitsAnalyzer analyzer = new GitCommitsAnalyzer();
            ArrayList<Exception> commitExceptions = new ArrayList<Exception>();
            for (String pkey : pkeys) {
                logger.infoV("Updating commits analysis for %s", new Object[]{pkey});
                try {
                    analyzer.updateProjectAnalysis(pkey);
                }
                catch (Exception e) {
                    logger.error((Object)("Git GC for project " + String.valueOf(pkeys) + " failed"), (Throwable)e);
                    commitExceptions.add(e);
                }
            }
            if (!commitExceptions.isEmpty()) {
                throw (Exception)commitExceptions.get(0);
            }
        }
        catch (Exception e) {
            throw new JobExecutionException("Git GC failed", (Throwable)e);
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

