/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedManagedFolderDAO
extends AbstractStandardDAO<ManagedFolder>
implements ManagedFolderDAO {
    @Autowired
    private FlowGraphService graphService;

    @Override
    public String getHumanReadableType() {
        return ITaggingService.TaggableType.MANAGED_FOLDER.toHumanReadableString();
    }

    public static boolean looksLikeAManagedFolderId(String name) {
        return name.length() == 8 || name.startsWith("v17conversion_");
    }

    @Override
    protected List<ManagedFolder> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile managedFoldersFolder = this.managedFoldersFolder(projectKey);
        ArrayList<ManagedFolder> ret = new ArrayList<ManagedFolder>();
        if (tr.isDirectory(managedFoldersFolder)) {
            for (RelFile f : tr.listFiles(managedFoldersFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    ManagedFolder mf = this.getOrNull_noTag(projectKey, id, unsafe);
                    if (mf == null) continue;
                    ret.add(mf);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Error in managed folder file:" + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isDirectory(rf = this.managedFoldersFolder(projectKey))) {
            return 0;
        }
        return tr.listFiles(rf, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    protected ManagedFolder getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        ManagedFolder ret = unsafe ? (ManagedFolder)tr.readObjectUnsafe(rf, ManagedFolder.class) : (ManagedFolder)tr.readObject(rf, ManagedFolder.class);
        ret.id = id;
        ret.projectKey = projectKey;
        return ret;
    }

    @Override
    public void save(ManagedFolder f) throws IOException {
        this.graphService.invalidateCache();
        super.save(f);
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        this.graphService.invalidateCache();
        tr.deleteFile(this.getDAOFile(projectKey, id));
    }

    private RelFile managedFoldersFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "managed_folders"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Managed folder id is not specified");
        return new RelFile(this.managedFoldersFolder(projectKey), new String[]{id + ".json"});
    }
}

