/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagedFolderCopier {
    @Autowired
    private FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.folders.copy");

    public ManagedFolderCopier() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public FutureResponse<List<FSPath>> startCopy_NT(DSSAuthCtx authCtx, String sourceFullId, String targetFullId, Output.WriteMode writeMode) throws Exception {
        CopyThread ct = new CopyThread(authCtx, DatasetLocUtils.DatasetLoc.resolveFull(sourceFullId), DatasetLocUtils.DatasetLoc.resolveFull(targetFullId), writeMode);
        return this.futureService.runFuture(ct, 0L, new TypeToken<FutureResponse<List<FSPath>>>(){});
    }

    static class CopyThread
    extends SimpleFutureThread<List<FSPath>> {
        private AnyLoc sourceLoc;
        private AnyLoc targetLoc;
        private Output.WriteMode writeMode;
        private FuturePayload futurePayload;

        public CopyThread(AuthCtx owner, AnyLoc sourceLoc, AnyLoc targetLoc, Output.WriteMode writeMode) {
            super(owner);
            this.sourceLoc = sourceLoc;
            this.targetLoc = targetLoc;
            this.writeMode = writeMode;
        }

        @Override
        protected List<FSPath> compute() throws Exception {
            ArrayList copied;
            block45: {
                ManagedFolder target;
                ManagedFolder source;
                ManagedFolderDAO dao = (ManagedFolderDAO)SpringUtils.getBean(ManagedFolderDAO.class);
                TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = ts.beginRead();){
                    source = (ManagedFolder)dao.getMandatory(this.sourceLoc);
                    target = (ManagedFolder)dao.getMandatory(this.targetLoc);
                }
                logger.info((Object)("Starting folder copy from " + String.valueOf(this.sourceLoc) + " to " + String.valueOf(this.targetLoc) + " mode = " + String.valueOf(this.writeMode)));
                if (this.writeMode == Output.WriteMode.OVERWRITE) {
                    try (ManagedFolderHandler targetHandler = (ManagedFolderHandler)target.buildHandler(this.owner);){
                        targetHandler.clear();
                    }
                }
                copied = Lists.newArrayList();
                try (ManagedFolderHandler sourceHandler = (ManagedFolderHandler)source.buildHandler(this.owner);
                     ManagedFolderHandler targetHandler = (ManagedFolderHandler)target.buildHandler(this.owner);){
                    FSProvider targetProvider = targetHandler.getProvider();
                    FSProvider sourceProvider = sourceHandler.getProvider();
                    FSEnumerationResult toCopy = sourceProvider.enumerateRecursive("/", new FSEnumerationSettings());
                    if (!toCopy.isSuccessful()) {
                        if (toCopy.getError() != null) {
                            throw new Exception("Cannot list files of source folder", toCopy.getError());
                        }
                        if (!toCopy.enumerationPrefixExists()) {
                            logger.info((Object)"Source folder is empty");
                            break block45;
                        }
                        throw new Exception("Cannot list source folder (no error)");
                    }
                    targetHandler.grantFullACLs();
                    if ("HDFS".equals(target.getType())) {
                        new HDFSPermissionsHandler(targetHandler).setGatewayACLCreate(this.owner);
                    }
                    for (FSPath path : toCopy.getPaths()) {
                        String sourcePath = path.path();
                        String targetPath = path.path();
                        if (targetProvider.stat(targetPath) != null) {
                            targetPath = this.suffixToUnicize(targetProvider, targetPath);
                        }
                        try (InputStream iStream = sourceProvider.read(sourcePath).rawStream();
                             OutputStream oStream = targetProvider.write(targetPath);){
                            logger.info((Object)("Copying " + JSON.log((Object)path)));
                            DKUIOUtils.copyLarge(iStream, oStream, null);
                        }
                        copied.add(path);
                    }
                }
            }
            return copied;
        }

        private String suffixToUnicize(FSProvider targetProvider, String targetPath) throws IOException, CodedException, DKUSecurityException {
            Pattern extendedCompressed = Pattern.compile("^(.*)\\.([^.]+)\\.(zip|gz|bz|bz2|deflate|snappy|lzo)$", 2);
            Pattern extended = Pattern.compile("^(.*)\\.([^.]+)$", 2);
            Matcher extendedCompressedMatcher = extendedCompressed.matcher((CharSequence)targetPath);
            Matcher extendedMatcher = extended.matcher((CharSequence)targetPath);
            Object suffix = extendedCompressedMatcher.matches() ? "." + extendedCompressedMatcher.group(2) + "." + extendedCompressedMatcher.group(3) : (extendedMatcher.matches() ? "." + extendedMatcher.group(2) : "");
            String base = ((String)targetPath).substring(0, ((String)targetPath).length() - ((String)suffix).length());
            int no = 0;
            while (targetProvider.stat((String)(targetPath = base + "_" + ++no + (String)suffix)) != null) {
            }
            return targetPath;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        static {
            JSON.registerAdapter(CopyThread.class, (Object)new JSON.Adapter<CopyThread>(){

                public CopyThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    AnyLoc sourceLoc = (AnyLoc)ctx.deserialize(jsonObj.get("sourceLoc"), AnyLoc.class);
                    AnyLoc targetLoc = (AnyLoc)ctx.deserialize(jsonObj.get("targetLoc"), AnyLoc.class);
                    Output.WriteMode writeMode = (Output.WriteMode)ctx.deserialize(jsonObj.get("writeMode"), Output.WriteMode.class);
                    CopyThread ft = new CopyThread(owner, sourceLoc, targetLoc, writeMode);
                    return ft;
                }

                public JsonElement serialize(CopyThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.add("sourceLoc", ctx.serialize((Object)ft.sourceLoc));
                    ret.add("targetLoc", ctx.serialize((Object)ft.targetLoc));
                    ret.add("writeMode", ctx.serialize((Object)ft.writeMode));
                    return ret;
                }
            });
        }
    }
}

