/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.mec.ModelEvaluationStoreHandler;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class ModelEvaluationStore
extends TaggableObjectsService.TaggableObject
implements Partitionable {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public SerializedDataset.RebuildBehavior rebuildBehavior = SerializedDataset.RebuildBehavior.EXPLICIT;
    public String name;
    public ProbesSet metrics;
    public ChecksSet metricsChecks;
    @Nonnull
    public ModelEvaluationStoreFlavor mesFlavor = ModelEvaluationStoreFlavor.TABULAR;
    public SerializedDataset.FlowOptions flowOptions = new SerializedDataset.FlowOptions();
    public PartitioningScheme partitioning = new PartitioningScheme();
    public DisplayParams displayParams = new DisplayParams();
    public boolean governSyncOptOut = false;
    public String governTimestampLabel;

    public ModelEvaluationStore() {
    }

    public ModelEvaluationStore(String projectKey, ModelEvaluationStoreFlavor mesFlavor) {
        this.projectKey = projectKey;
        this.mesFlavor = mesFlavor;
        this.id = SecretKeyGenerator.generate((int)8);
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
    }

    public IndexableType getIndexableType() {
        if (this.mesFlavor.isGenAi()) {
            return IndexableType.GENAI_EVALUATION_STORE;
        }
        return IndexableType.MODEL_EVALUATION_STORE;
    }

    @Override
    public String getSubtype() {
        if (this.mesFlavor.isGenAi()) {
            return "genai_evaluation_store";
        }
        return "model_evaluation_store";
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public boolean isPartitioned() {
        return false;
    }

    @Override
    public PartitioningScheme getPartitioningSchema() {
        return this.partitioning;
    }

    @Override
    public SerializedDataset.FlowOptions getFlowOptions() {
        return this.flowOptions;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public PartitionableHandler buildHandler(AuthCtx authCtx) {
        return new ModelEvaluationStoreHandler(this);
    }

    public static enum ModelEvaluationStoreFlavor {
        TABULAR,
        LLM,
        AGENT;


        public boolean isTabular() {
            return this.equals((Object)TABULAR);
        }

        public boolean isGenAi() {
            return this.equals((Object)LLM) || this.equals((Object)AGENT);
        }
    }

    public static class DisplayParams {
        LinkedHashSet<String> displayedMetrics;
        LinkedHashSet<String> allAvailableMetrics;
        String predictionType;
        LinkedHashSet<String> pinnedMetrics = new LinkedHashSet();
        String xLabel;
        List<String> yLabels = new ArrayList<String>();
        List<String> alsoDisplayedLabels = new ArrayList<String>();
        List<String> barLabels;
        GraphStyle graphStyle;
        String sortColumn;
        boolean sortDescending;
        boolean showConfidenceIntervals = true;
        List<String> disabledMERunIds = new ArrayList<String>();
        public String rowByRowShakerScript;
        public List<String> rowByRowAdditionalColumns;
    }

    public static enum GraphStyle {
        BAR,
        LINE;

    }

    public static class ModelEvaluationStoreListItem
    extends TaggableObjectsService.TaggableListItem {
        public long evaluationCount = 0L;
        public ModelEvaluationStoreFlavor mesFlavor;

        public ModelEvaluationStoreListItem(ModelEvaluationStore mes) {
            super(mes);
            this.mesFlavor = mes.mesFlavor;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
        }
    }
}

