/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.drift;

import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class TextDriftResult {
    public Map<String, EmbeddingDriftMetrics> columns = new HashMap<String, EmbeddingDriftMetrics>();
    @Nullable
    public SampleSize sampleSize;

    public void populateMetrics(PredictionModelPerformanceMetrics metrics) {
        if (metrics.euclidianDistancePerFeature == null) {
            metrics.euclidianDistancePerFeature = new HashMap<String, Double>();
        }
        if (metrics.cosineSimilarityPerFeature == null) {
            metrics.cosineSimilarityPerFeature = new HashMap<String, Double>();
        }
        if (metrics.classifierGiniPerFeature == null) {
            metrics.classifierGiniPerFeature = new HashMap<String, Double>();
        }
        this.columns.forEach((column, drift) -> {
            metrics.euclidianDistancePerFeature.put((String)column, drift.euclidianDistance);
            metrics.cosineSimilarityPerFeature.put((String)column, drift.cosineSimilarity);
            metrics.classifierGiniPerFeature.put((String)column, drift.classifierGini);
        });
    }

    public static class EmbeddingDriftMetrics {
        @Nullable
        Double euclidianDistance;
        @Nullable
        Double cosineSimilarity;
        @Nullable
        Double classifierGini;
    }

    public static class SampleSize {
        @Nullable
        public int referenceClassifierSampleSize;
        @Nullable
        public int currentClassifierSampleSize;
    }
}

