/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.codahale.metrics.graphite.Graphite;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.CustomMetricFailure;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.CustomMetricSuccess;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MulticlassModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.exceptions.ExceptionWithSerializedThrowable;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.mec.AgentEvaluationMetrics;
import com.dataiku.dip.mec.LLMEvaluationMetrics;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricCodes;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.ManagedFolderCheckContext;
import com.dataiku.dip.metrics.checks.ModelEvaluationCheckContext;
import com.dataiku.dip.metrics.checks.SavedModelVersionCheckContext;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.AgentEvaluationProbeType;
import com.dataiku.dip.metrics.probes.CheckProbeType;
import com.dataiku.dip.metrics.probes.LLMEvaluationProbeType;
import com.dataiku.dip.metrics.probes.ModelPerformanceProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.metrics.probes.ReportingProbeType;
import com.dataiku.dip.metrics.probes.TemporaryMetric;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.MesChecksRunCompletedEvent;
import com.dataiku.dip.server.services.GraphiteReportingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.AbstractValuedCheck;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsComputationService {
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private IBasicMeaningsService basicMeaningsService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.metrics.computations");

    public Map<String, ProbeType> getBuiltinsProbes() {
        return ProbeType.list();
    }

    public static void registerAdapters() {
        Metric.registerJsonAdapters();
        Probe.registerJsonAdapters();
        Check.registerJsonAdapters();
    }

    private DatasetLocUtils.DatasetLoc getObjectLoc(Object object, MetricTargetType objectType) {
        switch (objectType) {
            case DATASET: {
                return ((Dataset)object).getDatasetLoc();
            }
            case MANAGED_FOLDER: {
                return new DatasetLocUtils.DatasetLoc(((ManagedFolder)object).projectKey, ((ManagedFolder)object).id);
            }
            case SAVED_MODEL: {
                return new DatasetLocUtils.DatasetLoc(((SavedModel)object).projectKey, ((SavedModel)object).id);
            }
            case MODEL_EVALUATION_STORE: {
                return new DatasetLocUtils.DatasetLoc(((ModelEvaluationStore)object).projectKey, ((ModelEvaluationStore)object).id);
            }
            case PROJECT: {
                return new DatasetLocUtils.DatasetLoc(((SerializedProject)object).projectKey, null);
            }
        }
        throw new IllegalArgumentException("Unknown object type " + String.valueOf((Object)objectType));
    }

    public List<MetricsEngineRun> computePlan(String projectKey, AuthCtx authCtx, Object object, MetricTargetType objectType, ProbesSet metrics) throws Exception {
        MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(authCtx);
        context.clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
        return this.buildPlan(authCtx, object, objectType, null, metrics, false, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsComputationReport computeMetrics(AuthCtx authCtx, Object object, MetricTargetType objectType, Partition partition, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationEnvironment environment) throws Exception {
        HashMap metricsValues;
        MetricsComputationReport report;
        DateTime startTime;
        block63: {
            String projectKey;
            String objectDesc;
            String datasetName = null;
            switch (objectType) {
                case DATASET: {
                    objectDesc = ((Dataset)object).getFullName();
                    projectKey = ((Dataset)object).getProjectKey();
                    datasetName = ((Dataset)object).getName();
                    break;
                }
                case MANAGED_FOLDER: {
                    objectDesc = ((ManagedFolder)object).getFullId();
                    projectKey = ((ManagedFolder)object).getProjectKey();
                    break;
                }
                case SAVED_MODEL: {
                    objectDesc = ((SavedModel)object).getFullId();
                    projectKey = ((SavedModel)object).getProjectKey();
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    objectDesc = ((ModelEvaluationStore)object).getFullId();
                    projectKey = ((ModelEvaluationStore)object).getProjectKey();
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
            ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forMetrics((AuthCtx)authCtx, (String)projectKey, (String)datasetName);
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            boolean fullDataset = MetricsComputationService.isFullDataset(object, partition);
            logger.info((Object)("Compute metrics on " + String.valueOf(partition) + (fullDataset ? " (full dataset)" : "")));
            startTime = DateTime.now();
            report = new MetricsComputationReport();
            report.partition = partition != null ? partition.id() : null;
            report.startTime = startTime.getMillis();
            context.clusterSettings = new ClusterSelector().selectForProject(authCtx, projectKey);
            List<MetricsEngineRun> engineRuns = this.buildPlan(authCtx, object, objectType, partition, metrics, fullDataset, environment.startedFromBuild, context);
            APITicketService.Ticket ticket = this.apiTicketService.createTicket(authCtx, "metrics:" + String.valueOf((Object)objectType) + "." + objectDesc, object);
            metricsValues = Maps.newHashMap();
            HashMap alreadyComputed = Maps.newHashMap();
            try {
                FutureProgress.AutocloseableFutureProgressState afp;
                if (objectType == MetricTargetType.DATASET) {
                    Dataset dataset = (Dataset)object;
                    try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
                        afp = FutureProgress.pushAutoCloseableState((String)"Running metrics engines", (double)engineRuns.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                        try {
                            for (MetricsEngineRun engineRun : engineRuns) {
                                logger.info((Object)("Running metric run: " + engineRun.engine.getType()));
                                try (FutureProgress.AutocloseableFutureProgressState runAfp = FutureProgress.pushAutoCloseableState((String)engineRun.getProgressName(), (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                                    MetricsEngineRunReport runReport = new MetricsEngineRunReport(engineRun.engine.getType());
                                    try {
                                        MetricsEngine engine = engineRun.getEngine().build(engineRun, dataset, datasetHandler, partition, metrics.getEngineConfig(), ticket, context);
                                        Map<Metric, String> newMetricsValues = engine.compute(engineRun.getComputations(), runReport, this.futureService, authCtx, alreadyComputed);
                                        metricsValues.putAll(newMetricsValues);
                                        for (Map.Entry<Metric, String> newMetricValue : newMetricsValues.entrySet()) {
                                            alreadyComputed.put(newMetricValue.getKey().getId(), newMetricValue.getValue());
                                        }
                                    }
                                    catch (InterruptedException ex) {
                                        logger.info((Object)"Metrics engine run aborted", (Throwable)ex);
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                        logger.error((Object)"Metrics engine run failure, skipping.", (Throwable)ex);
                                        runReport.handleException(ex);
                                    }
                                    report.runs.add(runReport);
                                }
                                afp.increment(1.0);
                            }
                            break block63;
                        }
                        finally {
                            if (afp != null) {
                                afp.close();
                            }
                        }
                    }
                }
                if (objectType != MetricTargetType.MANAGED_FOLDER) break block63;
                ManagedFolder folder = (ManagedFolder)object;
                try (ManagedFolderHandler folderHandler = (ManagedFolderHandler)folder.buildHandler(authCtx);){
                    afp = FutureProgress.pushAutoCloseableState((String)"Running metrics engines", (double)engineRuns.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        for (MetricsEngineRun engineRun : engineRuns) {
                            try (FutureProgress.AutocloseableFutureProgressState runAfp = FutureProgress.pushAutoCloseableState((String)engineRun.getProgressName(), (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                                MetricsEngineRunReport runReport = new MetricsEngineRunReport(engineRun.engine.getType());
                                try {
                                    MetricsEngine engine = engineRun.getEngine().build(engineRun, folder, folderHandler, partition, metrics.getEngineConfig(), ticket, context);
                                    Map<Metric, String> newMetricsValues = engine.compute(engineRun.getComputations(), runReport, this.futureService, authCtx, alreadyComputed);
                                    metricsValues.putAll(newMetricsValues);
                                    for (Map.Entry<Metric, String> newMetricValue : newMetricsValues.entrySet()) {
                                        alreadyComputed.put(newMetricValue.getKey().getId(), newMetricValue.getValue());
                                    }
                                }
                                catch (InterruptedException ex) {
                                    logger.info((Object)"Metrics engine run aborted", (Throwable)ex);
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    logger.error((Object)"Metrics engine run failure, skipping.", (Throwable)ex);
                                    runReport.handleException(ex);
                                }
                                report.runs.add(runReport);
                            }
                            afp.increment(1.0);
                        }
                    }
                    finally {
                        if (afp != null) {
                            afp.close();
                        }
                    }
                }
            }
            finally {
                this.apiTicketService.expireTicket(ticket);
            }
        }
        try (FutureProgress.AutocloseableFutureProgressState afp = FutureProgress.pushAutoCloseableState((String)"Saving metrics", (double)0.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            DateTime endTime = DateTime.now();
            report.endTime = endTime.getMillis();
            String duration = Long.toString(endTime.getMillis() - startTime.getMillis());
            ReportingProbeType.ReportingMetric reportingMetric = new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.METRICS_COMPUTATION_DURATION);
            metricsValues.put(reportingMetric, duration);
            this.saveMetricsValues(authCtx, object, objectType, partition, startTime, metricsValues, environment);
            report.computed = metricsValues.entrySet().stream().map(a -> new ValuedMetric((Metric)a.getKey(), (String)a.getValue())).collect(Collectors.toList());
        }
        return report;
    }

    public void saveChecksValues(String projectKey, String objectId, Partition partition, DateTime computed, Map<? extends DataQualityRule, AbstractCheckContext.CheckResult> checksValues, DataQualityRunOrigin runOrigin) throws SQLException {
        logger.info((Object)("Saving " + checksValues.size() + " checks results on " + projectKey + "." + objectId + " (partition " + String.valueOf(partition) + ")"));
        this.jobsDatabaseService.saveChecks(projectKey, objectId, partition == null ? null : partition.id(), computed.getMillis(), checksValues, runOrigin);
        checksValues.entrySet().stream().filter(e -> ((AbstractCheckContext.CheckResult)e.getValue()).isError()).forEach(e -> logger.error((Object)String.format("Saving check %s with KO status : %s ", ((DataQualityRule)e.getKey()).getId(), ((AbstractCheckContext.CheckResult)e.getValue()).message)));
        checksValues.entrySet().stream().filter(e -> ((AbstractCheckContext.CheckResult)e.getValue()).isWarning()).forEach(e -> logger.warn((Object)String.format("Saving check %s with WARNING status : %s ", ((DataQualityRule)e.getKey()).getId(), ((AbstractCheckContext.CheckResult)e.getValue()).message)));
    }

    public void saveMetricsValues(AuthCtx authCtx, Object object, MetricTargetType objectType, Partition partition, DateTime computed, Map<Metric, String> metricsValues, MetricsComputationEnvironment environment) throws Exception {
        this.saveMetricsValues(authCtx, object, objectType, partition, computed, metricsValues, environment, true);
    }

    /*
     * Unable to fully structure code
     */
    public void saveMetricsValues(AuthCtx authCtx, Object object, MetricTargetType objectType, Partition partition, DateTime computed, Map<Metric, String> metricsValues, MetricsComputationEnvironment environment, boolean logValues) throws Exception {
        if (environment.doNotSaveMetricValues) {
            return;
        }
        toSave = new TreeMap<Metric, String>(Comparator.comparing((Function<Metric, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/dataiku/dip/metrics/Metric;)Ljava/lang/String;)()));
        for (Map.Entry<Metric, String> metricValue : metricsValues.entrySet()) {
            metric = metricValue.getKey();
            if (!metric.shouldBeSaved()) continue;
            toSave.put(metric, metricValue.getValue());
        }
        hashComputer = new ComputableHashComputer(authCtx);
        hashComputer.allowUseOfSession();
        hashComputer.setAlwaysConsiderReadyAndOnlyAccessDataIfAContentHashCanBeProvided();
        conn = this.flowStateInternalDB.acquireConnection();
        try {
            switch (2.$SwitchMap$com$dataiku$dip$metrics$MetricTargetType[objectType.ordinal()]) {
                case 1: {
                    ds = (Dataset)object;
                    cruContext = ComputeResourceUsageContext.forMetrics((AuthCtx)authCtx, (String)ds.getProjectKey(), (String)ds.getName());
                    CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
                    hash = hashComputer.getCurrentContentHash((DSSDBConnection)conn, (Dataset)ds, (Partition)partition).hash;
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 2: {
                    hash = hashComputer.getCurrentContentHash((ManagedFolder)((ManagedFolder)object), (Partition)partition).hash;
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 3: {
                    hash = hashComputer.getCurrentContentHash((SavedModel)((SavedModel)object)).hash;
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 4: {
                    hash = hashComputer.getCurrentContentHash((ModelEvaluationStore)((ModelEvaluationStore)object)).hash;
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 5: {
                    ss = (SerializedProject)JSON.deepCopy((Object)((SerializedProject)object));
                    ss.tags = null;
                    ss.description = null;
                    hash = DKUtils.md5Base64((String)JSON.json((Object)ss));
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        objectLoc = this.getObjectLoc(object, objectType);
        if (logValues) {
            firstMetricsSavedDebugMessage = (toSave.size() > 5 ? "first 5: " : "") + toSave.entrySet().stream().limit(5L).map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$saveMetricsValues$5(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).collect(Collectors.joining(","));
            MetricsComputationService.logger.info((Object)("Saving " + toSave.size() + " metrics values on " + objectLoc.getFullName() + " (partition " + String.valueOf(partition) + "): " + firstMetricsSavedDebugMessage));
        }
        this.jobsDatabaseService.saveMetrics(objectLoc, partition == null ? null : partition.id(), computed.getMillis(), hash, toSave);
        if (StringUtils.isNotBlank((String)environment.graphiteServerUrl)) {
            graphitePrefix = GraphiteReportingService.getPrefix((String)environment.graphiteMetricPrefix);
            hostPort = GraphiteReportingService.getUrl((String)environment.graphiteServerUrl);
            if (StringUtils.isNotBlank((String)((String)hostPort.first))) {
                ft = new SendMetricsToGraphiteThread(authCtx, computed, metricsValues, objectLoc, partition, graphitePrefix, (Pair<String, Integer>)hostPort, environment.graphiteServerUrl);
                fr = this.futureService.runFuture(ft, 200L, new TypeToken<FutureResponse<Void>>(){});
                if (!fr.hasResult) {
                    MetricsComputationService.logger.info((Object)"Sending metrics to Graphite not finished after 200ms, continuing asynchronously");
                }
            }
        }
    }

    private List<MetricsEngineRun> buildPlan(AuthCtx authCtx, Object object, MetricTargetType objectType, Partition partition, ProbesSet metrics, boolean fullDataset, boolean startedFromBuild, MetricsEngineDesc.MetricsEngineContext context) throws Exception {
        logger.info((Object)("Plan metrics computations on " + this.getObjectLoc(object, objectType).getFullName() + " (full=" + fullDataset + ")"));
        boolean verbose = DKUApp.getParams().getBoolParam("dip.metrics.planning.verbose", false);
        MetricsEngineDesc.MetricsEngineGeneralSettings settings = new MetricsEngineDesc.MetricsEngineGeneralSettings();
        ClusterSettings cluster = context.clusterSettings;
        settings.hiveEnabled = HiveConfigurator.isHiveInstalled() && cluster.getHiveSettings().enabled;
        settings.impalaEnabled = cluster.getImpalaSettings().enabled;
        boolean bl = settings.sparkEnabled = cluster.getSparkSettings().interactiveExecutionEngine != null;
        if (settings.couldUseHiveMetastore() && objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            if (DatasetInspector.canHDFS(dataset)) {
                HDFSDatasetHandler.Config params = dataset.getParamsAs(HDFSDatasetHandler.Config.class);
                if (!params.metastoreSynchronizationEnabled) {
                    logger.info((Object)"Dataset is not synchronized with Hive metastore, deactivating Hive and Impala engines");
                    settings.hiveEnabled = false;
                    settings.impalaEnabled = false;
                }
            }
            if (!DatasetInspector.isMetastoreAssociatedType(dataset)) {
                settings.sparkEnabled = false;
            }
            if (dataset.getSchema().getColumns().stream().anyMatch(sc -> sc.getType().isGeo())) {
                logger.info((Object)"Can't use spark because dataset contains geopoint or geometry columns");
                settings.sparkEnabled = false;
            }
        }
        Set<MetricsEngineDesc> availableEngines = MetricsEngineDesc.getAvailableEngines(settings, metrics.engineConfig);
        logger.trace((Object)("Building plan for metrics on engines: " + availableEngines.stream().map(MetricsEngineDesc::getType).collect(Collectors.joining(", "))));
        logger.trace(() -> "ProbesSet to compute: " + JSON.prettyLog((Object)metrics));
        Map<String, ProbeType> probeTypes = this.getBuiltinsProbes();
        HashMap computersByProbeType = Maps.newHashMap();
        for (Map.Entry<String, ProbeType> probeType : probeTypes.entrySet()) {
            computersByProbeType.put(probeType.getKey(), probeType.getValue().getComputers(this.basicMeaningsService));
        }
        HashMap computationsByEngine = Maps.newHashMap();
        HashSet metricsToCompute = Sets.newHashSet();
        HashMap requestedProbeByType = Maps.newHashMap();
        HashSet existingMetricIds = Sets.newHashSet();
        for (Probe probe : metrics.getProbes()) {
            ProbeType probeType = ProbeType.getProbeType(probe.getType());
            if (probeType == null) {
                logger.warn((Object)("Unknown probe " + probe.getType() + ". Skipping the probe."));
                continue;
            }
            if (startedFromBuild) {
                if (probe.computeOnBuildMode == Probe.ComputeMode.NO) {
                    logger.traceV("Probe %s not run on builds", new Object[]{probe.type});
                    continue;
                }
                if (fullDataset && !probe.computeOnBuildMode.includesALL()) {
                    logger.traceV("Probe %s does not include Whole dataset", new Object[]{probe.type});
                    continue;
                }
                if (!fullDataset && !probe.computeOnBuildMode.includesPartition()) {
                    logger.traceV("Probe %s does not include partition", new Object[]{probe.type});
                    continue;
                }
            }
            if (!probe.isEnabled()) {
                logger.traceV("Probe %s is not active", new Object[]{probe.type});
                continue;
            }
            requestedProbeByType.put(probeType.getType(), probe);
            for (Metric metric : probeType.getMetricsToCompute(probe, object, objectType, false)) {
                List possibleComputers;
                if (existingMetricIds.contains(metric.getId())) continue;
                existingMetricIds.add(metric.getId());
                boolean bl2 = false;
                List list = possibleComputers = metric instanceof TemporaryMetric ? ((TemporaryMetric)metric).getComputers() : (List)computersByProbeType.get(metric.getType());
                if (possibleComputers != null) {
                    for (Object computer : possibleComputers) {
                        MetricsEngineRun computationRun;
                        if (!availableEngines.contains(((MetricComputer)computer).getEngine()) || (computationRun = ((MetricComputer)computer).handles(authCtx, probe, metric, object, objectType, partition)) == null || computationRun.getComputations().isEmpty()) continue;
                        MetricsEngineDesc metricsEngineDesc = ((MetricComputer)computer).getEngine();
                        if (!computationsByEngine.containsKey(metricsEngineDesc)) {
                            computationsByEngine.put(metricsEngineDesc, new ArrayList());
                        }
                        ((List)computationsByEngine.get(metricsEngineDesc)).add(computationRun);
                        bl2 = true;
                    }
                }
                if (bl2) {
                    metricsToCompute.add(metric);
                    continue;
                }
                logger.warn((Object)("No registered computer for metric '" + probe.getType() + "' can handle this type of dataset. Skipping metric."));
            }
        }
        logger.trace((Object)("Found " + metricsToCompute.size() + " metrics to compute"));
        HashMap extraMetrics = Maps.newHashMap();
        if (metrics.engineConfig.padRunsWithMetrics) {
            for (ProbeType probeType : probeTypes.values()) {
                Probe probe = (Probe)requestedProbeByType.get(probeType.getType());
                if (probe == null) continue;
                for (Metric metric : probeType.listBuildableMetrics(object, objectType)) {
                    if (existingMetricIds.contains(metric.getId())) continue;
                    extraMetrics.put(metric.getId(), metric);
                }
            }
        }
        HashMap hashMap = Maps.newHashMap();
        HashSet extraMetricsToCompute = Sets.newHashSet();
        for (Metric metric : extraMetrics.values()) {
            Probe probe = (Probe)requestedProbeByType.get(metric.getType());
            if (probe == null) continue;
            boolean canBeComputed = false;
            List possibleComputers = (List)computersByProbeType.get(metric.getType());
            for (MetricComputer computer : possibleComputers) {
                MetricsEngineRun metricsEngineRun = computer.handles(authCtx, probe, metric, object, objectType, partition);
                if (metricsEngineRun == null) continue;
                MetricsEngineDesc engine = computer.getEngine();
                if (!hashMap.containsKey(engine)) {
                    hashMap.put(engine, new ArrayList());
                }
                ((List)hashMap.get(engine)).add(metricsEngineRun);
                canBeComputed = true;
            }
            if (!canBeComputed) continue;
            extraMetricsToCompute.add(metric);
        }
        logger.trace((Object)("Found " + extraMetricsToCompute.size() + " extra metrics to compute"));
        ArrayList possibleEngineRuns = Lists.newArrayList();
        for (Map.Entry entry : computationsByEngine.entrySet()) {
            ArrayList possibleEngineRunsForEngine = Lists.newArrayList();
            List computations = (List)entry.getValue();
            for (MetricsEngineRun computation2 : computations) {
                int n = -1;
                for (int i = 0; i < possibleEngineRunsForEngine.size(); ++i) {
                    if (!((MetricsEngineRun)possibleEngineRunsForEngine.get(i)).canMergeWith(computation2)) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    possibleEngineRunsForEngine.add(computation2);
                    continue;
                }
                possibleEngineRunsForEngine.set(n, ((MetricsEngineRun)possibleEngineRunsForEngine.get(n)).mergeWith(computation2));
            }
            possibleEngineRuns.addAll(possibleEngineRunsForEngine);
        }
        if (verbose) {
            logger.info((Object)"Metrics grouped by run");
            for (MetricsEngineRun metricsEngineRun : possibleEngineRuns) {
                String summary = metricsEngineRun.getComputations().stream().map(computation -> computation.metric.getId()).collect(Collectors.joining(", "));
                logger.info((Object)("> type=" + metricsEngineRun.engineType + " pass=" + metricsEngineRun.pass + " cost=" + metricsEngineRun.cost + " nbComputations=" + metricsEngineRun.getComputations().size() + " object=" + String.valueOf(metricsEngineRun) + "metrics=" + summary));
            }
        }
        logger.debugV("Computing %d+%d metrics", new Object[]{metricsToCompute.size(), extraMetricsToCompute.size()});
        ArrayList arrayList = Lists.newArrayList();
        while (!metricsToCompute.isEmpty()) {
            Object run2;
            logger.trace((Object)("Building a run. Still have " + metricsToCompute.size() + " metrics to cover"));
            ArrayList arrayList2 = Lists.newArrayList();
            for (MetricsEngineRun run2 : possibleEngineRuns) {
                MetricsEngineRun trimmedRun = run2.getUsefulPart(metricsToCompute);
                if (trimmedRun == null) continue;
                arrayList2.add(trimmedRun);
            }
            if (arrayList2.isEmpty()) {
                throw new Exception("Could not associate metrics computers to all metrics");
            }
            Collections.sort(arrayList2, (a, b) -> {
                double diff = this.getAmortizedCost((MetricsEngineRun)a) - this.getAmortizedCost((MetricsEngineRun)b);
                return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
            });
            if (verbose) {
                logger.info((Object)"Trimmed and sorted:");
                for (Object run2 : arrayList2) {
                    logger.info((Object)("> type=" + ((MetricsEngineRun)run2).engineType + " pass=" + ((MetricsEngineRun)run2).pass + " cost=" + ((MetricsEngineRun)run2).cost + " nbComputations=" + ((MetricsEngineRun)run2).getComputations().size() + " object=" + String.valueOf(run2)));
                }
            }
            MetricsEngineRun engineRun = (MetricsEngineRun)arrayList2.get(0);
            arrayList.add(engineRun);
            run2 = engineRun.getComputations().iterator();
            while (run2.hasNext()) {
                MetricComputation computation3 = (MetricComputation)run2.next();
                metricsToCompute.remove(computation3.metric);
            }
        }
        for (MetricsEngineRun engineRun : arrayList) {
            List extraComputations = (List)hashMap.get(engineRun.getEngine());
            if (extraComputations == null || extraComputations.isEmpty()) continue;
            logger.info((Object)("Trying to tack on " + extraComputations.size() + " extra computations running on " + engineRun.engine.getType()));
            ArrayList addable = Lists.newArrayList();
            for (MetricsEngineRun metricsEngineRun : extraComputations) {
                if (!engineRun.canAdd(metricsEngineRun)) continue;
                addable.addAll(metricsEngineRun.getComputations());
            }
            logger.info((Object)("Found " + addable.size() + " additions"));
            engineRun.with(addable);
            for (MetricComputation metricComputation : addable) {
                extraMetricsToCompute.remove(metricComputation.metric);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                ArrayList trimmed = Lists.newArrayList();
                List computations = (List)entry.getValue();
                for (MetricsEngineRun computation5 : computations) {
                    if (computation5.getComputations().size() != 1 || !extraMetricsToCompute.contains(computation5.getComputations().get((int)0).metric)) continue;
                    trimmed.add(computation5);
                }
                computations.clear();
                computations.addAll(trimmed);
            }
        }
        Collections.sort(arrayList, Comparator.comparingInt(MetricsEngineRun::getPass));
        logger.info((Object)("Computing metrics in " + arrayList.size() + " runs"));
        for (MetricsEngineRun engineRun : arrayList) {
            logger.info((Object)("Run on " + engineRun.engine.getType() + ": " + engineRun.getComputations().stream().map(computation -> computation.metric.getId()).collect(Collectors.joining(", "))));
        }
        return arrayList;
    }

    private double getAmortizedCost(MetricsEngineRun run) {
        return run.getMaxCost() / (double)run.getComputations().size();
    }

    public static boolean isFullDataset(Object object, Partition partition) {
        if (object instanceof SavedModel) {
            return false;
        }
        if (object instanceof Partitionable) {
            PartitioningScheme scheme = ((Partitionable)object).getPartitioningSchema();
            return scheme != null && scheme.isPartitioned() && partition.isAll();
        }
        return false;
    }

    public static Partition makePartitionFromId(PartitioningScheme scheme, String partitionId) {
        if (scheme == null || !scheme.isPartitioned()) {
            return Partition.newNP();
        }
        if (StringUtils.isBlank((String)partitionId) || partitionId.equals("NP")) {
            return Partition.newALL((PartitioningScheme)scheme);
        }
        if (partitionId.equals("ALL")) {
            return Partition.newALL((PartitioningScheme)scheme);
        }
        return PartitionFactory.fromIdentifier(scheme, partitionId);
    }

    public static Partition fakeSMVersionPartition(String version) {
        PartitioningScheme fakeScheme = new PartitioningScheme();
        fakeScheme.addDimension((Dimension)new ExactValueDimension("version"));
        Partition partition = new Partition(fakeScheme);
        partition.setDimensionValue("version", (DimensionValue)new ExactValueDimensionValue(version));
        return partition;
    }

    public static Partition fakeMEVersionPartition(String evaluationId) {
        PartitioningScheme fakeScheme = new PartitioningScheme();
        fakeScheme.addDimension((Dimension)new ExactValueDimension("evaluationId"));
        Partition partition = new Partition(fakeScheme);
        partition.setDimensionValue("evaluationId", (DimensionValue)new ExactValueDimensionValue(evaluationId));
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCheckReport.MetricsCheckReport checkSavedModelVersion(AuthCtx user, SavedModel sm, String version, ChecksSet checksSet, MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        AbstractCheckReport.MetricsCheckReport report = new AbstractCheckReport.MetricsCheckReport();
        DateTime timeCheck = DateTime.now();
        report.startTime = timeCheck.getMillis();
        if (environment.startedFromBuild && !checksSet.runOnBuild) {
            logger.info((Object)"Checks not run on build");
            return report;
        }
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(user, "checks:SAVED_MODEL." + sm.getFullId(), (Object)sm);
        SavedModelVersionCheckContext context = new SavedModelVersionCheckContext(sm, version, timeCheck.getMillis(), this.jobsDatabaseService, ticket, sm.projectKey);
        try {
            for (Check check : checksSet.checks) {
                MetricsCheckRunReport runReport = new MetricsCheckRunReport(version, check.getId());
                try {
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, check.run(user, context, runReport)));
                }
                catch (Exception ex) {
                    logger.error((Object)"Check failed to run", (Throwable)ex);
                    runReport.handleException(ex);
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, ex.getLocalizedMessage())));
                }
                report.runs.add(runReport);
            }
            logger.info((Object)("Collected " + report.results.size() + " check results"));
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
        }
        HashMap trimmedResults = Maps.newHashMap();
        for (AbstractValuedCheck.ValuedCheck checkResult : report.results) {
            trimmedResults.put(checkResult.check.trimForSave(), checkResult.value);
        }
        this.saveChecksValues(sm.projectKey, sm.id, MetricsComputationService.fakeSMVersionPartition(version), timeCheck, trimmedResults, runOrigin);
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry checkResult : trimmedResults.entrySet()) {
            Check check = (Check)checkResult.getKey();
            CheckProbeType.CheckMetric metric = new CheckProbeType.CheckMetric(CheckProbeType.CheckMetrics.CHECK, check.getId());
            hashMap.put(metric, ((AbstractCheckContext.CheckResult)checkResult.getValue()).outcome.name());
        }
        this.saveMetricsValues(user, sm, MetricTargetType.SAVED_MODEL, MetricsComputationService.fakeSMVersionPartition(version), timeCheck, hashMap, environment, false);
        report.endTime = DateTime.now().getMillis();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCheckReport.MetricsCheckReport checkModelEvaluation(AuthCtx user, ModelEvaluationStore mes, String evaluationId, ChecksSet checksSet, MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        AbstractCheckReport.MetricsCheckReport report = new AbstractCheckReport.MetricsCheckReport();
        DateTime timeCheck = DateTime.now();
        report.startTime = timeCheck.getMillis();
        if (environment.startedFromBuild && !checksSet.runOnBuild) {
            logger.info((Object)"Checks not run on build");
            return report;
        }
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(user, "checks:MODEL_EVALUATION_STORE." + mes.getFullId(), (Object)mes);
        ModelEvaluationCheckContext context = new ModelEvaluationCheckContext(mes, evaluationId, timeCheck.getMillis(), this.jobsDatabaseService, ticket, mes.projectKey);
        try {
            for (Check check : checksSet.checks) {
                MetricsCheckRunReport runReport = new MetricsCheckRunReport(evaluationId, check.getId());
                try {
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, check.run(user, context, runReport)));
                }
                catch (Exception ex) {
                    logger.error((Object)"Check failed to run", (Throwable)ex);
                    runReport.handleException(ex);
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, ex.getLocalizedMessage())));
                }
                report.runs.add(runReport);
            }
            logger.info((Object)("Collected " + report.results.size() + " check results"));
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
        }
        HashMap trimmedResults = Maps.newHashMap();
        for (AbstractValuedCheck.ValuedCheck checkResult : report.results) {
            trimmedResults.put(checkResult.check.trimForSave(), checkResult.value);
        }
        this.saveChecksValues(mes.projectKey, mes.id, MetricsComputationService.fakeMEVersionPartition(evaluationId), timeCheck, trimmedResults, runOrigin);
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry checkResult : trimmedResults.entrySet()) {
            Check check = (Check)checkResult.getKey();
            CheckProbeType.CheckMetric metric = new CheckProbeType.CheckMetric(CheckProbeType.CheckMetrics.CHECK, check.getId());
            hashMap.put(metric, ((AbstractCheckContext.CheckResult)checkResult.getValue()).outcome.name());
        }
        this.saveMetricsValues(user, mes, MetricTargetType.MODEL_EVALUATION_STORE, MetricsComputationService.fakeMEVersionPartition(evaluationId), timeCheck, hashMap, environment, false);
        report.endTime = DateTime.now().getMillis();
        this.handleCheckRunsCompletedNotification(mes, trimmedResults, evaluationId, timeCheck.getMillis());
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCheckReport.MetricsCheckReport checkManagedFolder(AuthCtx user, ManagedFolder mf, Partition partition, ChecksSet checksSet, MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        boolean fullDataset = MetricsComputationService.isFullDataset(mf, partition);
        AbstractCheckReport.MetricsCheckReport report = new AbstractCheckReport.MetricsCheckReport();
        DateTime timeCheck = DateTime.now();
        report.startTime = timeCheck.getMillis();
        if (environment.startedFromBuild && !checksSet.runOnBuild) {
            logger.info((Object)"Checks not run on build");
            return report;
        }
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(user, "checks:MANAGED_FOLDER." + mf.getFullId(), (Object)mf);
        ManagedFolderCheckContext context = new ManagedFolderCheckContext(mf, partition, timeCheck.getMillis(), this.jobsDatabaseService, ticket, mf.projectKey);
        try {
            for (Check check : checksSet.checks) {
                if (environment.startedFromBuild) {
                    if (fullDataset && !check.getComputeMode().includesALL()) {
                        logger.info((Object)("Full managed folder check " + check.type + " is not active."));
                        continue;
                    }
                    if (!fullDataset && !check.getComputeMode().includesPartition()) {
                        logger.info((Object)("Check " + check.type + " is not active."));
                        continue;
                    }
                }
                MetricsCheckRunReport runReport = new MetricsCheckRunReport(null, check.getId());
                try {
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, check.run(user, context, runReport)));
                }
                catch (Exception ex) {
                    logger.error((Object)"Check failed to run", (Throwable)ex);
                    runReport.handleException(ex);
                    report.results.add(new AbstractValuedCheck.ValuedCheck(check, new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, ex.getLocalizedMessage())));
                }
                report.runs.add(runReport);
            }
            logger.info((Object)("Collected " + report.results.size() + " check results"));
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
        }
        HashMap trimmedResults = Maps.newHashMap();
        for (AbstractValuedCheck.ValuedCheck checkResult : report.results) {
            trimmedResults.put(checkResult.check.trimForSave(), checkResult.value);
        }
        this.saveChecksValues(mf.projectKey, mf.id, partition, timeCheck, trimmedResults, runOrigin);
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry checkResult : trimmedResults.entrySet()) {
            Check check = (Check)checkResult.getKey();
            CheckProbeType.CheckMetric metric = new CheckProbeType.CheckMetric(CheckProbeType.CheckMetrics.CHECK, check.getId());
            hashMap.put(metric, ((AbstractCheckContext.CheckResult)checkResult.getValue()).outcome.name());
        }
        this.saveMetricsValues(user, mf, MetricTargetType.MANAGED_FOLDER, partition, timeCheck, hashMap, environment, false);
        report.endTime = DateTime.now().getMillis();
        return report;
    }

    public void scoopSavedModelMetrics(SavedModel model, Partition partition, Map<Metric, String> metricsValues) throws Exception {
        if (model.getType() == MLTask.MLTaskType.PREDICTION) {
            FullModelId fmi = new FullModelId(model.projectKey, model.id, partition.id());
            PredictionModelDetails summary = PredictionResultsReader.makeModelDetails(fmi);
            MLTask headMLTask = fmi.getHeadMLTask();
            if (headMLTask instanceof PredictionMLTask.TabularPredictionMLTask) {
                if (headMLTask instanceof PredictionMLTask.ClassicalPredictionMLTask) {
                    ((ClassicalPredictionModelDetails)summary).headTaskCMW = ((PredictionMLTask.ClassicalPredictionMLTask)headMLTask).modeling.metrics.costMatrixWeights;
                }
                this.scoopTabularPredictionMetrics(metricsValues, summary);
            }
        }
    }

    public void scoopMESMetrics(ModelEvaluationStore mes, Partition partition, Map<Metric, String> metricsValues) throws Exception {
        ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails evaluationFullInfo;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            evaluationFullInfo = this.modelEvaluationStoresCRUDService.getEvaluationDetails(mes, partition.id());
        }
        if (evaluationFullInfo.isTabular()) {
            this.scoopTabularPredictionMetrics(metricsValues, ((ModelEvaluationStoresCRUDService.TabularModelEvaluationDetails)evaluationFullInfo).details);
        } else if (evaluationFullInfo.isLLM()) {
            this.scoopLLMEvaluationMetrics(metricsValues, (LLMEvaluationMetrics)evaluationFullInfo.metrics);
        } else if (evaluationFullInfo.isAgent()) {
            this.scoopAgentEvaluationMetrics(metricsValues, (AgentEvaluationMetrics)evaluationFullInfo.metrics);
        }
    }

    public void scoopTabularPredictionMetrics(Map<Metric, String> metricsValues, ModelDetailsBase summary) {
        PredictionModelSnippetData snippet = PredictionResultsReader.makeSnippet(summary);
        ResolvedPredictionCoreParams coreParams = (ResolvedPredictionCoreParams)summary.getCoreParams();
        if (null != coreParams && null != coreParams.prediction_type) {
            switch (coreParams.prediction_type) {
                case BINARY_CLASSIFICATION: {
                    if (snippet.f1 != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.F1), Double.toString(snippet.f1));
                    }
                    if (snippet.recall != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.RECALL), Double.toString(snippet.recall));
                    }
                    if (snippet.precision != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PRECISION), Double.toString(snippet.precision));
                    }
                    if (snippet.accuracy != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ACCURACY), Double.toString(snippet.accuracy));
                    }
                    if (snippet.logLoss != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.LOGLOSS), Double.toString(snippet.logLoss));
                    }
                    if (snippet.auc != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AUC), Double.toString(snippet.auc));
                    }
                    if (snippet.averagePrecision != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION), Double.toString(snippet.averagePrecision));
                    }
                    if (snippet.customScore != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.CUSTOMOPTIMISATIONSCORE), Double.toString(snippet.customScore));
                    }
                    if (snippet.lift != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.LIFT), Double.toString(snippet.lift));
                    }
                    if (snippet.calibrationLoss == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.CALIBRATIONLOSS), Double.toString(snippet.calibrationLoss));
                    break;
                }
                case MULTICLASS: {
                    MulticlassModelPerf mp = (MulticlassModelPerf)((ClassicalPredictionModelDetails)summary).perf;
                    if (null == mp || null == mp.metrics) break;
                    if (mp.metrics.f1 != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.F1), Double.toString(mp.metrics.f1));
                    }
                    if (mp.metrics.recall != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.RECALL), Double.toString(mp.metrics.recall));
                    }
                    if (mp.metrics.precision != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PRECISION), Double.toString(mp.metrics.precision));
                    }
                    if (mp.metrics.accuracy != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ACCURACY), Double.toString(mp.metrics.accuracy));
                    }
                    if (mp.metrics.logLoss != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.LOGLOSS), Double.toString(mp.metrics.logLoss));
                    }
                    if (mp.metrics.mrocAUC != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AUC), Double.toString(mp.metrics.mrocAUC));
                    }
                    if (mp.metrics.averagePrecision != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION), Double.toString(mp.metrics.averagePrecision));
                    }
                    if (mp.metrics.customScore != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.CUSTOMOPTIMISATIONSCORE), Double.toString(mp.metrics.customScore));
                    }
                    if (mp.metrics.mcalibrationLoss == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.CALIBRATIONLOSS), Double.toString(mp.metrics.mcalibrationLoss));
                    break;
                }
                case REGRESSION: {
                    RegressionModelPerf mp = (RegressionModelPerf)((ClassicalPredictionModelDetails)summary).perf;
                    if (null == mp || null == mp.metrics) break;
                    if (mp.metrics.r2 != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.R2), Double.toString(mp.metrics.r2));
                    }
                    if (mp.metrics.evs != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.EVS), Double.toString(mp.metrics.evs));
                    }
                    if (mp.metrics.mape != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MAPE), Double.toString(mp.metrics.mape));
                    }
                    if (mp.metrics.mae != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MAE), Double.toString(mp.metrics.mae));
                    }
                    if (mp.metrics.mse != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MSE), Double.toString(mp.metrics.mse));
                    }
                    if (mp.metrics.rmse != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.RMSE), Double.toString(mp.metrics.rmse));
                    }
                    if (mp.metrics.rmsle != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.RMSLE), Double.toString(mp.metrics.rmsle));
                    }
                    if (mp.metrics.pearson != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PEARSON), Double.toString(mp.metrics.pearson));
                    }
                    if (mp.metrics.customScore == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.CUSTOMOPTIMISATIONSCORE), Double.toString(mp.metrics.customScore));
                    break;
                }
                case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                    if (snippet.averagePrecisionIOU50 != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION_IOU50), Double.toString(snippet.averagePrecisionIOU50));
                    }
                    if (snippet.averagePrecisionIOU75 != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION_IOU75), Double.toString(snippet.averagePrecisionIOU75));
                    }
                    if (snippet.averagePrecisionAllIOU == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION_ALL_IOU), Double.toString(snippet.averagePrecisionAllIOU));
                    break;
                }
                case DEEP_HUB_IMAGE_CLASSIFICATION: {
                    if (snippet.auc != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AUC), Double.toString(snippet.auc));
                    }
                    if (snippet.averagePrecision == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AVERAGE_PRECISION), Double.toString(snippet.averagePrecision));
                    break;
                }
                case TIMESERIES_FORECAST: {
                    TimeseriesForecastingModelPerf mp = ((TimeseriesForecastingModelDetails)summary).perf;
                    if (null == mp || null == mp.aggregatedMetrics) break;
                    if (mp.aggregatedMetrics.mase != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MASE), Double.toString(mp.aggregatedMetrics.mase));
                    }
                    if (mp.aggregatedMetrics.mape != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MAPE), Double.toString(mp.aggregatedMetrics.mape));
                    }
                    if (mp.aggregatedMetrics.meanAbsoluteQuantileLoss != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MEAN_ABSOLUTE_QUANTILE_LOSS), Double.toString(mp.aggregatedMetrics.meanAbsoluteQuantileLoss));
                    }
                    if (mp.aggregatedMetrics.meanWeightedQuantileLoss != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MEAN_WEIGHTED_QUANTILE_LOSS), Double.toString(mp.aggregatedMetrics.meanWeightedQuantileLoss));
                    }
                    if (mp.aggregatedMetrics.mse != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MSE), Double.toString(mp.aggregatedMetrics.mse));
                    }
                    if (mp.aggregatedMetrics.msis != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MSIS), Double.toString(mp.aggregatedMetrics.msis));
                    }
                    if (mp.aggregatedMetrics.nd != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ND), Double.toString(mp.aggregatedMetrics.nd));
                    }
                    if (mp.aggregatedMetrics.rmse != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.RMSE), Double.toString(mp.aggregatedMetrics.rmse));
                    }
                    if (mp.aggregatedMetrics.smape != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.SMAPE), Double.toString(mp.aggregatedMetrics.smape));
                    }
                    if (mp.aggregatedMetrics.mae != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MAE), Double.toString(mp.aggregatedMetrics.mae));
                    }
                    if (mp.aggregatedMetrics.worstMase != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_MASE), Double.toString(mp.aggregatedMetrics.worstMase));
                    }
                    if (mp.aggregatedMetrics.worstMape != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_MAPE), Double.toString(mp.aggregatedMetrics.worstMape));
                    }
                    if (mp.aggregatedMetrics.worstSmape != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_SMAPE), Double.toString(mp.aggregatedMetrics.worstSmape));
                    }
                    if (mp.aggregatedMetrics.worstMse != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_MSE), Double.toString(mp.aggregatedMetrics.worstMse));
                    }
                    if (mp.aggregatedMetrics.worstMsis != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_MSIS), Double.toString(mp.aggregatedMetrics.worstMsis));
                    }
                    if (mp.aggregatedMetrics.worstMae == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.WORST_MAE), Double.toString(mp.aggregatedMetrics.worstMae));
                    break;
                }
                case CAUSAL_BINARY_CLASSIFICATION: 
                case CAUSAL_REGRESSION: {
                    CausalPredictionModelPerf mp = ((CausalPredictionModelDetails)summary).perf;
                    if (mp.causalPerf.normalized.auuc != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.AUUC), Double.toString(mp.causalPerf.normalized.auuc));
                    }
                    if (mp.causalPerf.normalized.qini != null) {
                        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.QINI), Double.toString(mp.causalPerf.normalized.qini));
                    }
                    if (mp.causalPerf.normalized.netUplift == null) break;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.NET_UPLIFT), Double.toString(mp.causalPerf.normalized.netUplift));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)coreParams.prediction_type));
                }
            }
        }
        MetricsComputationService.scoopCustomMetrics(metricsValues, snippet.customMetricsResults);
        this.scoopDriftMetrics(metricsValues, snippet);
        this.enrichMetricsWithAssertions(metricsValues, snippet);
    }

    public void scoopLLMEvaluationMetrics(Map<Metric, String> metricsValues, LLMEvaluationMetrics metricsFromMe) {
        if (metricsFromMe == null) {
            return;
        }
        if (metricsFromMe.answerRelevancy != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ANSWER_RELEVANCY), Double.toString(metricsFromMe.answerRelevancy));
        }
        if (metricsFromMe.multimodalRelevancy != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.MULTIMODAL_RELEVANCY), Double.toString(metricsFromMe.multimodalRelevancy));
        }
        if (metricsFromMe.answerCorrectness != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ANSWER_CORRECTNESS), Double.toString(metricsFromMe.answerCorrectness));
        }
        if (metricsFromMe.answerSimilarity != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ANSWER_SIMILARITY), Double.toString(metricsFromMe.answerSimilarity));
        }
        if (metricsFromMe.contextPrecision != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.CONTEXT_PRECISION), Double.toString(metricsFromMe.contextPrecision));
        }
        if (metricsFromMe.contextRecall != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.CONTEXT_RECALL), Double.toString(metricsFromMe.contextRecall));
        }
        if (metricsFromMe.faithfulness != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.FAITHFULNESS), Double.toString(metricsFromMe.faithfulness));
        }
        if (metricsFromMe.multimodalFaithfulness != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.MULTIMODAL_FAITHFULNESS), Double.toString(metricsFromMe.multimodalFaithfulness));
        }
        if (metricsFromMe.bertScorePrecision != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.BERT_SCORE_PRECISION), Double.toString(metricsFromMe.bertScorePrecision));
        }
        if (metricsFromMe.bertScoreRecall != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.BERT_SCORE_RECALL), Double.toString(metricsFromMe.bertScoreRecall));
        }
        if (metricsFromMe.bertScoreF1 != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.BERT_SCORE_F1), Double.toString(metricsFromMe.bertScoreF1));
        }
        if (metricsFromMe.bleu != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.BLEU), Double.toString(metricsFromMe.bleu));
        }
        if (metricsFromMe.rouge1Precision != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_1_PRECISION), Double.toString(metricsFromMe.rouge1Precision));
        }
        if (metricsFromMe.rouge1Recall != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_1_RECALL), Double.toString(metricsFromMe.rouge1Recall));
        }
        if (metricsFromMe.rouge1F1 != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_1_F1), Double.toString(metricsFromMe.rouge1F1));
        }
        if (metricsFromMe.rouge2Precision != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_2_PRECISION), Double.toString(metricsFromMe.rouge2Precision));
        }
        if (metricsFromMe.rouge2Recall != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_2_RECALL), Double.toString(metricsFromMe.rouge2Recall));
        }
        if (metricsFromMe.rouge2F1 != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_2_F1), Double.toString(metricsFromMe.rouge2F1));
        }
        if (metricsFromMe.rougeLPrecision != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_L_PRECISION), Double.toString(metricsFromMe.rougeLPrecision));
        }
        if (metricsFromMe.rougeLRecall != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_L_RECALL), Double.toString(metricsFromMe.rougeLRecall));
        }
        if (metricsFromMe.rougeLF1 != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.ROUGE_L_F1), Double.toString(metricsFromMe.rougeLF1));
        }
        if (metricsFromMe.inputTokensPerRow != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.INPUT_TOKENS_PER_ROW), Double.toString(metricsFromMe.inputTokensPerRow));
        }
        if (metricsFromMe.outputTokensPerRow != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.OUTPUT_TOKENS_PER_ROW), Double.toString(metricsFromMe.outputTokensPerRow));
        }
        if (metricsFromMe.sampleRowCount != null) {
            metricsValues.put(new LLMEvaluationProbeType.LLMEvaluationMetric(LLMEvaluationProbeType.LLMEvaluationMetricsEnum.SAMPLE_ROW_COUNT), Double.toString(metricsFromMe.sampleRowCount));
        }
        MetricsComputationService.scoopCustomMetrics(metricsValues, metricsFromMe.customMetricsResults);
    }

    public void scoopAgentEvaluationMetrics(Map<Metric, String> metricsValues, AgentEvaluationMetrics metricsFromMe) {
        if (metricsFromMe == null) {
            return;
        }
        this.putDouble(metricsFromMe.averageToolExecutionsPerRow, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.AVERAGE_TOOL_EXECUTIONS_PER_ROW);
        this.putDouble(metricsFromMe.averageFailedToolExecutionsPerRow, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.AVERAGE_FAILED_TOOL_EXECUTIONS_PER_ROW);
        this.putDouble(metricsFromMe.averageToolExecutionTimeSecondsPerRow, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.AVERAGE_TOOL_EXECUTION_TIME_SECONDS_PER_ROW);
        this.putDouble(metricsFromMe.p95TotalAgentCallExecutionTimeSecondsPerRow, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.P95_TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS_PER_ROW);
        this.putDouble(metricsFromMe.sampleRowCount, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.SAMPLE_ROW_COUNT);
        this.putDouble(metricsFromMe.toolCallExactMatch, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.TOOL_CALL_EXACT_MATCH);
        this.putDouble(metricsFromMe.toolCallPartialMatch, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.TOOL_CALL_PARTIAL_MATCH);
        this.putDouble(metricsFromMe.toolCallPrecision, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.TOOL_CALL_PRECISION);
        this.putDouble(metricsFromMe.toolCallRecall, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.TOOL_CALL_RECALL);
        this.putDouble(metricsFromMe.toolCallF1, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.TOOL_CALL_F1);
        this.putDouble(metricsFromMe.agentGoalAccuracyWithReference, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.AGENT_GOAL_ACCURACY_WITH_REFERENCE);
        this.putDouble(metricsFromMe.agentGoalAccuracyWithoutReference, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE);
        this.putDouble(metricsFromMe.answerSimilarity, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.ANSWER_SIMILARITY);
        this.putDouble(metricsFromMe.answerCorrectness, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.ANSWER_CORRECTNESS);
        this.putDouble(metricsFromMe.bertScorePrecision, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.BERT_SCORE_PRECISION);
        this.putDouble(metricsFromMe.bertScoreRecall, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.BERT_SCORE_RECALL);
        this.putDouble(metricsFromMe.bertScoreF1, metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum.BERT_SCORE_F1);
        MetricsComputationService.scoopCustomMetrics(metricsValues, metricsFromMe.customMetricsResults);
    }

    private void putDouble(Double value, Map<Metric, String> metricsValues, AgentEvaluationProbeType.AgentEvaluationMetricsEnum type) {
        if (value != null) {
            metricsValues.put(new AgentEvaluationProbeType.AgentEvaluationMetric(type), Double.toString(value));
        }
    }

    private void enrichMetricsWithAssertions(Map<Metric, String> metricsValues, PredictionModelSnippetData snippet) {
        if (snippet.assertionsMetrics == null) {
            return;
        }
        PredictionModelPerf.AssertionsMetrics assertionsMetrics = snippet.assertionsMetrics;
        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PASSING_ASSERTIONS_RATIO), assertionsMetrics.passingAssertionsRatio == null ? null : Double.toString(assertionsMetrics.passingAssertionsRatio));
        if (assertionsMetrics.perAssertion != null) {
            for (PredictionModelPerf.AssertionMetrics am : assertionsMetrics.perAssertion) {
                this.enrichMetricsWithAssertion(metricsValues, am);
            }
        }
    }

    private void enrichMetricsWithAssertion(Map<Metric, String> metricsValues, PredictionModelPerf.AssertionMetrics am) {
        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ASSERTION_NB_MATCHING_ROWS, am.name), Double.toString(am.nbMatchingRows));
        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ASSERTION_NB_DROPPED_ROWS, am.name), Double.toString(am.nbDroppedRows));
        metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.ASSERTION_VALID_RATIO, am.name), am.validRatio == null ? null : Double.toString(am.validRatio));
    }

    private void scoopDriftMetrics(Map<Metric, String> metricsValues, PredictionModelSnippetData snippet) {
        if (snippet.dataDrift != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.DATA_DRIFT), Double.toString(snippet.dataDrift));
        }
        if (snippet.dataDriftPValue != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.DATA_DRIFT_PVALUE), Double.toString(snippet.dataDriftPValue));
        }
        if (snippet.minChiSquare != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MIN_CHISQUARE), Double.toString(snippet.minChiSquare));
        }
        if (snippet.minKs != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MIN_KS), Double.toString(snippet.minKs));
        }
        if (snippet.maxPsi != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.MAX_PSI), Double.toString(snippet.maxPsi));
        }
        if (snippet.ksPerFeature != null) {
            snippet.ksPerFeature.forEach((feature, ks) -> {
                if (ks != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.UnivariateDriftMetric.KS, (String)feature), Double.toString(ks));
                }
            });
        }
        if (snippet.psiPerFeature != null) {
            snippet.psiPerFeature.forEach((feature, psi) -> {
                if (psi != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.UnivariateDriftMetric.PSI, (String)feature), Double.toString(psi));
                }
            });
        }
        if (snippet.chiSquarePerFeature != null) {
            snippet.chiSquarePerFeature.forEach((feature, chi) -> {
                if (chi != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.UnivariateDriftMetric.CHISQUARE, (String)feature), Double.toString(chi));
                }
            });
        }
        if (snippet.predictionDrift_KS != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PREDICTION_DRIFT_KS), Double.toString(snippet.predictionDrift_KS));
        }
        if (snippet.predictionDrift_ChiSquare != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PREDICTION_DRIFT_CHISQUARE), Double.toString(snippet.predictionDrift_ChiSquare));
        }
        if (snippet.predictionDrift_PSI != null) {
            metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ModelPerformanceMetrics.PREDICTION_DRIFT_PSI), Double.toString(snippet.predictionDrift_PSI));
        }
        if (snippet.euclidianDistancePerFeature != null) {
            snippet.euclidianDistancePerFeature.forEach((feature, ed) -> {
                if (ed != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.EmbeddingDriftMetric.EUCLIDIAN_DISTANCE, (String)feature), Double.toString(ed));
                }
            });
        }
        if (snippet.cosineSimilarityPerFeature != null) {
            snippet.cosineSimilarityPerFeature.forEach((feature, cs2) -> {
                if (cs2 != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.EmbeddingDriftMetric.COSINE_SIMILARITY, (String)feature), Double.toString(cs2));
                }
            });
        }
        if (snippet.classifierGiniPerFeature != null) {
            snippet.classifierGiniPerFeature.forEach((feature, cs2) -> {
                if (cs2 != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.EmbeddingDriftMetric.CLASSIFIER_GINI, (String)feature), Double.toString(cs2));
                }
            });
        }
        if (snippet.meanRedPerFeature != null) {
            snippet.meanRedPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.MEAN_RED, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.meanGreenPerFeature != null) {
            snippet.meanGreenPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.MEAN_GREEN, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.meanBluePerFeature != null) {
            snippet.meanBluePerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.MEAN_BLUE, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.meanSaturationPerFeature != null) {
            snippet.meanSaturationPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.MEAN_SATURATION, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.rmsContrastPerFeature != null) {
            snippet.rmsContrastPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.RMS_CONTRAST, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.laplacianVarPerFeature != null) {
            snippet.laplacianVarPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.LAPLACIAN_VAR, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.tenengradPerFeature != null) {
            snippet.tenengradPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.TENENGRAD, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.entropyPerFeature != null) {
            snippet.entropyPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.ENTROPY, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.edgeDensityPerFeature != null) {
            snippet.edgeDensityPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.EDGE_DENSITY, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.areaPerFeature != null) {
            snippet.areaPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.AREA, (String)feature), Double.toString(val));
                }
            });
        }
        if (snippet.aspectRatioPerFeature != null) {
            snippet.aspectRatioPerFeature.forEach((feature, val) -> {
                if (val != null) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(ModelPerformanceProbeType.ImageQualityDriftMetric.ASPECT_RATIO, (String)feature), Double.toString(val));
                }
            });
        }
    }

    private static void scoopCustomMetrics(Map<Metric, String> metricsValues, CustomMetricResult[] customMetricsResults) {
        if (customMetricsResults != null) {
            for (CustomMetricResult result : customMetricsResults) {
                if (result instanceof CustomMetricSuccess) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(result.metric.name), ((CustomMetricSuccess)result).value != null ? Double.toString(((CustomMetricSuccess)result).value) : "");
                    if (((CustomMetricSuccess)result).worstValue == null) continue;
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric("Worst " + result.metric.name), Double.toString(((CustomMetricSuccess)result).worstValue));
                    continue;
                }
                if (result instanceof CustomMetricFailure) {
                    metricsValues.put(new ModelPerformanceProbeType.ModelPerformanceMetric(result.metric.name), "");
                    continue;
                }
                logger.error((Object)String.format("Illegal State: custom metric result for '%s' did not match either class CustomMetricSuccess or CustomMetricFailure", result.metric.name));
                throw new IllegalStateException("Custom Metric Result configuration is broken");
            }
        }
    }

    public void scoopAndSaveMetrics(AuthCtx authCtx, Object object, Partition partition, MetricsComputationEnvironment environment) throws Exception {
        MetricTargetType objectType;
        HashMap metricsValues = Maps.newHashMap();
        if (object instanceof SavedModel) {
            this.scoopSavedModelMetrics((SavedModel)object, partition, metricsValues);
            objectType = MetricTargetType.SAVED_MODEL;
        } else if (object instanceof ModelEvaluationStore) {
            this.scoopMESMetrics((ModelEvaluationStore)object, partition, metricsValues);
            objectType = MetricTargetType.MODEL_EVALUATION_STORE;
        } else {
            throw new NotImplementedException("Scooping metrics of unsupported object");
        }
        HashMap expandedMetricsValues = Maps.newHashMap();
        for (Map.Entry metricValue : metricsValues.entrySet()) {
            Metric metric = (Metric)metricValue.getKey();
            expandedMetricsValues.put(metric, (String)metricValue.getValue());
        }
        if (expandedMetricsValues.size() > 0) {
            this.saveMetricsValues(authCtx, object, objectType, partition, DateTime.now(), expandedMetricsValues, environment);
        }
    }

    private void handleCheckRunsCompletedNotification(ModelEvaluationStore mes, Map<Check, AbstractCheckContext.CheckResult> trimmedResults, String evaluationId, Long timestamp) {
        List checkNames = mes.metricsChecks.checks.stream().map(check -> check.meta.getLabel()).collect(Collectors.toList());
        HashMap<String, AbstractCheckContext.CheckResult> checkResults = new HashMap<String, AbstractCheckContext.CheckResult>();
        trimmedResults.forEach((check, checkResult) -> {
            String label = check.meta.getLabel();
            if (StringUtils.isBlank((String)label)) {
                logger.infoV("Check of type %s in MES %s of project %s has no name, it will not be considered in the model status computation of Unified Monitoring", new Object[]{check.type, mes.id, mes.projectKey});
            } else if (checkNames.contains(label)) {
                checkResults.put(check.meta.getLabel(), new AbstractCheckContext.CheckResult(checkResult.outcome, checkResult.message));
            }
        });
        if (!checkResults.isEmpty()) {
            MesChecksRunCompletedEvent event = new MesChecksRunCompletedEvent(mes.projectKey, mes.id, evaluationId, timestamp, checkResults);
            this.pubSubService.publish((DSSEvent)event);
        }
    }

    private static /* synthetic */ String lambda$saveMetricsValues$5(Map.Entry e) {
        return (e.getKey() != null ? ((Metric)e.getKey()).getId() : null) + "=" + (String)e.getValue();
    }

    @UIModel
    public static class MetricsComputationReport {
        public ReportTargetItem target;
        public String description;
        public String partition;
        public long startTime;
        public long endTime;
        public List<Metric> skipped = Lists.newArrayList();
        public List<ValuedMetric> computed = Lists.newArrayList();
        public List<MetricsEngineRunReport> runs = Lists.newArrayList();

        public void toInfoMessages(InfoMessage.InfoMessages target) {
            for (MetricsEngineRunReport runReport : this.runs) {
                if (runReport.error == null) continue;
                target.withFatal((InfoMessage.MessageCode)MetricCodes.ERR_METRIC_ENGINE_RUN_FAILED, this.description + ": " + runReport.error.message);
            }
            for (Metric sk : this.skipped) {
                target.withWarning((InfoMessage.MessageCode)MetricCodes.WARN_METRIC_COMPUTATION_SKIPPED, this.description + ": " + sk.getId());
            }
        }
    }

    public static class MetricsComputationEnvironment {
        public String graphiteServerUrl;
        public String graphiteMetricPrefix;
        public boolean startedFromBuild;
        public boolean doNotSaveMetricValues = false;
    }

    public static class MetricsEngineRunReport {
        public String engine;
        @Nullable
        public WarningsContext.SerializedThrowable error;
        @Nullable
        public SmartLogTail logTail;

        public MetricsEngineRunReport(String engine) {
            this.engine = engine;
        }

        public void handleException(Exception ex) {
            this.error = ex instanceof ExceptionWithSerializedThrowable && ((ExceptionWithSerializedThrowable)ex).getSerializedThrowable() != null ? ((ExceptionWithSerializedThrowable)ex).getSerializedThrowable() : new WarningsContext.SerializedThrowable((Throwable)ex);
            if (ex instanceof ExceptionWithLogTail) {
                this.logTail = ((ExceptionWithLogTail)ex).getLogTail();
            }
        }
    }

    private static class SendMetricsToGraphiteThread
    extends SimpleFutureThread<Void> {
        private final FuturePayload futurePayload;
        private final DateTime computed;
        private final Map<Metric, String> metricsValues;
        private final Partition partition;
        private final String graphitePrefix;
        private final Pair<String, Integer> hostPort;
        private final String graphiteServerUrl;
        private final DatasetLocUtils.DatasetLoc objectLoc;

        public SendMetricsToGraphiteThread(AuthCtx owner, DateTime computed, Map<Metric, String> metricsValues, DatasetLocUtils.DatasetLoc objectLoc, Partition partition, String graphitePrefix, Pair<String, Integer> hostPort, String graphiteServerUrl) {
            super(owner);
            this.computed = computed;
            this.metricsValues = metricsValues;
            this.objectLoc = objectLoc;
            this.partition = partition;
            this.graphitePrefix = graphitePrefix;
            this.hostPort = hostPort;
            this.graphiteServerUrl = graphiteServerUrl;
            this.futurePayload = new FuturePayload();
            this.futurePayload.displayName = "Send metrics to Graphite";
            this.futurePayload.action = "send_to_graphite";
        }

        @Override
        protected Void compute() throws Exception {
            try {
                long sSinceEpoch = this.computed.getMillis() / 1000L;
                try (Graphite graphite = new Graphite((String)this.hostPort.first, ((Integer)this.hostPort.second).intValue());
                     FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Sending metrics", (double)this.metricsValues.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    graphite.connect();
                    for (Map.Entry<Metric, String> metricValue : this.metricsValues.entrySet()) {
                        String valueForGraphite = metricValue.getValue();
                        if (StringUtils.isBlank((String)valueForGraphite)) {
                            valueForGraphite = "";
                        }
                        Object graphiteMetricId = this.graphitePrefix + "." + this.objectLoc.getFullName() + "." + (this.partition == null ? null : this.partition.id()) + "." + metricValue.getKey().getId();
                        graphiteMetricId = ((String)graphiteMetricId).replaceAll("\\s", "_");
                        graphite.send((String)graphiteMetricId, valueForGraphite, sSinceEpoch);
                        state.increment(1.0);
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to send metrics to Graphite server : " + this.graphiteServerUrl), (Throwable)e);
            }
            return null;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    public static class MetricsCheckRunReport {
        public String name;
        public String partition;
        @Nullable
        public WarningsContext.SerializedThrowable error;
        @Nullable
        public SmartLogTail logTail;

        public MetricsCheckRunReport(String partition, String name) {
            this.partition = partition;
            this.name = name;
        }

        public void handleException(Exception ex) {
            this.error = ex instanceof ExceptionWithSerializedThrowable && ((ExceptionWithSerializedThrowable)ex).getSerializedThrowable() != null ? ((ExceptionWithSerializedThrowable)ex).getSerializedThrowable() : new WarningsContext.SerializedThrowable((Throwable)ex);
            if (ex instanceof ExceptionWithLogTail) {
                this.logTail = ((ExceptionWithLogTail)ex).getLogTail();
            }
        }
    }

    public static class ValuedMetric {
        public final Metric metric;
        public final String metricId;
        public final Type dataType;
        public final String value;

        public ValuedMetric(Metric metric, String value) {
            this.metric = metric;
            this.value = value;
            this.metricId = metric.getId();
            this.dataType = metric.getDataType();
        }
    }

    public static class MetricsCheckReportsAndPartitions {
        public Set<String> partitionIds = new HashSet<String>();
        public List<AbstractCheckReport.MetricsCheckReport> reports = new ArrayList<AbstractCheckReport.MetricsCheckReport>();
    }

    public static class MetricsComputationReportsAndPartitions {
        public MetricsService.MetricPartitionsList partitionsList = new MetricsService.MetricPartitionsList(false, null, new ArrayList<MetricsService.MetricPartition>());
        public List<MetricsComputationReport> reports = new ArrayList<MetricsComputationReport>();
    }

    public static class MetricsComputationReports {
        public List<MetricsComputationReport> reports = new ArrayList<MetricsComputationReport>();
    }
}

