/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.DisplayedChecksSet;
import com.dataiku.dip.metrics.DisplayedMetricsSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.CheckMetadata;
import com.dataiku.dip.metrics.checks.ExternalCheck;
import com.dataiku.dip.metrics.probes.AdvancedStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.CheckProbeType;
import com.dataiku.dip.metrics.probes.ExternalProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.PercentileStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.metrics.probes.ReportingProbeType;
import com.dataiku.dip.metrics.probes.VerifyDatasetColumnProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsService {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private TransactionService transactionService;
    private static Function<String, Long> parseLongMetricValue = new Function<String, Long>(){

        public Long apply(String value) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                logger.info((Object)("Value " + value + " was not a long as expected"));
                return null;
            }
        }
    };
    private static Function<String, Double> parseDoubleMetricValue = new Function<String, Double>(){

        public Double apply(String value) {
            try {
                double doubleValue = Double.parseDouble(value);
                if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                    throw new Exception();
                }
                return doubleValue;
            }
            catch (Exception e) {
                logger.info((Object)("Value " + value + " was not a double as expected"));
                return null;
            }
        }
    };
    private static AnyTemporal anyTemporalMeaning = new AnyTemporal();
    private static Function<String, Double> parseDateAsDoubleMetricValue = new Function<String, Double>(){

        public Double apply(String value) {
            try {
                double doubleValue = anyTemporalMeaning.doubleValue(value);
                if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                    throw new Exception();
                }
                return doubleValue;
            }
            catch (Exception e) {
                logger.info((Object)("Value " + value + " was not a date as expected"));
                return null;
            }
        }
    };
    private static Function<String, String> parseStringMetricValue = new Function<String, String>(){

        public String apply(String value) {
            return value;
        }
    };
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.metrics");

    private Type getTypeWithMostValues(List<ReadOnlyJobsInternalDB.MetricDataPoint> points, List<MetricPartitionPoint> output) {
        Boolean booleanMeaning = new Boolean();
        AnyTemporal anyTemporalMeaning = new AnyTemporal();
        DoubleMeaning doubleMeaning = new DoubleMeaning();
        LongMeaning longMeaning = new LongMeaning();
        JSONArrayMeaning arrayMeaning = new JSONArrayMeaning();
        ArrayList booleans = Lists.newArrayList();
        ArrayList longs = Lists.newArrayList();
        ArrayList doubles = Lists.newArrayList();
        ArrayList arrays = Lists.newArrayList();
        ArrayList strings = Lists.newArrayList();
        ArrayList dates = Lists.newArrayList();
        block9: for (ReadOnlyJobsInternalDB.MetricDataPoint point : points) {
            try {
                switch (point.type) {
                    case BIGINT: 
                    case INT: 
                    case SMALLINT: 
                    case TINYINT: {
                        longs.add(new MetricPartitionPoint<Object>(point.partition, point.time, (point.value == null ? null : Long.valueOf(longMeaning.permissiveLongValue(point.value)))));
                        break;
                    }
                    case BOOLEAN: {
                        booleans.add(new MetricPartitionPoint<Object>(point.partition, point.time, (point.value == null ? null : java.lang.Boolean.valueOf(booleanMeaning.parse(point.value)))));
                        break;
                    }
                    case DATE: {
                        dates.add(new MetricPartitionPoint<Object>(point.partition, point.time, (point.value == null ? null : Long.valueOf(anyTemporalMeaning.longValue(point.value)))));
                        break;
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        if (point.value == null) {
                            doubles.add(new MetricPartitionPoint<Object>(point.partition, point.time, null));
                            break;
                        }
                        double doubleValue = doubleMeaning.doubleValue(point.value);
                        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                            throw new Exception();
                        }
                        doubles.add(new MetricPartitionPoint<Double>(point.partition, point.time, doubleValue));
                        break;
                    }
                    case ARRAY: {
                        if (!(arrayMeaning.detects(point.value) > 0.0)) continue block9;
                        List list = (List)JSON.parse((String)point.value, List.class);
                        ArrayList listStrings = Lists.newArrayList((Iterable)Iterables.transform((Iterable)list, (Function)new Function<Object, String>(){

                            public String apply(Object o) {
                                if (o == null) {
                                    return null;
                                }
                                if (o instanceof String) {
                                    return (String)o;
                                }
                                if (o instanceof Number || o instanceof java.lang.Boolean) {
                                    return o.toString();
                                }
                                return JSON.json((Object)o);
                            }
                        }));
                        arrays.add(new MetricPartitionPoint<String[]>(point.partition, point.time, listStrings.toArray(new String[0])));
                        break;
                    }
                    default: {
                        strings.add(new MetricPartitionPoint<String>(point.partition, point.time, point.value));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                strings.add(new MetricPartitionPoint<String>(point.partition, point.time, point.value));
            }
        }
        ArrayList lists = Lists.newArrayList();
        lists.add(booleans);
        lists.add(dates);
        lists.add(longs);
        lists.add(doubles);
        lists.add(strings);
        lists.add(arrays);
        Collections.sort(lists, new Comparator<List>(){

            @Override
            public int compare(List a, List b) {
                return -(a.size() - b.size());
            }
        });
        List values = (List)lists.get(0);
        output.addAll(values);
        if (values == booleans) {
            return Type.BOOLEAN;
        }
        if (values == longs) {
            return Type.BIGINT;
        }
        if (values == doubles) {
            return Type.DOUBLE;
        }
        if (values == dates) {
            return Type.DATE;
        }
        if (values == arrays) {
            return Type.ARRAY;
        }
        if (values == strings) {
            return Type.STRING;
        }
        return null;
    }

    private List<Probe> getProbesOfObject(Object object, MetricTargetType objectType) {
        ArrayList<Probe> probes = new ArrayList();
        if (objectType == MetricTargetType.DATASET) {
            probes = ((Dataset)object).getModel().getMetrics().probes;
        } else if (objectType == MetricTargetType.MANAGED_FOLDER) {
            probes = ((ManagedFolder)object).metrics.probes;
        }
        for (Probe probe : probes) {
            ProbeType pt = ProbeType.getProbeType(probe.getType());
            if (pt.isUserSelectedProbe()) continue;
            probe.withMeta(pt.getMeta());
        }
        return probes;
    }

    private static DatasetLocUtils.DatasetLoc getObjectLoc(Object object, MetricTargetType objectType) {
        switch (objectType) {
            case DATASET: {
                return ((Dataset)object).getDatasetLoc();
            }
            case MANAGED_FOLDER: {
                return new DatasetLocUtils.DatasetLoc(((ManagedFolder)object).projectKey, ((ManagedFolder)object).id);
            }
            case SAVED_MODEL: {
                return new DatasetLocUtils.DatasetLoc(((SavedModel)object).projectKey, ((SavedModel)object).id);
            }
            case MODEL_EVALUATION_STORE: {
                return new DatasetLocUtils.DatasetLoc(((ModelEvaluationStore)object).projectKey, ((ModelEvaluationStore)object).id);
            }
            case PROJECT: {
                return new DatasetLocUtils.DatasetLoc(((SerializedProject)object).projectKey, null);
            }
        }
        throw new IllegalArgumentException("Unknown object type " + String.valueOf((Object)objectType));
    }

    public MetricHistoriesData getMetricData_NT(Object object, MetricTargetType objectType, Partition partition, List<String> metricIds) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList histories = Lists.newArrayList();
        for (String metricId : metricIds) {
            MetricHistoryData history = this.getMetricData_NT(object, objectType, partition, metricId, false);
            if (history == null) continue;
            histories.add(history);
        }
        return new MetricHistoriesData(histories);
    }

    public ProbesSet subsetProbesForColumn(Dataset dataset, String columnName) {
        return this.subsetProbesForColumns(dataset.getModel().getMetrics(), Lists.newArrayList((Object[])new SchemaColumn[]{dataset.getSchema().getColumn(columnName)}));
    }

    public ProbesSet subsetProbesForColumn(Dataset dataset, String columnName, SerializedShakerScript.FullSampleStatisticsConfig statisticsConfig) {
        return this.subsetProbesForColumns(dataset.getModel().getMetrics(), Lists.newArrayList((Object[])new SchemaColumn[]{dataset.getSchema().getColumn(columnName)}), statisticsConfig);
    }

    public ProbesSet subsetProbesForAllColumns(Dataset dataset, SerializedShakerScript.FullSampleStatisticsConfig statisticsConfig) {
        return this.subsetProbesForColumns(dataset.getModel().getMetrics(), dataset.getSchema().getColumns(), statisticsConfig);
    }

    public ProbesSet subsetProbesForColumns(ProbesSet metrics, List<SchemaColumn> columns) {
        ProbesSet ret = new ProbesSet();
        ret.engineConfig = metrics.engineConfig;
        ret.displayedState = metrics.displayedState;
        for (Probe probe : metrics.probes) {
            ProbeType probeType = ProbeType.getProbeType(probe.getType());
            ProbeConfiguration configuration = probeType.buildFullConfiguration(columns, probe);
            if (configuration == null) continue;
            probe = (Probe)JSON.deepCopy((Object)probe);
            probe.enabled = true;
            probe.configuration = configuration;
            ret.probes.add(probe);
        }
        return ret;
    }

    public ProbesSet subsetProbesForColumns(ProbesSet metrics, List<SchemaColumn> columns, SerializedShakerScript.FullSampleStatisticsConfig statisticsConfig) {
        Probe probe;
        ProbeType probeType;
        ProbesSet ret = new ProbesSet();
        ret.engineConfig = statisticsConfig.engineConfig;
        ret.engineConfig.padRunsWithMetrics = statisticsConfig.computeCostFreeMetrics;
        ret.displayedState = metrics.displayedState;
        if (statisticsConfig.basic || statisticsConfig.countDistinct) {
            probeType = ProbeType.getProbeType("col_stats");
            probe = new Probe(probeType.getType());
            probe.configuration = probeType.buildFullConfiguration(columns, probe);
            probe.getConfigurationAs(BasicStatsDatasetProbeType.BasicStatsDatasetProbeConfiguration.class).filterOutExpensiveAggregations(statisticsConfig.countDistinct, false);
            probe.enabled = true;
            ret.probes.add(probe);
        }
        if (statisticsConfig.advanced) {
            probeType = ProbeType.getProbeType("adv_col_stats");
            probe = new Probe(probeType.getType());
            probe.configuration = probeType.buildFullConfiguration(columns, probe);
            probe.getConfigurationAs(AdvancedStatsDatasetProbeType.AdvancedStatsDatasetProbeConfiguration.class).numberTopValues = statisticsConfig.numberTopValues;
            probe.enabled = true;
            ret.probes.add(probe);
        }
        if (statisticsConfig.percentile) {
            probeType = ProbeType.getProbeType("percentile_stats");
            probe = new Probe(probeType.getType());
            probe.configuration = probeType.buildFullConfiguration(columns, probe);
            probe.enabled = true;
            ret.probes.add(probe);
        }
        if (statisticsConfig.validity) {
            probeType = ProbeType.getProbeType("verify_col");
            probe = new Probe(probeType.getType());
            probe.configuration = probeType.buildFullConfiguration(columns, probe);
            probe.enabled = true;
            ret.probes.add(probe);
        }
        return ret;
    }

    public MetricColumnsData getColumnMetricData(Dataset dataset, Partition partition, List<String> metricIds, List<String> columnNames) throws Exception {
        logger.info((Object)("Preparing metrics column data for " + Joiner.on((String)", ").join(metricIds)));
        HashSet metricTypeIds = Sets.newHashSet();
        String columnPlaceholder = "${column}";
        for (String string : metricIds) {
            Metric metric = Metric.deserializeMetric(string);
            String string2 = metric.getColumn();
            if (!StringUtils.isNotBlank((String)string2)) continue;
            String metricTypeId = metric.getColumnInvariantId(columnPlaceholder);
            metricTypeIds.add(metricTypeId);
        }
        logger.info((Object)("Retrieving metrics " + Joiner.on((String)",").join((Iterable)metricTypeIds) + " for columns " + Joiner.on((String)",").join(columnNames)));
        HashMap metricIdsPerMetricType = Maps.newHashMap();
        for (Object metricTypeId : metricTypeIds) {
            ArrayList arrayList = Lists.newArrayList();
            for (String columnName : columnNames) {
                arrayList.add(((String)metricTypeId).replace(columnPlaceholder, columnName));
            }
            metricIdsPerMetricType.put(metricTypeId, arrayList);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry entry : metricIdsPerMetricType.entrySet()) {
            MetricColumnData history = this.getColumnMetricData(dataset, (String)entry.getKey(), partition, (List<String>)((List)entry.getValue()));
            if (history == null) continue;
            arrayList.add(history);
        }
        MetricColumnsData columnsData = new MetricColumnsData(arrayList);
        PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
        columnsData.partition = partition == null ? null : partition.id();
        columnsData.isTimePartition = partitioningScheme.isPartitioned() && partitioningScheme.isSingleDimension() && partitioningScheme.getSingleDimension() instanceof TimeDimension;
        TimeDimension.Period period = columnsData.partitionTimePeriod = columnsData.isTimePartition ? ((TimeDimension)partitioningScheme.getSingleDimension()).mappedPeriod : null;
        if (columnsData.isTimePartition) {
            TimeDimension dimension = (TimeDimension)partitioningScheme.getSingleDimension();
            try {
                TimeDimensionValue partitionValue = (TimeDimensionValue)dimension.getValueFromId(columnsData.partition);
                columnsData.partitionTime = partitionValue.getCalendar().getTimeInMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return columnsData;
    }

    public MetricColumnData getColumnMetricData(Dataset dataset, String metricTypeId, Partition partition, List<String> requestedMetricIds) throws Exception {
        logger.info((Object)("Preparing " + requestedMetricIds.size() + " metrics column data for " + metricTypeId + " on " + String.valueOf(dataset.getLoc())));
        List<ReadOnlyJobsInternalDB.MetricDataPoint> points = this.jobsDatabaseService.getLastMetricValues(MetricsService.getObjectLoc(dataset, MetricTargetType.DATASET), partition == null ? null : partition.id(), requestedMetricIds);
        Metric metric = Metric.deserializeMetric(metricTypeId);
        MetricColumnData columns = new MetricColumnData(metric, dataset);
        columns.meta = metric.getMeta();
        ArrayList converted = Lists.newArrayList();
        Boolean booleanMeaning = new Boolean();
        AnyTemporal anyTemporalMeaning = new AnyTemporal();
        DoubleMeaning doubleMeaning = new DoubleMeaning();
        LongMeaning longMeaning = new LongMeaning();
        JSONArrayMeaning arrayMeaning = new JSONArrayMeaning();
        block9: for (ReadOnlyJobsInternalDB.MetricDataPoint point : points) {
            try {
                switch (point.type) {
                    case BIGINT: 
                    case INT: 
                    case SMALLINT: 
                    case TINYINT: {
                        converted.add(new MetricColumnPoint<Object>(point.metric.getColumn(), point.time, point.type, (point.value == null ? null : Long.valueOf(longMeaning.longValue(point.value)))));
                        break;
                    }
                    case BOOLEAN: {
                        converted.add(new MetricColumnPoint<Object>(point.metric.getColumn(), point.time, point.type, (point.value == null ? null : java.lang.Boolean.valueOf(booleanMeaning.parse(point.value)))));
                        break;
                    }
                    case DATE: {
                        converted.add(new MetricColumnPoint<Object>(point.metric.getColumn(), point.time, point.type, (point.value == null ? null : Long.valueOf(anyTemporalMeaning.longValue(point.value)))));
                        break;
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        if (point.value == null) {
                            converted.add(new MetricColumnPoint<Object>(point.metric.getColumn(), point.time, point.type, null));
                            break;
                        }
                        double doubleValue = doubleMeaning.doubleValue(point.value);
                        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                            throw new Exception();
                        }
                        converted.add(new MetricColumnPoint<Double>(point.metric.getColumn(), point.time, point.type, doubleValue));
                        break;
                    }
                    case ARRAY: {
                        if (!(arrayMeaning.detects(point.value) > 0.0)) continue block9;
                        List list = (List)JSON.parse((String)point.value, List.class);
                        ArrayList listStrings = Lists.newArrayList((Iterable)Iterables.transform((Iterable)list, (Function)new Function<Object, String>(){

                            public String apply(Object o) {
                                if (o == null) {
                                    return null;
                                }
                                if (o instanceof String) {
                                    return (String)o;
                                }
                                if (o instanceof Number || o instanceof java.lang.Boolean) {
                                    return o.toString();
                                }
                                return JSON.json((Object)o);
                            }
                        }));
                        converted.add(new MetricColumnPoint<String[]>(point.metric.getColumn(), point.time, point.type, listStrings.toArray(new String[0])));
                        break;
                    }
                    default: {
                        converted.add(new MetricColumnPoint<String>(point.metric.getColumn(), point.time, point.type, point.value));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                converted.add(new MetricColumnPoint<String>(point.metric.getColumn(), point.time, Type.STRING, point.value));
            }
        }
        columns.setValues(converted);
        return columns;
    }

    public MetricPartitionsData getPartitionMetricData(Dataset dataset, List<String> metricIds) throws Exception {
        logger.info((Object)("Preparing metrics partition data for " + Joiner.on((String)", ").join(metricIds)));
        ArrayList partitions = Lists.newArrayList();
        for (String metricId : metricIds) {
            MetricPartitionData history = this.getPartitionMetricData(MetricTargetType.DATASET, dataset, metricId, false);
            if (history == null) continue;
            partitions.add(history);
        }
        return new MetricPartitionsData(partitions);
    }

    public MetricPartitionsData getPartitionMetricData(ManagedFolder folder, List<String> metricIds) throws Exception {
        logger.info((Object)("Preparing metrics partition data for " + Joiner.on((String)", ").join(metricIds)));
        ArrayList partitions = Lists.newArrayList();
        for (String metricId : metricIds) {
            MetricPartitionData history = this.getPartitionMetricData(MetricTargetType.MANAGED_FOLDER, folder, metricId, false);
            if (history == null) continue;
            partitions.add(history);
        }
        return new MetricPartitionsData(partitions);
    }

    public MetricPartitionsData getPartitionMetricData(SavedModel savedModel, List<String> metricIds) throws Exception {
        logger.info((Object)("Preparing metrics partition data for " + Joiner.on((String)", ").join(metricIds)));
        ArrayList partitions = Lists.newArrayList();
        for (String metricId : metricIds) {
            MetricPartitionData history = this.getPartitionMetricData(savedModel, metricId, false);
            if (history == null) continue;
            partitions.add(history);
        }
        return new MetricPartitionsData(partitions);
    }

    public MetricPartitionsData getPartitionMetricData(ModelEvaluationStore mes, List<String> metricIds) throws Exception {
        logger.info((Object)("Preparing metrics partition data for " + Joiner.on((String)", ").join(metricIds)));
        ArrayList partitions = Lists.newArrayList();
        for (String metricId : metricIds) {
            MetricPartitionData history = this.getPartitionMetricData(MetricTargetType.MODEL_EVALUATION_STORE, mes, metricId, false);
            if (history == null) continue;
            partitions.add(history);
        }
        return new MetricPartitionsData(partitions);
    }

    public MetricPartitionData getPartitionMetricData(MetricTargetType objectType, Partitionable dataset, String requestedMetricId, boolean alwaysReturnPoints) throws Exception {
        Metric metric;
        logger.info((Object)("Preparing metrics partition data for " + requestedMetricId + " on " + dataset.getFullName()));
        List<ReadOnlyJobsInternalDB.MetricDataPoint> points = this.jobsDatabaseService.getLastMetricValues(MetricsService.getObjectLoc(dataset, objectType), requestedMetricId);
        if (!points.isEmpty()) {
            metric = points.get((int)(points.size() - 1)).metric;
        } else if (alwaysReturnPoints) {
            metric = new ExternalProbeType.ExternalMetric(requestedMetricId, Type.STRING);
        } else {
            return null;
        }
        MetricPartitionData partitions = new MetricPartitionData(metric, dataset);
        ArrayList converted = Lists.newArrayList();
        partitions.valueType = this.getTypeWithMostValues(points, converted);
        partitions.setValues(converted);
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        partitions.isTimePartition = scheme.isPartitioned() && scheme.isSingleDimension() && scheme.getSingleDimension() instanceof TimeDimension;
        TimeDimension.Period period = partitions.partitionTimePeriod = scheme.isPartitioned() && scheme.isSingleDimension() && scheme.getSingleDimension() instanceof TimeDimension ? ((TimeDimension)scheme.getSingleDimension()).mappedPeriod : null;
        if (partitions.isTimePartition) {
            TimeDimension dimension = (TimeDimension)scheme.getSingleDimension();
            for (MetricPartitionPoint point : partitions.values) {
                try {
                    TimeDimensionValue partitionValue = (TimeDimensionValue)dimension.getValueFromId(point.partition);
                    point.partitionTime = partitionValue.getCalendar().getTimeInMillis();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return partitions;
    }

    public MetricPartitionData getPartitionMetricData(SavedModel savedModel, String requestedMetricId, boolean alwaysReturnPoints) throws Exception {
        Metric metric;
        logger.info((Object)("Preparing metrics partition data for " + requestedMetricId + " on " + savedModel.id));
        List<ReadOnlyJobsInternalDB.MetricDataPoint> points = this.jobsDatabaseService.getLastMetricValues(MetricsService.getObjectLoc(savedModel, MetricTargetType.SAVED_MODEL), requestedMetricId);
        if (!points.isEmpty()) {
            metric = points.get((int)(points.size() - 1)).metric;
        } else if (alwaysReturnPoints) {
            metric = new ExternalProbeType.ExternalMetric(requestedMetricId, Type.STRING);
        } else {
            return null;
        }
        points = this.keepOnlyPointsOfFinalVersions(savedModel, points);
        MetricPartitionData partitions = new MetricPartitionData(metric, savedModel);
        ArrayList converted = Lists.newArrayList();
        partitions.valueType = this.getTypeWithMostValues(points, converted);
        partitions.setValues(converted);
        partitions.isTimePartition = false;
        return partitions;
    }

    private List<ReadOnlyJobsInternalDB.MetricDataPoint> keepOnlyPointsOfFinalVersions(SavedModel savedModel, List<ReadOnlyJobsInternalDB.MetricDataPoint> points) {
        if (savedModel.isPartitioned()) {
            HashSet versionIds = Sets.newHashSet();
            List<FullModelId> finalVersions = this.predictionSMMgmtService.listUsableVersions(savedModel);
            for (FullModelId fmi : finalVersions) {
                versionIds.add(fmi.getSavedModelVersionID());
            }
            ArrayList filteredPoints = Lists.newArrayList();
            for (ReadOnlyJobsInternalDB.MetricDataPoint point : points) {
                if (!StringUtils.isBlank((String)point.partition) && !versionIds.contains(point.partition)) continue;
                filteredPoints.add(point);
            }
            points = filteredPoints;
        }
        return points;
    }

    public CheckHistoriesData getCheckData_NT(Object object, MetricTargetType objectType, Partition partition, List<String> checkNames) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList histories = Lists.newArrayList();
        for (String checkName : checkNames) {
            CheckHistoryData history = this.getCheckData_NT(object, objectType, partition, checkName, false);
            if (history == null) continue;
            histories.add(history);
        }
        return new CheckHistoriesData(histories);
    }

    public CheckHistoryData getCheckData_NT(Object object, MetricTargetType objectType, Partition partition, String requestedCheckName, boolean alwaysReturnPoints) throws Exception {
        DataQualityRule rule;
        TransactionContext.assertNoAttachedTransaction();
        List<ReadOnlyJobsInternalDB.CheckDataPoint> points = partition == null ? this.jobsDatabaseService.getChecks(MetricsService.getObjectLoc(object, objectType), requestedCheckName) : this.jobsDatabaseService.getChecks(MetricsService.getObjectLoc(object, objectType), partition.id(), requestedCheckName);
        if (!points.isEmpty()) {
            rule = points.get((int)(points.size() - 1)).check;
        } else if (alwaysReturnPoints) {
            rule = new ExternalCheck(requestedCheckName);
        } else {
            return null;
        }
        CheckHistoryData history = new CheckHistoryData(rule, requestedCheckName);
        history.set(points.toArray(new ReadOnlyJobsInternalDB.CheckDataPoint[0]));
        return history;
    }

    public MetricHistoryData getMetricData_NT(Object object, MetricTargetType objectType, Partition partition, String requestedMetricId, boolean alwaysReturnPoints) throws Exception {
        Metric metric;
        TransactionContext.assertNoAttachedTransaction();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> points = partition == null ? this.jobsDatabaseService.getMetrics(MetricsService.getObjectLoc(object, objectType), requestedMetricId) : this.jobsDatabaseService.getMetrics(MetricsService.getObjectLoc(object, objectType), partition.id(), requestedMetricId);
        if (!points.isEmpty()) {
            metric = points.get((int)(points.size() - 1)).metric;
        } else if (alwaysReturnPoints) {
            metric = new ExternalProbeType.ExternalMetric(requestedMetricId, Type.STRING);
        } else {
            return null;
        }
        MetricHistoryData history = new MetricHistoryData(metric, object);
        ArrayList converted = Lists.newArrayList();
        Type valueType = this.getTypeWithMostValues(points, converted);
        history.set(valueType, converted.toArray(new MetricPartitionPoint[0]));
        return history;
    }

    public MetricPartitionsList getLastKnownListOfPartitions(Object object, MetricTargetType objectType) throws Exception {
        if (object instanceof SavedModel) {
            return new MetricPartitionsList(false, null, null);
        }
        if (object instanceof Partitionable) {
            Partitionable dataset = (Partitionable)object;
            PartitioningScheme scheme = dataset.getPartitioningSchema();
            if (scheme == null || !scheme.isPartitioned()) {
                return new MetricPartitionsList(false, null, Lists.newArrayList((Object[])new MetricPartition[]{new MetricPartition("NP", 0L)}));
            }
            TimeDimension timeDimension = scheme.isSingleDimension() && scheme.getSingleDimension() instanceof TimeDimension ? (TimeDimension)scheme.getSingleDimension() : null;
            DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, objectType);
            List<ReadOnlyJobsInternalDB.MetricDataPoint> partitionList = this.jobsDatabaseService.getLastMetricValues(loc, new PartitioningProbeType.PartitioningMetric(PartitioningProbeType.PartitioningMetrics.PARTITIONS_LIST).getId());
            if (!partitionList.isEmpty()) {
                for (ReadOnlyJobsInternalDB.MetricDataPoint point : partitionList) {
                    if (!point.partition.equals("ALL") && !point.partition.equals("NP")) continue;
                    try {
                        List partitionIds = (List)JSON.parse((String)point.value, (TypeToken)new TypeToken<List<String>>(){});
                        return new MetricPartitionsList(scheme, partitionIds);
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return new MetricPartitionsList(timeDimension != null, timeDimension != null ? timeDimension.mappedPeriod : null, new ArrayList<MetricPartition>());
        }
        return new MetricPartitionsList(false, null, null);
    }

    public Map<String, Metric> getLastKnownMetrics_NT(Object object, MetricTargetType objectType) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashMap metrics = Maps.newHashMap();
        DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, objectType);
        List<ReadOnlyJobsInternalDB.MetricDataPoint> lastComputes = this.jobsDatabaseService.getLastMetrics(loc);
        for (ReadOnlyJobsInternalDB.MetricDataPoint lastCompute : lastComputes) {
            metrics.put(lastCompute.metric.getId(), lastCompute.metric);
        }
        return metrics;
    }

    public Map<String, Check> getLastKnownProjectChecks_NT(Object object) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashMap metrics = Maps.newHashMap();
        DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, MetricTargetType.PROJECT);
        List<ReadOnlyJobsInternalDB.CheckDataPoint> lastComputes = this.jobsDatabaseService.getLastChecks(loc);
        for (ReadOnlyJobsInternalDB.CheckDataPoint lastCompute : lastComputes) {
            if (!(lastCompute.check instanceof Check)) continue;
            metrics.put(lastCompute.check.getId(), (Check)lastCompute.check);
        }
        return metrics;
    }

    public ComputedMetric getComputedMetric_NT(DatasetLocUtils.DatasetLoc loc, Metric metric, boolean withLastValues) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> lastComputes = this.jobsDatabaseService.getLastMetricValues(loc, metric.getId());
        ComputedMetric ret = new ComputedMetric(metric, false);
        for (ReadOnlyJobsInternalDB.MetricDataPoint point : lastComputes) {
            if (withLastValues) {
                ret.lastValues.add(new ComputedMetricPartition(point.time, point.partition, point.type, point.value));
            }
            ret.partitionsWithValue.add(point.partition);
        }
        return ret;
    }

    public ComputedMetrics listComputedMetrics_NT(Object object, MetricTargetType objectType, DisplayedMetricsSet displayed, boolean withLastValues) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashSet displayedAsMetric = Sets.newHashSet();
        if (displayed != null) {
            displayedAsMetric.addAll(displayed.metrics);
        }
        DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, objectType);
        List<ReadOnlyJobsInternalDB.MetricDataPoint> lastComputes = this.jobsDatabaseService.getLastMetrics(loc);
        ComputedMetrics computed = new ComputedMetrics();
        try (Transaction t = this.transactionService.beginRead();){
            if (objectType == MetricTargetType.SAVED_MODEL) {
                lastComputes = this.keepOnlyPointsOfFinalVersions((SavedModel)object, lastComputes);
            }
            HashMap metrics = Maps.newHashMap();
            for (ReadOnlyJobsInternalDB.MetricDataPoint point : lastComputes) {
                String metricId = point.metric.getId();
                Metric metric = point.metric;
                if (!metrics.containsKey(metricId)) {
                    metrics.put(metricId, new ComputedMetric(metric, displayedAsMetric.contains(metricId)));
                }
                if (withLastValues) {
                    ((ComputedMetric)metrics.get((Object)metricId)).lastValues.add(new ComputedMetricPartition(point.time, point.partition, point.type, point.value));
                }
                ((ComputedMetric)metrics.get((Object)metricId)).partitionsWithValue.add(point.partition);
            }
            this.padWithNonExistingMetricAndFlagComputed(metrics, displayedAsMetric, object, objectType);
            computed.metrics.addAll(metrics.values());
            computed.notExistingViews = Lists.newArrayList((Object[])JobsdbDatasetParams.View.values());
            for (ComputedMetric computedMetric : computed.metrics) {
                computedMetric.notExistingViews = Lists.newArrayList((Object[])JobsdbDatasetParams.View.values());
            }
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(loc.getProjectKey())) {
                if (!"JobsDB".equals(dataset.type)) continue;
                JobsdbDatasetParams params = (JobsdbDatasetParams)dataset.getParams();
                try {
                    AnyLoc target;
                    if (params.scope != JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT || !(target = DatasetLocUtils.DatasetLoc.resolveSmart(dataset.projectKey, params.smartName)).equals(loc)) continue;
                    if (StringUtils.isBlank((String)params.filter)) {
                        computed.notExistingViews.remove((Object)params.view);
                        continue;
                    }
                    for (ComputedMetric computedMetric : computed.metrics) {
                        if (!params.filter.equals(computedMetric.metric.getId())) continue;
                        computedMetric.notExistingViews.remove((Object)params.view);
                    }
                }
                catch (Exception ex) {
                    logger.info((Object)("Error while searching for metrics dataset on " + loc.getFullName()), (Throwable)ex);
                }
            }
        }
        this.sortComputedMetricsByName(computed);
        this.enrichComputedMetricsWithName_NT(computed, object);
        return computed;
    }

    private void enrichComputedMetricsWithName_NT(ComputedMetrics computed, Object object) throws Exception {
        if (object instanceof Dataset && computed.metrics.stream().anyMatch(m -> m.metric instanceof CheckProbeType.CheckMetric)) {
            SerializedDataset dataset = ((Dataset)object).getModel();
            Map<String, String> allRules = this.jobsDatabaseService.getAllRulesThatEverExisted(dataset.projectKey, dataset.name, null);
            dataset.getDataQualityRuleSet().getRules().forEach(rule -> allRules.put(rule.getId(), rule.getDisplayName()));
            computed.metrics.stream().filter(m -> m.metric instanceof CheckProbeType.CheckMetric && allRules.containsKey(((CheckProbeType.CheckMetric)m.metric).getCheckName())).forEach(m -> {
                m.meta.name = "Rule " + (String)allRules.get(((CheckProbeType.CheckMetric)m.metric).getCheckName());
            });
        }
    }

    private void padWithNonExistingMetricAndFlagComputed(Map<String, ComputedMetric> metrics, Set<String> displayedAsMetric, Object object, MetricTargetType objectType) {
        if (displayedAsMetric != null) {
            for (String metricId : displayedAsMetric) {
                if (metrics.containsKey(metricId)) continue;
                try {
                    Metric metric = Metric.deserializeMetric(metricId);
                    metrics.put(metricId, new ComputedMetric(metric, true));
                }
                catch (Exception ex) {
                    logger.info((Object)("Unparsable metricId " + metricId), (Throwable)ex);
                }
            }
        }
        ProbesSet probes = null;
        if (objectType == MetricTargetType.DATASET) {
            probes = ((Dataset)object).getModel().getMetrics();
        } else if (objectType == MetricTargetType.MANAGED_FOLDER) {
            probes = ((ManagedFolder)object).metrics;
        }
        if (probes != null) {
            for (Probe probe : probes.probes) {
                ProbeType probeType = ProbeType.getProbeType(probe.getType());
                if (probeType == null) {
                    logger.warn((Object)("Unknown probe " + probe.getType() + ". Skipping the probe."));
                    continue;
                }
                if (!probe.isEnabled()) {
                    logger.info((Object)("Probe " + probe.getType() + " is not enabled."));
                    continue;
                }
                for (Metric metric : probeType.getMetricsToCompute(probe, object, objectType, true)) {
                    if (!metrics.containsKey(metric.getId())) {
                        metrics.put(metric.getId(), new ComputedMetric(metric, false));
                    }
                    metrics.get((Object)metric.getId()).computingProbe = metric.getType();
                }
            }
        }
    }

    public ComputedChecks listComputedChecks_NT(Object object, MetricTargetType objectType, DisplayedChecksSet displayed, boolean withLastValues) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashSet displayedAsCheck = Sets.newHashSet();
        if (displayed != null) {
            displayedAsCheck.addAll(displayed.checks);
        }
        DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, objectType);
        List<ReadOnlyJobsInternalDB.CheckDataPoint> lastComputes = this.jobsDatabaseService.getLastChecks(loc);
        HashMap checks = Maps.newHashMap();
        for (ReadOnlyJobsInternalDB.CheckDataPoint point : lastComputes) {
            String checkName = point.name;
            DataQualityRule rule = point.check;
            if (!checks.containsKey(checkName)) {
                checks.put(checkName, new ComputedCheck(rule, checkName, displayedAsCheck.contains(checkName)));
            }
            if (withLastValues) {
                ((ComputedCheck)checks.get((Object)checkName)).lastValues.add(new ComputedCheckPartition(point.time, point.partition, point.outcome, point.message));
            }
            ((ComputedCheck)checks.get((Object)checkName)).partitionsWithValue.add(point.partition);
        }
        try (Transaction t = this.transactionService.beginRead();){
            ComputedChecks computed = new ComputedChecks();
            computed.checks.addAll(checks.values());
            computed.notExistingViews = Lists.newArrayList((Object[])JobsdbDatasetParams.View.values());
            for (ComputedCheck computedMetric : computed.checks) {
                computedMetric.notExistingViews = Lists.newArrayList((Object[])JobsdbDatasetParams.View.values());
            }
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(loc.getProjectKey())) {
                if (!"JobsDB".equals(dataset.type)) continue;
                JobsdbDatasetParams params = (JobsdbDatasetParams)dataset.getParams();
                try {
                    AnyLoc target;
                    if (params.scope != JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT || !(target = DatasetLocUtils.DatasetLoc.resolveSmart(dataset.projectKey, params.smartName)).equals(loc)) continue;
                    if (StringUtils.isBlank((String)params.filter)) {
                        computed.notExistingViews.remove((Object)params.view);
                        continue;
                    }
                    for (ComputedCheck computedCheck : computed.checks) {
                        if (!params.filter.equals(computedCheck.name)) continue;
                        computedCheck.notExistingViews.remove((Object)params.view);
                    }
                }
                catch (Exception ex) {
                    logger.info((Object)("Error while searching for checks dataset on " + loc.getFullName()), (Throwable)ex);
                }
            }
            this.sortComputedChecksByName(computed);
            ComputedChecks computedChecks = computed;
            return computedChecks;
        }
    }

    public ComputedChecks listComputedChecks_NT(Object object, MetricTargetType objectType, Partition partition, DisplayedChecksSet displayed, boolean withLastValues) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashSet displayedAsCheck = Sets.newHashSet();
        if (displayed != null) {
            displayedAsCheck.addAll(displayed.checks);
        }
        DatasetLocUtils.DatasetLoc loc = MetricsService.getObjectLoc(object, objectType);
        List<ReadOnlyJobsInternalDB.CheckDataPoint> lastComputes = this.jobsDatabaseService.getLastChecks(loc, partition == null ? null : partition.id());
        HashMap checks = Maps.newHashMap();
        for (ReadOnlyJobsInternalDB.CheckDataPoint point : lastComputes) {
            String checkName = point.name;
            DataQualityRule check = point.check;
            if (!checks.containsKey(checkName)) {
                checks.put(checkName, new ComputedCheck(check, checkName, displayedAsCheck.contains(checkName)));
            }
            if (withLastValues) {
                ((ComputedCheck)checks.get((Object)checkName)).lastValues.add(new ComputedCheckPartition(point.time, point.partition, point.outcome, point.message));
            }
            ((ComputedCheck)checks.get((Object)checkName)).partitionsWithValue.add(point.partition);
        }
        ComputedChecks computed = new ComputedChecks();
        computed.checks.addAll(checks.values());
        this.sortComputedChecksByName(computed);
        return computed;
    }

    public ComputedMetrics listComputedMetrics_NT(Object object, MetricTargetType objectType, Partition partition, DisplayedMetricsSet displayed, boolean withLastValues) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        HashSet displayedAsMetric = Sets.newHashSet();
        if (displayed != null) {
            displayedAsMetric.addAll(displayed.metrics);
        }
        List<ReadOnlyJobsInternalDB.MetricDataPoint> lastComputes = this.jobsDatabaseService.getLastMetrics(MetricsService.getObjectLoc(object, objectType), partition == null ? null : partition.id());
        HashMap metrics = Maps.newHashMap();
        for (ReadOnlyJobsInternalDB.MetricDataPoint point : lastComputes) {
            String metricId = point.metric.getId();
            Metric metric = point.metric;
            if (!metrics.containsKey(metricId)) {
                metrics.put(metricId, new ComputedMetric(metric, displayedAsMetric.contains(metricId)));
            }
            if (withLastValues) {
                ((ComputedMetric)metrics.get((Object)metricId)).lastValues.add(new ComputedMetricPartition(point.time, point.partition, point.type, point.value));
            }
            ((ComputedMetric)metrics.get((Object)metricId)).partitionsWithValue.add(point.partition);
        }
        this.padWithNonExistingMetricAndFlagComputed(metrics, displayedAsMetric, object, objectType);
        ComputedMetrics computed = new ComputedMetrics();
        computed.metrics.addAll(metrics.values());
        this.sortComputedMetricsByName(computed);
        return computed;
    }

    private void sortComputedMetricsByName(ComputedMetrics computed) {
        Collections.sort(computed.metrics, new Comparator<ComputedMetric>(){

            @Override
            public int compare(ComputedMetric a, ComputedMetric b) {
                String bName;
                String aName;
                String string = aName = a.meta == null ? null : a.meta.getFullName();
                if (StringUtils.isBlank((String)aName)) {
                    String string2 = aName = a.meta == null ? null : a.meta.getName();
                }
                if (StringUtils.isBlank((String)aName)) {
                    aName = a.metric.getId();
                }
                assert (aName != null);
                String string3 = bName = b.meta == null ? null : b.meta.getFullName();
                if (StringUtils.isBlank((String)bName)) {
                    String string4 = bName = b.meta == null ? null : b.meta.getName();
                }
                if (StringUtils.isBlank((String)bName)) {
                    bName = b.metric.getId();
                }
                return aName.compareTo(bName);
            }
        });
    }

    private void sortComputedChecksByName(ComputedChecks computed) {
        Collections.sort(computed.checks, new Comparator<ComputedCheck>(){

            @Override
            public int compare(ComputedCheck a, ComputedCheck b) {
                String aId = a.check.getId();
                String bId = b.check.getId();
                return aId.compareTo(bId);
            }
        });
    }

    public SerializedDataset saveMetricsSetOnDataset(String projectKey, String name, ProbesSet metrics, AuthCtx liu) throws Exception {
        SerializedDataset existingDataset = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, name);
        DatasetInspector.checkDatasetConnectionPermission(existingDataset, liu, "modify a dataset on");
        SerializedDataset copy = (SerializedDataset)JSON.deepCopy((Object)existingDataset);
        copy.projectKey = projectKey;
        copy.name = name;
        copy.versionTag = VersionTag.increment(existingDataset.versionTag, liu.getIdentifier());
        copy.setMetrics(metrics);
        this.datasetSaveService.saveWithoutEvents(projectKey, name, copy, liu);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, projectKey, name, liu, TaggableObjectChangedEvent.ActionType.DATASET_UPDATE_METRICS));
        return copy;
    }

    public ManagedFolder saveMetricsSetOnManagedFolder(String projectKey, String id, ProbesSet metrics, ChecksSet checks, AuthCtx liu) throws IOException, SQLException {
        ManagedFolder existingFolder = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(projectKey, id);
        ManagedFolder copy = (ManagedFolder)JSON.deepCopy((Object)existingFolder);
        copy.versionTag = VersionTag.increment(existingFolder.versionTag, liu.getIdentifier());
        copy.metrics = metrics;
        copy.checks = checks;
        this.managedFolderDAO.save(copy);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MANAGED_FOLDER, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_UPDATE_METRICS));
        return copy;
    }

    public SerializedProject saveMetricsSetOnProject(String projectKey, ProbesSet metrics, ChecksSet checks, AuthCtx liu) throws IOException, SQLException {
        SerializedProject existingProject = this.projectsDAO.getOrNullUnsafe(projectKey);
        SerializedProject copy = (SerializedProject)JSON.deepCopy((Object)existingProject);
        copy.versionTag = VersionTag.increment(existingProject.versionTag, liu.getIdentifier());
        copy.metrics = metrics;
        copy.metricsChecks = checks;
        this.projectsDAO.save(copy);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, liu, TaggableObjectChangedEvent.ActionType.PROJECT_EDIT));
        return copy;
    }

    public SavedModel saveMetricsSetOnSavedModel(String projectKey, String id, ChecksSet checks, AuthCtx liu) throws IOException, SQLException {
        SavedModel existingModel = (SavedModel)this.savedModelsDAO.getOrNull(projectKey, id);
        SavedModel copy = (SavedModel)JSON.deepCopy((Object)existingModel);
        copy.versionTag = VersionTag.increment(existingModel.versionTag, liu.getIdentifier());
        copy.metricsChecks = checks;
        this.savedModelsDAO.save(copy);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.SAVED_MODEL, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.SAVED_MODEL_UPDATE_METRICS));
        return copy;
    }

    public AvailableMetrics getAvailableMetricsSet(AuthCtx authCtx, Object object, MetricTargetType objectType) throws JSONException, InstantiationException, IllegalAccessException {
        Object hint;
        List<Probe> usedProbes = this.getProbesOfObject(object, objectType);
        HashSet usedProbeTypes = Sets.newHashSet();
        for (Probe probe : usedProbes) {
            usedProbeTypes.add(probe.getType());
        }
        AvailableMetrics availableMetrics = new AvailableMetrics();
        availableMetrics.isHive = objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object);
        availableMetrics.isSql = objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object);
        for (Probe probe : usedProbes) {
            ProbeType probeType = ProbeType.getProbeType(probe.getType());
            if (probeType == null) {
                logger.warn((Object)("No probe type found for " + probe.getType() + ". Discarding the probe."));
                continue;
            }
            hint = probeType.listSelectableMetrics(probe, object, objectType);
            if (hint == null && !probeType.isUserSelectedProbe()) continue;
            availableMetrics.probes.add(new AvailableProbe(probe, hint));
        }
        for (ProbeType probeType : ProbeType.list().values()) {
            if (usedProbeTypes.contains(probeType.getType()) || probeType.isUserSelectedProbe()) continue;
            Probe probe = new Probe(probeType.getType()).withMeta(probeType.getMeta());
            hint = probeType.listSelectableMetrics(probe = probe.withConfiguration(probeType.getParamsClazz().newInstance()), object, objectType);
            if (hint == null) continue;
            availableMetrics.probes.add(new AvailableProbe(probe, hint));
        }
        Collections.sort(availableMetrics.probes, new Comparator<AvailableProbe>(){

            @Override
            public int compare(AvailableProbe a, AvailableProbe b) {
                int levelDiff = a.probe.getMeta().getLevel() - b.probe.getMeta().getLevel();
                if (levelDiff != 0) {
                    return levelDiff;
                }
                String aName = StringUtils.isNotBlank((String)a.probe.getMeta().getName()) ? a.probe.getMeta().getName() : a.probe.getType();
                String bName = StringUtils.isNotBlank((String)b.probe.getMeta().getName()) ? b.probe.getMeta().getName() : b.probe.getType();
                return aName.compareToIgnoreCase(bName);
            }
        });
        return availableMetrics;
    }

    public static Metric lookupMetric(String metricLookup, Map<String, Metric> lastMetrics) {
        Metric lookedUpMetric = null;
        for (String metricId : lastMetrics.keySet()) {
            if (!metricLookup.equals(metricId)) continue;
            lookedUpMetric = lastMetrics.get(metricId);
        }
        if (lookedUpMetric == null) {
            for (Metric metric : lastMetrics.values()) {
                if (!metricLookup.equalsIgnoreCase(metric.getMeta().getFullName())) continue;
                lookedUpMetric = metric;
            }
        }
        if (lookedUpMetric == null) {
            for (Metric metric : lastMetrics.values()) {
                if (!metricLookup.equalsIgnoreCase(metric.getMeta().getName())) continue;
                lookedUpMetric = metric;
            }
        }
        if (lookedUpMetric == null) {
            try {
                Metric metric = (Metric)JSON.parse((String)metricLookup, Metric.class);
                String jsonLookup = JSON.json((Object)metric.withDataType(null));
                for (Metric metric2 : lastMetrics.values()) {
                    if (!jsonLookup.equals(JSON.json((Object)(metric2 = ((Metric)JSON.parse((String)JSON.json((Object)metric2), Metric.class)).withDataType(null))))) continue;
                    lookedUpMetric = metric2;
                }
            }
            catch (Exception ex) {
                logger.info((Object)"Lookup is not json");
            }
        }
        return lookedUpMetric;
    }

    public static Check lookupCheck(String checkLookup, Map<String, Check> lastChecks) {
        Check lookedUpCheck = null;
        for (Map.Entry<String, Check> checkEntry : lastChecks.entrySet()) {
            if (!checkLookup.equals(checkEntry.getKey())) continue;
            lookedUpCheck = checkEntry.getValue();
        }
        if (lookedUpCheck == null) {
            for (Check metric : lastChecks.values()) {
                if (!checkLookup.equalsIgnoreCase(metric.getMeta().getName())) continue;
                lookedUpCheck = metric;
            }
        }
        return lookedUpCheck;
    }

    public Object getHint(Object object, MetricTargetType objectType, Probe probe) {
        logger.info((Object)("Creating hint object for probe of type " + probe.getType()));
        Object hint = null;
        for (ProbeType probeType : ProbeType.list().values()) {
            if (!probeType.getType().equals(probe.getType())) continue;
            hint = probeType.listSelectableMetrics(probe, object, objectType);
            break;
        }
        return hint == null ? new Object() : hint;
    }

    private Long getMetricTime(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, Long def) {
        if (metricsValuesById.containsKey(metricId)) {
            return metricsValuesById.get((Object)metricId).time;
        }
        return def;
    }

    private <T> DataService.FullSampleColumnStatistic<T> getMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, Function<String, T> parse, String reason) {
        if (metricsValuesById.containsKey(metricId)) {
            ReadOnlyJobsInternalDB.MetricDataPoint metricDataPoint = metricsValuesById.get(metricId);
            Object value = parse.apply((Object)metricDataPoint.value);
            if (value != null) {
                return new DataService.FullSampleColumnStatistic<Object>(value, metricDataPoint.hash.equals(hash), null);
            }
            return new DataService.FullSampleColumnStatistic<Object>(null, metricDataPoint.hash.equals(hash), "column is empty or values are not of the expected storage type");
        }
        return new DataService.FullSampleColumnStatistic<Object>(null, StringUtils.isNotBlank((String)reason), reason);
    }

    private <T> void fillMetricValue(Map<String, Object> map, String name, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, Function<String, T> parse, String reason) {
        if (metricsValuesById.containsKey(metricId)) {
            ReadOnlyJobsInternalDB.MetricDataPoint metricDataPoint = metricsValuesById.get(metricId);
            Object value = parse.apply((Object)metricDataPoint.value);
            if (value != null) {
                map.put(name, value);
                map.put(name + "_current", metricDataPoint.hash.equals(hash));
            } else {
                map.put(name + "_reason", "column is empty or values are not of the expected storage type");
            }
        } else {
            map.put(name + "_reason", reason);
        }
    }

    private DataService.FullSampleColumnStatistic<Long> getLongMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, parseLongMetricValue, reason);
    }

    private void fillLongMetricValue(Map<String, Object> map, String name, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        this.fillMetricValue(map, name, metricsValuesById, metricId, hash, parseLongMetricValue, reason);
    }

    private DataService.FullSampleColumnStatistic<Double> getDoubleMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, parseDoubleMetricValue, reason);
    }

    private DataService.FullSampleColumnStatistic<Double> getDateAsDoubleMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, parseDateAsDoubleMetricValue, reason);
    }

    private void fillDoubleMetricValue(Map<String, Object> map, String name, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        this.fillMetricValue(map, name, metricsValuesById, metricId, hash, parseDoubleMetricValue, reason);
    }

    private void fillDateAsDoubleMetricValue(Map<String, Object> map, String name, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        this.fillMetricValue(map, name, metricsValuesById, metricId, hash, parseDateAsDoubleMetricValue, reason);
    }

    private DataService.FullSampleColumnStatistic<String> getStringMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, parseStringMetricValue, reason);
    }

    private void fillStringMetricValue(Map<String, Object> map, String name, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        this.fillMetricValue(map, name, metricsValuesById, metricId, hash, parseStringMetricValue, reason);
    }

    private DataService.FullSampleColumnStatistic<List<String>> getArrayMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, new Function<String, List<String>>(){

            public List<String> apply(String value) {
                try {
                    List list = (List)JSON.parse((String)value, List.class);
                    ArrayList listStrings = Lists.newArrayList((Iterable)Iterables.transform((Iterable)list, (Function)new Function<Object, String>(){

                        public String apply(Object o) {
                            if (o == null) {
                                return null;
                            }
                            if (o instanceof String) {
                                return (String)o;
                            }
                            if (o instanceof Number || o instanceof java.lang.Boolean) {
                                return o.toString();
                            }
                            return JSON.json((Object)o);
                        }
                    }));
                    return listStrings;
                }
                catch (Exception e) {
                    logger.info((Object)("Value " + value + " was not an array as expected"));
                    return null;
                }
            }
        }, reason);
    }

    private DataService.FullSampleColumnStatistic<List<List<?>>> getHistogramMetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, new Function<String, List<List<?>>>(){

            public List<List<?>> apply(String value) {
                try {
                    List bins = (List)JSON.parse((String)value, (TypeToken)new TypeToken<List<Map<String, Long>>>(){});
                    ArrayList chistogram = Lists.newArrayList();
                    for (int i = 1; i < bins.size(); ++i) {
                        Map.Entry lower = ((Map)bins.get(i - 1)).entrySet().iterator().next();
                        Map.Entry upper = ((Map)bins.get(i)).entrySet().iterator().next();
                        double lowerBound = Double.parseDouble((String)lower.getKey());
                        double upperBound = Double.parseDouble((String)upper.getKey());
                        ArrayList bin = Lists.newArrayList();
                        bin.add(lowerBound);
                        bin.add(upperBound);
                        bin.add(lower.getValue());
                        chistogram.add(bin);
                    }
                    return chistogram;
                }
                catch (Exception e) {
                    logger.info((Object)("Value " + value + " was not an array as expected"));
                    return null;
                }
            }
        }, reason);
    }

    private DataService.FullSampleColumnStatistic<List<List<?>>> getTop10MetricValue(Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> metricsValuesById, String metricId, String hash, String reason) {
        return this.getMetricValue(metricsValuesById, metricId, hash, new Function<String, List<List<?>>>(){

            public List<List<?>> apply(String value) {
                try {
                    List valueAndCounts = (List)JSON.parse((String)value, (TypeToken)new TypeToken<List<Map<String, Long>>>(){});
                    ArrayList top10 = Lists.newArrayList();
                    for (int i = 0; i < valueAndCounts.size(); ++i) {
                        Map.Entry valueAndCount = ((Map)valueAndCounts.get(i)).entrySet().iterator().next();
                        ArrayList point = Lists.newArrayList();
                        point.add(valueAndCount.getKey());
                        point.add(valueAndCount.getValue());
                        top10.add(point);
                    }
                    return top10;
                }
                catch (Exception e) {
                    logger.info((Object)("Value " + value + " was not an array as expected"));
                    return null;
                }
            }
        }, reason);
    }

    public DataService.FullSampleColumnDetailedAnalysis getDetailedColumnMetrics_NT(Dataset dataset, String columnName, Partition partition, AuthCtx authCtx) throws Exception {
        String hash;
        TransactionContext.assertNoAttachedTransaction();
        SchemaColumn schemaColumn = dataset.getSchema().getColumn(columnName);
        DataService.FullSampleColumnDetailedAnalysis ret = new DataService.FullSampleColumnDetailedAnalysis();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> metricsValues = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned() ? this.jobsDatabaseService.getLastMetrics(dataset.getLoc(), partition != null ? partition.id() : null) : this.jobsDatabaseService.getLastMetrics(dataset.getLoc());
        HashMap metricsValuesById = Maps.newHashMap();
        for (ReadOnlyJobsInternalDB.MetricDataPoint metricValue : metricsValues) {
            metricsValuesById.put(metricValue.metric.getId(), metricValue);
        }
        ComputableHashComputer hashComputer = new ComputableHashComputer(authCtx);
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            dataset.getModel().getMetrics();
            hash = hashComputer.getCurrentContentHash((DSSDBConnection)conn, (Dataset)dataset, (Partition)(partition != null ? partition : Partition.newNP())).hash;
        }
        ret.lastBuild = this.getMetricTime(metricsValuesById, new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.BUILD_DURATION).getId(), 0L);
        String minMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MIN, columnName, Type.STRING).getId();
        String meanMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MEAN, columnName, Type.DOUBLE).getId();
        String sumMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.SUM, columnName, Type.DOUBLE).getId();
        String maxMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MAX, columnName, Type.STRING).getId();
        String stddevMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.STDDEV, columnName, Type.DOUBLE).getId();
        String countMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, columnName, Type.STRING).getId();
        String countDistinctMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_DISTINCT, columnName, Type.STRING).getId();
        String histogramMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.HISTOGRAM, columnName, Type.STRING).getId();
        String countNullMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, columnName, Type.STRING).getId();
        String modeMetricId = new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric(AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetrics.MODE, columnName, Type.STRING).getId();
        String top10MetricId = new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric(AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetrics.TOP10, columnName, Type.STRING).getId();
        String top10WithCountsMetricId = new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric(AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetrics.TOP10_WITH_COUNTS, columnName, Type.STRING).getId();
        String meaningInvalidCountMetricId = new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric(VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, columnName).getId();
        String medianMetricId = new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric(PercentileStatsDatasetProbeType.PercentileStatsDatasetMetrics.P50, columnName, Type.DOUBLE).getId();
        String iqrMetricId = new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric(PercentileStatsDatasetProbeType.PercentileStatsDatasetMetrics.IQR, columnName, Type.DOUBLE).getId();
        String p25MetricId = new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric(PercentileStatsDatasetProbeType.PercentileStatsDatasetMetrics.P25, columnName, Type.DOUBLE).getId();
        String p75MetricId = new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric(PercentileStatsDatasetProbeType.PercentileStatsDatasetMetrics.P75, columnName, Type.DOUBLE).getId();
        ret.categorical = new DataService.FullSampleColumnCategoricalAnalysis();
        ret.categorical.min = this.getStringMetricValue(metricsValuesById, minMetricId, hash, null);
        ret.categorical.mode = this.getStringMetricValue(metricsValuesById, modeMetricId, hash, null);
        ret.categorical.top10 = this.getArrayMetricValue(metricsValuesById, top10MetricId, hash, null);
        ret.categorical.top10WithCounts = this.getTop10MetricValue(metricsValuesById, top10WithCountsMetricId, hash, null);
        ret.categorical.max = this.getStringMetricValue(metricsValuesById, maxMetricId, hash, null);
        ret.categorical.count = this.getLongMetricValue(metricsValuesById, countMetricId, hash, null);
        ret.categorical.countMissing = this.getLongMetricValue(metricsValuesById, countNullMetricId, hash, null);
        ret.categorical.countDistinct = this.getLongMetricValue(metricsValuesById, countDistinctMetricId, hash, null);
        ret.categorical.countInvalid = schemaColumn == null || StringUtils.isBlank((String)schemaColumn.getMeaning()) ? new DataService.FullSampleColumnStatistic<Object>(null, true, "cannot compute, no meaning forced on column") : this.getLongMetricValue(metricsValuesById, meaningInvalidCountMetricId, hash, null);
        if (schemaColumn != null && schemaColumn.getType().isNumeric()) {
            ret.numeric = new DataService.FullSampleColumnNumericAnalysis();
            ret.numeric.min = this.getDoubleMetricValue(metricsValuesById, minMetricId, hash, null);
            ret.numeric.mean = this.getDoubleMetricValue(metricsValuesById, meanMetricId, hash, null);
            ret.numeric.sum = this.getDoubleMetricValue(metricsValuesById, sumMetricId, hash, null);
            ret.numeric.stddev = this.getDoubleMetricValue(metricsValuesById, stddevMetricId, hash, null);
            ret.numeric.max = this.getDoubleMetricValue(metricsValuesById, maxMetricId, hash, null);
            ret.numeric.histogram = this.getHistogramMetricValue(metricsValuesById, histogramMetricId, hash, null);
            ret.numeric.median = this.getDoubleMetricValue(metricsValuesById, medianMetricId, hash, null);
            ret.numeric.iqr = this.getDoubleMetricValue(metricsValuesById, iqrMetricId, hash, null);
            ret.numeric.p25 = this.getDoubleMetricValue(metricsValuesById, p25MetricId, hash, null);
            ret.numeric.p75 = this.getDoubleMetricValue(metricsValuesById, p75MetricId, hash, null);
        }
        if (schemaColumn != null && schemaColumn.getType().isTemporal()) {
            ret.numeric = new DataService.FullSampleColumnNumericAnalysis();
            ret.numeric.min = this.getDateAsDoubleMetricValue(metricsValuesById, minMetricId, hash, null);
            ret.numeric.max = this.getDateAsDoubleMetricValue(metricsValuesById, maxMetricId, hash, null);
            ret.numeric.mean = this.getDateAsDoubleMetricValue(metricsValuesById, meanMetricId, hash, null);
            ret.numeric.stddev = this.getDoubleMetricValue(metricsValuesById, stddevMetricId, hash, null);
            ret.numeric.histogram = this.getHistogramMetricValue(metricsValuesById, histogramMetricId, hash, null);
            ret.numeric.median = this.getDateAsDoubleMetricValue(metricsValuesById, medianMetricId, hash, null);
            ret.numeric.iqr = this.getDoubleMetricValue(metricsValuesById, iqrMetricId, hash, null);
            ret.numeric.p25 = this.getDateAsDoubleMetricValue(metricsValuesById, p25MetricId, hash, null);
            ret.numeric.p75 = this.getDateAsDoubleMetricValue(metricsValuesById, p75MetricId, hash, null);
        }
        return ret;
    }

    public Map<String, Object> getMultiColumnMetrics_NT(Dataset dataset, String[] columnNames, Partition partition, AuthCtx authCtx) throws Exception {
        String hash;
        TransactionContext.assertNoAttachedTransaction();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> metricsValues = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned() ? this.jobsDatabaseService.getLastMetrics(dataset.getLoc(), partition != null ? partition.id() : null) : this.jobsDatabaseService.getLastMetrics(dataset.getLoc());
        HashMap metricsValuesById = Maps.newHashMap();
        for (ReadOnlyJobsInternalDB.MetricDataPoint metricValue : metricsValues) {
            metricsValuesById.put(metricValue.metric.getId(), metricValue);
        }
        ComputableHashComputer hashComputer = new ComputableHashComputer(authCtx);
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            dataset.getModel().getMetrics();
            hash = hashComputer.getCurrentContentHash((DSSDBConnection)conn, (Dataset)dataset, (Partition)(partition != null ? partition : Partition.newNP())).hash;
        }
        HashMap perColumn = Maps.newHashMap();
        for (String columnName : columnNames) {
            HashMap forColumn = Maps.newHashMap();
            String minMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MIN, columnName, Type.STRING).getId();
            String meanMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MEAN, columnName, Type.DOUBLE).getId();
            String sumMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.SUM, columnName, Type.DOUBLE).getId();
            String maxMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MAX, columnName, Type.STRING).getId();
            String stddevMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.STDDEV, columnName, Type.DOUBLE).getId();
            String countDistinctMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_DISTINCT, columnName, Type.STRING).getId();
            String modeMetricId = new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric(AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetrics.MODE, columnName, Type.STRING).getId();
            String medianMetricId = new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric(PercentileStatsDatasetProbeType.PercentileStatsDatasetMetrics.P50, columnName, Type.DOUBLE).getId();
            String countMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, columnName, Type.STRING).getId();
            String countNullMetricId = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, columnName, Type.STRING).getId();
            String meaningInvalidCountMetricId = new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric(VerifyDatasetColumnProbeType.VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, columnName).getId();
            SchemaColumn schemaColumn = dataset.getSchema().getColumn(columnName);
            if (schemaColumn != null) {
                if (schemaColumn.getType().isNumeric()) {
                    if (schemaColumn.getType().isFloatingPoint()) {
                        this.fillDoubleMetricValue(forColumn, "min", metricsValuesById, minMetricId, hash, "not computed");
                        this.fillDoubleMetricValue(forColumn, "max", metricsValuesById, maxMetricId, hash, "not computed");
                        this.fillDoubleMetricValue(forColumn, "mode", metricsValuesById, modeMetricId, hash, "not computed");
                    } else {
                        this.fillLongMetricValue(forColumn, "min", metricsValuesById, minMetricId, hash, "not computed");
                        this.fillLongMetricValue(forColumn, "max", metricsValuesById, maxMetricId, hash, "not computed");
                        this.fillLongMetricValue(forColumn, "mode", metricsValuesById, modeMetricId, hash, "not computed");
                    }
                    this.fillDoubleMetricValue(forColumn, "median", metricsValuesById, medianMetricId, hash, "not computed");
                    this.fillDoubleMetricValue(forColumn, "mean", metricsValuesById, meanMetricId, hash, "not computed");
                    this.fillDoubleMetricValue(forColumn, "sum", metricsValuesById, sumMetricId, hash, "not computed");
                    this.fillDoubleMetricValue(forColumn, "stddev", metricsValuesById, stddevMetricId, hash, "not computed");
                } else if (schemaColumn.getType().isTemporal()) {
                    this.fillDateAsDoubleMetricValue(forColumn, "min", metricsValuesById, minMetricId, hash, "not computed");
                    this.fillDateAsDoubleMetricValue(forColumn, "max", metricsValuesById, maxMetricId, hash, "not computed");
                    this.fillDateAsDoubleMetricValue(forColumn, "mean", metricsValuesById, meanMetricId, hash, "not computed");
                    this.fillDateAsDoubleMetricValue(forColumn, "median", metricsValuesById, medianMetricId, hash, "not computed");
                    this.fillDoubleMetricValue(forColumn, "stddev", metricsValuesById, stddevMetricId, hash, "not computed");
                    this.fillStringMetricValue(forColumn, "mode", metricsValuesById, modeMetricId, hash, "not computed");
                } else {
                    this.fillStringMetricValue(forColumn, "mode", metricsValuesById, modeMetricId, hash, "not computed");
                }
                this.fillLongMetricValue(forColumn, "cardinality", metricsValuesById, countDistinctMetricId, hash, "not computed");
                this.fillLongMetricValue(forColumn, "presentCount", metricsValuesById, countMetricId, hash, "not computed");
                this.fillLongMetricValue(forColumn, "missingCount", metricsValuesById, countNullMetricId, hash, "not computed");
                this.fillLongMetricValue(forColumn, "invalidCount", metricsValuesById, meaningInvalidCountMetricId, hash, StringUtils.isBlank((String)schemaColumn.getMeaning()) ? "cannot compute, no meaning forced on column" : "not computed");
                if (forColumn.containsKey("presentCount") && forColumn.containsKey("missingCount")) {
                    boolean current;
                    long presentCount = (Long)forColumn.get("presentCount");
                    long missingCount = (Long)forColumn.get("missingCount");
                    boolean bl = current = (java.lang.Boolean)forColumn.get("presentCount_current") != false && (java.lang.Boolean)forColumn.get("missingCount_current") != false;
                    if (presentCount + missingCount > 0L) {
                        double emptyPercentage = 100.0 * (double)missingCount / (double)(presentCount + missingCount);
                        double nonemptyPercentage = 100.0 * (double)presentCount / (double)(presentCount + missingCount);
                        forColumn.put("emptyPercentage", emptyPercentage);
                        forColumn.put("nonemptyPercentage", nonemptyPercentage);
                        forColumn.put("emptyPercentage_current", current);
                        forColumn.put("nonemptyPercentage_current", current);
                        if (forColumn.containsKey("invalidCount")) {
                            long invalidCount = (Long)forColumn.get("invalidCount");
                            current = current && (java.lang.Boolean)forColumn.get("invalidCount_current") != false;
                            double okPercentage = 100.0 * (double)(presentCount - invalidCount) / (double)(presentCount + missingCount);
                            double nokPercentage = 100.0 * (double)invalidCount / (double)(presentCount + missingCount);
                            forColumn.put("okPercentage", okPercentage);
                            forColumn.put("nokPercentage", nokPercentage);
                            forColumn.put("okPercentage_current", current);
                            forColumn.put("nokPercentage_current", current);
                        }
                    }
                }
                if (forColumn.containsKey("missingCount_reason")) {
                    Object reason = forColumn.get("missingCount_reason");
                    forColumn.put("emptyPercentage_reason", reason);
                    forColumn.put("nonemptyPercentage_reason", reason);
                }
                if (forColumn.containsKey("invalidCount_reason")) {
                    Object reason = forColumn.get("invalidCount_reason");
                    forColumn.put("okPercentage_reason", reason);
                    forColumn.put("nokPercentage_reason", reason);
                }
            }
            perColumn.put(columnName, forColumn);
        }
        return perColumn;
    }

    public void clearMetrics(Partitionable dataStore, @Nullable String partition) throws SQLException {
        if (StringUtils.isBlank((String)partition)) {
            this.jobsDatabaseService.clearMetricsForDataStore(dataStore.getLoc());
        } else {
            this.jobsDatabaseService.clearMetricsForDataStore(dataStore.getLoc(), partition);
        }
    }

    public void clearMetrics(SerializedProject project) throws SQLException {
        this.jobsDatabaseService.clearMetricsForDataStore(new AnyLoc(project.getProjectKey(), null));
    }

    public void clearMetrics(SavedModel model, String partition) throws SQLException {
        if (StringUtils.isBlank((String)partition)) {
            this.jobsDatabaseService.clearMetricsForDataStore(AnyLoc.resolveFull(model.getFullId()));
        } else {
            this.jobsDatabaseService.clearMetricsForDataStore(AnyLoc.resolveFull(model.getFullId()), partition);
        }
    }

    public void clearMetrics(ModelEvaluationStore mes, String partition) throws SQLException {
        if (StringUtils.isBlank((String)partition)) {
            this.jobsDatabaseService.clearMetricsForDataStore(AnyLoc.resolveFull(mes.getFullId()));
        } else {
            this.jobsDatabaseService.clearMetricsForDataStore(AnyLoc.resolveFull(mes.getFullId()), partition);
        }
    }

    public static class MetricPartitionPoint<T> {
        public final String partition;
        public final long time;
        public long partitionTime;
        public final T value;

        MetricPartitionPoint(String partition, long time, T value) {
            this.partition = partition;
            this.time = time;
            this.value = value;
        }

        MetricPartitionPoint(long time, T value) {
            this.value = value;
            this.partition = null;
            this.time = time;
        }
    }

    public static class MetricHistoryData {
        public Metric metric;
        public String metricId;
        public Type dataType;
        public long from;
        public long to;
        public Type valueType;
        public MetricPartitionPoint[] values;
        public MetricPartitionPoint lastValue;
        public SchemaColumn schemaColumn;

        MetricHistoryData(Metric metric, Object object) {
            Dataset dataset;
            this.metric = metric;
            this.dataType = metric.getDataType();
            this.metricId = metric.getId();
            if (StringUtils.isNotBlank((String)metric.getColumn()) && object instanceof Dataset && (dataset = (Dataset)object).getSchema() != null) {
                this.schemaColumn = dataset.getSchema().getColumn(metric.getColumn());
            }
        }

        public void set(Type valueType, MetricPartitionPoint[] points) {
            this.valueType = valueType;
            this.values = points;
            if (points.length > 0) {
                this.lastValue = points[points.length - 1];
            }
            if (points.length == 0) {
                this.from = -1L;
                this.to = -1L;
            } else {
                this.from = points[0].time;
                this.to = points[0].time;
                for (MetricPartitionPoint point : points) {
                    this.from = Math.min(this.from, point.time);
                    this.to = Math.max(this.to, point.time);
                }
            }
        }
    }

    public static class MetricHistoriesData {
        public List<MetricHistoryData> histories = Lists.newArrayList();
        public long from;
        public long to;

        public MetricHistoriesData(List<MetricHistoryData> histories) {
            this.histories = histories;
            if (histories.size() == 0) {
                this.from = -1L;
                this.to = -1L;
            } else {
                this.from = histories.get((int)0).from;
                this.to = histories.get((int)0).to;
                for (MetricHistoryData history : histories) {
                    if (history.from < 0L || history.to < 0L) continue;
                    this.from = Math.min(this.from, history.from);
                    this.to = Math.max(this.to, history.to);
                }
            }
        }
    }

    public static class MetricColumnData {
        public Metric metric;
        public String metricId;
        public MetricMetadata meta;
        public MetricColumnPoint[] values;
        public SchemaColumn schemaColumn;

        MetricColumnData(Metric metric, Object object) {
            Dataset dataset;
            this.metric = metric;
            this.metricId = metric.getId();
            if (StringUtils.isNotBlank((String)metric.getColumn()) && object instanceof Dataset && (dataset = (Dataset)object).getSchema() != null) {
                this.schemaColumn = dataset.getSchema().getColumn(metric.getColumn());
            }
        }

        public void setValues(List<MetricColumnPoint> values) {
            this.values = values.toArray(new MetricColumnPoint[values.size()]);
        }
    }

    public static class MetricColumnsData {
        public boolean isTimePartition;
        public TimeDimension.Period partitionTimePeriod;
        public String partition;
        public long partitionTime;
        public List<MetricColumnData> metrics = Lists.newArrayList();

        public MetricColumnsData(List<MetricColumnData> metrics) {
            this.metrics = metrics;
        }
    }

    public static class MetricColumnPoint<T> {
        public final String column;
        public final long time;
        public long partitionTime;
        public final Type valueType;
        public final T value;

        MetricColumnPoint(String column, long time, Type valueType, T value) {
            this.column = column;
            this.time = time;
            this.valueType = valueType;
            this.value = value;
        }
    }

    public static class MetricPartitionData {
        public Metric metric;
        public String metricId;
        public MetricMetadata meta;
        public Type dataType;
        public boolean isTimePartition;
        public Type valueType;
        public MetricPartitionPoint partitionAll;
        public MetricPartitionPoint[] values;
        public TimeDimension.Period partitionTimePeriod;
        public SchemaColumn schemaColumn;

        MetricPartitionData(Metric metric, Object object) {
            Dataset dataset;
            this.metric = metric;
            this.dataType = metric.getDataType();
            this.metricId = metric.getId();
            if (StringUtils.isNotBlank((String)metric.getColumn()) && object instanceof Dataset && (dataset = (Dataset)object).getSchema() != null) {
                this.schemaColumn = dataset.getSchema().getColumn(metric.getColumn());
            }
        }

        public void setValues(List<MetricPartitionPoint> values) {
            for (MetricPartitionPoint value : values) {
                if (!"ALL".equals(value.partition)) continue;
                this.partitionAll = value;
            }
            this.values = new MetricPartitionPoint[this.partitionAll != null ? values.size() - 1 : values.size()];
            int i = 0;
            for (MetricPartitionPoint value : values) {
                if ("ALL".equals(value.partition)) continue;
                this.values[i++] = value;
            }
        }

        public void setValuesEvenForAll(List<MetricPartitionPoint> values) {
            this.values = values.toArray(new MetricPartitionPoint[values.size()]);
        }
    }

    public static class MetricPartitionsData {
        public List<MetricPartitionData> metrics = Lists.newArrayList();

        public MetricPartitionsData(List<MetricPartitionData> metrics) {
            this.metrics = metrics;
        }
    }

    public static class CheckHistoryData {
        public DataQualityRule check;
        public String name;
        public long from;
        public long to;
        public ReadOnlyJobsInternalDB.CheckDataPoint[] values;
        public ReadOnlyJobsInternalDB.CheckDataPoint lastValue;

        CheckHistoryData(DataQualityRule check, String name) {
            this.check = check;
            this.name = name;
        }

        public void set(ReadOnlyJobsInternalDB.CheckDataPoint[] points) {
            this.values = points;
            if (points.length > 0) {
                this.lastValue = points[points.length - 1];
            }
            if (points.length == 0) {
                this.from = -1L;
                this.to = -1L;
            } else {
                this.from = points[0].time;
                this.to = points[0].time;
                for (ReadOnlyJobsInternalDB.CheckDataPoint point : points) {
                    this.from = Math.min(this.from, point.time);
                    this.to = Math.max(this.to, point.time);
                }
            }
        }
    }

    public static class CheckHistoriesData {
        public List<CheckHistoryData> histories = Lists.newArrayList();
        public long from;
        public long to;

        public CheckHistoriesData(List<CheckHistoryData> histories) {
            this.histories = histories;
            if (histories.size() == 0) {
                this.from = -1L;
                this.to = -1L;
            } else {
                this.from = histories.get((int)0).from;
                this.to = histories.get((int)0).to;
                for (CheckHistoryData history : histories) {
                    this.from = Math.min(this.from, history.from);
                    this.to = Math.max(this.to, history.to);
                }
            }
        }
    }

    @UIModel
    public static class MetricPartitionsList {
        public List<MetricPartition> partitions;
        public boolean isTimePartition;
        public TimeDimension.Period partitionTimePeriod;

        MetricPartitionsList(boolean isTimePartition, TimeDimension.Period partitionTimePeriod, List<MetricPartition> partitions) {
            this.isTimePartition = isTimePartition;
            this.partitionTimePeriod = partitionTimePeriod;
            this.partitions = partitions;
        }

        MetricPartitionsList(PartitioningScheme scheme, List<String> partitionIds) {
            TimeDimension timeDimension = scheme.isSingleDimension() && scheme.getSingleDimension() instanceof TimeDimension ? (TimeDimension)scheme.getSingleDimension() : null;
            this.isTimePartition = timeDimension != null;
            this.partitionTimePeriod = timeDimension != null ? timeDimension.mappedPeriod : null;
            ArrayList partitionsFromList = Lists.newArrayList();
            for (String partitionId : partitionIds) {
                long partitionTime = 0L;
                if (timeDimension != null) {
                    try {
                        TimeDimensionValue partitionValue = (TimeDimensionValue)timeDimension.getValueFromId(partitionId);
                        partitionTime = partitionValue.getCalendar().getTimeInMillis();
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Partition identifier '" + partitionId + "' from partition list is incorrect for the partitioning scheme. Ignoring."));
                    }
                }
                partitionsFromList.add(new MetricPartition(partitionId, partitionTime));
            }
            this.partitions = partitionsFromList;
        }
    }

    public static class MetricPartition {
        public final String partition;
        public long partitionTime;

        MetricPartition(String partition, long partitionTime) {
            this.partition = partition;
            this.partitionTime = partitionTime;
        }
    }

    public static class ComputedMetric {
        public Metric metric;
        public MetricMetadata meta;
        public List<String> partitionsWithValue = Lists.newArrayList();
        public List<ComputedMetricPartition> lastValues = Lists.newArrayList();
        public List<JobsdbDatasetParams.View> notExistingViews = Lists.newArrayList();
        public boolean displayedAsMetric;
        public String computingProbe;

        ComputedMetric(Metric metric, boolean displayedAsMetric) {
            this.metric = metric;
            this.displayedAsMetric = displayedAsMetric;
            this.meta = metric.getMeta();
        }
    }

    public static class ComputedMetricPartition {
        public long computed;
        public String partition;
        public Type dataType;
        public String value;

        public ComputedMetricPartition(long computed, String partition, Type dataType, String value) {
            this.computed = computed;
            this.dataType = dataType;
            this.value = value;
            this.partition = partition;
        }
    }

    @UIModel
    public static class ComputedMetrics {
        public List<ComputedMetric> metrics = Lists.newArrayList();
        public List<JobsdbDatasetParams.View> notExistingViews = Lists.newArrayList();
    }

    public static class ComputedCheck {
        public DataQualityRule check;
        @Nullable
        public CheckMetadata meta;
        public String name;
        public List<String> partitionsWithValue = Lists.newArrayList();
        public List<ComputedCheckPartition> lastValues = Lists.newArrayList();
        public List<JobsdbDatasetParams.View> notExistingViews = Lists.newArrayList();
        public boolean displayedAsCheck;

        ComputedCheck(DataQualityRule rule, String name, boolean displayedAsCheck) {
            this.check = rule;
            this.name = name;
            this.displayedAsCheck = displayedAsCheck;
            this.meta = rule instanceof Check ? ((Check)rule).getMeta() : null;
        }
    }

    public static class ComputedCheckPartition {
        public long computed;
        public String partition;
        public AbstractCheckContext.CheckOutcome outcome;
        public String message;

        public ComputedCheckPartition(long computed, String partition, AbstractCheckContext.CheckOutcome outcome, String message) {
            this.computed = computed;
            this.outcome = outcome;
            this.message = message;
            this.partition = partition;
        }
    }

    public static class ComputedChecks {
        public List<ComputedCheck> checks = Lists.newArrayList();
        public List<JobsdbDatasetParams.View> notExistingViews = Lists.newArrayList();
    }

    public static class AvailableMetrics {
        public List<AvailableProbe> probes = Lists.newArrayList();
        public boolean isHive;
        public boolean isSql;
    }

    public static class AvailableProbe {
        public Probe probe;
        public Object hint;

        AvailableProbe(Probe probe, Object hint) {
            this.probe = probe;
            this.hint = hint;
        }
    }

    private static class SavedModelVersionFilteringInfo {
        String versionId;
        PartitionedModelExtract partitions;

        SavedModelVersionFilteringInfo(String versionId) {
            this.versionId = versionId;
        }
    }
}

