/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.utils.DKUMathsUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.List;

public class Model {

    @UIModel(index=false)
    public static class AggregatedDatasetsMetricValue
    extends SummedDatasetMetricValue {
        public int nbWithData;
        public int nbIncomplete;
        public double ratioOfTotal;

        public void computeRatio(List<SummedDatasetMetricValue> list) {
            long total = 0L;
            for (SummedDatasetMetricValue sdmv : list) {
                if (sdmv.totalValue <= 0L) continue;
                total += sdmv.totalValue;
            }
            this.ratioOfTotal = DKUMathsUtils.safeDivide((long)this.totalValue, (long)total);
        }

        public void merge(SummedDatasetMetricValue other) {
            if (other.hasData) {
                this.totalValue += other.totalValue;
                this.lastComputed = Math.max(this.lastComputed, other.lastComputed);
                this.firstComputed = Math.min(this.firstComputed, other.firstComputed);
            }
            this.incomplete |= other.incomplete;
            this.hasData |= other.hasData;
            this.nbWithData += other.hasData ? 1 : 0;
            this.nbIncomplete += other.incomplete ? 1 : 0;
        }
    }

    @UIModel(index=false)
    public static class DetailedSummedDatasetMetricValue
    extends SummedDatasetMetricValue {
        public List<LongMetricPartitionValue> partitions = Lists.newArrayList();
    }

    @UIModel(index=false)
    public static class SummedDatasetMetricValue {
        public long totalValue = 0L;
        public long lastComputed = 0L;
        public long firstComputed = Long.MAX_VALUE;
        public boolean hasData;
        public boolean incomplete;

        public void updateTimeRange(long point) {
            this.lastComputed = Math.max(point, this.lastComputed);
            this.firstComputed = Math.min(point, this.firstComputed);
        }
    }

    @UIModel(index=false)
    public static class LongMetricPartitionValue {
        public String partition;
        public long value;

        public LongMetricPartitionValue(String partition, long value) {
            this.partition = partition;
            this.value = value;
        }
    }
}

