/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLColumnMetricsEngine
extends JdbcEngine
implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine {
    public SQLColumnMetricsEngine(Dataset dataset, Partition partition, JdbcEngine.SQLMetricsEngineConfig config) {
        super(dataset, partition);
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, SQLException, DKUSecurityException {
        this.connectionData = DatasetInspector.getSQLConnectionForSQLAbleDatasetOrHive(authCtx, this.dataset);
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ColumnMetricsQueryBuilder builder = new ColumnMetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        for (String[] row : res.rows) {
            boolean more = false;
            for (MetricComputation computation : computations) {
                ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
                more |= computer.handleResult(res.columns, row, computation);
            }
            if (more) continue;
            break;
        }
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(computation));
        }
        return metricsValues;
    }

    public static class SQLColumnMetricsEngineRun
    extends MetricsEngineRun {
        public final String column;

        public SQLColumnMetricsEngineRun(String column) {
            super(MetricsEngineDesc.SQLColumnMetricsEngine);
            this.column = column;
        }

        public SQLColumnMetricsEngineRun(String column, double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SQLColumnMetricsEngine, cost, computations, pass);
            this.column = column;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SQLColumnMetricsEngineRun(this.column, cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return super.canMergeWith(other) && this.column.equals(((SQLColumnMetricsEngineRun)other).column);
        }
    }
}

