/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.ProbeQueryBuilder;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkProbeEngine
extends JdbcEngine
implements ProbeQueryBuilder.ProbeQueryBuilderEngine {
    private final DatasetHandler datasetHandler;
    @Autowired
    private SparkSQLConnectionPoolService connectionPoolService;
    private final JdbcEngine.SparkMetricsEngineConfig config;
    private final SparkSettings sparkSettings;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.spark.probe");

    public SparkProbeEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, JdbcEngine.SparkMetricsEngineConfig config, SparkSettings sparkSettings) {
        super(dataset, partition);
        this.datasetHandler = datasetHandler;
        this.config = config;
        this.sparkSettings = sparkSettings;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        logger.info((Object)("Spark metrics engine on dataset : " + this.dataset.getFullName()));
        SparkConnection datasetConnection = SparkConfigurator.configureConnectionForDatabase("default", this.config.extraConf, this.connectionPoolService);
        String datasetTableName = this.dataset.getProjectKey() + "_" + this.dataset.getName();
        datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.dataset." + this.dataset.getFullName(), datasetTableName, false));
        Partition partition = this.getPartition();
        if (partition != null) {
            datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.partition." + this.dataset.getFullName(), partition.id(), false));
        }
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricComputation primerComputation = computations.get(0);
        MetricComputer.SparkQueryEngineComputer computer = (MetricComputer.SparkQueryEngineComputer)primerComputation.computer;
        ProbeQueryBuilder builder = new ProbeQueryBuilder();
        return builder.buildQuery(authCtx, this, computer.getQuery(primerComputation.probe), computer.getVariables(primerComputation.probe, authCtx, this.getDataset().getProjectKey()));
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        Probe sqlProbe = computations.get((int)0).probe;
        MetricBuilder metricBuilder = (MetricBuilder)((Object)ProbeType.getProbeType(sqlProbe.getType()));
        HashMap metricsValues = Maps.newHashMap();
        if (res.rows != null && res.rows.size() > 0) {
            for (int i = 0; i < res.columns.size(); ++i) {
                SchemaColumn column = HiveSchemaHandler.dssColumnFromHiveColumnDef(res.columns.get((int)i).name, res.columns.get((int)i).type, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING);
                String v = res.rows.get(0)[i];
                Metric metric = metricBuilder.build(column.getName(), column.getType(), sqlProbe);
                metricsValues.put(metric, v);
            }
        }
        return metricsValues;
    }

    @Override
    public ExpressionBuilder getPartitionFilter() {
        return null;
    }

    public static class SparkProbeEngineRun
    extends MetricsEngineRun {
        public SparkProbeEngineRun() {
            super(MetricsEngineDesc.SparkQueryEngine);
        }

        public SparkProbeEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SparkQueryEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SparkProbeEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return false;
        }
    }
}

