/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.engines.BasicMetricsEngine;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class RecordsProbeType
extends ProbeType {
    public static final String TYPE = "records";
    public static final long MIN_DATASET_SIZE_FOR_HIVE = 0xA00000L;
    private static Map<RecordsMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.records");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new DatasetHandlerRecordCountComputer());
        computers.add(new SQLRecordCountComputer(new SQLBasedRecordCountComputer()));
        computers.add(new HiveRecordCountComputer(new SQLBasedRecordCountComputer()));
        computers.add(new ImpalaRecordCountComputer(new SQLBasedRecordCountComputer()));
        computers.add(new SparkRecordCountComputer(new SQLBasedRecordCountComputer()));
        computers.add(new GrouperRecordCountComputer());
        return computers;
    }

    public RecordsProbeType() {
        metadataPerType.put(RecordsMetrics.COUNT_RECORDS, new MetricMetadata().withName("Record count").withFullName("Record count").withFormat("longReadableNumber"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            metrics.add(new RecordsMetric(RecordsMetrics.COUNT_RECORDS));
        }
        return metrics;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        metrics.add(new RecordsMetric(RecordsMetrics.COUNT_RECORDS));
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            RecordsProbeHint hint = new RecordsProbeHint();
            hint.hasCountRecords = true;
            return hint;
        }
        return null;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new RecordsProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return RecordsProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("Record count");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static class DatasetHandlerRecordCountComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer
    implements BasicMetricsEngine.DangerousBasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof RecordsMetric && ((RecordsMetric)metric).getMetricType() == RecordsMetrics.COUNT_RECORDS && objectType == MetricTargetType.DATASET) {
                Dataset ds = (Dataset)object;
                if (DatasetInspector.isSQL(ds) && ds.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).variablesExpansionLoopConfig.isEnabled()) {
                    return null;
                }
                return new BasicMetricsEngine.BasicMetricsEngineRun().withUnmergeable(true).with(new MetricComputation(probe, this, metric, 6.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                logger.info((Object)("Record count of single partition " + engine.getPartition().id() + " using the dataset handler"));
                long count = engine.getDatasetHandler().getPartitionRecords(engine.getPartition());
                return Long.toString(count);
            }
            logger.info((Object)"Record count using the dataset handler");
            long count = engine.getDatasetHandler().getRecords();
            return Long.toString(count);
        }
    }

    public static class SQLRecordCountComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private SQLBasedRecordCountComputer subComputer;

        SQLRecordCountComputer(SQLBasedRecordCountComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof RecordsMetric && ((RecordsMetric)metric).getMetricType() == RecordsMetrics.COUNT_RECORDS && objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                Dataset ds = (Dataset)object;
                if (DatasetInspector.isSQL(ds) && ds.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).variablesExpansionLoopConfig.isEnabled()) {
                    return null;
                }
                return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class SQLBasedRecordCountComputer {
        public void addAggregations(MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) {
            SQLRecordCountComputerSession session = new SQLRecordCountComputerSession();
            computation.session = session;
            session.dialect = dialect;
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(ef.expr("*").count().castToBigint());
            session.offset = ref.getIndex();
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) {
            SQLRecordCountComputerSession session = (SQLRecordCountComputerSession)computation.session;
            return rs2.rows.get(0)[session.offset - 1];
        }
    }

    public static class HiveRecordCountComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private SQLBasedRecordCountComputer subComputer;

        HiveRecordCountComputer(SQLBasedRecordCountComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (!(metric instanceof RecordsMetric)) return null;
            if (((RecordsMetric)metric).getMetricType() != RecordsMetrics.COUNT_RECORDS) return null;
            if (objectType != MetricTargetType.DATASET) return null;
            if (!DatasetInspector.canHDFS((Dataset)object)) {
                if (!DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) return null;
                return new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
            }
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(authCtx, (Dataset)object);){
                if (handler.getLengthIfSmallerThan(partition, 0xA00000L) <= 0xA00000L) return null;
                MetricsEngineRun metricsEngineRun = new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
                return metricsEngineRun;
            }
            catch (CodedException | DKUSecurityException | IOException e) {
                logger.error((Object)"Could not get file size", e);
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Could not get file size", (Throwable)e);
                return null;
            }
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class ImpalaRecordCountComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        private SQLBasedRecordCountComputer subComputer;

        ImpalaRecordCountComputer(SQLBasedRecordCountComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof RecordsMetric && ((RecordsMetric)metric).getMetricType() == RecordsMetrics.COUNT_RECORDS && objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null).with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class SparkRecordCountComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private SQLBasedRecordCountComputer subComputer;

        SparkRecordCountComputer(SQLBasedRecordCountComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (!(metric instanceof RecordsMetric)) return null;
            if (((RecordsMetric)metric).getMetricType() != RecordsMetrics.COUNT_RECORDS) return null;
            if (objectType != MetricTargetType.DATASET) return null;
            if (!DatasetInspector.isMetastoreAssociatedType((Dataset)object)) return null;
            try (AbstractFSDatasetHandler handler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, (Dataset)object);){
                if (handler.getLengthIfSmallerThan(partition, 0xA00000L) <= 0xA00000L) return null;
                MetricsEngineRun metricsEngineRun = new SparkMetricsEngine.SparkMetricsEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
                return metricsEngineRun;
            }
            catch (CodedException | DKUSecurityException | IOException e) {
                logger.error((Object)"Could not get file size", e);
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Could not get file size", (Throwable)e);
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class GrouperRecordCountComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return RecordsProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof RecordsMetric && ((RecordsMetric)metric).getMetricType() == RecordsMetrics.COUNT_RECORDS && objectType == MetricTargetType.DATASET) {
                return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
            }
            return null;
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            Validate.isTrue((computations.size() == 1 ? 1 : 0) != 0, (String)(this.getClass().getSimpleName() + " can only compute one metric at a time"), (Object[])new Object[0]);
            MetricComputation computation = computations.get(0);
            GrouperRecordCountComputerSession session = new GrouperRecordCountComputerSession();
            session.computation = computation;
            session.count = 0L;
            computation.session = session;
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            GrouperRecordCountComputerSession session = (GrouperRecordCountComputerSession)dssComputerSession;
            ++session.count;
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) {
            GrouperRecordCountComputerSession session = (GrouperRecordCountComputerSession)dssComputerSession;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            aggregates.put(session.computation.metric, Long.toString(session.count));
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            return new JsonObject();
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
        }

        public static class GrouperRecordCountComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public MetricComputation computation;
            private long count;
        }
    }

    public static enum RecordsMetrics {
        COUNT_RECORDS;

    }

    public static class RecordsMetric
    extends Metric {
        public RecordsMetrics metricType;

        public RecordsMetric(RecordsMetrics metricType) {
            super(RecordsProbeType.TYPE, Type.BIGINT);
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        public RecordsMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new RecordsProbeConfiguration()).withMeta(ProbeType.getProbeType(RecordsProbeType.TYPE).getMeta());
        }
    }

    public static class RecordsProbeHint {
        boolean hasCountRecords;
    }

    public static class RecordsProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class SQLRecordCountComputerSession {
        public SQLDialect dialect;
        public int offset;
    }

    public static class RecordsMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof RecordsMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            RecordsMetric recordsMetric = (RecordsMetric)metric;
            return Metric.buildMetricIdFromParts(RecordsProbeType.TYPE, recordsMetric.getMetricType().name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 2 || !parts.get(0).equals(RecordsProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new RecordsMetric(RecordsMetrics.valueOf(parts.get(1)));
        }
    }
}

