/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.hive.HiveBasicSerDeParser;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.chrono.ISOChronology;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CSVSerializer {
    private static final DKULogger logger = DKULogger.getLogger(CSVSerializer.class);
    private static final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter isoParser = ISODateTimeFormat.dateTimeParser().withZoneUTC();
    private static final DateTimeFormatter isoParserWithOffset = isoParser.withOffsetParsed().withChronology((Chronology)ISOChronology.getInstanceUTC());
    private static final DateTimeFormatter hiveFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSS").withZoneUTC();
    private final CSVFormatConfig config;
    private final RecordContext rc;
    private WarningsContext warningsContext;
    private final Boolean booleanMeaning = new Boolean();

    public CSVSerializer(CSVFormatConfig conf, RecordContext rc) {
        this.warningsContext = new WarningsContext();
        this.config = conf;
        this.rc = rc;
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext == null ? new WarningsContext() : warningsContext;
    }

    public String writeComplex(String v, SchemaColumn col) throws IOException {
        switch (this.config.arrayMapFormat) {
            case delimited: {
                if (col.getType() != Type.ARRAY) {
                    throw new IOException("Cannot write 'object' or 'map' columns when 'array map format' is 'delimited'");
                }
                try {
                    JSONArray arr = new JSONArray(v);
                    return HiveBasicSerDeParser.serializeArray(arr, col, new char[]{this.config.getArrayItemSeparatorChar()}, 0);
                }
                catch (Exception e) {
                    this.warningsContext.addWarning(WarningsContext.WarningType.CSV_OUTPUT_BAD_COMPLEX_VALUE, "Failed to serialize delimited array, val: '" + v + "'", (Throwable)e, logger);
                    return null;
                }
            }
            case hive: {
                if (v == null) {
                    return null;
                }
                char[] separators = new char[this.config.hiveSeparators.size()];
                for (int i = 0; i < this.config.hiveSeparators.size(); ++i) {
                    separators[i] = Params.getAsChar((String)this.config.hiveSeparators.get(i));
                }
                try {
                    switch (col.getType()) {
                        case OBJECT: {
                            return HiveBasicSerDeParser.serializeStruct(new JSONObject(v), col, separators, 0);
                        }
                        case ARRAY: {
                            return HiveBasicSerDeParser.serializeArray(new JSONArray(v), col, separators, 0);
                        }
                        case MAP: {
                            return HiveBasicSerDeParser.serializeMap(new JSONObject(v), col, separators, 0);
                        }
                    }
                    throw new Error("Unreachable");
                }
                catch (Exception e) {
                    this.warningsContext.addWarning(WarningsContext.WarningType.CSV_OUTPUT_BAD_COMPLEX_VALUE, "Failed to serialize column  " + JSON.json((Object)col) + " val: '" + v + "'", (Throwable)e, logger);
                    return null;
                }
            }
            case json: {
                return v;
            }
        }
        throw new Error("Unreachable");
    }

    public String writeBoolean(String s, SchemaColumn col) {
        if (this.config.normalizeBooleans) {
            java.lang.Boolean b = this.booleanMeaning.parseNoFail(s);
            if (b == null) {
                this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_BOOLEAN, StorageTypeVerifier.buildWarningMessage(s, col, this.warningsContext, this.rc), logger);
                return null;
            }
            return b.toString();
        }
        return s;
    }

    public String writeDouble(String s, SchemaColumn col) {
        if (this.config.normalizeDoubles && StringUtils.isNotEmpty((String)s)) {
            Double d = DKUDoubles.tryParse((String)s);
            if (d == null) {
                this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_FLOAT, StorageTypeVerifier.buildWarningMessage(s, col, this.warningsContext, this.rc), logger);
                return null;
            }
            return d.toString();
        }
        return s;
    }

    public String writeDate(String v, SchemaColumn sc) {
        switch (this.config.dateSerializationFormat) {
            case HIVE: {
                if (StringUtils.isBlank((String)v)) {
                    return "";
                }
                try {
                    return hiveFormatter.print((ReadableInstant)isoParser.parseDateTime(v));
                }
                catch (IllegalArgumentException e) {
                    this.warningsContext.addWarning(WarningsContext.WarningType.CSV_OUTPUT_BAD_DATE, "Failed to write date, val=" + v, (Throwable)e, logger);
                    return "";
                }
            }
            case ISO_FORCED_UTC: {
                if (StringUtils.isBlank((String)v)) {
                    return "";
                }
                try {
                    DateTime dateTime = isoParser.parseDateTime(v);
                    DateTime dateTimeUTC = dateTime.toDateTime(DateTimeZone.UTC);
                    return isoFormatter.print((ReadableInstant)dateTimeUTC);
                }
                catch (IllegalArgumentException e) {
                    this.warningsContext.addWarning(WarningsContext.WarningType.CSV_OUTPUT_BAD_DATE, "Failed to write date, val=" + v, (Throwable)e, logger);
                    return "";
                }
            }
            case ISO_STRICT: {
                if (StringUtils.isBlank((String)v)) {
                    return "";
                }
                int vLength = v.length();
                if (vLength > 10 && v.charAt(10) == 'T' && (v.charAt(vLength - 1) == 'Z' || v.charAt(vLength - 3) == ':')) {
                    return v;
                }
                try {
                    DateTime dateTime = isoParserWithOffset.parseDateTime(v);
                    return isoFormatter.print((ReadableInstant)dateTime);
                }
                catch (IllegalArgumentException e) {
                    this.warningsContext.addWarning(WarningsContext.WarningType.CSV_OUTPUT_BAD_DATE, "Failed to write date, val=" + v, (Throwable)e, logger);
                    return "";
                }
            }
        }
        return v;
    }

    public String writeDateonly(String v, SchemaColumn sc) {
        switch (this.config.dateSerializationFormat) {
            case ISO_STRICT: {
                if (StringUtils.isBlank((String)v) || !v.contains("/")) {
                    return v;
                }
                return v.replace("/", "-");
            }
        }
        return v;
    }
}

