/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.AbstractJSONFormatConfig;
import com.dataiku.dip.input.formats.AbstractJSONOutputFormatter;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.json.JSONString;

public class PythonOutputFormatter
extends AbstractJSONOutputFormatter {
    private final boolean indent;
    private final int indentSize;
    private final String baseIndent;

    public PythonOutputFormatter(AbstractJSONFormatConfig config) {
        this(config, false, 0);
    }

    public PythonOutputFormatter(boolean indent, int indentSize) {
        this(new JSONFormatConfig(), indent, indentSize);
    }

    public PythonOutputFormatter(AbstractJSONFormatConfig config, boolean indent, int indentSize) {
        super(config);
        this.indent = indent;
        this.indentSize = indentSize;
        if (!indent || indentSize < 0) {
            this.baseIndent = "";
        } else {
            char[] baseIndentChar = new char[indentSize];
            Arrays.fill(baseIndentChar, ' ');
            this.baseIndent = new String(baseIndentChar);
        }
    }

    @Override
    public void header(ColumnFactory cf, Writer w) throws Exception {
        super.header(cf, w);
        this.jsonWriter.array();
    }

    @Override
    public void footer(ColumnFactory cf, Writer w) throws Exception {
        super.footer(cf, w);
        this.originalWriter.write("\n");
        this.jsonWriter.endArray();
    }

    @Override
    protected void addRow(Row row, ColumnFactory cf) {
        try {
            this.indentNewLine();
            this.indentObject();
            this.jsonWriter.object();
            this.indentNewLine();
            for (SchemaColumn cs2 : this.outputSchema.columns) {
                block15: {
                    String value = row.get(cf.column(cs2.getName()));
                    Type type = cs2.getType();
                    this.indentKey();
                    this.jsonWriter.key(cs2.getName());
                    this.indentValue();
                    if (type.isNumeric()) {
                        if (value == null) {
                            this.jsonWriter.value(0L);
                        } else {
                            try {
                                if (type.isInteger()) {
                                    this.jsonWriter.value(Long.parseLong(value));
                                    break block15;
                                }
                                Double doubleValue = Double.parseDouble(value);
                                if (Double.isFinite(doubleValue)) {
                                    this.jsonWriter.value((Object)this.toPythonDouble(doubleValue));
                                    break block15;
                                }
                                this.jsonWriter.value((Object)"0.0");
                            }
                            catch (NumberFormatException e) {
                                this.jsonWriter.value(0L);
                            }
                        }
                    } else if (type == Type.BOOLEAN) {
                        this.jsonWriter.value((Object)this.toPythonBoolean(Boolean.parseBoolean(value)));
                    } else if (StringUtils.isBlank((String)value)) {
                        this.jsonWriter.value((Object)"");
                    } else {
                        this.jsonWriter.value((Object)value);
                    }
                }
                this.indentNewLine();
            }
            this.indentObject();
            this.jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void indentNewLine() throws IOException {
        if (!this.indent) {
            return;
        }
        this.originalWriter.write("\n");
    }

    private void indentObject() throws IOException {
        if (!this.indent) {
            return;
        }
        this.originalWriter.write(this.baseIndent);
    }

    private void indentKey() throws IOException {
        if (!this.indent) {
            return;
        }
        this.originalWriter.write(this.baseIndent);
        this.originalWriter.write(this.baseIndent);
    }

    private void indentValue() throws IOException {
        if (!this.indent) {
            return;
        }
        this.originalWriter.write(" ");
    }

    private JSONString toPythonDouble(double value) {
        return () -> Double.toString(value);
    }

    private JSONString toPythonBoolean(boolean value) {
        return () -> value ? "True" : "False";
    }
}

