/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.DoubleDataList;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.SimplePivotBuilder;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PivotPostprocessor {
    public static void computeFromSQL(PivotTableRequest req, PivotTableResponse resp) {
        if (!(req instanceof PivotTableTensorRequest) || !(resp instanceof PivotTableTensorResponse)) {
            throw new UnsupportedOperation();
        }
        PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)req;
        PivotTableTensorResponse tensorResponse = (PivotTableTensorResponse)resp;
        if (tensorRequest.axes.length == 1) {
            PivotPostprocessor.computeMeasureModesSimple(tensorRequest, tensorResponse);
            PivotPostprocessor.computeIntermeasuresSimple(tensorRequest, tensorResponse);
        } else {
            PivotPostprocessor.computeMeasureModesTensor(tensorRequest, tensorResponse);
            PivotPostprocessor.computeTensorMarginals(tensorRequest, tensorResponse);
            PivotPostprocessor.computeIntermeasuresTensor(tensorRequest, tensorResponse);
        }
    }

    public static void computeIntermeasuresTensor(PivotTableTensorRequest request, PivotTableTensorResponse resp) {
        if (request.diminishingReturns) {
            assert (resp.aggregations.size() == 2);
            int[] axisLengths = ((DataTensor)resp.aggregations.get((int)0)).axisLengths;
            PivotPostprocessor.forAllCells(axisLengths, 0, coords -> {
                List<AxisElt> groupLabels = resp.axisLabels[0];
                DoubleDataList measureProportion = new DoubleDataList(groupLabels.size());
                double measureTotal = 0.0;
                int i = 0;
                while (i < groupLabels.size()) {
                    coords[0] = i++;
                    measureTotal += ((DataTensor)resp.aggregations.get(0)).getAsDouble(coords);
                }
                for (i = 0; i < groupLabels.size(); ++i) {
                    coords[0] = i;
                    measureProportion.data[i] = ((DataTensor)resp.aggregations.get(0)).getAsDouble(coords) / measureTotal;
                }
                DoubleDataList lifterProportion = new DoubleDataList(groupLabels.size());
                double lifterTotal = 0.0;
                int i2 = 0;
                while (i2 < groupLabels.size()) {
                    coords[0] = i2++;
                    lifterTotal += ((DataTensor)resp.aggregations.get(1)).getAsDouble(coords);
                }
                for (i2 = 0; i2 < groupLabels.size(); ++i2) {
                    coords[0] = i2;
                    if (!(lifterTotal > 0.0)) continue;
                    lifterProportion.data[i2] = ((DataTensor)resp.aggregations.get(1)).getAsDouble(coords) / lifterTotal;
                }
                ArrayList<SimplePivotBuilder.DiminishingReturnsPoint> ret = new ArrayList<SimplePivotBuilder.DiminishingReturnsPoint>();
                for (int i3 = 0; i3 < groupLabels.size(); ++i3) {
                    coords[0] = i3;
                    SimplePivotBuilder.DiminishingReturnsPoint drp = new SimplePivotBuilder.DiminishingReturnsPoint();
                    drp.elt = groupLabels.get(i3);
                    drp.x = ((DataTensor)resp.aggregations.get(0)).getAsDouble(coords);
                    drp.y = ((DataTensor)resp.aggregations.get(1)).getAsDouble(coords);
                    drp.excessRatio = measureProportion.data[i3] / lifterProportion.data[i3] - 1.0;
                    ret.add(drp);
                }
                ret.sort((o1, o2) -> Double.compare(o1.excessRatio, o2.excessRatio));
                double cumX = 0.0;
                double cumY = 0.0;
                for (int i4 = 0; i4 < ret.size(); ++i4) {
                    coords[0] = i4;
                    SimplePivotBuilder.DiminishingReturnsPoint drp = (SimplePivotBuilder.DiminishingReturnsPoint)ret.get(i4);
                    ((DataTensor)resp.aggregations.get(0)).setAsDouble(coords, cumX += drp.x);
                    ((DataTensor)resp.aggregations.get(1)).setAsDouble(coords, cumY += drp.y);
                    groupLabels.set(i4, drp.elt);
                }
            });
        }
    }

    public static void computeIntermeasuresSimple(PivotTableTensorRequest request, PivotTableTensorResponse resp) {
        block15: {
            int i;
            int i2;
            List<AxisElt> labels;
            block16: {
                block14: {
                    int i3;
                    int i4;
                    labels = resp.axisLabels[0];
                    if (!request.relativeLift) break block14;
                    DoubleDataList measureProportion = new DoubleDataList(labels.size());
                    double measureTotal = 0.0;
                    for (i4 = 0; i4 < labels.size(); ++i4) {
                        measureTotal += ((DataTensor)resp.aggregations.get(0)).getAsDouble(i4);
                    }
                    for (i4 = 0; i4 < labels.size(); ++i4) {
                        measureProportion.data[i4] = ((DataTensor)resp.aggregations.get(0)).getAsDouble(i4) / measureTotal;
                    }
                    DoubleDataList lifterProportion = new DoubleDataList(labels.size());
                    double lifterTotal = 0.0;
                    for (i3 = 0; i3 < labels.size(); ++i3) {
                        lifterTotal += ((DataTensor)resp.aggregations.get(1)).getAsDouble(i3);
                    }
                    for (i3 = 0; i3 < labels.size(); ++i3) {
                        lifterProportion.data[i3] = ((DataTensor)resp.aggregations.get(1)).getAsDouble(i3) / lifterTotal;
                    }
                    for (i3 = 0; i3 < labels.size(); ++i3) {
                        ((DataTensor)resp.aggregations.get(0)).setAsDouble(i3, measureProportion.data[i3] / lifterProportion.data[i3] - 1.0);
                    }
                    break block15;
                }
                if (!request.ratio) break block16;
                for (int i5 = 0; i5 < labels.size(); ++i5) {
                    double n = ((DataTensor)resp.aggregations.get(0)).getAsDouble(i5);
                    double d = ((DataTensor)resp.aggregations.get(1)).getAsDouble(i5);
                    if (d == 0.0) {
                        ((DataTensor)resp.aggregations.get(0)).setAsDouble(i5, 0.0);
                        continue;
                    }
                    ((DataTensor)resp.aggregations.get(0)).setAsDouble(i5, n / d);
                }
                break block15;
            }
            if (!request.diminishingReturns) break block15;
            assert (resp.aggregations.size() == 2);
            DoubleDataList measureProportion = new DoubleDataList(labels.size());
            double measureTotal = 0.0;
            for (i2 = 0; i2 < labels.size(); ++i2) {
                measureTotal += ((DataTensor)resp.aggregations.get(0)).getAsDouble(i2);
            }
            for (i2 = 0; i2 < labels.size(); ++i2) {
                measureProportion.data[i2] = ((DataTensor)resp.aggregations.get(0)).getAsDouble(i2) / measureTotal;
            }
            DoubleDataList lifterProportion = new DoubleDataList(labels.size());
            double lifterTotal = 0.0;
            for (i = 0; i < labels.size(); ++i) {
                lifterTotal += ((DataTensor)resp.aggregations.get(1)).getAsDouble(i);
            }
            for (i = 0; i < labels.size(); ++i) {
                lifterProportion.data[i] = ((DataTensor)resp.aggregations.get(1)).getAsDouble(i) / lifterTotal;
            }
            ArrayList<SimplePivotBuilder.DiminishingReturnsPoint> ret = new ArrayList<SimplePivotBuilder.DiminishingReturnsPoint>();
            for (int i6 = 0; i6 < labels.size(); ++i6) {
                SimplePivotBuilder.DiminishingReturnsPoint drp = new SimplePivotBuilder.DiminishingReturnsPoint();
                drp.elt = labels.get(i6);
                drp.x = ((DataTensor)resp.aggregations.get(0)).getAsDouble(i6);
                drp.y = ((DataTensor)resp.aggregations.get(1)).getAsDouble(i6);
                drp.excessRatio = measureProportion.data[i6] / lifterProportion.data[i6] - 1.0;
                ret.add(drp);
            }
            ret.sort((o1, o2) -> Double.compare(o1.excessRatio, o2.excessRatio));
            double cumX = 0.0;
            double cumY = 0.0;
            for (int i7 = 0; i7 < ret.size(); ++i7) {
                SimplePivotBuilder.DiminishingReturnsPoint drp = (SimplePivotBuilder.DiminishingReturnsPoint)ret.get(i7);
                ((DataTensor)resp.aggregations.get(0)).setAsDouble(i7, cumX += drp.x);
                ((DataTensor)resp.aggregations.get(1)).setAsDouble(i7, cumY += drp.y);
                labels.set(i7, drp.elt);
            }
        }
    }

    public static void computeMeasureModesSimple(PivotTableTensorRequest request, PivotTableTensorResponse resp) {
        int[] allBinCoords = PivotPostprocessor.getTotalBins(request, resp);
        block8: for (int aggr = 0; aggr < request.aggregations.size(); ++aggr) {
            Aggregation aggrObj = (Aggregation)request.aggregations.get(aggr);
            DataTensor aggrData = (DataTensor)resp.aggregations.get(aggr);
            assert (aggrObj != null);
            if (PivotUtils.aggregationProduceAlphanumericalResult(aggrObj.function, aggrData.type) || aggrObj.isUnaggregated) {
                return;
            }
            List<AxisElt> labels = resp.axisLabels[0];
            switch (aggrObj.computeMode) {
                case NORMAL: {
                    continue block8;
                }
                case AVG_RATIO: {
                    double measureTotal = 0.0;
                    double count = 0.0;
                    for (int i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        measureTotal += aggrData.getAsDouble(i);
                        count += 1.0;
                    }
                    double avg = measureTotal / count;
                    if (avg == 0.0) continue block8;
                    for (int i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        aggrData.setAsDouble(i, aggrData.getAsDouble(i) / avg - 1.0);
                    }
                    continue block8;
                }
                case CUMULATIVE: {
                    double cumAggr = 0.0;
                    for (int i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        aggrData.setAsDouble(i, cumAggr += aggrData.getAsDouble(i));
                    }
                    continue block8;
                }
                case DIFFERENCE: {
                    double prevAggr = 0.0;
                    for (int i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        if (i == 0) {
                            prevAggr = aggrData.getAsDouble(i);
                            continue;
                        }
                        double thisAggr = aggrData.getAsDouble(i);
                        aggrData.setAsDouble(i, thisAggr - prevAggr);
                        prevAggr = thisAggr;
                    }
                    continue block8;
                }
                case PERCENTAGE: {
                    int i;
                    double measureTotal = 0.0;
                    for (i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        measureTotal += aggrData.getAsDouble(i);
                    }
                    if (measureTotal == 0.0) continue block8;
                    for (i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        aggrData.setAsDouble(i, aggrData.getAsDouble(i) / measureTotal);
                    }
                    continue block8;
                }
                case CUMULATIVE_PERCENTAGE: {
                    int i;
                    double cumAggr = 0.0;
                    for (i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        aggrData.setAsDouble(i, cumAggr += aggrData.getAsDouble(i));
                    }
                    if (cumAggr == 0.0) continue block8;
                    for (i = 0; i < labels.size(); ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, 0, i)) continue;
                        aggrData.setAsDouble(i, aggrData.getAsDouble(i) / cumAggr);
                    }
                    continue block8;
                }
            }
        }
    }

    private static void forAllCells(int[] axisLengths, CoordinateConsumer consumer) {
        PivotPostprocessor.forAllCells(axisLengths, -1, consumer, null);
    }

    private static void forAllCells(int[] axisLengths, int fixedAxisIdx, CoordinateConsumer consumer) {
        PivotPostprocessor.forAllCells(axisLengths, fixedAxisIdx, consumer, 0, new int[axisLengths.length], null);
    }

    private static void forAllCells(int[] axisLengths, int fixedAxisIdx, CoordinateConsumer consumer, int[] allCoords) {
        PivotPostprocessor.forAllCells(axisLengths, fixedAxisIdx, consumer, 0, new int[axisLengths.length], allCoords);
    }

    private static void forAllCells(int[] axisLengths, int fixedAxisIdx, CoordinateConsumer consumer, int currentAxisIdx, int[] coords, int[] allCoords) {
        if (currentAxisIdx == fixedAxisIdx) {
            if (currentAxisIdx < axisLengths.length - 1) {
                PivotPostprocessor.forAllCells(axisLengths, fixedAxisIdx, consumer, currentAxisIdx + 1, coords, allCoords);
            } else {
                consumer.consume(coords);
            }
        } else {
            for (int x = 0; x < axisLengths[currentAxisIdx]; ++x) {
                coords[currentAxisIdx] = x;
                if (PivotPostprocessor.isTotalBin(allCoords, currentAxisIdx, x)) continue;
                if (currentAxisIdx < axisLengths.length - 1) {
                    PivotPostprocessor.forAllCells(axisLengths, fixedAxisIdx, consumer, currentAxisIdx + 1, coords, allCoords);
                    continue;
                }
                consumer.consume(coords);
            }
        }
    }

    public static void computeTensorMarginals(PivotTableTensorRequest req, PivotTableTensorResponse resp) {
        int numAxes = req.axes.length;
        for (int i = 0; i < numAxes; ++i) {
            Arrays.fill(resp.counts.axes[i], 0L);
        }
        PivotPostprocessor.forAllCells(resp.counts.axisLengths, coords -> {
            long cnt = resp.counts.get(coords);
            for (int i = 0; i < numAxes; ++i) {
                long[] lArray = resp.counts.axes[i];
                int n = coords[i];
                lArray[n] = lArray[n] + cnt;
            }
        });
        for (int k = 0; k < resp.aggregations.size(); ++k) {
            Aggregation aggr = (Aggregation)req.aggregations.get(k);
            DataTensor aggrData = (DataTensor)resp.aggregations.get(k);
            if (aggr.function == Aggregation.Function.DISTINCT || PivotUtils.aggregationProduceAlphanumericalResult(aggr.function, aggrData.type) || aggr.isUnaggregated) continue;
            PivotPostprocessor.forAllCells(((DataTensor)resp.aggregations.get((int)k)).axisLengths, coords -> {
                if (resp.counts.get(coords) == 0L) {
                    return;
                }
                switch (aggr.function) {
                    case COUNT: 
                    case STDEV: 
                    case STDEV_POPULATION: 
                    case VARIANCE: 
                    case VARIANCE_POPULATION: 
                    case SUM: {
                        for (int i = 0; i < numAxes; ++i) {
                            aggrData.setAxisAsDouble(i, coords[i], aggrData.getAxisAsDouble(i, coords[i]) + aggrData.getAsDouble(coords));
                        }
                        break;
                    }
                    case AVG: {
                        double w = aggrData.getAsDouble(coords) * (double)resp.counts.get(coords);
                        for (int i = 0; i < numAxes; ++i) {
                            aggrData.setAxisAsDouble(i, coords[i], aggrData.getAxisAsDouble(i, coords[i]) + w);
                        }
                        break;
                    }
                    case MIN: {
                        for (int i = 0; i < numAxes; ++i) {
                            aggrData.setAxisAsDouble(i, coords[i], Math.min(aggrData.getAsDouble(coords), aggrData.getAxisAsDouble(i, coords[i])));
                        }
                        break;
                    }
                    case MAX: {
                        for (int i = 0; i < numAxes; ++i) {
                            aggrData.setAxisAsDouble(i, coords[i], Math.max(aggrData.getAsDouble(coords), aggrData.getAxisAsDouble(i, coords[i])));
                        }
                        break;
                    }
                }
            });
            if (((Aggregation)req.aggregations.get((int)k)).function != Aggregation.Function.AVG) continue;
            for (int i = 0; i < numAxes; ++i) {
                for (int j = 0; j < aggrData.axisLengths[i]; ++j) {
                    if (resp.counts.axes[i][j] == 0L) continue;
                    double axis = ((DataTensor)resp.aggregations.get(k)).getAxisAsDouble(i, j);
                    ((DataTensor)resp.aggregations.get(k)).setAxisAsDouble(i, j, axis / (double)resp.counts.axes[i][j]);
                }
            }
        }
    }

    public static void computeMeasureModesTensor(PivotTableTensorRequest request, PivotTableTensorResponse resp) {
        int[] allBinCoords = PivotPostprocessor.getTotalBins(request, resp);
        block6: for (int aggr = 0; aggr < request.aggregations.size(); ++aggr) {
            Aggregation aggrObj = (Aggregation)request.aggregations.get(aggr);
            DataTensor aggrData = (DataTensor)resp.aggregations.get(aggr);
            assert (aggrObj != null);
            if (PivotUtils.aggregationProduceAlphanumericalResult(aggrObj.function, aggrData.type) || aggrObj.isUnaggregated) {
                return;
            }
            if (aggrObj.computeModeDim >= aggrData.axisLengths.length) {
                aggrObj.computeModeDim = 0;
            }
            if (aggrObj.computeMode == Aggregation.ComputeMode.PERCENTAGE || aggrObj.computeMode == Aggregation.ComputeMode.CUMULATIVE_PERCENTAGE) {
                boolean isCumulPercentage = aggrObj.computeMode == Aggregation.ComputeMode.CUMULATIVE_PERCENTAGE;
                PivotPostprocessor.forAllCells(aggrData.axisLengths, aggrObj.computeModeDim, coords -> {
                    int i;
                    double total = 0.0;
                    for (i = 0; i < aggrData.axisLengths[aggrObj.computeModeDim]; ++i) {
                        if (PivotPostprocessor.isTotalBin(allBinCoords, aggrObj.computeModeDim, i)) continue;
                        coords[aggrObj.computeModeDim] = i;
                        total += aggrData.getAsDouble(coords);
                    }
                    if (total > 0.0) {
                        for (i = 0; i < aggrData.axisLengths[aggrObj.computeModeDim]; ++i) {
                            if (isCumulPercentage && PivotPostprocessor.isTotalBin(allBinCoords, aggrObj.computeModeDim, i)) continue;
                            coords[aggrObj.computeModeDim] = i;
                            aggrData.setAsDouble(coords, aggrData.getAsDouble(coords) / total);
                        }
                    } else {
                        for (i = 0; i < aggrData.axisLengths[aggrObj.computeModeDim]; ++i) {
                            if (isCumulPercentage && PivotPostprocessor.isTotalBin(allBinCoords, aggrObj.computeModeDim, i)) continue;
                            coords[aggrObj.computeModeDim] = i;
                            aggrData.setAsDouble(coords, 0.0);
                        }
                    }
                }, (int[])(isCumulPercentage ? allBinCoords : null));
            }
            switch (aggrObj.computeMode) {
                case NORMAL: 
                case PERCENTAGE: {
                    continue block6;
                }
                case CUMULATIVE: 
                case CUMULATIVE_PERCENTAGE: {
                    PivotPostprocessor.forAllCells(aggrData.axisLengths, 0, coords -> {
                        long cumCount = 0L;
                        double cumAggr = 0.0;
                        for (int x = 0; x < aggrData.axisLengths[0]; ++x) {
                            if (PivotPostprocessor.isTotalBin(allBinCoords, 0, x)) continue;
                            coords[0] = x;
                            resp.counts.put(coords, cumCount += resp.counts.get(coords));
                            aggrData.setAsDouble(coords, cumAggr += aggrData.getAsDouble(coords));
                        }
                    }, allBinCoords);
                    continue block6;
                }
                case AVG_RATIO: {
                    PivotPostprocessor.forAllCells(aggrData.axisLengths, aggrObj.computeModeDim, coords -> {
                        double total = 0.0;
                        double count = 0.0;
                        for (int i = 0; i < aggrData.axisLengths[aggrObj.computeModeDim]; ++i) {
                            if (PivotPostprocessor.isTotalBin(allBinCoords, aggrObj.computeModeDim, i)) continue;
                            coords[aggrObj.computeModeDim] = i;
                            total += aggrData.getAsDouble(coords);
                            count += 1.0;
                        }
                        double average = total / count;
                        if (average > 0.0) {
                            for (int i = 0; i < aggrData.axisLengths[aggrObj.computeModeDim]; ++i) {
                                if (PivotPostprocessor.isTotalBin(allBinCoords, aggrObj.computeModeDim, i)) continue;
                                coords[aggrObj.computeModeDim] = i;
                                int loc = aggrData.loc(coords);
                                aggrData.setAsDouble(loc, aggrData.getAsDouble(loc) / average - 1.0);
                            }
                        }
                    }, allBinCoords);
                    continue block6;
                }
                case DIFFERENCE: {
                    PivotPostprocessor.forAllCells(aggrData.axisLengths, 0, coords -> {
                        long prevCount = 0L;
                        double prevAggr = 0.0;
                        boolean first = true;
                        for (int x = 0; x < aggrData.axisLengths[0]; ++x) {
                            if (PivotPostprocessor.isTotalBin(allBinCoords, 0, x)) continue;
                            coords[0] = x;
                            if (first) {
                                prevAggr = aggrData.getAsDouble(coords);
                            } else {
                                double thisAggr = aggrData.getAsDouble(coords);
                                aggrData.setAsDouble(coords, thisAggr - prevAggr);
                                prevAggr = thisAggr;
                            }
                            first = false;
                        }
                    }, allBinCoords);
                }
            }
        }
    }

    private static boolean isTotalBin(int[] totalBins, int dimensionId, int binId) {
        return totalBins != null && totalBins[dimensionId] == binId;
    }

    private static int[] getTotalBins(PivotTableTensorRequest request, PivotTableTensorResponse response) {
        if (request.computeSubTotals) {
            int[] totalBins = new int[response.axisDefs.size()];
            block0: for (int i = 0; i < totalBins.length; ++i) {
                for (int j = 0; j < response.axisLabels[i].size(); ++j) {
                    if (!Objects.equals(response.axisLabels[i].get((int)j).label, "___dku_total_value___")) continue;
                    totalBins[i] = j;
                    continue block0;
                }
            }
            return totalBins;
        }
        return null;
    }

    private static interface CoordinateConsumer {
        public void consume(int[] var1);
    }
}

