/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.MultipassPivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.TensorPivotBuilder;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class HexbinTensorPivotBuilder
extends TensorPivotBuilder
implements MultipassPivotTableBuilder {
    double xMin = Double.POSITIVE_INFINITY;
    double xMax = Double.NEGATIVE_INFINITY;
    double yMin = Double.POSITIVE_INFINITY;
    double yMax = Double.NEGATIVE_INFINITY;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public HexbinTensorPivotBuilder(PivotTableTensorRequest request, AxisHandler[] handlers) {
        super(request, handlers);
    }

    @Override
    public void addPass1(ColumnBlock[] axisBlocks, LinoReader linoReader, int blockIdx) throws IOException {
        boolean[] filters = null;
        if (this.filtered) {
            filters = new boolean[axisBlocks[0].nbRecords()];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
        }
        for (int r = 0; r < axisBlocks[0].nbRecords(); ++r) {
            double dy;
            if (filters != null && !filters[r]) continue;
            double dx = axisBlocks[0].doubles[r];
            if (!Double.isNaN(dx)) {
                this.xMin = Math.min(this.xMin, dx);
                this.xMax = Math.max(this.xMax, dx);
            }
            if (Double.isNaN(dy = axisBlocks[1].doubles[r])) continue;
            this.yMin = Math.min(this.yMin, dy);
            this.yMax = Math.max(this.yMax, dy);
        }
        for (int i = 2; i < this.handlers.length; ++i) {
            this.handlers[i].observe(axisBlocks[i], filters);
        }
    }

    @Override
    public void endPass1() throws BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        int[] numBins = new int[this.numAxes];
        numBins[0] = this.request.hexbinXHexagons + 1;
        numBins[1] = this.request.hexbinYHexagons + 1;
        for (int i = 2; i < this.numAxes; ++i) {
            numBins[i] = this.handlers[i].getNbBins();
        }
        this.endPass1(numBins);
        logger.infoV("End of binning xHex=%d, yHex=%d xMin=%f xMax=%f yMin=%f yMax=%f", new Object[]{this.request.hexbinXHexagons, this.request.hexbinYHexagons, this.xMin, this.xMax, this.yMin, this.yMax});
    }

    @Override
    protected int[] getAxisBins(ColumnBlock[] axisBlocks, boolean[] filters, int[][] axisBins) {
        int i;
        int[] xBins = axisBins[0];
        int[] yBins = axisBins[1];
        for (i = 0; i < axisBlocks[0].nbRecords(); ++i) {
            long pj2;
            double py2;
            double pi2;
            double px2;
            double px1;
            if (filters != null && !filters[i]) continue;
            double vx = axisBlocks[0].doubles[i];
            double vy = axisBlocks[1].doubles[i];
            if (Double.isNaN(vx) || Double.isNaN(vy)) {
                xBins[i] = -1;
                yBins[i] = -1;
                continue;
            }
            double scaledX = (vx - this.xMin) / (this.xMax - this.xMin) * (double)this.request.hexbinXHexagons;
            double scaledY = (vy - this.yMin) / (this.yMax - this.yMin) * (double)this.request.hexbinYHexagons;
            double py = scaledY;
            long pj = Math.round(py);
            double px = scaledX - (pj % 2L == 1L ? 0.5 : 0.0);
            double pi = Math.round(px);
            double py1 = py - (double)pj;
            if (Math.abs(py1) * 3.0 > 1.0 && (px1 = px - pi) * px1 + py1 * py1 > (px2 = px - (pi2 = pi + (px < pi ? -1.0 : 1.0) / 2.0)) * px2 + (py2 = py - (double)(pj2 = pj + (long)(py < (double)pj ? -1 : 1))) * py2) {
                pi = pi2 + (pj % 2L == 1L ? 1.0 : -1.0) / 2.0;
                pj = pj2;
            }
            if (vx < 800.0 || vx > 1550.0) {
                // empty if block
            }
            xBins[i] = (int)pi;
            yBins[i] = (int)pj;
        }
        for (i = 2; i < this.numAxes; ++i) {
            this.handlers[i].getBins(axisBlocks[i], axisBins[i], filters);
        }
        return null;
    }

    @Override
    protected AxisHandler.Axis sortAndPruneAxis(AxisDef def, AxisHandler handler, AxisSortPrune sortPrune, int axisIdx, boolean computeAxisTotal) {
        if (axisIdx > 1) {
            return super.sortAndPruneAxis(def, handler, sortPrune, axisIdx, false);
        }
        AxisHandler.Axis ret = new AxisHandler.Axis();
        ArrayList<? extends AxisElt> axisElts = new ArrayList<AxisElt>();
        if (axisIdx == 0) {
            double xRange = (this.xMax - this.xMin) / (double)this.request.hexbinXHexagons;
            for (i = 0; i < this.request.hexbinXHexagons; ++i) {
                ae = new NumericalAxisElt();
                ae.binIndex = i;
                ae.sortValue = this.xMin + (double)i * xRange;
                ae.min = ae.sortValue - xRange / 2.0;
                ae.max = ae.sortValue + xRange / 2.0;
                ae.label = Double.toString(ae.sortValue);
                axisElts.add(ae);
            }
        } else {
            double yRange = (this.yMax - this.yMin) / (double)this.request.hexbinYHexagons;
            for (i = 0; i < this.request.hexbinYHexagons; ++i) {
                ae = new NumericalAxisElt();
                ae.binIndex = i;
                ae.sortValue = this.yMin + (double)i * yRange;
                ae.min = ae.sortValue - yRange / 2.0;
                ae.max = ae.sortValue + yRange / 2.0;
                ae.label = Double.toString(ae.sortValue);
                axisElts.add(ae);
            }
        }
        ret.elts = axisElts;
        logger.info((Object)("Do SortPrune on axis X=" + (axisIdx == 0) + " have " + ret.elts.size() + " elts"));
        Collections.sort(axisElts, new Comparator<NumericalAxisElt>(){

            @Override
            public int compare(NumericalAxisElt o1, NumericalAxisElt o2) {
                return o1.sortValue - o2.sortValue > 0.0 ? 1 : (o1.sortValue - o2.sortValue < 0.0 ? -1 : 0);
            }
        });
        for (int i = 0; i < ret.elts.size(); ++i) {
            if (ret.elts.get((int)i).cutoffed) continue;
            ++ret.nbNotCutoff;
        }
        return ret;
    }
}

