/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.AnumAxisHandler;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DateAxisHandler;
import com.dataiku.dip.pivot.backend.dss.NumericalCustomBinsAxisHandler;
import com.dataiku.dip.pivot.backend.dss.NumericalFixedNbBinsAxisHandler;
import com.dataiku.dip.pivot.backend.dss.NumericalFixedSizeBinsAxisHandler;
import com.dataiku.dip.pivot.backend.dss.NumericalNotBinnedAxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.StringDictAxisHandler;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PivotTableAggrBuilder
extends PivotTableBuilder {
    public static AxisHandler buildLinoAxisHandler(LinoReader linoReader, AxisDef axis) {
        if (axis.type == AxisDef.Type.GEOPOINT || axis.type == AxisDef.Type.GEOMETRY) {
            throw new IllegalArgumentException("A column of type POINT or GEOMETRY can not be used for this kind of chart");
        }
        LinoMetaFile.ColumnHeader dimCol = linoReader.getColHeader(axis.column);
        AxisHandler handler = null;
        if (axis.type == AxisDef.Type.DATE) {
            handler = new DateAxisHandler(null, axis.dateParams.mode);
        } else if (axis.type == AxisDef.Type.NUMERICAL) {
            if (axis.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
                handler = new NumericalFixedNbBinsAxisHandler(null, axis.numParams);
            } else if (axis.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE) {
                handler = new NumericalFixedSizeBinsAxisHandler(null, axis.numParams);
            } else if (axis.numParams.mode == NumericalAxisParams.BinningMode.NONE) {
                handler = new NumericalNotBinnedAxisHandler(null);
            } else if (axis.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM) {
                handler = new NumericalCustomBinsAxisHandler(axis);
            }
        } else if (axis.type == AxisDef.Type.ALPHANUM) {
            handler = dimCol.memType == ColumnBlock.MemoryType.STRING_DICT ? new StringDictAxisHandler(dimCol) : new AnumAxisHandler(dimCol);
        } else {
            throw new IllegalArgumentException("Unexpected axis type: " + String.valueOf((Object)axis.type));
        }
        return handler;
    }

    public static List<ColumnBlock> getAggrBlocks(LinoReader linoReader, List<Aggregation> aggregations, int block) throws IOException {
        ArrayList<ColumnBlock> blocks = new ArrayList<ColumnBlock>();
        HashMap<String, ColumnBlock> columnBlocksMap = new HashMap<String, ColumnBlock>();
        for (Aggregation aggr : aggregations) {
            if (aggr.column != null && (aggr.function != Aggregation.Function.CUSTOM || aggr.isUnaggregated)) {
                ColumnBlock colBlock = (ColumnBlock)columnBlocksMap.get(aggr.column);
                if (colBlock == null) {
                    colBlock = linoReader.readColumnBlock(aggr.column, block);
                    columnBlocksMap.put(aggr.column, colBlock);
                }
                blocks.add(colBlock);
                continue;
            }
            blocks.add(null);
        }
        return blocks;
    }

    public void sortAxisOnNatural(AxisDef def, AxisHandler.Axis ret, AxisHandler handler) {
        int asc;
        int n = asc = def.sortPrune.sortAscending ? 1 : -1;
        if (handler instanceof AnumAxisHandler || handler instanceof StringDictAxisHandler) {
            ret.elts.sort((o1, o2) -> asc * o1.label.compareToIgnoreCase(o2.label));
        } else if (def.type == AxisDef.Type.NUMERICAL) {
            ret.elts.sort((o1, o2) -> asc * (o1.sortValue - o2.sortValue > 0.0 ? 1 : (o1.sortValue - o2.sortValue < 0.0 ? -1 : 0)));
        } else if (handler instanceof DateAxisHandler) {
            ret.elts.sort((o1, o2) -> asc * (o1.sortValue - o2.sortValue > 0.0 ? 1 : (o1.sortValue - o2.sortValue < 0.0 ? -1 : 0)));
        }
    }

    public void applyCustomSorting(AxisHandler.Axis ret, List<String> customSortingValues) {
        if (customSortingValues != null && ret.elts != null) {
            Map<String, Integer> orderMap = IntStream.range(0, customSortingValues.size()).boxed().collect(Collectors.toMap(customSortingValues::get, i -> i, (existing, replacement) -> existing));
            int lastPosition = orderMap.size();
            ret.elts.sort(Comparator.comparing(element -> orderMap.getOrDefault(element.label, lastPosition)));
        }
    }

    public AxisElt createOtherBin() {
        AxisElt others = new AxisElt();
        others.label = "___dku_others_value___";
        return others;
    }
}

