/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.PivotPostprocessor;
import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.MultipassPivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.udaf.UdafUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;

public class SimplePivotBuilder
extends PivotTableAggrBuilder
implements MultipassPivotTableBuilder {
    private final PivotTableTensorRequest request;
    private final AxisHandler axisHandler;
    private final VariablesContext variablesContext;
    private final LinoReader linoReader;
    private long beforeFilterRecords = 0L;
    private long afterFilterRecords = 0L;
    public LongDataList countList;
    public List<AbstractAggregator<?>> aggregators = new ArrayList();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public SimplePivotBuilder(PivotTableTensorRequest request, AxisHandler[] axisHandlers) {
        this(request, axisHandlers, null, null);
    }

    public SimplePivotBuilder(PivotTableTensorRequest request, AxisHandler[] axisHandlers, VariablesContext variablesContext, LinoReader linoReader) {
        this.request = request;
        this.axisHandler = axisHandlers[0];
        this.variablesContext = variablesContext;
        this.linoReader = linoReader;
        this.filtered = request.isFiltered();
    }

    @Override
    public void linoInit(LinoReader linoReader) {
        logger.info((Object)"Init PivotTableSimpleBuilder");
        this.buildLinoFilters(this.request, linoReader);
    }

    @Override
    public void addPass1(ColumnBlock[] axisBlocks, LinoReader linoReader, int blockIdx) throws IOException {
        this.addPass1(axisBlocks[0], linoReader, blockIdx);
    }

    public void addPass1(ColumnBlock dimColumn, LinoReader linoReader, int blockIdx) throws IOException {
        boolean[] filters = null;
        if (this.filtered) {
            filters = new boolean[dimColumn.nbRecords()];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
        }
        this.axisHandler.observe(dimColumn, filters);
    }

    @Override
    public void endPass1() throws BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        int bins = this.axisHandler.getNbBins();
        BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins((PivotTableAggregatedRequest)this.request, new int[]{bins}, this.variablesContext);
        logger.info((Object)("End of binning pass, bins=" + bins));
        this.countList = new LongDataList(bins);
        this.buildAggregator(bins);
    }

    public void buildAggregator(int bins) {
        for (Aggregation aggregation : this.request.aggregations) {
            this.aggregators.add(PivotUtils.buildAggregator(this.variablesContext, this.linoReader, aggregation, bins));
        }
    }

    @Override
    public void addPass2(ColumnBlock[] axisBlocks, List<ColumnBlock> aggrColumns, LinoReader linoReader, int blockIdx) throws IOException {
        this.addPass2(axisBlocks[0], aggrColumns, linoReader, blockIdx);
    }

    public void addPass2(ColumnBlock dimColumn, List<ColumnBlock> aggrColumns, LinoReader linoReader, int blockIdx) throws IOException {
        int i;
        this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
        boolean[] filters = null;
        this.beforeFilterRecords += (long)dimColumn.nbRecords();
        if (this.filtered) {
            filters = new boolean[dimColumn.nbRecords()];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            this.afterFilterRecords += (long)FilteringExecutor.countTrue(filters);
        } else {
            this.afterFilterRecords += (long)dimColumn.nbRecords();
        }
        int[] bins = new int[dimColumn.nbRecords()];
        this.axisHandler.getBins(dimColumn, bins, filters);
        for (i = 0; i < bins.length; ++i) {
            if (filters != null && !filters[i] || bins[i] == -1) continue;
            int n = bins[i];
            this.countList.data[n] = this.countList.data[n] + 1L;
        }
        for (i = 0; i < this.request.aggregations.size(); ++i) {
            AbstractAggregator<?> aggregator = this.aggregators.get(i);
            ColumnBlock block = aggrColumns.get(i);
            UdafUtils.setBlocksIfCustomAggregation(aggregator, linoReader, blockIdx);
            aggregator.handleBlock(block, bins.length, bins, filters);
            UdafUtils.mergeOtherAggregators(aggregator, this.countList);
        }
    }

    @Override
    public PivotTableTensorResponse end() throws IOException {
        logger.info((Object)"End of accumulation phase");
        for (AbstractAggregator<?> aggregator : this.aggregators) {
            aggregator.end();
        }
        AxisHandler.Axis axis = this.sortAndPruneAxis(this.request.axes[0], this.axisHandler, this.request.axes[0].sortPrune);
        logger.info((Object)("End of prune, not-cutoff=" + axis.nbNotCutoff + " (elts " + axis.elts.size() + ")"));
        boolean willNeedAnOthersBin = false;
        if (this.request.axes[0].sortPrune.maxValues > 0L) {
            axis.nbNotCutoff = (int)Math.min(this.request.axes[0].sortPrune.maxValues, (long)axis.nbNotCutoff);
            int notCutoff = 0;
            for (int x = 0; x < axis.elts.size(); ++x) {
                if (axis.elts.get((int)x).cutoffed || ++notCutoff <= (int)this.request.axes[0].sortPrune.maxValues) continue;
                axis.elts.get((int)x).cutoffed = true;
                willNeedAnOthersBin = true;
            }
        }
        if (!willNeedAnOthersBin) {
            this.request.axes[0].sortPrune.generateOthersCategory = false;
        }
        PivotTableTensorResponse resp = this.buildEmptyResponse(axis);
        for (int aggrId = 0; aggrId < this.request.aggregations.size(); ++aggrId) {
            AbstractAggregator<?> aggregator = this.aggregators.get(aggrId);
            aggregator.initMerge(resp.counts.axisLengths[0]);
            aggregator.fillTensorAndRegroup(axis, this.request, this.countList);
            aggregator.postProcessEndPhase2();
            resp.aggregations.add(aggregator.getMergeDT());
        }
        if (this.request.axes[0].sortPrune.generateOthersCategory && axis.nbNotCutoff != axis.elts.size()) {
            logger.info((Object)("Generate others nbNotCut=" + axis.nbNotCutoff + " eltsSize=" + axis.elts.size() + " targetCount=" + resp.counts.tensor[resp.axisLabels[0].size()]));
            if (resp.counts.tensor[resp.axisLabels[0].size()] != 0L) {
                AxisElt others = new AxisElt();
                others.label = "___dku_others_value___";
                resp.axisLabels[0].add(others);
            }
        }
        PivotPostprocessor.computeMeasureModesSimple(this.request, resp);
        PivotPostprocessor.computeIntermeasuresSimple(this.request, resp);
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        logger.info((Object)"End of building output data");
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        ResponseValidator.validateNonEmptyAxes(resp.counts);
        return resp;
    }

    @Override
    public void cleanup() {
        PivotUtils.cleanupAggregators(this.aggregators);
    }

    private PivotTableTensorResponse buildEmptyResponse(AxisHandler.Axis axis) {
        PivotTableTensorResponse resp = new PivotTableTensorResponse(1, this.request);
        resp.engine = PivotTableResponse.PivotEngine.LINO;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (axis.elts.get((int)x).cutoffed) continue;
            resp.axisLabels[0].add(axis.elts.get(x));
        }
        PostPruneSafetyChecks.checkTensorResponse(this.request, resp);
        resp.counts = new LongDataTensor(axis.nbNotCutoff + (this.request.axes[0].sortPrune.generateOthersCategory ? 1 : 0));
        int targetBin = 0;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (axis.elts.get((int)x).cutoffed) continue;
            int origBin = axis.elts.get((int)x).binIndex;
            resp.counts.tensor[targetBin] = this.countList.data[origBin];
            if (++targetBin == axis.nbNotCutoff) break;
        }
        if (this.request.axes[0].sortPrune.generateOthersCategory) {
            long sumOfOthersColumn = 0L;
            for (int x = 0; x < axis.elts.size(); ++x) {
                if (!axis.elts.get((int)x).cutoffed) continue;
                int origBin = axis.elts.get((int)x).binIndex;
                sumOfOthersColumn += this.countList.data[origBin];
            }
            resp.counts.tensor[axis.nbNotCutoff] = sumOfOthersColumn;
        }
        return resp;
    }

    AxisHandler.Axis sortAndPruneAxis(AxisDef def, AxisHandler handler, AxisSortPrune sortPrune) {
        AxisHandler.Axis ret = new AxisHandler.Axis();
        ArrayList<? extends AxisElt> axisElts = new ArrayList<AxisElt>();
        int idx = 0;
        for (AxisElt elt : handler.getAxisElts()) {
            elt.binIndex = idx++;
            axisElts.add(elt);
        }
        ret.elts = axisElts;
        if (sortPrune == null) {
            ret.nbNotCutoff = ret.elts.size();
            return ret;
        }
        if (sortPrune.sortType != null) {
            int asc = sortPrune.sortAscending ? -1 : 1;
            switch (sortPrune.sortType) {
                case ORIGINAL: {
                    break;
                }
                case NATURAL: {
                    this.sortAxisOnNatural(def, ret, handler);
                    break;
                }
                case AGGREGATION: {
                    logger.info((Object)"Aggregation sort");
                    AbstractAggregator<?> aggr = this.aggregators.get(sortPrune.aggregationSortId);
                    aggr.sortAxis(ret, asc, this.countList);
                    break;
                }
                case CUSTOM: {
                    this.applyCustomSorting(ret, sortPrune.customSortingValues);
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        for (AxisSortPrune.MeasureFilter filter : sortPrune.filters) {
            AbstractAggregator<?> aggr = this.aggregators.get(filter.measureFilterId);
            logger.info((Object)"Measure cutoff");
            for (int i = 0; i < ret.elts.size(); ++i) {
                double measureValue = aggr.getOutDT().getAsDouble(ret.elts.get((int)i).binIndex);
                if (!(measureValue > filter.maxValue) && !(measureValue < filter.minValue)) continue;
                ret.elts.get((int)i).cutoffed = true;
            }
        }
        if (def.type == AxisDef.Type.ALPHANUM || def.type == AxisDef.Type.NUMERICAL && def.numParams.mode == NumericalAxisParams.BinningMode.NONE) {
            for (int i = 0; i < ret.elts.size(); ++i) {
                long count = this.countList.data[ret.elts.get((int)i).binIndex];
                if (count != 0L) continue;
                ret.elts.get((int)i).cutoffed = true;
            }
        }
        for (int i = 0; i < ret.elts.size(); ++i) {
            if (ret.elts.get((int)i).cutoffed) continue;
            ++ret.nbNotCutoff;
        }
        return ret;
    }

    public static class DiminishingReturnsPoint {
        public AxisElt elt;
        public double x;
        public double y;
        public double excessRatio;
    }
}

