/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.refine.grel.ast.FunctionCallExpr;
import java.io.IOException;
import java.util.Date;

public abstract class AbstractAggregator<T>
implements AutoCloseable {
    protected final DataTensor<T> outDT;
    protected DataTensor<T> mergeDT;
    public Aggregation req;
    public FunctionCallExpr parentReference;
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    protected AbstractAggregator(Aggregation req, DataTensor<T> outDT) {
        this.req = req;
        this.outDT = outDT;
    }

    public abstract void sortAxis(AxisHandler.Axis var1, int var2, int var3);

    public abstract void sortAxis(AxisHandler.Axis var1, int var2, LongDataList var3);

    public abstract T mergeValues(T var1, T var2);

    public abstract boolean mergeTensorAndAxes(PivotTableTensorRequest var1, int[] var2, int[] var3, AxisHandler.Axis[] var4) throws IOException;

    public void applyOtherCategoryToTensor(OtherCategoryProperties<T> ocp, int index) {
        this.getMergeDT().set(index, ocp.aggrOfOthersColumn, true);
    }

    protected void transferBinToMergeDT(int originBin, int targetBin, LongDataList countList) {
        this.getMergeDT().set(targetBin, this.getValue(originBin, countList, true), true);
    }

    protected void transferBinToAxisMergeDT(int i, int j, int jTargetBin) {
        this.getMergeDT().setAxis(i, jTargetBin, this.getValue(this.getOutDT().getAxis(i, j), this.getAxisNonNullCount(i, j)));
    }

    public double mergeDoubleValues(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return v1 + v2;
    }

    protected void handle(double value, int[] coords, boolean fillAxes) throws IOException {
        if (Double.isFinite(value)) {
            if (fillAxes) {
                for (int i = 0; i < this.getOutDT().numAxes; ++i) {
                    this.getOutDT().setAxisAsDouble(i, coords[i], this.mergeDoubleValues(this.getOutDT().getAxisAsDouble(i, coords[i]), value));
                }
                this.getOutDT().incrementAxesNonNullCount(coords);
            }
            this.getOutDT().setAsDouble(coords, this.mergeDoubleValues(this.getOutDT().getAsDouble(coords), value));
            this.getOutDT().incrementNonNullCount(coords);
        } else {
            this.getOutDT().hasNullValues = true;
        }
    }

    protected void handle(Object value, int[] coords, boolean fillAxes) throws IOException {
        if (value != null && !value.toString().isEmpty()) {
            if (fillAxes) {
                for (int i = 0; i < this.getOutDT().numAxes; ++i) {
                    this.getOutDT().setAxis(i, coords[i], this.mergeValues(this.getOutDT().getAxis(i, coords[i]), value));
                }
                this.getOutDT().incrementAxesNonNullCount(coords);
            }
            this.getOutDT().set(coords, this.mergeValues(value, this.getValue(coords, true)), true);
            this.getOutDT().incrementNonNullCount(coords);
        } else {
            this.getOutDT().hasNullValues = true;
        }
    }

    public void handleBlock(ColumnBlock block, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            int[] destBin;
            if (filters != null && !filters[row] || (destBin = this.extractDestBin(row, coords, bins)) == null) continue;
            if (block.doubles != null) {
                this.handle(block.doubles[row], destBin, fillAxes);
                continue;
            }
            this.handle(block.getAsStringSlow(row), destBin, fillAxes);
        }
    }

    public final void handleBlock(ColumnBlock block, int rows, int[] coords) throws IOException {
        this.handleBlock(block, rows, rows + 1, coords, null, null, true);
    }

    public final void handleBlock(ColumnBlock block, int rows, int[] bins, boolean[] filters) throws IOException {
        this.handleBlock(block, 0, rows, null, bins, filters, false);
    }

    protected void handle(double value, int loc) throws IOException {
        this.handle(value, new int[]{loc}, false);
    }

    protected void handle(Object value, int loc) throws IOException {
        this.handle(value, new int[]{loc}, false);
    }

    protected void handle(double value, int[] coords) throws IOException {
        this.handle(value, coords, true);
    }

    protected void handle(Object value, int[] coords) throws IOException {
        this.handle(value, coords, true);
    }

    public OtherCategoryProperties<T> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        OtherCategoryProperties otherCategoryProperties = new OtherCategoryProperties();
        Object otherValue = null;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (!axis.elts.get((int)x).cutoffed) continue;
            int origBin = axis.elts.get((int)x).binIndex;
            otherValue = this.mergeValues(otherValue, this.getValue(origBin, true));
            otherCategoryProperties.nonNullCountOfOthersColumn += this.getOutDT().nonNullCounts[origBin];
        }
        otherCategoryProperties.aggrOfOthersColumn = this.getValue(otherValue, otherCategoryProperties.nonNullCountOfOthersColumn);
        return otherCategoryProperties;
    }

    public void end() throws IOException {
    }

    @Override
    public void close() throws Exception {
    }

    public void postProcessEndPhase2() {
        this.getMergeDT().replaceInvalidValues();
    }

    public void setMergeDT(DataTensor<T> mergeDT) {
        this.mergeDT = mergeDT;
    }

    public void initMerge(int[] axisLengths) {
        this.setMergeDT(this.getOutDT().createMergeDT(axisLengths));
    }

    public void initMerge(int axisLength) {
        this.setMergeDT(this.getOutDT().createMergeDT(axisLength));
    }

    public void initMerge() {
        this.setMergeDT(this.getOutDT().createMergeDT(this.getOutDT().axisLengths));
    }

    public void fillTensorAndRegroup(AxisHandler.Axis axis, PivotTableTensorRequest request, LongDataList countList) {
        if (request.axes[0].sortPrune.generateOthersCategory) {
            OtherCategoryProperties<T> otherCategoryProperties = this.retrieveOthersCategoryProperties(axis);
            this.applyOtherCategoryToTensor(otherCategoryProperties, axis.nbNotCutoff);
            if (this.getMergeDT().hasNullValues) {
                this.getMergeDT().nonNullCounts[axis.nbNotCutoff] = otherCategoryProperties.nonNullCountOfOthersColumn;
            }
        }
        int targetBin = 0;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (axis.elts.get((int)x).cutoffed) continue;
            int originBin = axis.elts.get((int)x).binIndex;
            this.transferBinToMergeDT(originBin, targetBin, countList);
            if (this.getMergeDT().hasNullValues) {
                int n = targetBin;
                this.getMergeDT().nonNullCounts[n] = this.getMergeDT().nonNullCounts[n] + this.getOutDT().nonNullCounts[originBin];
            }
            if (++targetBin == axis.nbNotCutoff) break;
        }
    }

    public void mapFillMergeDT(LongDataList countList) {
    }

    public DataTensor<T> getMergeDT() {
        return this.mergeDT;
    }

    public DataTensor<T> getOutDT() {
        return this.outDT;
    }

    public DataTensor<T> mergeTensor() {
        for (int i = 0; i < this.getOutDT().tensorSize; ++i) {
            this.getMergeDT().set(i, this.getValue(i, this.getOutDT().nonNullCounts, true), true);
        }
        this.getMergeDT().nonNullCounts = this.getOutDT().nonNullCounts;
        return this.getMergeDT();
    }

    public long getNonNullCount(int[] coordinates) {
        return this.getOutDT().nonNullCounts[this.getOutDT().loc(coordinates)];
    }

    public long getAxisNonNullCount(int i, int j) {
        return this.getOutDT().axesNonNullCounts[i][j];
    }

    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        block0: for (int i = 0; i < axes.length; ++i) {
            int targetBin = 0;
            for (int x = 0; x < axes[i].elts.size(); ++x) {
                if (axes[i].elts.get((int)x).cutoffed) continue;
                this.transferBinToAxisMergeDT(i, axes[i].elts.get((int)x).binIndex, targetBin);
                if (++targetBin == axes[i].nbNotCutoff) continue block0;
            }
        }
    }

    public T getAxisValue(int i, int j, long[][] counts) {
        return this.getValue(this.getOutDT().getAxis(i, j), counts[i][j]);
    }

    public T getValue(int loc, LongDataList countList) {
        return this.getValue(loc, countList, false);
    }

    public T getValue(int loc, LongDataList countList, boolean toRealType) {
        if (countList == null) {
            return this.getValue(loc, this.getOutDT().nonNullCounts, toRealType);
        }
        return this.getValue(loc, this.getOutDT().hasNullValues ? this.getOutDT().nonNullCounts : countList.data, toRealType);
    }

    public double getDoubleValue(int loc, LongDataList countList) {
        if (countList == null) {
            return this.getDoubleValue(loc, this.getOutDT().nonNullCounts);
        }
        return this.getDoubleValue(loc, this.getOutDT().hasNullValues ? this.getOutDT().nonNullCounts : countList.data);
    }

    public T getValue(int loc, LongDataTensor countTensor) {
        return this.getValue(loc, this.getOutDT().hasNullValues ? this.getOutDT().nonNullCounts : countTensor.tensor, false);
    }

    public T getValue(int[] coords, long[] counts) {
        return this.getValue(this.getOutDT().loc(coords), counts, false);
    }

    public T getValue(int[] coords, long[] counts, boolean toRealType) {
        return this.getValue(this.getOutDT().loc(coords), counts, toRealType);
    }

    public T getValue(int loc, long[] counts, boolean toRealType) {
        return this.getValue(this.getOutDT().get(loc), counts[loc], toRealType);
    }

    public T getValue(int loc, long[] counts) {
        return this.getValue(this.getOutDT().get(loc), counts[loc], false);
    }

    public double getDoubleValue(int loc, long[] counts) {
        return this.getDoubleValue(this.getOutDT().getAsDouble(loc), counts[loc]);
    }

    public T getValue(int[] coords) {
        return this.getValue(coords, false);
    }

    public T getValue(int[] coords, boolean realType) {
        return this.getValue(this.getOutDT().loc(coords), realType);
    }

    public T getValue(int loc) {
        return this.getValue(loc, false);
    }

    public T getValue(int loc, boolean realType) {
        return this.getValue(this.getOutDT().get(loc), this.getOutDT().nonNullCounts[loc], realType);
    }

    public T getMergeDTValue(int[] coords, boolean realType) {
        return this.getMergeDTValue(this.getMergeDT().loc(coords), realType);
    }

    public T getValue(T value, long count) {
        return this.getValue(value, count, false);
    }

    public T getValue(T value, long count, boolean toRealType) {
        if (toRealType) {
            return this.realType(value);
        }
        return value;
    }

    public T getMergeDTValue(int loc, boolean realType) {
        T value = this.getMergeDT().get(loc);
        if (realType) {
            return this.realType(value);
        }
        return value;
    }

    private T realType(T value) {
        if (this.getOutDT().type == TensorType.DATE && value != null) {
            return (T)new DateTime(value);
        }
        return value;
    }

    public double getDoubleValue(double value, long count) {
        return value;
    }

    public boolean expressionNeedsFix() {
        return false;
    }

    public int compareValues(T v1, T v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (this.isNumeric(v1) || this.isNumeric(v2) || this.isDate(v1) || this.isDate(v2)) {
            return this.compareNumericValues(v2, v1);
        }
        if (this.isAlphanum(v1) || this.isAlphanum(v2)) {
            return this.compareStringValues(v2, v1);
        }
        throw new UnsupportedOperationException("Not able to compare that type of values");
    }

    private boolean isNumeric(Object value) {
        return value instanceof Number;
    }

    private boolean isDate(Object value) {
        return value instanceof DateTime || value instanceof Date;
    }

    private boolean isAlphanum(Object value) {
        return value instanceof String;
    }

    private int compareNumericValues(Object v1, Object v2) {
        Double v1d = this.extractNumericValue(v1);
        Double v2d = this.extractNumericValue(v2);
        if (v1d.isNaN() && v2d.isNaN()) {
            return 0;
        }
        if (v1d.isNaN()) {
            return 1;
        }
        if (v2d.isNaN()) {
            return -1;
        }
        return v1d.compareTo(v2d);
    }

    private int compareStringValues(Object v1, Object v2) {
        String v1d = (String)(v1 != null ? v1 : "");
        String v2d = (String)(v2 != null ? v2 : "");
        return v1d.compareTo(v2d);
    }

    private Double extractNumericValue(Object v) {
        if (this.isNumeric(v)) {
            return ((Number)v).doubleValue();
        }
        if (this.isDate(v)) {
            return new DateTime(v).getMillis();
        }
        return Double.NaN;
    }

    protected int compareAxisDoubleValues(double v1, double v2, AxisElt o1, AxisElt o2, int asc, long[] nnc) {
        return this.compareAxisDoubleValues(v1, v2, o1, o2, asc, nnc, 0);
    }

    protected int compareAxisDoubleValues(double v1, double v2, AxisElt o1, AxisElt o2, int asc, long[] nnc, int invalidCountValue) {
        double nnc1 = nnc[o1.binIndex];
        double nnc2 = nnc[o2.binIndex];
        if (nnc1 <= (double)invalidCountValue || nnc2 <= (double)invalidCountValue) {
            if (nnc1 == nnc2) {
                return 0;
            }
            if (nnc1 <= (double)invalidCountValue) {
                return 1;
            }
            return -1;
        }
        return asc * Double.compare(v2, v1);
    }

    protected int[] extractDestBin(int row, int[] coords, int[] bins) {
        if (coords == null) {
            int[] nArray;
            if (bins[row] == -1) {
                nArray = null;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = bins[row];
            }
            return nArray;
        }
        return coords;
    }

    public static class OtherCategoryProperties<T> {
        public T aggrOfOthersColumn;
        long nonNullCountOfOthersColumn;
    }
}

