/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CountingInputStream;
import gnu.trove.TDoubleCollection;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.fontbox.ttf.BufferedRandomAccessFile;

public abstract class FlushableAggregator
implements AutoCloseable {
    private final int passNumber;
    private AutoDelete tempFolder;
    private String linoFileName;
    private int numberOfHandleBeforeFlush;
    private int tensorLength;
    private int timesFlushed = 0;
    private BufferedRandomAccessFile raf;
    private TIntLongMap locMapping;
    protected Visitor visitor;
    protected ColumnBlock.MemoryType memType;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public FlushableAggregator(String column, int passNumber, int tensorLength) {
        this.passNumber = passNumber;
        this.numberOfHandleBeforeFlush = passNumber;
        this.tensorLength = tensorLength;
        try {
            this.tempFolder = DSSTempUtils.getTempFolder((String)"aggregators");
            this.linoFileName = "aggregations_" + column;
        }
        catch (IOException e) {
            logger.error((Object)"Cannot create tempFile distinct aggregation will not work");
        }
    }

    protected void flushDoubleToDisk(TreeMap<Integer, ?> values) throws IOException {
        this.flushToDisk(values, true);
    }

    protected void flushStringToDisk(TreeMap<Integer, ?> values) throws IOException {
        this.flushToDisk(values, false);
    }

    private void flushToDisk(TreeMap<Integer, ?> values, boolean isDoubles) throws IOException {
        this.writeValues(values, isDoubles);
        this.numberOfHandleBeforeFlush = this.passNumber;
        ++this.timesFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValues(TreeMap<Integer, ?> values, boolean isDoubles) throws IOException {
        File previousFile = new File((File)this.tempFolder, this.linoFileName + (this.timesFlushed - 1) + ".agg");
        try (DataInputStream inputStream = this.retrieveInputStream(previousFile);
             DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(new File((File)this.tempFolder, this.linoFileName + this.timesFlushed + ".agg").toPath(), new OpenOption[0])));){
            int locInFile;
            int n = locInFile = inputStream == null ? Integer.MAX_VALUE : inputStream.readInt();
            while (locInFile != Integer.MAX_VALUE || !values.isEmpty()) {
                Map.Entry<Integer, ?> entry = values.pollFirstEntry();
                int key = entry != null ? entry.getKey() : Integer.MAX_VALUE;
                boolean writeMetadata = true;
                while (inputStream != null && locInFile <= key) {
                    outputStream.writeInt(locInFile);
                    int length = inputStream.readInt();
                    outputStream.writeInt(length + (key == locInFile && entry != null ? this.getSize(entry) : 0));
                    this.writeExistingValues(outputStream, inputStream, length, !isDoubles);
                    writeMetadata = locInFile != key;
                    try {
                        locInFile = inputStream.readInt();
                    }
                    catch (EOFException e) {
                        locInFile = Integer.MAX_VALUE;
                        break;
                    }
                }
                if (entry == null) continue;
                this.writeCurrentEntry(outputStream, entry, writeMetadata, !isDoubles);
            }
        }
        finally {
            try {
                DKUFileUtils.delete((File)previousFile);
            }
            catch (IOException e) {
                logger.error((Object)"Cannot delete previous file for values");
            }
        }
    }

    protected void readValues(boolean readAsString, boolean storeLocation) throws IOException {
        if (storeLocation) {
            this.locMapping = new TIntLongHashMap(this.tensorLength / 2, 0.5f, -1, -1L);
        }
        CountingInputStream countingInputStream = new CountingInputStream((InputStream)new BufferedInputStream(Files.newInputStream(new File((File)this.tempFolder, this.linoFileName + (this.timesFlushed - 1) + ".agg").toPath(), new OpenOption[0])));
        try (DataInputStream dataInputStream = new DataInputStream((InputStream)countingInputStream);){
            for (int i = 0; i < this.tensorLength; ++i) {
                if (this.isLocationEmpty(i)) continue;
                int loc = dataInputStream.readInt();
                if (storeLocation) {
                    this.locMapping.put(loc, countingInputStream.getByteCount() - 4L);
                }
                if (loc == i) {
                    int length = dataInputStream.readInt();
                    this.readValuesForLoc(dataInputStream, length, readAsString, i, this.visitor);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Expecting to read data for location '%d' but found '%d'", i, loc));
            }
        }
    }

    public void readValues(int loc, Visitor visitor) throws IOException {
        if (this.hasBeenFlushed()) {
            long position;
            if (this.raf == null) {
                this.raf = new BufferedRandomAccessFile(new File((File)this.tempFolder, this.linoFileName + (this.timesFlushed - 1) + ".agg"), "r", 50000);
            }
            if ((position = this.locMapping.get(loc)) != this.locMapping.getNoEntryValue()) {
                this.raf.seek(position);
                int fileLoc = this.raf.readInt();
                if (fileLoc != loc) {
                    throw new IllegalArgumentException(String.format("Expecting to read data for location '%d' but found '%d'", loc, fileLoc));
                }
                int length = this.raf.readInt();
                this.readValuesForLoc((DataInput)this.raf, length, this.memType == ColumnBlock.MemoryType.STRING, loc, visitor);
            }
        }
    }

    private void readValuesForLoc(DataInput dataInputStream, int length, boolean readAsString, int location, Visitor visitor) throws IOException {
        visitor.beginRead(location, length);
        while (length-- > 0) {
            if (readAsString) {
                visitor.handleString(dataInputStream.readUTF());
                continue;
            }
            visitor.handleDouble(dataInputStream.readDouble());
        }
        visitor.endRead(location);
    }

    protected abstract boolean isLocationEmpty(int var1);

    protected boolean needFlush() {
        return this.numberOfHandleBeforeFlush-- == 0;
    }

    private void writeCurrentEntry(DataOutputStream outputStream, Map.Entry<Integer, ?> entry, boolean writeMetadata, boolean writeAsStrings) throws IOException {
        if (writeAsStrings) {
            Collection stringValues = (Collection)entry.getValue();
            if (writeMetadata) {
                outputStream.writeInt(entry.getKey());
                outputStream.writeInt(stringValues.size());
            }
            for (String s : stringValues) {
                outputStream.writeUTF(s);
            }
        } else {
            TDoubleCollection doubleValues = (TDoubleCollection)entry.getValue();
            if (writeMetadata) {
                outputStream.writeInt(entry.getKey());
                outputStream.writeInt(doubleValues.size());
            }
            TDoubleIterator valueIterator = doubleValues.iterator();
            while (valueIterator.hasNext()) {
                outputStream.writeDouble(valueIterator.next());
            }
        }
    }

    private void writeExistingValues(DataOutputStream outputStream, DataInputStream inputStream, int length, boolean writeAsStrings) throws IOException {
        while (length-- > 0) {
            if (writeAsStrings) {
                outputStream.writeUTF(inputStream.readUTF());
                continue;
            }
            outputStream.writeDouble(inputStream.readDouble());
        }
    }

    private DataInputStream retrieveInputStream(File file) throws IOException {
        if (file.exists()) {
            return new DataInputStream(new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        return null;
    }

    private int getSize(Map.Entry<Integer, ?> entry) {
        Object value = entry.getValue();
        if (value instanceof TDoubleCollection) {
            return ((TDoubleCollection)value).size();
        }
        return ((Collection)value).size();
    }

    @Override
    public void close() throws Exception {
        this.tempFolder.close();
        IOUtils.closeQuietly((Closeable)this.raf);
    }

    public boolean hasBeenFlushed() {
        return this.timesFlushed > 0;
    }

    protected void setTensorLength(int length) {
        this.tensorLength = length;
    }

    public static interface Visitor {
        public void handleString(String var1) throws IOException;

        public void handleDouble(double var1) throws IOException;

        public void beginRead(int var1, int var2);

        public void endRead(int var1);
    }

    public static class VisitorManager
    implements Visitor {
        private final Iterable<Visitor> visitors;

        public VisitorManager(Iterable<Visitor> visitors) {
            this.visitors = visitors;
        }

        @Override
        public void handleString(String value) throws IOException {
            for (Visitor visitor : this.visitors) {
                visitor.handleString(value);
            }
        }

        @Override
        public void handleDouble(double value) throws IOException {
            for (Visitor visitor : this.visitors) {
                visitor.handleDouble(value);
            }
        }

        @Override
        public void beginRead(int location, int length) {
            for (Visitor visitor : this.visitors) {
                visitor.beginRead(location, length);
            }
        }

        @Override
        public void endRead(int location) {
            for (Visitor visitor : this.visitors) {
                visitor.endRead(location);
            }
        }
    }
}

