/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.scatter.AbstractScatterBuilder;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.GeometryColumn;
import com.dataiku.dip.pivot.backend.model.maps.PTMapRawGeometryRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapRawGeometryResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.processors.geo.GeoJSONUtils;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;

public class MapRawGeometryBuilder
extends AbstractScatterBuilder {
    private final PTMapRawGeometryRequest request;
    private int finishedPoints;
    private final long maxTotalGeometryStringLength = DKUApp.getParams().getLongParam("dku.charts.geo.maxTotalGeometryStringLength", 100000000L);

    public MapRawGeometryBuilder(PTMapRawGeometryRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PTMapRawGeometryResponse buildFromLino(LinoReader linoReader) throws Exception {
        int i;
        this.outputRows = (int)linoReader.nbRecords();
        List<GeometryColumn> geoColumns = this.request.geoColumns;
        GeometryMeaning geometryMeaning = new GeometryMeaning();
        this.buildLinoFilters(this.request, linoReader);
        this.initValues(this.request.columns);
        PTMapRawGeometryResponse resp = new PTMapRawGeometryResponse();
        long beforeFilter = 0L;
        long afterFilter = 0L;
        int geoNumber = geoColumns.size();
        boolean hasMultipleGeometries = geoNumber > 1;
        boolean[] blockFilters = new boolean[]{};
        HashMap<String, boolean[]> missingDetails = new HashMap<String, boolean[]>();
        int[] propertyIndex = new int[geoNumber];
        JSONArray[] computedFeatures = new JSONArray[geoNumber];
        TIntHashSet[] processedGeometries = new TIntHashSet[geoNumber];
        long usedGeometryStrLength = 0L;
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            for (int geoColumnIndex = 0; geoColumnIndex < geoColumns.size(); ++geoColumnIndex) {
                ColumnBlock geomBlock = linoReader.readColumnBlock(geoColumns.get((int)geoColumnIndex).column + "__dku_raw", blockIdx);
                if (geoColumnIndex == 0) {
                    beforeFilter += (long)geomBlock.nbRecords();
                    blockFilters = new boolean[geomBlock.nbRecords()];
                    if (this.filtered) {
                        this.filterLinoBlock(this.request, linoReader, blockIdx, blockFilters);
                    } else {
                        Arrays.fill(blockFilters, true);
                    }
                    long blockKept = FilteringExecutor.countTrue(blockFilters);
                    logger.info((Object)("Handle block " + blockIdx + " with " + geomBlock.nbRecords() + "(keep: " + blockKept + ")"));
                    afterFilter += blockKept;
                    this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
                    for (int i2 = 0; i2 < this.request.columns.size(); ++i2) {
                        if (this.request.columns.get((int)i2).id.startsWith("tooltip")) continue;
                        boolean[] initialMissingDetails = new boolean[geomBlock.nbRecords()];
                        Arrays.fill(initialMissingDetails, true);
                        this.filterNAOnBlock(linoReader, this.request.columns.get((int)i2).column, (AbstractScatterBuilder.BlockTmpData)this.values.get(i2), initialMissingDetails, blockIdx);
                        missingDetails.put(this.request.columns.get((int)i2).id, initialMissingDetails);
                    }
                }
                if (computedFeatures[geoColumnIndex] == null) {
                    computedFeatures[geoColumnIndex] = new JSONArray();
                }
                boolean[] columnFilters = (boolean[])blockFilters.clone();
                for (int i3 = 0; i3 < geomBlock.nbRecords(); ++i3) {
                    boolean isColorDetailsEmpty;
                    if (!blockFilters[i3]) continue;
                    String geometryStr = geomBlock.getAsStringSlow(i3);
                    Geometry geometry = geometryMeaning.toGeometry(geometryStr);
                    boolean[] rowsWithoutDetails = missingDetails.get("color_" + geoColumnIndex);
                    boolean bl = isColorDetailsEmpty = rowsWithoutDetails != null && !rowsWithoutDetails[i3];
                    if (geometry == null || isColorDetailsEmpty) {
                        if (hasMultipleGeometries) {
                            int n = geoColumnIndex;
                            int n2 = propertyIndex[n];
                            propertyIndex[n] = n2 + 1;
                            computedFeatures[geoColumnIndex].put((Object)this.generateEmptyFeature(n2));
                            continue;
                        }
                        columnFilters[i3] = false;
                        continue;
                    }
                    if (geoColumns.get((int)geoColumnIndex).aggregationFunction == Aggregation.Function.DISTINCT) {
                        int hashCode = geometry.hashCode();
                        if (processedGeometries[geoColumnIndex] == null) {
                            processedGeometries[geoColumnIndex] = new TIntHashSet();
                        } else if (processedGeometries[geoColumnIndex].contains(hashCode)) {
                            if (!hasMultipleGeometries) continue;
                            int n = geoColumnIndex;
                            int n3 = propertyIndex[n];
                            propertyIndex[n] = n3 + 1;
                            computedFeatures[geoColumnIndex].put((Object)this.generateEmptyFeature(n3));
                            continue;
                        }
                        processedGeometries[geoColumnIndex].add(hashCode);
                    }
                    if ((usedGeometryStrLength += (long)geometryStr.length()) > this.maxTotalGeometryStringLength) {
                        throw new BinsAndTensorsSafetyChecks.MemoryLimitExceededException("Too much geometry data, memory limit reached. Simplify geometries or use fewer records");
                    }
                    int n = geoColumnIndex;
                    int n4 = propertyIndex[n];
                    propertyIndex[n] = n4 + 1;
                    computedFeatures[geoColumnIndex].put((Object)this.generateFeature(geometry, n4));
                }
                if (geoColumnIndex != 0) continue;
                this.getDetails(linoReader, blockIdx, columnFilters, missingDetails);
            }
        }
        logger.info((Object)"End of accumulation phase, build the response");
        for (i = 0; i < this.request.columns.size(); ++i) {
            resp.values.put(this.request.columns.get((int)i).id, this.fromBlock((AbstractScatterBuilder.BlockTmpData)this.values.get(i)));
        }
        for (i = 0; i < geoNumber; ++i) {
            JSONObject featureCollection = new JSONObject();
            featureCollection.put("type", (Object)"FeatureCollection");
            featureCollection.put("features", (Object)computedFeatures[i]);
            resp.geoJsons.add(featureCollection.toString());
        }
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        resp.setRecordCounts(beforeFilter, afterFilter);
        return resp;
    }

    private JSONObject generateEmptyFeature(int propertyIndex) {
        JSONObject geoJson = new JSONObject();
        geoJson.put("type", (Object)"MultiLineString");
        JSONArray emptyCoordinates = new JSONArray();
        geoJson.put("coordinates", (Object)new JSONObject((Object)emptyCoordinates));
        JSONObject feature = new JSONObject();
        feature.put("type", (Object)"Feature");
        feature.put("geometry", (Object)geoJson);
        JSONObject props = new JSONObject();
        feature.put("properties", (Object)props);
        props.put("idx", propertyIndex);
        return feature;
    }

    private JSONObject generateFeature(Geometry geometry, int propertyIndex) {
        JSONObject feature = new JSONObject();
        feature.put("type", (Object)"Feature");
        feature.put("geometry", (Object)new JSONObject(GeoJSONUtils.getGeoJSON(geometry)));
        JSONObject props = new JSONObject();
        feature.put("properties", (Object)props);
        props.put("idx", propertyIndex);
        return feature;
    }

    private void getDetails(LinoReader linoReader, int blockIdx, boolean[] filters, HashMap<String, boolean[]> missingDetails) throws IOException {
        int gathered = 0;
        for (int i = 0; i < this.request.columns.size(); ++i) {
            boolean[] haveMissingDetails = missingDetails.get(this.request.columns.get((int)i).id);
            gathered = this.gatherDataBlock(linoReader, this.request.columns.get((int)i).column, (AbstractScatterBuilder.BlockTmpData)this.values.get(i), blockIdx, filters, this.finishedPoints, haveMissingDetails);
        }
        this.finishedPoints += gathered;
    }
}

