/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.scatter;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.IndexedDataListBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.ds.DoubleDataListBuilder;
import com.dataiku.dip.pivot.backend.dss.ds.LongDataListBuilder;
import com.dataiku.dip.pivot.backend.dss.scatter.UnaggregatedDateHelper;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.Unaggregated;
import com.dataiku.dip.pivot.backend.model.scatter.PTCommonScatterResponse;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractScatterBuilder
extends PivotTableBuilder {
    protected int outputRows;
    private final UnaggregatedDateHelper dateHelper = new UnaggregatedDateHelper();
    protected List<BlockTmpData> values = new ArrayList<BlockTmpData>();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    protected void initValues(List<Unaggregated> columns) {
        for (Unaggregated column : columns) {
            BlockTmpData data = new BlockTmpData();
            data.type = column.type;
            data.dateMode = column.dateMode;
            this.initAxis(data);
            this.values.add(data);
        }
    }

    protected void initAxis(BlockTmpData data) {
        switch (data.type) {
            case ALPHANUM: {
                data.strBuilder = new IndexedDataListBuilder(this.outputRows);
                break;
            }
            case DATE: {
                if (data.dateMode == Unaggregated.DateMode.RANGE) {
                    data.longBuilder = new LongDataListBuilder(this.outputRows);
                    break;
                }
                data.strBuilder = new IndexedDataListBuilder(this.outputRows);
                break;
            }
            case NUMERICAL: {
                data.dblBuilder = new DoubleDataListBuilder(this.outputRows);
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("A column of type POINT or GEOMETRY can not be used for this kind of chart");
            }
        }
    }

    protected void filterNAOnNumBlock(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            int n = i;
            filters[n] = filters[n] & !Double.isNaN(block.doubles[i]);
        }
    }

    protected void filterNAOnBlock(LinoReader linoReader, String column, BlockTmpData data, boolean[] filters, int blockIdx) throws IOException {
        this.filterNAOnBlock(linoReader.readColumnBlock(column, blockIdx), data, filters);
    }

    protected void filterNAOnBlock(ColumnBlock block, BlockTmpData data, boolean[] filters) throws IOException {
        switch (data.type) {
            case ALPHANUM: {
                for (int i = 0; i < block.nbRecords(); ++i) {
                    if (block.getMemoryType() == ColumnBlock.MemoryType.STRING) {
                        int n = i;
                        filters[n] = filters[n] & block.strings.getSlow(i) != null;
                        continue;
                    }
                    if (block.getMemoryType() == ColumnBlock.MemoryType.DOUBLE) {
                        int n = i;
                        filters[n] = filters[n] & !Double.isNaN(block.doubles[i]);
                        continue;
                    }
                    if (block.getMemoryType() == ColumnBlock.MemoryType.STRING_DICT) {
                        int idx = block.ints[i];
                        int n = i;
                        filters[n] = filters[n] & idx != 0;
                        continue;
                    }
                    throw new Error("Unexpected block type " + String.valueOf((Object)block.getMemoryType()) + " for " + block.name);
                }
                break;
            }
            case DATE: 
            case NUMERICAL: {
                this.filterNAOnNumBlock(block, filters);
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new Error("Unreachable");
            }
        }
    }

    protected int gatherDataOnNumBlock(ColumnBlock block, boolean[] filters, BlockTmpData data, int finishedPoints) {
        int gatheredInBlock = 0;
        int remainingToGather = this.outputRows - finishedPoints;
        assert (remainingToGather > 0);
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (!filters[i]) continue;
            data.dblBuilder.add(block.doubles[i]);
            if (++gatheredInBlock == remainingToGather) break;
        }
        logger.info((Object)("End of num block, was remaining =" + remainingToGather + " gathered " + gatheredInBlock));
        return gatheredInBlock;
    }

    protected int gatherDataBlock(LinoReader linoReader, String column, BlockTmpData data, int blockIdx, boolean[] filters, int finishedPoints, @Nullable boolean[] haveMissingDetails) throws IOException {
        int gatheredInBlock = 0;
        int remainingToGather = this.outputRows - finishedPoints;
        assert (remainingToGather > 0);
        ColumnBlock block = linoReader.readColumnBlock(column, blockIdx);
        block0 : switch (data.type) {
            case ALPHANUM: {
                for (int i = 0; i < block.nbRecords(); ++i) {
                    if (!filters[i]) continue;
                    if (haveMissingDetails != null && !haveMissingDetails[i]) {
                        data.strBuilder.addEmptyData();
                    } else {
                        data.strBuilder.addData(block.getAsStringSlow(i));
                    }
                    if (++gatheredInBlock == remainingToGather) break block0;
                }
                break;
            }
            case DATE: {
                if (data.dateMode == Unaggregated.DateMode.RANGE) {
                    for (int i = 0; i < block.nbRecords(); ++i) {
                        if (!filters[i]) continue;
                        if (haveMissingDetails != null && !haveMissingDetails[i]) {
                            data.longBuilder.addEmptyData();
                        } else {
                            data.longBuilder.add((long)block.doubles[i]);
                        }
                        if (++gatheredInBlock == remainingToGather) break block0;
                    }
                } else {
                    for (int i = 0; i < block.nbRecords(); ++i) {
                        if (!filters[i]) continue;
                        if (haveMissingDetails != null && !haveMissingDetails[i]) {
                            data.strBuilder.addEmptyData();
                        } else {
                            data.strBuilder.addData(this.dateHelper.getValue((long)block.doubles[i], data.dateMode));
                        }
                        if (++gatheredInBlock == remainingToGather) break block0;
                    }
                }
                break;
            }
            case NUMERICAL: {
                for (int i = 0; i < block.nbRecords(); ++i) {
                    if (!filters[i]) continue;
                    if (haveMissingDetails != null && !haveMissingDetails[i]) {
                        data.dblBuilder.addEmptyData();
                    } else {
                        data.dblBuilder.add(block.doubles[i]);
                    }
                    if (++gatheredInBlock == remainingToGather) break block0;
                }
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("A column of type POINT or GEOMETRY can not be used for this kind of chart");
            }
        }
        logger.info((Object)("End of block, was remaining =" + remainingToGather + " gathered " + gatheredInBlock));
        return gatheredInBlock;
    }

    protected PTCommonScatterResponse.ScatterAxis fromBlock(BlockTmpData block) {
        PTCommonScatterResponse.ScatterAxis axis = new PTCommonScatterResponse.ScatterAxis();
        axis.type = block.type;
        switch (block.type) {
            case ALPHANUM: {
                axis.str = block.strBuilder.build();
                break;
            }
            case DATE: {
                if (block.dateMode == Unaggregated.DateMode.RANGE) {
                    axis.ts = block.longBuilder.build();
                    break;
                }
                axis.str = block.strBuilder.build();
                break;
            }
            case NUMERICAL: {
                axis.num = block.dblBuilder.build();
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new Error("unreachable");
            }
        }
        return axis;
    }

    public static class BlockTmpData {
        public AxisDef.Type type;
        IndexedDataListBuilder strBuilder;
        DoubleDataListBuilder dblBuilder;
        LongDataListBuilder longBuilder;
        Unaggregated.DateMode dateMode;
    }
}

