/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.scatter;

import com.dataiku.dip.PivotAllFilteredOutException;
import com.dataiku.dip.charts.ScatterSettings;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.IndexedDataList;
import com.dataiku.dip.pivot.backend.dss.scatter.AbstractScatterBuilder;
import com.dataiku.dip.pivot.backend.dss.scatter.PreparedAxisPair;
import com.dataiku.dip.pivot.backend.dss.scatter.UnaggregatedDateHelper;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisDefPair;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.Unaggregated;
import com.dataiku.dip.pivot.backend.model.scatter.AbstractPTScatterRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTCommonScatterResponse;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterMultiplePairsRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterMultiplePairsResponse;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterRequest;
import com.dataiku.dip.pivot.backend.model.scatter.PTScatterResponse;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

public class ScatterBuilder
extends AbstractScatterBuilder {
    private AbstractPTScatterRequest request;
    private final ScatterSettings scatterSettings = new ScatterSettings();
    private final List<PreparedAxisPair> preparedAxesPairs = new ArrayList<PreparedAxisPair>();
    private int[] gatheredForPairs;
    private int[] beforeFilterRecords;
    private int finishedPoints;
    public List<AxisDefPair> axisPairs;
    public List<Unaggregated> columns;
    private boolean multiple = true;
    private final UnaggregatedDateHelper dateHelper = new UnaggregatedDateHelper();

    public ScatterBuilder(PTScatterRequest request) {
        AxisDefPair pair = new AxisDefPair();
        pair.xAxis = request.xAxis;
        pair.yAxis = request.yAxis;
        this.multiple = false;
        this.initialize(request, Collections.singletonList(pair));
    }

    public ScatterBuilder(PTScatterMultiplePairsRequest request) {
        this.initialize(request, request.axisPairs);
    }

    private void initialize(AbstractPTScatterRequest request, List<AxisDefPair> axisPairs) {
        this.request = request;
        this.columns = request.columns;
        this.filtered = request.isFiltered();
        this.axisPairs = axisPairs;
        this.gatheredForPairs = new int[this.axisPairs.size()];
        this.beforeFilterRecords = new int[this.axisPairs.size()];
        Arrays.fill(this.gatheredForPairs, 0);
        Arrays.fill(this.beforeFilterRecords, 0);
    }

    public PivotTableResponse buildFromLino(LinoReader linoReader) throws Exception {
        int maxRows = (int)Math.min(this.scatterSettings.maxNbOfRecords, (double)this.request.maxRows);
        this.outputRows = linoReader.nbRecords() * (long)this.axisPairs.size() <= (long)maxRows ? (int)linoReader.nbRecords() : maxRows / this.axisPairs.size();
        logger.info((Object)("Will build scatter on " + this.outputRows + " rows"));
        this.buildLinoFilters(this.request, linoReader);
        for (int i = 0; i < this.axisPairs.size(); ++i) {
            this.preparedAxesPairs.add(new PreparedAxisPair());
            AbstractScatterBuilder.BlockTmpData xAxis = new AbstractScatterBuilder.BlockTmpData();
            xAxis.type = this.axisPairs.get((int)i).xAxis.type;
            xAxis.dateMode = this.axisPairs.get((int)i).xAxis.dateMode;
            AbstractScatterBuilder.BlockTmpData yAxis = new AbstractScatterBuilder.BlockTmpData();
            yAxis.type = this.axisPairs.get((int)i).yAxis.type;
            yAxis.dateMode = this.axisPairs.get((int)i).yAxis.dateMode;
            this.initAxis(xAxis);
            this.initAxis(yAxis);
            this.preparedAxesPairs.get((int)i).x = xAxis;
            this.preparedAxesPairs.get((int)i).y = yAxis;
            for (Unaggregated column : this.columns) {
                AbstractScatterBuilder.BlockTmpData data = new AbstractScatterBuilder.BlockTmpData();
                data.type = column.type;
                data.dateMode = column.dateMode;
                this.initAxis(data);
                this.preparedAxesPairs.get((int)i).values.add(data);
            }
        }
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
            if (this.finishedPoints == this.outputRows * this.axisPairs.size()) continue;
            int i = 0;
            while (i < this.axisPairs.size()) {
                ColumnBlock xBlock = linoReader.readColumnBlock(this.axisPairs.get((int)i).xAxis.column, blockIdx);
                boolean[] filters = new boolean[xBlock.nbRecords()];
                if (this.filtered) {
                    this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
                } else {
                    Arrays.fill(filters, true);
                }
                logger.info((Object)("Handle block " + blockIdx + " with " + xBlock.nbRecords()));
                this.filterNAOnBlock(xBlock, this.preparedAxesPairs.get((int)i).x, filters);
                this.filterNAOnBlock(linoReader, this.axisPairs.get((int)i).yAxis.column, this.preparedAxesPairs.get((int)i).y, filters, blockIdx);
                for (int j = 0; j < this.columns.size(); ++j) {
                    if (this.columns.get((int)j).id.startsWith("tooltip")) continue;
                    this.filterNAOnBlock(linoReader, this.columns.get((int)j).column, this.preparedAxesPairs.get((int)i).values.get(j), filters, blockIdx);
                }
                GatheredBlockMeta res = this.gatherDataBlock(xBlock, this.preparedAxesPairs.get((int)i).x, filters, this.outputRows - this.gatheredForPairs[i]);
                this.gatherDataBlock(linoReader, this.axisPairs.get((int)i).yAxis.column, this.preparedAxesPairs.get((int)i).y, blockIdx, filters, this.outputRows - this.gatheredForPairs[i]);
                for (int j = 0; j < this.columns.size(); ++j) {
                    this.gatherDataBlock(linoReader, this.columns.get((int)j).column, this.preparedAxesPairs.get((int)i).values.get(j), blockIdx, filters, this.outputRows - this.gatheredForPairs[i]);
                }
                int n = i;
                this.gatheredForPairs[n] = this.gatheredForPairs[n] + res.gatheredInBlock;
                int n2 = i++;
                this.beforeFilterRecords[n2] = this.beforeFilterRecords[n2] + res.beforeFilterRecords;
            }
            this.finishedPoints = Arrays.stream(this.gatheredForPairs).sum();
        }
        if (this.finishedPoints == 0) {
            throw new PivotAllFilteredOutException();
        }
        return this.buildResponse();
    }

    private PivotTableResponse buildResponse() throws JSONException {
        logger.info((Object)"End of accumulation phase, build the response");
        PTCommonScatterResponse resp = this.multiple ? new PTScatterMultiplePairsResponse() : new PTScatterResponse();
        for (int i = 0; i < this.preparedAxesPairs.size(); ++i) {
            PTCommonScatterResponse.ScatterAxis xAxis = this.fromBlock(this.preparedAxesPairs.get((int)i).x);
            PTCommonScatterResponse.ScatterAxis yAxis = this.fromBlock(this.preparedAxesPairs.get((int)i).y);
            if (xAxis.type == AxisDef.Type.ALPHANUM && this.axisPairs.get((int)i).xAxis.sortPrune != null) {
                this.sortAxis(this.axisPairs.get((int)i).xAxis, xAxis.str);
            }
            if (yAxis.type == AxisDef.Type.ALPHANUM && this.axisPairs.get((int)i).yAxis.sortPrune != null) {
                this.sortAxis(this.axisPairs.get((int)i).yAxis, yAxis.str);
            }
            HashMap<String, PTCommonScatterResponse.ScatterAxis> values = new HashMap<String, PTCommonScatterResponse.ScatterAxis>();
            for (int j = 0; j < this.columns.size(); ++j) {
                values.put(this.columns.get((int)j).id, this.fromBlock(this.preparedAxesPairs.get((int)i).values.get(j)));
            }
            if (this.multiple) {
                assert (resp instanceof PTScatterMultiplePairsResponse);
                ((PTScatterMultiplePairsResponse)resp).axesPairs.add(new PTScatterMultiplePairsResponse.ScatterAxisPair(xAxis, yAxis, values, this.gatheredForPairs[i]));
                continue;
            }
            assert (resp instanceof PTScatterResponse);
            ((PTScatterResponse)resp).xAxis = xAxis;
            ((PTScatterResponse)resp).yAxis = yAxis;
            ((PTScatterResponse)resp).values = values;
        }
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        resp.setRecordCounts(Arrays.stream(this.beforeFilterRecords).max().orElse(this.finishedPoints), Arrays.stream(this.gatheredForPairs).max().orElse(this.finishedPoints));
        return resp;
    }

    public GatheredBlockMeta gatherDataBlock(ColumnBlock block, AbstractScatterBuilder.BlockTmpData data, boolean[] filters, int toGather) throws IOException {
        GatheredBlockMeta res = new GatheredBlockMeta();
        for (int i = 0; i < block.nbRecords() && res.gatheredInBlock < toGather; ++i) {
            ++res.beforeFilterRecords;
            if (!filters[i]) continue;
            switch (data.type) {
                case ALPHANUM: {
                    data.strBuilder.addData(block.getAsStringSlow(i));
                    break;
                }
                case DATE: {
                    if (data.dateMode == Unaggregated.DateMode.RANGE) {
                        data.longBuilder.add((long)block.doubles[i]);
                        break;
                    }
                    data.strBuilder.addData(this.dateHelper.getValue((long)block.doubles[i], data.dateMode));
                    break;
                }
                case NUMERICAL: {
                    data.dblBuilder.add(block.doubles[i]);
                    break;
                }
                case GEOMETRY: 
                case GEOPOINT: {
                    throw new IllegalArgumentException("A column of type POINT or GEOMETRY can not be used for this kind of chart");
                }
            }
            ++res.gatheredInBlock;
        }
        logger.info((Object)("End of block, was remaining = " + toGather + " gathered " + res.gatheredInBlock));
        return res;
    }

    public void gatherDataBlock(LinoReader linoReader, String column, AbstractScatterBuilder.BlockTmpData data, int blockIdx, boolean[] filters, int toGather) throws IOException {
        if (toGather <= 0) {
            return;
        }
        this.gatherDataBlock(linoReader.readColumnBlock(column, blockIdx), data, filters, toGather);
    }

    public void sortAxis(AxisDef def, IndexedDataList idl) {
        assert (def.type == AxisDef.Type.ALPHANUM);
        ArrayList toSort = Lists.newArrayList(idl.sortedMapping);
        logger.info((Object)("Sorting AXIS BY " + String.valueOf((Object)def.sortPrune.sortType)));
        switch (def.sortPrune.sortType) {
            case AGGREGATION: {
                throw new Error("unreachable");
            }
            case COUNT: {
                toSort.sort((o1, o2) -> -Integer.compare(o1.count, o2.count));
                break;
            }
            case NATURAL: {
                toSort.sort(Comparator.comparing(o -> o.label));
                break;
            }
        }
        for (int i = 0; i < toSort.size(); ++i) {
            ((IndexedDataList.Entry)toSort.get((int)i)).sortOrder = i;
        }
    }

    public static class GatheredBlockMeta {
        public int gatheredInBlock = 0;
        public int beforeFilterRecords = 0;
    }
}

