/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.utils.ErrorContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class BasicStatsBuilder {
    public BasicStats parseResponse(BasicStatsToSQL.BasicStatsQueryContext plan, ResultSet rs2) throws SQLException {
        BasicStats stats = new BasicStats();
        stats.columnStats = new HashMap<String, ColStats>();
        for (String string : plan.fields.keySet()) {
            ColStats colStat = new ColStats();
            colStat.minValue = Double.NaN;
            colStat.maxValue = Double.NaN;
            colStat.type = plan.fields.get((Object)string).type;
            stats.columnStats.put(string, colStat);
        }
        while (rs2.next()) {
            long cnt = rs2.getLong(plan.countRef.index);
            if (plan.filterPredRef == null || rs2.getBoolean(plan.filterPredRef.index)) {
                stats.totalAfterFiltering += cnt;
                for (Map.Entry entry : plan.fields.entrySet()) {
                    ColStats colStat = stats.columnStats.get(entry.getKey());
                    colStat.minValue = rs2.getDouble(((BasicStatsToSQL.FieldStatMapping)entry.getValue()).min.index);
                    colStat.maxValue = rs2.getDouble(((BasicStatsToSQL.FieldStatMapping)entry.getValue()).max.index);
                    colStat.approxCount = (int)((long)colStat.approxCount + cnt);
                }
            }
            stats.totalBeforeFiltering += cnt;
        }
        ResponseValidator.validateRecordsCount(stats.totalBeforeFiltering, stats.totalAfterFiltering);
        for (Map.Entry entry : stats.columnStats.entrySet()) {
            ColStats cs2 = (ColStats)entry.getValue();
            if (!Double.isInfinite(cs2.maxValue) && !Double.isNaN(cs2.maxValue) && !Double.isInfinite(cs2.minValue) && !Double.isNaN(cs2.minValue)) continue;
            throw ErrorContext.iae((String)("Unable to build a chart: The min/max values of the column " + (String)entry.getKey() + " are invalid."));
        }
        return stats;
    }

    public static class BasicStats {
        public Map<String, ColStats> columnStats;
        public long totalBeforeFiltering;
        public long totalAfterFiltering;
    }

    public static class ColStats {
        public double minValue;
        public double maxValue;
        public int approxCount;
        public AxisDef.Type type;
    }
}

