/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.sql.binners.BinnerBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SQLTypeSniffer;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.SimpleAxisToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import com.dataiku.dip.sql.DB2SQLDialect;
import com.dataiku.dip.sql.DatabricksSQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class InMemoryResultSet {
    private static DateTimeFormatter TERADATA_TIMESTAMP_PARSER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").withZone(DateTimeZone.UTC);
    private static long MAX_TENSOR_BYTES = DKUApp.getParams().getLongParam("dku.charts.maxTensorBytes", 200000000L);
    public TLongArrayList counts;
    public List<DataTensor<Object>> aggregations;
    public Object[] axes;
    public long count;

    public static InMemoryResultSet parseResultSet(ResultSet rs2, AxisDef[] axisDefs, SimpleAxisToSQL.SelectMapping mapping, InputTable inputTable, SQLDialect dialect) throws SQLException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        int i;
        int i2;
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        int nbAggregations = mapping.aggrRefs.size();
        int nbAxes = axisDefs == null ? 0 : axisDefs.length;
        InMemoryResultSet imrs = new InMemoryResultSet();
        imrs.axes = new Object[nbAxes];
        for (i2 = 0; i2 < nbAxes; ++i2) {
            Class<?> storageType = BinnerBuilder.getStorageType(axisDefs[i2]);
            if (storageType == Long.class) {
                imrs.axes[i2] = new NullableLongArrayList();
                continue;
            }
            if (storageType == Double.class) {
                imrs.axes[i2] = new NullableDoubleArrayList();
                continue;
            }
            if (storageType == String.class) {
                imrs.axes[i2] = new ArrayList();
                continue;
            }
            throw new UnsupportedOperation("Unsupported storage type");
        }
        if (nbAggregations > 0) {
            if (nbAggregations > 1) {
                imrs.aggregations = new ArrayList<DataTensor<Object>>();
                for (i2 = 1; i2 < nbAggregations; ++i2) {
                    if (mapping.aggrRefs.get((int)i2).countOfPrevious) continue;
                    imrs.aggregations.add(new GenericDataTensor.Builder<Object>().clazz(Object.class).build());
                }
            }
            imrs.counts = new TLongArrayList();
        }
        SQLTypeSniffer sniffer = new SQLTypeSniffer(inputTable);
        ResultSetMetaData rsMetaData = rs2.getMetaData();
        ColumnMapper rsMapping = sniffer.buildMapper(rsMetaData);
        HashMap<Integer, ColumnMapper.ExprType> typeMapping = new HashMap<Integer, ColumnMapper.ExprType>();
        HashSet<Integer> hasDateToTimestamp = new HashSet<Integer>();
        HashSet<Integer> hasDatetimeToTimestamp = new HashSet<Integer>();
        for (i = 1; i < nbAggregations; ++i) {
            int idx = mapping.aggrRefs.get((int)i).index;
            String name = rsMetaData.getColumnName(idx);
            ColumnMapper.TypedExpr typedExpr = rsMapping.get(name);
            typeMapping.put(idx, typedExpr.type);
            if (rsMapping.hasComputer(name, SQLTypeSniffer.DateToTimestamp.class)) {
                hasDateToTimestamp.add(idx);
            }
            if (!rsMapping.hasComputer(name, SQLTypeSniffer.DatetimeToTimestamp.class)) continue;
            hasDatetimeToTimestamp.add(idx);
        }
        while (rs2.next()) {
            if (nbAggregations > 0) {
                int currentAggregation = 0;
                long cnt = rs2.getLong(mapping.aggrRefs.get((int)0).index);
                imrs.counts.add(cnt);
                for (int i3 = 1; i3 < mapping.aggrRefs.size(); ++i3) {
                    Object v;
                    SelectQueryBuilder.SelectRef currentRef = mapping.aggrRefs.get(i3);
                    int rsColumn = currentRef.index;
                    ColumnMapper.ExprType rsType = (ColumnMapper.ExprType)((Object)typeMapping.get(rsColumn));
                    if (rsType == ColumnMapper.ExprType.STRING || rsType == ColumnMapper.ExprType.NON_NULL_STRING) {
                        v = rs2.getString(rsColumn);
                    } else if (rsType == ColumnMapper.ExprType.DATE || rsType == ColumnMapper.ExprType.NON_NULL_DATE) {
                        if (inputTable.dialect instanceof TeradataSQLDialect) {
                            String s = DKUtils.isoFormatReadableByDateFormatFromTimestampWithCorrectToString((Timestamp)rs2.getTimestamp(rsColumn, utcCalendar));
                            v = TERADATA_TIMESTAMP_PARSER.parseDateTime(s);
                        } else {
                            String val;
                            v = hasDateToTimestamp.contains(rsColumn) || hasDatetimeToTimestamp.contains(rsColumn) ? (dialect instanceof HiveSQLDialect && !(dialect instanceof PrestoSQLDialect) || dialect instanceof ImpalaSQLDialect ? (hasDateToTimestamp.contains(rsColumn) ? new DateTime((Object)rs2.getDate(rsColumn)) : new DateTime((Object)rs2.getTimestamp(rsColumn))) : (dialect instanceof TrinoSQLDialect ? (hasDateToTimestamp.contains(rsColumn) ? new DateTime((Object)rs2.getDate(rsColumn, utcCalendar)) : (hasDatetimeToTimestamp.contains(rsColumn) ? new DateTime((Object)rs2.getTimestamp(rsColumn, utcCalendar)) : new DateTime((Object)rs2.getTimestamp(rsColumn)))) : new DateTime((Object)rs2.getTimestamp(rsColumn, utcCalendar)))) : (dialect instanceof PrestoSQLDialect && rsMetaData.getColumnType(rsColumn) == 12 ? ((val = rs2.getString(rsColumn)) == null ? null : ((PrestoSQLDialect)dialect).readTimestampWithTimeZoneStringAsDateTime(val)) : (dialect instanceof DB2SQLDialect ? new DateTime((Object)rs2.getTimestamp(rsColumn, utcCalendar)) : (dialect instanceof DatabricksSQLDialect ? new DateTime((Object)rs2.getTimestamp(rsColumn, utcCalendar)) : new DateTime((Object)rs2.getTimestamp(rsColumn)))));
                        }
                    } else {
                        v = rs2.getDouble(rsColumn);
                    }
                    if (rs2.wasNull()) {
                        v = null;
                    }
                    if (currentRef.countOfPrevious) {
                        imrs.aggregations.get(currentAggregation - 1).addNonNullCount(rs2.getLong(rsColumn));
                        continue;
                    }
                    imrs.aggregations.get(currentAggregation++).add(v, true);
                }
            }
            for (i = 0; i < nbAxes; ++i) {
                int rawValueIdx = mapping.axisRefs.get((int)i).index;
                if (imrs.axes[i] instanceof NullableLongArrayList) {
                    Long lv = rs2.getLong(rawValueIdx);
                    if (rs2.wasNull()) {
                        lv = null;
                    }
                    ((NullableLongArrayList)((Object)imrs.axes[i])).addNullable(lv);
                    continue;
                }
                if (imrs.axes[i] instanceof NullableDoubleArrayList) {
                    Double dv = rs2.getDouble(rawValueIdx);
                    if (rs2.wasNull()) {
                        dv = null;
                    }
                    ((NullableDoubleArrayList)((Object)imrs.axes[i])).addNullable(dv);
                    continue;
                }
                if (!(imrs.axes[i] instanceof ArrayList)) continue;
                ((ArrayList)imrs.axes[i]).add(rs2.getString(rawValueIdx));
            }
            ++imrs.count;
            if (imrs.count % 5000L != 0L) continue;
            imrs.checkMemoryUsage();
        }
        return imrs;
    }

    private void checkMemoryUsage() throws BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        long footprint = 0L;
        if (this.axes != null) {
            for (Object axis : this.axes) {
                if (axis instanceof NullableLongArrayList) {
                    footprint += (long)(8 * ((NullableLongArrayList)((Object)axis)).size());
                    continue;
                }
                if (axis instanceof NullableDoubleArrayList) {
                    footprint += (long)(8 * ((NullableDoubleArrayList)((Object)axis)).size());
                    continue;
                }
                if (!(axis instanceof ArrayList)) continue;
                for (Object v : (ArrayList)axis) {
                    if (!(v instanceof String)) continue;
                    footprint += (long)(8 + 2 * ((String)v).length());
                }
            }
        }
        if (this.aggregations != null) {
            for (DataTensor dataTensor : this.aggregations) {
                footprint += (long)(32 * dataTensor.tensorSize);
            }
        }
        if (footprint > MAX_TENSOR_BYTES) {
            throw new BinsAndTensorsSafetyChecks.MemoryLimitExceededException("Chart computation memory limit reached: " + footprint + " > " + MAX_TENSOR_BYTES);
        }
    }

    private InMemoryResultSet() {
    }

    public InMemoryResultSet(InMemoryResultSet imrs) {
        if (imrs.aggregations != null) {
            this.aggregations = new ArrayList<DataTensor<Object>>();
            this.aggregations.addAll(imrs.aggregations);
        }
        this.count = imrs.count;
        if (imrs.counts != null) {
            this.counts = new TLongArrayList((TLongCollection)imrs.counts);
        }
        this.axes = new Object[imrs.axes.length];
        for (int i = 0; i < this.axes.length; ++i) {
            Object axis = imrs.axes[i];
            if (axis instanceof NullableDoubleArrayList) {
                this.axes[i] = new NullableDoubleArrayList((NullableDoubleArrayList)((Object)axis));
                continue;
            }
            if (axis instanceof NullableLongArrayList) {
                this.axes[i] = new NullableLongArrayList((NullableLongArrayList)((Object)axis));
                continue;
            }
            if (axis instanceof ArrayList) {
                this.axes[i] = new ArrayList((ArrayList)axis);
                continue;
            }
            throw new RuntimeException("Unreachable");
        }
    }
}

