/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.sql.SQLPivotListener;
import com.dataiku.dip.pivot.backend.sql.cache.CacheContext;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SynapseSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutionContext
implements AutoCloseable {
    public final InputTable input;
    public final ConnectionPool sqlPool;
    public final PivotTableAggregatedRequest req;
    public final ExecutorService threadPool;
    public final CacheContext cache;
    public final SQLPivotListener listener;
    public final boolean singleThreadExecution;
    private boolean closed = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.context");

    public ExecutionContext(CacheContext cache, InputTable input, PivotTableAggregatedRequest req, SQLPivotListener listener, AuthCtx authCtx) throws IOException {
        String useUTC = input.dialect.useUTCTimezone();
        ConnectionPool.InitQueriesPreparation preparation = input.dialect instanceof SynapseSQLDialect ? new ConnectionPool.SynapsePreparation(new String[]{useUTC}) : (input.dialect instanceof SQLServerSQLDialect ? new ConnectionPool.InitQueriesPreparation(new String[]{useUTC, "SET DATEFIRST 1"}) : new ConnectionPool.InitQueriesPreparation(new String[]{useUTC}));
        boolean disableConnectionPooling = false;
        this.input = input;
        this.req = req;
        this.singleThreadExecution = false;
        if (this.singleThreadExecution) {
            logger.info((Object)"Using single-thread execution for charts");
            this.threadPool = Executors.newSingleThreadExecutor(runnable -> {
                long originalStart = DKULogger.getCurrentStartOrNow();
                Runnable wrapped = () -> {
                    DKULogger.startCurrentCallWithExplicitStartTime((long)originalStart);
                    runnable.run();
                };
                return new Thread(wrapped, Thread.currentThread().getName() + "-SingleExecutor");
            });
        } else {
            AtomicLong count = new AtomicLong(0L);
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                long originalStart = DKULogger.getCurrentStartOrNow();
                Runnable wrapped = () -> {
                    DKULogger.startCurrentCallWithExplicitStartTime((long)originalStart);
                    runnable.run();
                };
                return new Thread(wrapped, Thread.currentThread().getName() + "-Executor-" + count.incrementAndGet());
            });
        }
        this.sqlPool = new ConnectionPool(input.connection, preparation, disableConnectionPooling, authCtx, input.projectKey);
        this.cache = cache;
        this.listener = new SynchronizedListener(listener);
    }

    @Override
    public synchronized void close() {
        logger.debug((Object)"Closing SQL chart ExecutionContext");
        if (!this.closed) {
            this.closed = true;
            ExecutionContext.shutdownAndAwaitTermination(this.threadPool);
            this.sqlPool.close();
        }
    }

    public synchronized void cancel() {
        if (!this.closed) {
            this.closed = true;
            Thread t = new Thread(){

                @Override
                public void run() {
                    ExecutionContext.this.threadPool.shutdown();
                    ExecutionContext.this.threadPool.shutdownNow();
                    try {
                        ExecutionContext.this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        ExecutionContext.this.sqlPool.close();
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    private static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static class SynchronizedListener
    implements SQLPivotListener {
        private final SQLPivotListener listener;

        public SynchronizedListener(SQLPivotListener listener) {
            this.listener = listener;
        }

        @Override
        public synchronized void facetProgress(int facetId, SQLPivotListener.FacetStatus status) throws InterruptedException {
            if (this.listener != null) {
                this.listener.facetProgress(facetId, status);
            }
        }

        @Override
        public synchronized void pivotProgress(SQLPivotListener.PivotStatus status) throws InterruptedException {
            if (this.listener != null) {
                this.listener.pivotProgress(status);
            }
        }
    }
}

