/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.GlobalStatsSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class GlobalStatsHybridExecutor
implements Callable<BasicStatsBuilder.BasicStats> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.global_stats");
    private final Future<ColumnMapper> colMappingFuture;
    private final ExecutionContext ctx;

    public GlobalStatsHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture) {
        this.colMappingFuture = colMappingFuture;
        this.ctx = ctx;
    }

    @Override
    public BasicStatsBuilder.BasicStats call() throws Exception {
        logger.debug((Object)"Starting task: Global stats");
        try {
            BasicStatsBuilder.BasicStats basicStats;
            block18: {
                BasicStatsBuilder.BasicStats stats;
                FutureProgress.AutocloseableFutureProgressState state;
                block16: {
                    BasicStatsBuilder.BasicStats basicStats2;
                    block17: {
                        ArrayList<String> bsCols;
                        block14: {
                            BasicStatsBuilder.BasicStats basicStats3;
                            block15: {
                                state = FutureProgress.pushAutoCloseableState((String)"Computing global column statistics...");
                                try {
                                    bsCols = new ArrayList<String>();
                                    for (AxisDef axisDef : BasicStatsToSQL.determineDependentColumns(this.ctx.req, true)) {
                                        bsCols.add(axisDef.column);
                                    }
                                    stats = this.ctx.cache.columnsStatsCache.get(bsCols);
                                    if (stats == null) break block14;
                                    logger.info((Object)"Computed global column stats from cache");
                                    basicStats3 = stats;
                                    if (state == null) break block15;
                                }
                                catch (Throwable throwable) {
                                    if (state != null) {
                                        try {
                                            state.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                state.close();
                            }
                            return basicStats3;
                        }
                        if (!bsCols.isEmpty()) break block16;
                        basicStats2 = null;
                        if (state == null) break block17;
                        state.close();
                    }
                    return basicStats2;
                }
                GlobalStatsSQLExecutor globalStatsSQLExecutor = new GlobalStatsSQLExecutor(this.ctx, this.colMappingFuture);
                stats = globalStatsSQLExecutor.call();
                this.ctx.cache.columnsStatsCache.put(stats);
                basicStats = stats;
                if (state == null) break block18;
                state.close();
            }
            return basicStats;
        }
        finally {
            logger.debug((Object)"Done task: Global stats");
        }
    }
}

