/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.queries.AggregateToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.AxisMaterializerToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.BinningToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.FilterToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.TensorToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.PartitionUtils;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SimpleAxisToSQL {
    private InputTable input;
    private AxisDef axis;
    private PivotTableAggregatedRequest req;
    private boolean storeAggregates = true;
    private boolean generateAliasForAxis = true;
    private BasicStatsBuilder.BasicStats stats;
    private ColumnMapper colMapping;
    private SQLDialect dialect;
    private boolean forceVarcharCast = false;
    private static ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();

    public SimpleAxisToSQL(InputTable input, PivotTableAggregatedRequest req, AxisDef axis, BasicStatsBuilder.BasicStats stats, ColumnMapper colMapping) {
        this.input = input;
        this.stats = stats;
        this.axis = axis;
        this.dialect = input.dialect;
        this.req = req;
        this.colMapping = colMapping;
    }

    public void setComputeAggregate(boolean storeAggregates) {
        this.storeAggregates = storeAggregates;
    }

    public void setGenerateAliasForAxis(boolean generateAliasForAxis) {
        this.generateAliasForAxis = generateAliasForAxis;
    }

    public void setForceVarcharCast(boolean forceVarcharCast) {
        this.forceVarcharCast = forceVarcharCast;
    }

    public static boolean requireJoin(AxisMaterializerToSQL.MaterializedAxis matAxis, InMemoryResultSet rs2) {
        if (matAxis == null || rs2 == null) {
            return false;
        }
        if (!matAxis.mayRequireJoin) {
            return false;
        }
        return TensorToSQL.requireJoin(matAxis.axis.def, rs2);
    }

    public AxisQueryContext buildAxis(AxisMaterializerToSQL.MaterializedAxis materializedAxis, InMemoryResultSet imrs, BasicStatsBuilder.BasicStats globalStats) {
        AxisQueryContext sqlAxis = new AxisQueryContext();
        sqlAxis.computedWithAggregates = this.storeAggregates;
        sqlAxis.def = this.axis;
        sqlAxis.query = new SelectQueryBuilder(this.dialect);
        AggregateToSQL aggregator = new AggregateToSQL(this.colMapping, this.dialect, this.input.projectKey);
        FilterToSQL filter = new FilterToSQL(this.input.dialect, this.colMapping, globalStats);
        if (this.storeAggregates) {
            sqlAxis.mapping.aggrRefs = aggregator.deduplicateAndAddToQuery(this.req.aggregations, (aggregation, alias) -> sqlAxis.query.select(aggregator.aggregateExpr(aggregation), alias));
        }
        sqlAxis.query.fromTable(this.input.table);
        filter.filterQuery(sqlAxis.query, (List<RowFilter>)this.req.filters);
        if (this.req.type != PivotTableRequest.RequestType.NO_PIVOT_AGGREGATED) {
            this.withAxis(materializedAxis, imrs, sqlAxis, aggregator);
        }
        PartitionUtils.appendPartitionFilteringClause(this.input, sqlAxis.query);
        return sqlAxis;
    }

    private void withAxis(AxisMaterializerToSQL.MaterializedAxis materializedAxis, InMemoryResultSet imrs, AxisQueryContext sqlAxis, AggregateToSQL aggregator) {
        SelectQueryBuilder.SelectRef axisRef;
        String axisIdentifier;
        boolean join = SimpleAxisToSQL.requireJoin(materializedAxis, imrs);
        BinningToSQL binToSQL = new BinningToSQL(this.dialect, this.colMapping);
        String string = axisIdentifier = this.generateAliasForAxis ? QueryUtils.safeRandomIdentifier("dku_axis_") : null;
        if (join) {
            axisRef = sqlAxis.query.select(this.dialect.getQuotedTableFullName(materializedAxis.tempTableTable) + "." + this.dialect.quoteIdentifier(materializedAxis.axis.mapping.axisRefs.get((int)0).name));
        } else {
            ColumnMapper.TypedExpr sqlExpr = this.colMapping.get(this.axis.column);
            sqlExpr = binToSQL.binningExpression(sqlExpr, this.axis, this.stats);
            if (this.forceVarcharCast) {
                sqlExpr.expr = this.dialect.convertToVarchar(sqlExpr.expr, 512);
            }
            axisRef = sqlAxis.query.select(sqlExpr.expr, axisIdentifier);
        }
        sqlAxis.mapping.axisRefs.add(axisRef);
        sqlAxis.query.group(axisRef);
        String tableName = this.getInputTableName();
        if (this.axis.sortPrune.sortType == AxisSortPrune.SortType.AGGREGATION) {
            if (this.storeAggregates) {
                if (this.axis.sortPrune.aggregationSortId >= 0 && this.axis.sortPrune.aggregationSortId < this.req.aggregations.size()) {
                    SelectQueryBuilder.SelectRef ref = sqlAxis.mapping.aggrRefs.get(this.computeCorrectIndexForRef(this.req.aggregations, this.axis.sortPrune.aggregationSortId));
                    sqlAxis.query.orderBy(ref, this.axis.sortPrune.sortAscending);
                    ordering = new AxisQueryContext.AxisOrdering();
                    ordering.columnName = ref.name;
                    ordering.asc = this.axis.sortPrune.sortAscending;
                    sqlAxis.order.add(ordering);
                }
            } else if (this.axis.sortPrune.aggregationSortId >= 0 && this.axis.sortPrune.aggregationSortId < this.req.aggregations.size()) {
                Aggregation aggr = this.req.aggregations.get(this.axis.sortPrune.aggregationSortId);
                String alias = QueryUtils.safeRandomIdentifier("dku_aggr2_");
                SelectQueryBuilder.SelectRef aggrRef = sqlAxis.query.select(aggregator.aggregateExpr(aggr), alias);
                sqlAxis.query.orderBy(aggrRef, this.axis.sortPrune.sortAscending);
                AxisQueryContext.AxisOrdering ordering = new AxisQueryContext.AxisOrdering();
                ordering.columnName = aggrRef.name;
                ordering.asc = this.axis.sortPrune.sortAscending;
                sqlAxis.order.add(ordering);
            }
        } else if (this.axis.sortPrune.sortType == AxisSortPrune.SortType.NATURAL) {
            String dedicatedSortExpr = binToSQL.sortingExpression(this.dialect.quoteIdentifier(this.axis.column), this.axis);
            if (dedicatedSortExpr == null) {
                ordering = new AxisQueryContext.AxisOrdering();
                if (this.axis.type == AxisDef.Type.ALPHANUM && !(this.dialect instanceof OracleSQLDialect)) {
                    String groupExpression = this.dialect.hasAccessToAliasInOrderByCaseStatement() && StringUtils.isNotBlank((String)axisRef.name) ? this.dialect.quoteIdentifier(axisRef.name) : axisRef.expr;
                    sqlAxis.query.orderBy(ExpressionUtils.ef.caseWhen(ExpressionUtils.ef.expr(groupExpression).eq("___dku_no_value___"), ExpressionUtils.ef.cst(0), ExpressionUtils.ef.cst(1)).toSQL(this.dialect), true);
                    ordering.needCaseWhen = true;
                }
                sqlAxis.query.orderBy(axisRef, true);
                ordering.columnName = axisRef.name;
                ordering.asc = true;
                sqlAxis.order.add(ordering);
            } else {
                sqlAxis.query.orderBy(dedicatedSortExpr, true);
            }
        } else if (this.axis.sortPrune.sortType == AxisSortPrune.SortType.CUSTOM && this.axis.sortPrune.customSortingValues != null && !this.axis.sortPrune.customSortingValues.isEmpty()) {
            ArrayList<ExpressionBuilder> caseArgs = new ArrayList<ExpressionBuilder>();
            String groupExpression = this.dialect.hasAccessToAliasInOrderByCaseStatement() && StringUtils.isNotBlank((String)axisRef.name) ? this.dialect.quoteIdentifier(axisRef.name) : axisRef.expr;
            for (int i = 0; i < this.axis.sortPrune.customSortingValues.size(); ++i) {
                String val = this.axis.sortPrune.customSortingValues.get(i);
                if ("___dku_no_value___".equals(val)) {
                    caseArgs.add(ExpressionUtils.ef.expr(groupExpression).eq("___dku_no_value___").or(ExpressionUtils.ef.expr(groupExpression).isNullOrEmptyString()));
                } else {
                    caseArgs.add(ExpressionUtils.ef.expr(groupExpression).eq(ExpressionUtils.ef.cst(val)));
                }
                caseArgs.add(ExpressionUtils.ef.cst(i));
            }
            caseArgs.add(ExpressionUtils.ef.cst(this.axis.sortPrune.customSortingValues.size()));
            sqlAxis.query.orderBy(ExpressionUtils.ef.caseWhen(caseArgs.toArray()).toSQL(this.dialect), true);
        } else if (this.axis.sortPrune.sortType == AxisSortPrune.SortType.ORIGINAL) {
            String cteName = "original_table_without_order";
            String dkuRowOrderAlias = "dku_row_order";
            String dkuOrderAlias = "dku_order";
            com.dataiku.dip.sql.queries.SelectQueryBuilder withClause = new com.dataiku.dip.sql.queries.SelectQueryBuilder();
            ArrayList<ExpressionBuilder> orderExpressions = new ArrayList<ExpressionBuilder>();
            orderExpressions.add(ebf.cst(1));
            QueryAst.Window window = com.dataiku.dip.sql.queries.SelectQueryBuilder.window(null, orderExpressions, null);
            withClause.select(ebf.col(cteName, "*"));
            withClause.select(ebf.rowNumber().over(window), dkuRowOrderAlias);
            withClause.from(this.input.table, cteName);
            tableName = "ordered_table_original_order";
            sqlAxis.query.with((Pair<String, String>)new Pair((Object)tableName, (Object)withClause.toSQL(this.dialect)));
            sqlAxis.query.select("MIN(" + this.dialect.quoteIdentifier(dkuRowOrderAlias) + ")", dkuOrderAlias);
            sqlAxis.query.orderBy(this.dialect.quoteIdentifier(dkuOrderAlias), true);
            sqlAxis.query.fromTable(tableName);
        }
        if (join) {
            ColumnMapper.TypedExpr qualifiedAndBinnedColExpr = this.colMapping.get(materializedAxis.axis.def.column, tableName + "." + this.dialect.quoteIdentifier(materializedAxis.axis.def.column));
            String joinCond = binToSQL.binningExpression((ColumnMapper.TypedExpr)qualifiedAndBinnedColExpr, (AxisDef)materializedAxis.axis.def, (BasicStatsBuilder.BasicStats)this.stats).expr + "=" + this.dialect.getQuotedTableFullName(materializedAxis.tempTableTable) + "." + this.dialect.quoteIdentifier(materializedAxis.axis.mapping.axisRefs.get((int)0).name);
            if (materializedAxis.axis.def.sortPrune.generateOthersCategory) {
                sqlAxis.query.join(this.dialect.getQuotedTableFullName(materializedAxis.tempTableTable), null, joinCond, SelectQueryBuilder.JoinExpr.JoinType.LEFT);
            } else {
                sqlAxis.query.join(this.dialect.getQuotedTableFullName(materializedAxis.tempTableTable), null, joinCond, SelectQueryBuilder.JoinExpr.JoinType.INNER);
            }
        } else {
            if ((this.axis.type == AxisDef.Type.ALPHANUM || this.axis.type == AxisDef.Type.NUMERICAL && this.axis.numParams.mode == NumericalAxisParams.BinningMode.NONE) && this.axis.sortPrune.isMaxValuesDefined()) {
                sqlAxis.query.withStrictTop().limit(this.axis.sortPrune.maxValues);
            }
            if (SimpleAxisToSQL.shouldFilterAxisNullValues(this.axis)) {
                sqlAxis.query.where(this.dialect.quoteIdentifier(this.axis.column) + " IS NOT NULL");
            }
        }
    }

    private int computeCorrectIndexForRef(List<Aggregation> aggregations, int aggregationSortId) {
        int correctedIndex = 0;
        for (int i = 0; i < aggregationSortId; ++i) {
            correctedIndex += aggregations.get((int)i).function != Aggregation.Function.CUSTOM ? 2 : 1;
        }
        return correctedIndex + 1;
    }

    private String getInputTableName() {
        if (this.dialect instanceof SparkSQLDialect) {
            return this.dialect.quoteIdentifier(this.input.table.getTable());
        }
        return this.dialect.getQuotedTableFullName(this.input.table);
    }

    public static boolean shouldFilterAxisNullValues(AxisDef def) {
        switch (def.type) {
            case ALPHANUM: {
                return false;
            }
            case DATE: {
                return true;
            }
            case NUMERICAL: {
                return true;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    public static class AxisQueryContext {
        public AxisDef def;
        public SelectQueryBuilder query;
        public List<AxisOrdering> order = new ArrayList<AxisOrdering>();
        public SelectMapping mapping = new SelectMapping();
        public boolean computedWithAggregates;

        public static class AxisOrdering {
            public String columnName;
            public boolean asc;
            public boolean needCaseWhen;
        }
    }

    public static class SelectMapping {
        public List<SelectQueryBuilder.SelectRef> aggrRefs = new ArrayList<SelectQueryBuilder.SelectRef>();
        public List<SelectQueryBuilder.SelectRef> axisRefs = new ArrayList<SelectQueryBuilder.SelectRef>();
    }
}

