/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.charts;

import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;

public class BarChart
extends BaseChart<Series1D> {
    private STBarGrouping.Enum grouping = STBarGrouping.CLUSTERED;

    public void setGrouping(STBarGrouping.Enum grouping) {
        this.grouping = grouping;
    }

    @Override
    public void plot(XDDFChart chart, XDDFChartAxis ... chartAxes) {
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBarChart ctBarChart = plotArea.addNewBarChart();
        ctBarChart.addNewVaryColors().setVal(false);
        CTBarDir dir = ctBarChart.addNewBarDir();
        dir.setVal(STBarDir.COL);
        CTBarGrouping ctgr = ctBarChart.addNewGrouping();
        ctgr.setVal(this.grouping);
        if (this.grouping == STBarGrouping.PERCENT_STACKED || this.grouping == STBarGrouping.STACKED) {
            ctBarChart.addNewOverlap().setVal((Object)100);
        } else {
            ctBarChart.addNewOverlap().setVal((Object)0);
        }
        for (Series1D series : this.getSeries()) {
            CTBarSer barSer = ctBarChart.addNewSer();
            barSer.addNewIdx().setVal((long)series.getId());
            barSer.addNewOrder().setVal((long)series.getId());
            CTShapeProperties spPr = barSer.addNewSpPr();
            CTSolidColorFillProperties scfp = spPr.addNewSolidFill();
            CTSRgbColor rgbColor = scfp.addNewSrgbClr();
            rgbColor.setVal(series.getColor().asByteArray());
            CTSerTx tx = barSer.addNewTx();
            ChartUtils.buildSerTx(tx, series.getTitle());
            CTAxDataSource cats = barSer.addNewCat();
            ChartUtils.buildAxDataSource(cats, series.getLabels());
            CTNumDataSource vals = barSer.addNewVal();
            ChartUtils.buildNumDataSource(vals, series.getXValues());
        }
        for (XDDFChartAxis axis : chartAxes) {
            ctBarChart.addNewAxId().setVal(axis.getId());
        }
    }
}

