/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorMeta;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public class HadoopJythonPluginsHelper {
    private static Logger logger = Logger.getLogger((String)"dku.plugins");

    public static PluginsWithJythonState buildState() {
        CustomJythonProcessorsService ps2 = (CustomJythonProcessorsService)SpringUtils.getBean(CustomJythonProcessorsService.class);
        PluginsWithJythonState pwjs = new PluginsWithJythonState();
        pwjs.steps.addAll(ps2.list());
        return pwjs;
    }

    public static void load(PluginsWithJythonState pjs) {
        for (LoadedJythonProcessor loaded : pjs.steps) {
            try {
                CustomJythonProcessorMeta meta = new CustomJythonProcessorMeta(loaded);
                BaseProcessorsFactory.addBuiltinProcessor(meta);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to initialize plugin step " + JSON.log((Object)loaded)), (Throwable)e);
            }
        }
    }

    public static class PluginsWithJythonState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public List<LoadedJythonProcessor> steps = Lists.newArrayList();
    }
}

