/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleActivationFinishedEvent;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.AliveService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractBundleService {
    private static final Object DELETE_BUNDLE = new Object();
    @Autowired
    protected FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.automation.bundles");

    public BundleActivationTestResult checkBundleActivation(AuthCtx user, String projectKey, String bundleId, boolean forDesignRevert) throws Exception {
        File bundleArchive = this.getBundleArchive(projectKey, bundleId);
        File unzippedBundlePath = new File(bundleArchive.getParentFile().getPath(), "extracted");
        if (!unzippedBundlePath.isDirectory()) {
            DKUFileUtils.mkdirs((File)unzippedBundlePath);
            ZipUnzipDir.extractFolder(bundleArchive, unzippedBundlePath, false);
        }
        BundleActivator activator = new BundleActivator(user, bundleArchive, unzippedBundlePath, projectKey, new BundleActivationOptions());
        return activator.checkActivable(forDesignRevert);
    }

    public BundleActivator.BundleActivationReport activateBundle_NT(AuthCtx user, String projectKey, File bundleArchive, BundleActivationOptions options, DKUtils.SmartLogTailBuilder logTail) throws Exception {
        AliveService aliveService = (AliveService)SpringUtils.getBean(AliveService.class);
        File unzippedBundlePath = new File(bundleArchive.getParentFile().getPath(), "extracted");
        if (!unzippedBundlePath.isDirectory()) {
            DKUFileUtils.mkdirs((File)unzippedBundlePath);
            ZipUnzipDir.extractFolder(bundleArchive, unzippedBundlePath, false);
        }
        BundleActivator activator = new BundleActivator(user, bundleArchive, unzippedBundlePath, projectKey, options);
        boolean isDeploymentUpdate = CommonBundleUtils.hasActiveBundle(projectKey);
        if (isDeploymentUpdate) {
            switch (options.alivePolicyOnUpdate) {
                case INSTANCE: {
                    aliveService.setNotAlive();
                    break;
                }
                case PROJECT: {
                    aliveService.setProjectNotAlive(projectKey);
                    break;
                }
            }
            if (options.updateDelaySec != null) {
                if (options.updateDelaySec > 0) {
                    logger.infoV("Waiting an update delay of %s seconds...", new Object[]{options.updateDelaySec});
                    logTail.appendLine(String.format("Waiting an update delay of %s seconds...", options.updateDelaySec));
                    Thread.sleep(1000L * (long)options.updateDelaySec.intValue());
                } else {
                    logger.info((Object)"The update delay is <= 0 second: will proceed directly to the bundle activation");
                }
            }
        }
        BundleActivator.BundleActivationReport report = activator.run();
        if (isDeploymentUpdate) {
            switch (options.alivePolicyOnUpdate) {
                case INSTANCE: {
                    aliveService.setAlive();
                    break;
                }
                case PROJECT: {
                    aliveService.setProjectAlive(projectKey);
                    break;
                }
            }
        }
        logTail.appendLine("Bundle activation succeeded");
        if (report.neededAMigration) {
            logger.warn((Object)("Bundle needed a migration, removing the extracted folder: " + String.valueOf(unzippedBundlePath)));
            DKUFileUtils.deleteDirectory((File)unzippedBundlePath);
        }
        IReflectedEventsService.ReflectedEvent evt = new IReflectedEventsService.ReflectedEvent("bundle-activate");
        this.pubSub.publish((DSSEvent)new ReflectedEventEvent(evt));
        ProjectBundleActivationFinishedEvent finishedEvt = new ProjectBundleActivationFinishedEvent(projectKey);
        this.pubSub.publish(finishedEvt);
        return report;
    }

    public FutureResponse<BundleActivator.BundleActivationReport> startActivateBundle_NT(AuthCtx user, String projectKey, String bundleId) throws Exception {
        return this.startActivateBundle_NT(user, projectKey, bundleId, new BundleActivationOptions());
    }

    public FutureResponse<BundleActivator.BundleActivationReport> startActivateBundle_NT(AuthCtx user, String projectKey, String bundleId, BundleActivationOptions importOptions) throws Exception {
        BundleActivationFutureThread baft = new BundleActivationFutureThread((DSSAuthCtx)user, projectKey, this.getBundleArchive(projectKey, bundleId), importOptions);
        return this.futureService.runFuture(baft, 0L, new TypeToken<FutureResponse<BundleActivator.BundleActivationReport>>(){});
    }

    public static FuturePayload buildFuturePayload(String projectKey, String bundleName) {
        FuturePayload fp = new FuturePayload();
        fp.action = "activate";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, bundleName, bundleName, "BUNDLE"));
        fp.displayName = "Activate bundle " + projectKey + "/" + bundleName;
        return fp;
    }

    public void deleteBundle(String projectKey, String bundleId) throws Exception {
        File bundleDirectory = this.getBundleDirectory(projectKey, bundleId);
        if (!bundleDirectory.isDirectory()) {
            throw ErrorContext.iaef((String)"Can't find bundle %s in project %s", (Object)bundleId, (Object[])new Object[]{projectKey});
        }
        DKUFileUtils.forceDelete((File)bundleDirectory);
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        GitLocalCommands gitLocalCommands = new GitLocalCommands(gitManager.getSubGit((String)projectKey).git);
        String tag = this.getBundleTag(projectKey, bundleId);
        gitLocalCommands.removeTag(tag);
    }

    public File getBundleArchive(String projectKey, String bundleId) {
        return DKUFileUtils.getWithin((File)this.getBundleDirectory(projectKey, bundleId), (String[])new String[]{this.getBundleTag(projectKey, bundleId) + ".zip"});
    }

    public String getBundleTag(String projectKey, String bundleId) {
        return "dss-bundle-" + projectKey + "-" + bundleId;
    }

    public abstract File getBundleDirectory(String var1, String var2);

    public static class BundleActivationOptions {
        Map<String, Boolean> meaningsToImport;
        public Map<String, Boolean> scenariosActiveOnActivation = new HashMap<String, Boolean>();
        public String setRunAsUser;
        public boolean async;
        public AlivePolicyOnUpdate alivePolicyOnUpdate = AlivePolicyOnUpdate.NONE;
        public Integer updateDelaySec;
        public boolean restartWebApps;
    }

    public static enum AlivePolicyOnUpdate {
        NONE,
        PROJECT,
        INSTANCE;

    }

    public class BundleActivationFutureThread
    extends FutureThread<BundleActivator.BundleActivationReport> {
        private String projectKey;
        private File bundleArchive;
        private BundleActivationOptions activationOptions;
        private BundleActivator.BundleActivationReport result;
        private final FuturePayload futurePayload;
        private final DKUtils.SmartLogTailBuilder logTailBuilder;

        public BundleActivationFutureThread(DSSAuthCtx user, String projectKey, File bundleArchive, BundleActivationOptions activationOptions) {
            super(user);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.projectKey = projectKey;
            this.bundleArchive = bundleArchive;
            this.activationOptions = activationOptions;
            this.futurePayload = AbstractBundleService.buildFuturePayload(projectKey, bundleArchive.getName());
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public BundleActivator.BundleActivationReport getResult() {
            return this.result;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public void execute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Activating bundle");){
                this.result = AbstractBundleService.this.activateBundle_NT(this.owner, this.projectKey, this.bundleArchive, this.activationOptions, this.logTailBuilder);
            }
        }
    }

    public static class BundlePreloadOptions {
        public boolean async;
    }
}

