/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.llm.LLMStructuredRef;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AgentReviewConnectionsUtils {
    private AgentReviewConnectionsUtils() {
    }

    public static Set<String> listConnectionNames(AgentReview agentReview) {
        return agentReview.traits.stream().filter(trait -> trait.llmId != null).map(trait -> LLMStructuredRef.decodeId((String)trait.llmId).connection).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void remapTrait(AgentReviewTrait trait, Map<String, String> replacements) {
        if (trait.llmId == null) {
            return;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(trait.llmId);
        if (ref.connection == null) {
            return;
        }
        String newConnection = replacements.get(ref.connection);
        if (newConnection != null) {
            ref.setConnection(newConnection);
            trait.llmId = ref.encodeToId();
        }
    }

    public static void remapConnections(AgentReview agentReview, Map<String, String> replacements) {
        for (AgentReviewTrait trait : agentReview.traits) {
            AgentReviewConnectionsUtils.remapTrait(trait, replacements);
        }
    }
}

