/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.git.BaseDiffBuilder;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.AutoMigrator;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ConnectionRemapper;
import com.dataiku.dip.projects.importexport.ContainerExecRemapper;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectImportExportUtils;
import com.dataiku.dip.projects.importexport.ProjectImporterBase;
import com.dataiku.dip.projects.importexport.model.ActiveBundleState;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.MeaningsFolderChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleActivatedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.SearchNotebooksService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendRestartThread;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BundleActivator
extends ProjectImporterBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private MeaningsDAO meaningsDAO;
    @Autowired
    private IBasicMeaningsService basicMeaningsService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private SearchNotebooksService searchNotebooksService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private AutomationNodeCodeEnvsService codeEnvsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DataQualitySummaryService dataQualitySummaryService;
    private final File bundleArchive;
    private ProjectRemappingSettings remapping;
    private ExportedProject ep;
    AbstractBundleService.BundleActivationOptions activationOptions;
    boolean checkedAdminIfRunAsOverride = false;
    private ProjectImporterBase.StashedLocalConfig stashedLocalConfig = new ProjectImporterBase.StashedLocalConfig();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.projects.import");

    public BundleActivator(AuthCtx initiator, File bundleArchive, File bundlePath, String projectKey, AbstractBundleService.BundleActivationOptions activationOptions) {
        super(initiator);
        this.targetProjectKey = projectKey;
        this.bundleArchive = bundleArchive;
        this.importSourceDirectory = bundlePath;
        this.activationOptions = activationOptions;
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected void checkAdminIfRunAsOverride() throws UnauthorizedException {
        if (StringUtils.isNotEmpty((String)this.activationOptions.setRunAsUser) && !this.checkedAdminIfRunAsOverride) {
            logger.info((Object)"Import specifies an override of scenarios and webapps runAs user. Checking permissions.");
            if (!(this.authCtx.isAdmin() || null != this.authCtx.getImmediateParent() && this.authCtx.getImmediateParent().isAdmin())) {
                throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
            }
            this.checkedAdminIfRunAsOverride = true;
        }
    }

    public BundleActivationTestResult checkActivable(boolean forDesignRevert) throws Exception {
        BundleActivationTestResult result = new BundleActivationTestResult();
        this.ep = (ExportedProject)JSON.parseFile((File)this.importFile("export-manifest.json"), ExportedProject.class);
        result.bundleId = this.ep.bundleId;
        AutoMigrator migrator = new AutoMigrator(this.importSourceDirectory, this.ep);
        String shouldMigrateFrom = migrator.getMigrateFrom();
        if (shouldMigrateFrom != null) {
            result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_BUNDLE_FROM_PREVIOUS_VERSION, (String)("Bundle was created with DSS: " + shouldMigrateFrom + ". It is recommended to export a new bundle.")));
        }
        this.readAdditionalExportManifest(this.ep, this.importSourceDirectory);
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsLoggedInUser(this.authCtx);){
            SerializedProject projectConfigBefore = this.projectsService.getMandatory(this.targetProjectKey);
            this.remapping = projectConfigBefore.bundleContainerSettings == null ? null : projectConfigBefore.bundleContainerSettings.remapping;
            rwt.deleteDirectory(new RelFile(new String[]{"projects", this.targetProjectKey}));
            this.importWholeConfig();
            if (this.remapping != null) {
                this.checkConnectionsRemapping(result);
                if (this.remapping.enableContainerExecRemapping) {
                    this.checkContainerExecRemapping(result);
                } else {
                    logger.info((Object)"Skipping check of container exec remapping.");
                }
                if (result.messages.size() == 0) {
                    this.executeKnowledgeBankImageFolderRemapping();
                    this.executeConnectionRemapping(result);
                    if (this.remapping.enableContainerExecRemapping) {
                        this.executeContainerExecRemapping();
                    } else {
                        logger.info((Object)"Skipping container exec remapping.");
                    }
                    this.v3CheckConnectionsWritability(this.ep, result);
                }
            }
            Map meaningsBefore = DKUtils.listToMap(this.meaningsDAO.listUnsafe(), (String)"id");
            this.importUserDefinedMeanings();
            for (UserDefinedMeaning meaning : this.meaningsDAO.listUnsafe()) {
                String oldMeaning;
                String newMeaning;
                if (!meaningsBefore.containsKey(meaning.id) || (newMeaning = JSON.prettyAsFile((Object)meaning)).equals(oldMeaning = JSON.prettyAsFile(meaningsBefore.get(meaning.id)))) continue;
                result.messages.add(new UDMConflictWarning(meaning.id, new BaseDiffBuilder().diffStrings(oldMeaning, newMeaning)));
            }
            if (!forDesignRevert) {
                this.checkPlugins(this.ep.exportedWithPlugins, this.targetProjectKey, result);
                this.checkCodeEnvs(this.ep, result, projectConfigBefore.bundleContainerSettings);
                this.checkCodeStudioTemplates(this.ep, result);
            }
            result.messages.addAll(this.checkSavedModelVersions());
            rwt.rollback();
        }
        result.summarize();
        return result;
    }

    private void checkConnectionsRemapping(BundleActivationTestResult result) throws IOException, DKUSecurityException {
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, this.remapping, this.ep);
        for (SerializedDataset serializedDataset : this.datasetsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapDataset(serializedDataset));
        }
        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapStreamingEndpoint(streamingEndpoint));
        }
        for (SavedModel savedModel : this.savedModelsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapSavedModel(this.importSourceDirectory, savedModel));
        }
        for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapNotebook(sQLNotebook));
        }
        for (SearchNotebook searchNotebook : this.searchNotebooksDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapNotebook(searchNotebook));
        }
        for (ManagedFolder managedFolder : this.managedFolderDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapManagedFolder(managedFolder));
        }
        for (SerializedRecipe serializedRecipe : this.recipesDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapRecipe(serializedRecipe));
        }
        for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapScenario(scenario));
        }
        for (LambdaService lambdaService : this.lambdaServicesDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRemapLambdaService(lambdaService));
        }
        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkRetrievableKnowledge(retrievableKnowledge));
        }
        for (PromptStudio promptStudio : this.promptStudioDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkPromptStudio(promptStudio));
        }
        for (AgentReview agentReview : this.agentReviewsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkAgentReview(agentReview));
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(connectionRemapper.checkAgentTool(agentTool));
        }
    }

    private void checkContainerExecRemapping(BundleActivationTestResult result) throws IOException {
        ContainerExecRemapper containerExecRemapper = new ContainerExecRemapper(this.authCtx, this.remapping, this.ep);
        SerializedProject sp = this.projectsService.getMandatory(this.targetProjectKey);
        result.messages.addAll(containerExecRemapper.checkRemapProject(sp));
        for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRemapRecipe(sr));
            result.messages.addAll(containerExecRemapper.checkRemapPayloadRecipe(sr));
        }
        for (JupyterUtils.JupyterNotebookListEntry listEntry : this.jupyterService.listUnsafe(null, this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRemapNotebooks(listEntry, this.targetProjectKey));
        }
        for (WebApp webApp : this.webAppsDAO.listUnsafe(this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRemapWebApp(webApp));
        }
        for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRetrievableKnowledge(rk));
        }
        for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            result.messages.addAll(containerExecRemapper.checkRemapAnalysis(acp));
        }
        for (SavedModel sm : this.savedModelsDAO.listUnsafe(this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRemapSavedModels(sm));
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
            result.messages.addAll(containerExecRemapper.checkRemapAgentTool(agentTool));
        }
    }

    private void checkCodeEnvs(ExportedProject ep, BundleActivationTestResult ret, BundleContainerSettings containerSettings) throws Exception {
        for (CodeEnvModel.UsedCodeEnvRef envRef : ep.usedCodeEnvRefs) {
            this.checkCodeEnv(envRef.envLang, envRef.envName, ret, containerSettings);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkCodeEnv(CodeEnvModel.EnvLang envLang, String envName, BundleActivationTestResult ret, BundleContainerSettings containerSettings) throws Exception {
        try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("check-env-" + String.valueOf((Object)envLang) + "-" + envName));){
            logger.infoV("Checking code env: %s %s", new Object[]{envLang, envName});
            File exportedEnvDir = envLang == CodeEnvModel.EnvLang.PYTHON ? this.importFile("python-envs", envName) : this.importFile("r-envs", envName);
            CodeEnvModel.AutomationEnvRootDef envRootDef = this.codeEnvsService.getEnvRootDefOrNull(envLang, envName);
            if (containerSettings == null) return;
            if (containerSettings.codeEnvsBehavior == null) return;
            if (containerSettings.codeEnvsBehavior.importTimeMode == null) {
                return;
            }
            if (envRootDef != null && envLang == CodeEnvModel.EnvLang.PYTHON) {
                this.checkPythonDeprecated(envName, ret, containerSettings, exportedEnvDir, envRootDef);
            }
            if (envRootDef != null && envRootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                logger.info((Object)"Env already exists in AUTOMATION_VERSIONED mode, checking for bundle link");
                CodeEnvModel.EnvVersionRef evr = AutomationNodeManagedEnvUtils.getNamedBundleLink(envLang, envName, this.targetProjectKey, this.ep.bundleId);
                if (evr != null) {
                    logger.infoV("Found existing link " + JSON.log((Object)evr), new Object[0]);
                    return;
                }
            }
            switch (containerSettings.codeEnvsBehavior.importTimeMode) {
                case DO_NOTHING: {
                    logger.infoV("Do nothing mode, doing nothing", new Object[]{envName});
                    return;
                }
                case FAIL_IF_MISS: 
                case INSTALL_IF_MISS: {
                    if (envRootDef == null) {
                        logger.infoV("Env does not exist at all, failing", new Object[0]);
                        if (containerSettings.codeEnvsBehavior.importTimeMode == BundleContainerSettings.PythonEnvImportTimeMode.FAIL_IF_MISS) {
                            ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName, new Object[0]);
                            return;
                        }
                        ret.withWarningV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName + ". Use the bundle preloading, or manually create it.", new Object[0]);
                        return;
                    }
                    boolean failIfDifferent = containerSettings.codeEnvsBehavior.importTimeMode == BundleContainerSettings.PythonEnvImportTimeMode.FAIL_IF_MISS;
                    this.checkExistingCodeEnv(envLang, envName, ret, containerSettings, exportedEnvDir, envRootDef, failIfDifferent);
                    return;
                }
            }
            return;
        }
    }

    private void checkPythonDeprecated(String envName, BundleActivationTestResult ret, BundleContainerSettings containerSettings, File exportedEnvDir, CodeEnvModel.AutomationEnvRootDef envRootDef) throws IOException {
        CodeEnvModel.PythonEnvDesc pydesc = null;
        switch (envRootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case DSS_INTERNAL: 
            case EXTERNAL_CONDA_NAMED: 
            case PLUGIN_NON_MANAGED: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                break;
            }
            case AUTOMATION_SINGLE: {
                File rootDir = AutomationNodeManagedEnvUtils.getEnvDir(CodeEnvModel.EnvLang.PYTHON, envName);
                pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                break;
            }
            case AUTOMATION_VERSIONED: {
                CodeEnvModel.EnvVersionRef versionRef = this.codeEnvsService.findMatchingEnvVersion(CodeEnvModel.EnvLang.PYTHON, envName, exportedEnvDir, containerSettings.codeEnvsBehavior.envImportSpecificationMode);
                if (versionRef == null) break;
                File rootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                pydesc = AutomationNodeManagedEnvUtils.getEnvDesc(rootDir, CodeEnvModel.PythonEnvDesc.class);
                break;
            }
        }
        if (pydesc != null && pydesc.pythonInterpreter.isDeprecated()) {
            ret.addMessage(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_PYTHON_VERSION_DEPRECATED, (String)("Bundle was created with Python '" + String.valueOf((Object)pydesc.pythonInterpreter) + "' for code env: " + envName + ". '" + String.valueOf((Object)pydesc.pythonInterpreter) + "' is deprecated and will soon be removed")));
        }
    }

    private void checkExistingCodeEnv(CodeEnvModel.EnvLang envLang, String envName, BundleActivationTestResult ret, BundleContainerSettings containerSettings, File exportedEnvDir, CodeEnvModel.AutomationEnvRootDef envRootDef, boolean failIfDifferent) throws Exception, Error {
        switch (envRootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case DSS_INTERNAL: 
            case EXTERNAL_CONDA_NAMED: 
            case PLUGIN_NON_MANAGED: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: {
                break;
            }
            case AUTOMATION_SINGLE: {
                logger.info((Object)"Env is in SINGLE mode: checking if single version matches");
                if (this.codeEnvsService.checkIfNonVersionedCodeEnvMatches(envLang, envName, exportedEnvDir, containerSettings.codeEnvsBehavior.envImportSpecificationMode)) break;
                if (failIfDifferent) {
                    ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName, new Object[0]);
                    break;
                }
                ret.withWarningV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for code env " + envName + ". Use the bundle preloading, or manually update it.", new Object[0]);
                break;
            }
            case AUTOMATION_VERSIONED: {
                logger.info((Object)"Env is in VERSIONED mode: checking if a version matches");
                CodeEnvModel.EnvVersionRef versionRef = this.codeEnvsService.findMatchingEnvVersion(envLang, envName, exportedEnvDir, containerSettings.codeEnvsBehavior.envImportSpecificationMode);
                if (versionRef != null) break;
                if (failIfDifferent) {
                    ret.withFatalV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for py env " + envName, new Object[0]);
                    break;
                }
                ret.withWarningV(BundleCodes.ERR_BUNDLE_PRELOAD_NO_MATCHING_PYENV, "No matching environment for py env " + envName + ". Use the bundle preloading, or manually update it.", new Object[0]);
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new Error("illegal env deployment mode");
            }
        }
    }

    public BundleActivationReport run() throws Exception {
        SerializedProject.ProjectAppType projectAppType;
        Map<String, String> smActive;
        Set<String> existingAgentReviewIds;
        Set existingWebAppIds;
        Set existingScenarioIds;
        BundleActivationReport ret = new BundleActivationReport();
        this.ep = (ExportedProject)JSON.parseFile((File)this.importFile("export-manifest.json"), ExportedProject.class);
        AutoMigrator migrator = new AutoMigrator(this.importSourceDirectory, this.ep);
        ret.neededAMigration = migrator.migrateIfNeeded();
        this.readAdditionalExportManifest(this.ep, this.importSourceDirectory);
        try (Transaction t = this.transactionService.beginRead();){
            existingScenarioIds = this.scenariosDAO.listUnsafe(this.targetProjectKey).stream().map(s -> s.id).collect(Collectors.toSet());
            existingWebAppIds = this.webAppsDAO.listUnsafe(this.targetProjectKey).stream().map(w -> w.id).collect(Collectors.toSet());
            existingAgentReviewIds = this.agentReviewsDAO.listUnsafe(this.targetProjectKey).stream().map(ar -> ar.id).collect(Collectors.toSet());
            smActive = this.savedModelsDAO.listUnsafe(this.targetProjectKey).stream().filter(sm -> null != sm.activeVersion).collect(Collectors.toMap(SavedModel::getId, SavedModel::getActiveVersion));
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
             FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Importing config");){
            this.shareForeignObjects(this.authCtx, this.ep, ret);
            this.stashLocalConfig((TransactionRef)rwt);
            SerializedProject projectConfigBefore = this.projectsService.getMandatory(this.targetProjectKey);
            AppManifest appManifestBefore = null;
            if (SerializedProject.ProjectAppType.APP_TEMPLATE.equals((Object)projectConfigBefore.projectAppType) && this.appsService.hasAppTemplateManifestFile_T(this.targetProjectKey)) {
                appManifestBefore = this.appsService.getAppTemplateManifestForProject_T(this.targetProjectKey);
            }
            this.remapping = projectConfigBefore.bundleContainerSettings == null ? null : projectConfigBefore.bundleContainerSettings.remapping;
            File configBackupDir = ApplicationConfigurator.getFile((String[])new String[]{"bundle_activation_backups", this.targetProjectKey, this.ep.bundleId + "-" + DKUtils.formatTSFileCompatible(null)});
            DKUFileUtils.mkdirs((File)configBackupDir);
            NativeFS configBackupFS = NativeFS.from((File)configBackupDir).build();
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)rwt, new RelFile(new String[]{"projects", this.targetProjectKey})).to((ReadWriteFS)configBackupFS, new RelFile(new String[]{"project_config", this.targetProjectKey})).run();
            RelFile meaningsDir = new RelFile(new String[]{"meanings"});
            if (rwt.isDirectory(meaningsDir)) {
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)rwt, "meanings").to((ReadWriteFS)configBackupFS, "meanings").run();
            }
            rwt.deleteDirectory(new RelFile(new String[]{"projects", this.targetProjectKey}));
            NativeFS projectConfigFS = NativeFS.from((File)new File(this.importSourceDirectory, "project_config")).build();
            ProjectImportExportUtils.hashApiKeys((ReadWriteFS)projectConfigFS);
            ProjectImportExportUtils.encryptWebAppKeys((ReadWriteFS)projectConfigFS);
            ProjectImportExportUtils.encryptApiServiceApiKeys((ReadWriteFS)projectConfigFS);
            this.importWholeConfig();
            this.importUserDefinedMeanings();
            File wikiAttachmentDir = ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", this.targetProjectKey});
            DKUFileUtils.deleteDirectory((File)wikiAttachmentDir);
            this.importWikiData();
            if (this.remapping != null) {
                this.executeKnowledgeBankImageFolderRemapping();
                this.executeConnectionRemapping(ret);
                if (this.remapping.enableContainerExecRemapping) {
                    this.executeContainerExecRemapping();
                } else {
                    logger.info((Object)"Skipping container exec remapping.");
                }
            }
            this.updateModelVersions(smActive);
            this.remapCodeEnvsInNotebooks();
            this.v3CheckConnectionsWritabilityWithFail(this.ep);
            this.v3ForceReloadedDatasetsPath(this.ep);
            for (JupyterUtils.JupyterNotebookListEntry nb2 : this.jupyterService.listUnsafe(this.authCtx, this.targetProjectKey)) {
                this.jupyterService.rewriteNotebook(nb2.projectKey, nb2.name);
            }
            SerializedProject projectConfigAfter = this.projectsService.getMandatory(this.targetProjectKey);
            assert (projectConfigBefore.projectKey.equals(projectConfigAfter.projectKey));
            projectConfigAfter.owner = projectConfigBefore.owner;
            projectConfigAfter.permissions = projectConfigBefore.permissions;
            projectConfigAfter.additionalDashboardUsers = projectConfigBefore.additionalDashboardUsers;
            projectConfigAfter.bundleContainerSettings = projectConfigBefore.bundleContainerSettings;
            projectConfigAfter.projectStatus = projectConfigBefore.projectStatus;
            projectConfigAfter.settings.limitedVisibilityEnabled = projectConfigBefore.settings.limitedVisibilityEnabled;
            projectConfigAfter.settings.accessRequestsEnabled = projectConfigBefore.settings.accessRequestsEnabled;
            projectConfigAfter.settings.sharingRequestsEnabled = projectConfigBefore.settings.sharingRequestsEnabled;
            if (SerializedProject.ProjectAppType.APP_TEMPLATE.equals((Object)projectConfigAfter.projectAppType)) {
                AppManifest manifest = this.appsService.getAppTemplateManifestForProject_T(this.targetProjectKey);
                if (appManifestBefore == null) {
                    manifest.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                    manifest.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
                } else {
                    manifest.limitedVisibilityEnabled = appManifestBefore.limitedVisibilityEnabled;
                    manifest.accessRequestsEnabled = appManifestBefore.accessRequestsEnabled;
                }
                this.appsService.saveAppTemplateManifestForProject(this.targetProjectKey, manifest);
            }
            projectAppType = projectConfigAfter.projectAppType;
            if (ApplicationConfigurator.isAutomation()) {
                projectConfigAfter.projectType = SerializedProject.ProjectType.BUNDLE_CONTAINER;
                projectConfigAfter.bundleExporterSettings = null;
            }
            this.projectsService.save(projectConfigAfter, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN);
            this.unstashLocalConfig((RWTransactionRef)rwt);
            if (StringUtils.isNotEmpty((String)this.activationOptions.setRunAsUser)) {
                List scenarioList = this.scenariosDAO.list(this.targetProjectKey);
                Iterator iterator = scenarioList.iterator();
                while (iterator.hasNext()) {
                    Scenario currentScenario = (Scenario)iterator.next();
                    if (existingScenarioIds.contains(currentScenario.id)) {
                        logger.debugV("Scenario %s pre-existed. Not setting its runAs user", new Object[]{currentScenario.id});
                        continue;
                    }
                    if (StringUtils.equals((String)currentScenario.runAsUser, (String)this.activationOptions.setRunAsUser)) continue;
                    this.checkAdminIfRunAsOverride();
                    logger.info((Object)("Setting runAsUser of scenario " + currentScenario.id + " of project " + this.targetProjectKey + " to " + this.activationOptions.setRunAsUser));
                    currentScenario.runAsUser = this.activationOptions.setRunAsUser;
                    this.scenariosDAO.save(this.targetProjectKey, currentScenario.id, currentScenario);
                }
                List webAppList = this.webAppsDAO.list(this.targetProjectKey);
                for (WebApp currentWebapp : webAppList) {
                    if (existingWebAppIds.contains(currentWebapp.id)) {
                        logger.debugV("WebApp %s pre-existed. Not setting its runAs user", new Object[]{currentWebapp.id});
                        continue;
                    }
                    if (StringUtils.equals((String)currentWebapp.params.runAs, (String)this.activationOptions.setRunAsUser)) continue;
                    this.checkAdminIfRunAsOverride();
                    logger.info((Object)("Setting runAsUser of webapp " + currentWebapp.id + " of project " + this.targetProjectKey + " to " + this.activationOptions.setRunAsUser));
                    currentWebapp.params.runAs = this.activationOptions.setRunAsUser;
                    this.webAppsService.save(currentWebapp, false);
                }
            }
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(this.targetProjectKey)) {
                if (!dataset.type.startsWith("Sample_") || DatasetHandlerFactory.hasParamsClass(dataset.type)) continue;
                ret.withWarningV(BundleCodes.WARN_BUNDLE_ACTIVATE_MISSING_PLUGIN, "Bundle contains a custom sample dataset of type '" + dataset.type + "' from a plugin that is not installed", new Object[0]);
            }
            this.clearDataOfNoLongerExistingAgentReviews(existingAgentReviewIds);
            ActiveBundleState abs = new ActiveBundleState();
            abs.activatedOn = DKUDateUtils.isoFormatLocalNow();
            abs.bundleId = this.ep.bundleId;
            rwt.writeObject(new RelFile(new String[]{"projects", this.targetProjectKey, "active-bundle.json"}), (Object)abs);
            JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
            gitManager.invalidateSubGit(this.targetProjectKey);
            this.pubSub.publishAfterTransaction(new ProjectBundleActivatedEvent(this.targetProjectKey, projectConfigAfter.name));
            rwt.commit("Activated bundle " + this.ep.bundleId);
        }
        this.graphService.invalidateCache();
        if (this.activationOptions.restartWebApps) {
            WebAppBackendRestartThread.restartAll(this.targetProjectKey, this.authCtx);
        } else {
            WebAppBackendRestartThread.stopAll(this.targetProjectKey, this.authCtx, null);
        }
        if (projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
            this.appsService.handleProjectImported_NT(this.targetProjectKey);
        }
        this.importProjectResources();
        this.importKnowledgeBanksData();
        this.importPromptStudioHistories();
        this.importAgentReviewsTestsData();
        if (this.ep.exportedWithOptions.exportNotebooks && this.ep.exportedWithOptions.exportNotebooksWithOutputs) {
            this.importNotebooksOutputs();
            this.remapCodeEnvsInNotebooksResults();
        } else {
            this.deleteImportedNotebooksOutputsExcept(this.stashedLocalConfig.localJupyterNotebooks.stream().flatMap(nb -> Stream.of(nb.id + ".ipynb", nb.id + "-checkpoint.ipynb")).collect(Collectors.toSet()));
        }
        this.dataQualitySummaryService.updateProjectStatusOnBundleActivation(this.targetProjectKey, System.currentTimeMillis());
        logger.infoV("Deleting previous static insights data of project %s", new Object[]{this.targetProjectKey});
        this.deleteInsightsData();
        if (this.ep.actualContent.insightsData) {
            logger.infoV("Importing static insights data of project %s", new Object[]{this.targetProjectKey});
            this.importInsightsData();
        }
        this.v3ReloadAllData(this.ep, ret.messages);
        this.executeAllDataRemapping(this.ep, this.remapping, ret.messages);
        ret.summarize();
        return ret;
    }

    private void clearDataOfNoLongerExistingAgentReviews(Set<String> existingAgentReviewIds) throws IOException {
        Set currentAgentReviewIds = this.agentReviewsDAO.listUnsafe(this.targetProjectKey).stream().map(ar -> ar.id).collect(Collectors.toSet());
        for (String existingAgentReviewId : existingAgentReviewIds) {
            if (currentAgentReviewIds.contains(existingAgentReviewId)) continue;
            try {
                logger.infoV("Deleting data for no longer existing agent review %s", new Object[]{existingAgentReviewId});
                this.agentReviewCRUDService.clearAgentReviewForDeletion(this.targetProjectKey, existingAgentReviewId);
            }
            catch (SQLException exception) {
                logger.warnV((Throwable)exception, "Could not clean DB from data of agent review %s", new Object[]{existingAgentReviewId});
            }
        }
    }

    private void executeAllDataRemapping(ExportedProject ep, ProjectRemappingSettings remapping, Set<InfoMessage> messages) {
        try {
            this.executeSavedModelConnectionRemapping(ep, remapping);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to remap connection for imported saved model data of '" + this.targetProjectKey + "'"), (Throwable)e);
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONNECTION_REMAPPING, (String)("Failed remapping connections in saved models:  " + String.valueOf(e))));
        }
        try {
            this.executeModelEvaluationConnectionRemapping(ep, remapping);
        }
        catch (Exception e) {
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONNECTION_REMAPPING, (String)("Failed remapping connections in model evaluation stores:  " + String.valueOf(e))));
        }
        try {
            this.executeKnowledgeBankDataImagesFolderRemapping(ep);
        }
        catch (Exception e) {
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONNECTION_REMAPPING, (String)("Failed remapping images folder id in knowledge banks:  " + String.valueOf(e))));
        }
        try {
            this.executeKnowledgeBankDataConnectionRemapping(ep, remapping);
        }
        catch (Exception e) {
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONNECTION_REMAPPING, (String)("Failed remapping connections in knowledge banks:  " + String.valueOf(e))));
        }
        if (remapping != null && remapping.enableContainerExecRemapping) {
            try {
                this.executeSavedModelContainerExecRemapping(ep, remapping);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap container exec for imported saved model data of '" + this.targetProjectKey + "'"), (Throwable)e);
                messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONTAINER_EXEC_CONFIG_REMAPPING, (String)("Failed remapping container exec configs in saved models:  " + String.valueOf(e))));
            }
            try {
                this.executeAnalysisDataContainerExecRemapping(ep, remapping);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap container exec for imported analysis data of '" + this.targetProjectKey + "'"), (Throwable)e);
                messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONTAINER_EXEC_CONFIG_REMAPPING, (String)("Failed remapping container exec configs in analysis data:  " + String.valueOf(e))));
            }
            try {
                this.executeKnowledgeBankDataContainerExecRemapping(ep, remapping);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap container exec for imported knowledge bank data of '" + this.targetProjectKey + "'"), (Throwable)e);
                messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONTAINER_EXEC_CONFIG_REMAPPING, (String)("Failed remapping container exec configs in knowledge banks data:  " + String.valueOf(e))));
            }
            try {
                this.executeAgentToolContainerExecRemapping(ep, remapping);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap container exec for imported agent tool data of '" + this.targetProjectKey + "'"), (Throwable)e);
                messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_FAILED_CONTAINER_EXEC_CONFIG_REMAPPING, (String)("Failed remapping container exec configs in agent tools:  " + String.valueOf(e))));
            }
        } else {
            logger.info((Object)"Skipping container exec remapping in data.");
        }
    }

    private void stashLocalConfig(TransactionRef t) throws Exception {
        RelFile rf = new RelFile(new String[]{"projects", this.targetProjectKey, "localvariables.json"});
        if (t.isFile(rf)) {
            this.stashedLocalConfig.localVariables = (JsonObject)t.readObject(rf, JsonObject.class);
        }
        for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
            this.stashedLocalConfig.allScenarios.add(scenario);
            if (scenario.automationLocal) {
                ScenarioAndPayload sap = new ScenarioAndPayload();
                sap.scenario = scenario;
                sap.payload = this.scenariosDAO.getPayload(this.targetProjectKey, scenario.id, "py");
                this.stashedLocalConfig.localScenarios.add(sap);
            }
            this.stashedLocalConfig.scenariosActiveState.put(scenario.id, scenario.active);
        }
        for (WebApp webApp : this.webAppsDAO.list(this.targetProjectKey)) {
            this.stashedLocalConfig.allWebApps.add(webApp);
        }
        for (Insight insight : this.insightsDAO.list(this.targetProjectKey)) {
            this.stashedLocalConfig.allInsights.add(insight);
        }
        for (SQLNotebook sqlNotebook : this.sqlNotebooksService.list(this.targetProjectKey)) {
            if (!sqlNotebook.automationLocal) continue;
            logger.infoV("Preserving automation-local SQL notebook %s", new Object[]{sqlNotebook.id});
            SQLNotebookWithQueries snwq = new SQLNotebookWithQueries();
            snwq.notebook = sqlNotebook;
            snwq.queries = this.sqlNotebooksDAO.getQueries(this.targetProjectKey, sqlNotebook.id);
            this.stashedLocalConfig.localSQLNotebooks.add(snwq);
        }
        for (SearchNotebook searchNotebook : this.searchNotebooksService.list(this.targetProjectKey)) {
            if (!searchNotebook.automationLocal) continue;
            logger.infoV("Preserving automation-local Search notebook %s", new Object[]{searchNotebook.id});
            this.stashedLocalConfig.localSearchNotebooks.add(searchNotebook);
        }
        for (JupyterUtils.JupyterNotebookListEntry entry : this.jupyterService.listSimple(DSSAuthCtx.newNone(), this.targetProjectKey)) {
            if (!entry.automationLocal) continue;
            logger.infoV("Preserving automation-local Jupyter notebook %s", new Object[]{entry.name});
            JupyterNotebook nbk = new JupyterNotebook();
            nbk.id = entry.name;
            nbk.data = TransactionContext.retrieveRead().readBytes(this.jupyterService.getNotebookFile(this.targetProjectKey, entry.name));
            this.stashedLocalConfig.localJupyterNotebooks.add(nbk);
        }
    }

    private void unstashLocalConfig(RWTransactionRef rwt) throws IOException {
        if (this.stashedLocalConfig.localVariables != null) {
            RelFile rf = new RelFile(new String[]{"projects", this.targetProjectKey, "localvariables.json"});
            rwt.writeStringUTF8(rf, JSON.prettyUnescapeHtml((Object)this.stashedLocalConfig.localVariables));
        }
        for (ScenarioAndPayload sap : this.stashedLocalConfig.localScenarios) {
            Scenario conflicting = (Scenario)this.scenariosDAO.getOrNull(this.targetProjectKey, sap.scenario.id);
            if (conflicting != null) {
                throw ErrorContext.iae((String)("Conflicting scenario: " + sap.scenario.id));
            }
            this.scenariosDAO.save(this.targetProjectKey, sap.scenario.id, sap.scenario);
            if (sap.payload == null) continue;
            this.scenariosDAO.savePayload(this.targetProjectKey, sap.scenario.id, "py", sap.payload);
        }
        boolean adjustRunAsInScenarios = ApplicationConfigurator.getParams().getBoolParam("dku.security.bundleActivation.adjustRunAsUserInScenarios", true);
        boolean adjustRunAsInWebapps = ApplicationConfigurator.getParams().getBoolParam("dku.security.bundleActivation.adjustRunAsUserInWebapps", true);
        boolean adjustRunAsInInsights = ApplicationConfigurator.getParams().getBoolParam("dku.security.bundleActivation.adjustRunAsUserInInsights", true);
        this.adjustRunAsUsers(this.stashedLocalConfig, adjustRunAsInScenarios, adjustRunAsInWebapps, adjustRunAsInInsights);
        for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
            Boolean wasActive = this.stashedLocalConfig.scenariosActiveState.get(scenario.id);
            Boolean activeOnActivationOverride = this.activationOptions.scenariosActiveOnActivation.get(scenario.id);
            if (activeOnActivationOverride != null) {
                logger.infoV("Scenario %s manually specified to have its active state set to %s upon bundle activation", new Object[]{scenario.id, activeOnActivationOverride});
                scenario.active = activeOnActivationOverride;
            } else if (wasActive != null) {
                logger.infoV("Scenario %s already existed, keeping its active state", new Object[]{scenario.id});
                scenario.active = wasActive;
            } else {
                logger.infoV("Scenario %s just imported, disabling it", new Object[]{scenario.id});
                scenario.active = false;
            }
            this.scenariosDAO.save(this.targetProjectKey, scenario.id, scenario);
        }
        for (SQLNotebookWithQueries sqlNotebook : this.stashedLocalConfig.localSQLNotebooks) {
            logger.infoV("Restoring automation-local SQL notebook", new Object[]{sqlNotebook.notebook.id});
            this.sqlNotebooksDAO.save(sqlNotebook.notebook);
            this.sqlNotebooksDAO.writeQueries(sqlNotebook.notebook.projectKey, sqlNotebook.notebook.id, sqlNotebook.queries);
        }
        for (SearchNotebook searchNotebook : this.stashedLocalConfig.localSearchNotebooks) {
            logger.infoV("Restoring automation-local Search notebook", new Object[]{searchNotebook.id});
            this.searchNotebooksDAO.save(searchNotebook);
        }
        for (JupyterNotebook entry : this.stashedLocalConfig.localJupyterNotebooks) {
            logger.infoV("Restoring automation-local Jupyter notebook", new Object[]{entry.id});
            TransactionContext.retrieveWrite().writeBytes(this.jupyterService.getNotebookFile(this.targetProjectKey, entry.id), entry.data);
        }
    }

    private void executeKnowledgeBankImageFolderRemapping() throws IOException {
        logger.info((Object)"Starting knowledge bank images folder remapping...");
        for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            boolean remapped = this.remapKnowledgeBankImagesFolder(rk, this.ep.originalProjectKey);
            if (!remapped) continue;
            logger.info((Object)"Saving retrievable knowledge %s after remapping its images folder id".formatted(rk.getId()));
            this.retrievableKnowledgeDAO.save(rk);
        }
        logger.info((Object)"Knowledge bank images folder remapping done.");
    }

    private void executeConnectionRemapping(InfoMessage.InfoMessages ret) throws IOException, DKUSecurityException {
        boolean wasRemapped;
        logger.info((Object)"Starting connection remapping...");
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, this.remapping, this.ep);
        for (SerializedDataset serializedDataset : this.datasetsDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapDataset(serializedDataset);
            if (!wasRemapped) continue;
            logger.infoV("Saving dataset %s after remapping its connection", new Object[]{serializedDataset.name});
            serializedDataset.projectKey = this.targetProjectKey;
            this.datasetsDAO.save(serializedDataset);
        }
        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapStreamingEndpoint(streamingEndpoint);
            if (!wasRemapped) continue;
            logger.infoV("Saving streaming endpoint %s after remapping its connection", new Object[]{streamingEndpoint.id});
            streamingEndpoint.projectKey = this.targetProjectKey;
            this.streamingEndpointsDAO.save(streamingEndpoint);
        }
        for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapNotebook(sQLNotebook);
            if (!wasRemapped) continue;
            logger.infoV("Saving notebook %s after remapping its connection", new Object[]{sQLNotebook.name});
            this.sqlNotebooksDAO.save(sQLNotebook);
        }
        for (SearchNotebook searchNotebook : this.searchNotebooksDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapNotebook(searchNotebook);
            if (!wasRemapped) continue;
            logger.infoV("Saving notebook %s after remapping its connection", new Object[]{searchNotebook.name});
            this.searchNotebooksDAO.save(searchNotebook);
        }
        for (ManagedFolder managedFolder : this.managedFolderDAO.list(this.targetProjectKey)) {
            wasRemapped = connectionRemapper.remapManagedFolder(managedFolder);
            if (wasRemapped) {
                logger.infoV("Saving folder %s after remapping its connection", new Object[]{managedFolder.name});
                this.managedFolderDAO.save(managedFolder);
            }
            this.fixFolderType(ret, managedFolder);
        }
        for (SerializedRecipe serializedRecipe : this.recipesDAO.list(this.targetProjectKey)) {
            ConnectionRemapper.RecipeRemappingResult remappingRecipe = connectionRemapper.remapRecipe(serializedRecipe);
            if (!remappingRecipe.wasRemapped) continue;
            logger.infoV("Saving recipe %s after remapping its connection", new Object[]{serializedRecipe.name});
            this.recipesDAO.save(this.targetProjectKey, serializedRecipe.name, serializedRecipe, JSON.json((Object)remappingRecipe.payloadParams));
        }
        for (Scenario scenario : this.scenariosDAO.list(this.targetProjectKey)) {
            boolean wasRemapped2 = connectionRemapper.remapScenario(scenario);
            if (!wasRemapped2) continue;
            logger.infoV("Saving scenario %s after remapping its connection", new Object[]{scenario.name});
            this.scenariosDAO.save(this.targetProjectKey, scenario.id, scenario);
        }
        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            boolean wasRemapped3 = connectionRemapper.remapRetrievableKnowledge(retrievableKnowledge);
            if (!wasRemapped3) continue;
            logger.infoV("Saving retrievable knowledge %s after remapping its connection", new Object[]{retrievableKnowledge.id});
            this.retrievableKnowledgeDAO.save(retrievableKnowledge);
        }
        for (PromptStudio promptStudio : this.promptStudioDAO.list(this.targetProjectKey)) {
            boolean wasRemapped4 = connectionRemapper.remapPromptStudio(promptStudio);
            if (!wasRemapped4) continue;
            logger.infoV("Saving prompt studio %s after remapping its connection", new Object[]{promptStudio.id});
            this.promptStudioDAO.save(promptStudio);
        }
        for (AgentReview agentReview : this.agentReviewsDAO.list(this.targetProjectKey)) {
            boolean wasRemapped5 = connectionRemapper.remapAgentReview(agentReview);
            if (!wasRemapped5) continue;
            logger.infoV("Saving agent review %s after remapping its connection", new Object[]{agentReview.id});
            this.agentReviewsDAO.save(agentReview);
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(this.targetProjectKey)) {
            boolean wasRemapped6 = connectionRemapper.remapAgentTool(agentTool);
            if (!wasRemapped6) continue;
            logger.infoV("Saving remapped agent tool %s", new Object[]{agentTool.id});
            this.agentToolsDAO.save(agentTool);
        }
        for (LambdaService lambdaService : this.lambdaServicesDAO.list(this.targetProjectKey)) {
            LambdaService lambdaService2 = (LambdaService)this.lambdaServicesDAO.getOrNull(lambdaService.projectKey, lambdaService.id);
            boolean wasRemapped7 = connectionRemapper.remapLambdaService(lambdaService2);
            if (!wasRemapped7) continue;
            logger.infoV("Saving service %s after remapping its connection", new Object[]{lambdaService2.name});
            this.lambdaServicesDAO.save(lambdaService2);
        }
        for (AnalysisCoreParams analysisCoreParams : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, analysisCoreParams.id)) {
                boolean wasRemapped8 = connectionRemapper.remapMLTask(mlTask);
                if (!wasRemapped8) continue;
                logger.infoV("Saving ML task %s.%s after remapping its connection", new Object[]{analysisCoreParams.id, mlTask.id});
                this.analysisCRUDService.saveMLTask(new MLTaskLoc(this.targetProjectKey, analysisCoreParams.id, mlTask.id), mlTask, true);
            }
        }
        logger.info((Object)"Connection remapping done.");
    }

    private void executeContainerExecRemapping() throws IOException, UnauthorizedException {
        logger.info((Object)"Starting container exec remapping...");
        ContainerExecRemapper containerExecRemapper = new ContainerExecRemapper(this.authCtx, this.remapping, this.ep);
        SerializedProject sp = this.projectsDAO.getMandatory(this.targetProjectKey);
        if (containerExecRemapper.remapProject(sp)) {
            logger.infoV("Saving project %s after remapping its container exec", new Object[]{sp.name});
            this.projectsDAO.save(sp);
        }
        for (SerializedRecipe sr : this.recipesDAO.list(this.targetProjectKey)) {
            boolean isRecipeRemapped = containerExecRemapper.remapRecipe(sr);
            Object newPayload = containerExecRemapper.remapRecipePayload(sr);
            if (!(isRecipeRemapped |= newPayload != null)) continue;
            logger.infoV("Saving recipe %s after remapping its container exec", new Object[]{sr.name});
            this.recipesDAO.save(this.targetProjectKey, sr.name, sr, JSON.pretty((Object)newPayload));
        }
        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.list(this.targetProjectKey)) {
            boolean wasRemapped = containerExecRemapper.remapRetrievableKnowledge(retrievableKnowledge);
            if (!wasRemapped) continue;
            logger.infoV("Saving retrievable knowledge %s after remapping its container exec", new Object[]{retrievableKnowledge.id});
            this.retrievableKnowledgeDAO.save(retrievableKnowledge);
        }
        for (JupyterUtils.JupyterNotebookListEntry nbk : this.jupyterService.listUnsafe(this.authCtx, this.targetProjectKey)) {
            RelFile rf = this.jupyterService.getNotebookFile(this.targetProjectKey, nbk.name);
            RWTransactionRef t = TransactionContext.retrieveWrite();
            JsonObject notebook = (JsonObject)t.readObject(rf, JsonObject.class);
            if (!containerExecRemapper.remapNotebook(nbk.name, notebook)) continue;
            logger.infoV("Saving notebook %s after remapping its container exec", new Object[]{nbk.name});
            t.writeObject(rf, (Object)notebook);
        }
        for (WebApp webApp : this.webAppsDAO.list(this.targetProjectKey)) {
            boolean wasRemapped = containerExecRemapper.remapWebApp(webApp);
            if (!wasRemapped) continue;
            logger.infoV("Saving web app %s after remapping its container exec", new Object[]{webApp.id});
            this.webAppsDAO.save(webApp);
        }
        for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
            for (MLTask task : this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, acp.id)) {
                if (!containerExecRemapper.remapAnalysis(acp, task)) continue;
                logger.infoV("Saving ML task %s.%s after remapping its container exec", new Object[]{acp.id, task.id});
                this.analysisCRUDService.saveMLTask(new MLTaskLoc(this.targetProjectKey, acp.id, task.id), task, true);
            }
        }
        logger.info((Object)"Container exec remapping done.");
    }

    private List<String> getModelVersions(SavedModel sm) {
        ArrayList<String> ret = new ArrayList<String>();
        File versionsFolder = MLPaths.savedModelVersionsFolder(sm);
        if (!versionsFolder.isDirectory()) {
            return ret;
        }
        return Arrays.stream(versionsFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES)).map(File::getName).collect(Collectors.toList());
    }

    private void updateModelVersions(Map<String, String> preexistingSMActivVersions) throws Exception {
        HashMultimap<String, String> includedSavedModelWithVersion = CommonBundleUtils.getIncludedSavedModelVersionsInArchive(this.bundleArchive);
        for (SavedModel savedModel : this.savedModelsDAO.list(this.targetProjectKey)) {
            if (this.ep.actualContent.includedSavedModels.stream().noneMatch(ism -> StringUtils.equals((String)ism.id, (String)savedModel.id))) {
                if (savedModel.savedModelType.isRetrievalAugmentedLlm()) continue;
                if (savedModel.savedModelType.isAgent()) {
                    if (savedModel.activeVersion == null || !savedModel.inlineVersions.stream().noneMatch(inlineVersion -> StringUtils.equals((String)inlineVersion.versionId, (String)savedModel.activeVersion))) continue;
                    logger.warnV("Active version %s configured for included agent %s not found in bundle archive. Agent will have no active version.", new Object[]{savedModel.activeVersion, savedModel.id});
                    savedModel.activeVersion = null;
                    this.savedModelsDAO.save(savedModel);
                    continue;
                }
                List<String> preexistingVersions = this.getModelVersions(savedModel);
                if (preexistingVersions.contains(savedModel.activeVersion)) continue;
                if (preexistingSMActivVersions.containsKey(savedModel.id)) {
                    savedModel.activeVersion = preexistingSMActivVersions.get(savedModel.id);
                    logger.infoV("Preserving pre-import active version of model %s: %s", new Object[]{savedModel.id, savedModel.activeVersion});
                } else {
                    savedModel.activeVersion = null;
                    logger.warnV("Active version specified in config for saved model %s does not exist. Setting to null.", new Object[]{savedModel.id});
                }
                this.savedModelsDAO.save(savedModel);
                continue;
            }
            if (savedModel.activeVersion == null) {
                logger.warnV("There is no active version for saved model %s included in the bundle: active version is null", new Object[]{savedModel.id});
                continue;
            }
            if (includedSavedModelWithVersion.get((Object)savedModel.id).contains(savedModel.activeVersion)) continue;
            logger.warnV("Active version %s configured for included saved model %s not found in bundle archive. Saved Model will have no active version.", new Object[]{savedModel.activeVersion, savedModel.id});
            savedModel.activeVersion = null;
            this.savedModelsDAO.save(savedModel);
        }
    }

    private List<InfoMessage> checkSavedModelVersions() throws IOException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        HashMultimap<String, String> includedSavedModelWithVersion = CommonBundleUtils.getIncludedSavedModelVersionsInArchive(this.bundleArchive);
        for (BundleContentSummary.IncludedSavedModel ism : this.ep.actualContent.includedSavedModels) {
            JsonElement smVersion;
            JsonObject smConfig = CommonBundleUtils.getSavedModelConfigFromArchive(this.bundleArchive, ism.id);
            JsonElement smType = smConfig.get("savedModelType");
            if (smType != null && List.of(SavedModel.SavedModelType.PYTHON_AGENT.toString(), SavedModel.SavedModelType.PLUGIN_AGENT.toString(), SavedModel.SavedModelType.TOOLS_USING_AGENT.toString()).contains(smType.getAsString()) || (smVersion = smConfig.get("activeVersion")) != null && includedSavedModelWithVersion.get((Object)ism.id).contains(smVersion.getAsString())) continue;
            ret.add(InfoMessage.warningV((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_SAVED_MODEL_NO_ACTIVE_VERSION, (String)"Included saved model %s has no valid active version in the bundle", (Object[])new Object[]{ism.id}));
        }
        return ret;
    }

    private void remapCodeEnvsInNotebooksResults() throws Exception {
        File notebooksDirectory = this.jupyterService.getNotebooksWithOutputsDir(this.targetProjectKey);
        if (!notebooksDirectory.isDirectory()) {
            return;
        }
        for (File f : DKUFileUtils.recursiveListFiles((File)notebooksDirectory)) {
            if (!f.getPath().endsWith(".ipynb")) continue;
            try {
                JsonObject notebook = (JsonObject)JSON.parseFile((File)f, JsonObject.class);
                boolean changed = this.remapCodeEnvsInNotebook(f.getPath(), notebook);
                if (!changed) continue;
                logger.info((Object)("Did change notebook " + f.getPath()));
                JSON.prettyToFile((Object)notebook, (File)f);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap venv in " + f.getPath()), (Throwable)e);
            }
        }
    }

    private void remapCodeEnvsInNotebooks() throws Exception {
        RelFile notebooksDirectory;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.exists(notebooksDirectory = this.jupyterService.getNotebooksDir(this.targetProjectKey))) {
            return;
        }
        for (RelFile rf : t.listFiles(notebooksDirectory)) {
            if (!rf.getLeafName().endsWith(".ipynb")) continue;
            try {
                JsonObject notebook = (JsonObject)t.readObject(rf, JsonObject.class);
                boolean changed = this.remapCodeEnvsInNotebook(rf.getFullPath(), notebook);
                if (!changed) continue;
                logger.info((Object)("Did change notebook " + rf.getFullPath()));
                t.writeObject(rf, (Object)notebook);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to remap venv in " + rf.getFullPath()), (Throwable)e);
            }
        }
    }

    private boolean remapCodeEnvsInNotebook(String filePath, JsonObject notebook) throws IOException {
        JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(notebook);
        if (kernelInfo == null) {
            return false;
        }
        if (kernelInfo.envLang != null) {
            String envName = kernelInfo.envName;
            CodeEnvModel.AutomationEnvRootDef rootDef = this.codeEnvsService.getEnvRootDefOrNull(kernelInfo.envLang, envName);
            if (rootDef == null) {
                throw new IllegalArgumentException("Unknown " + String.valueOf((Object)kernelInfo.envLang) + " env: " + envName);
            }
            if (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                kernelInfo.projectKey = this.targetProjectKey;
                kernelInfo.bundleId = this.ep.bundleId;
                String kernelName = JupyterCodeEnvUtils.getKernelName(kernelInfo.envLang, kernelInfo.envName, kernelInfo.projectKey, kernelInfo.bundleId, kernelInfo.containerConf);
                logger.warn((Object)("Notebook " + filePath + " references versioned py env " + kernelInfo.kernelName + ", remapping to " + kernelName));
                JupyterCodeEnvUtils.setKernelNameInNotebook(notebook, kernelName);
                JupyterCodeEnvUtils.setDisplayNameInNotebook(notebook, JupyterCodeEnvUtils.getDisplayName(kernelInfo.envLang, kernelInfo.envName, kernelInfo.projectKey, kernelInfo.bundleId, kernelInfo.containerConf));
                return true;
            }
            logger.warn((Object)("Notebook " + filePath + " references non-versioned py env " + envName + ", not-remapping"));
            return false;
        }
        logger.info((Object)("Kernel is not a versioned kernel: " + JSON.log((Object)kernelInfo)));
        return false;
    }

    protected void importUserDefinedMeanings() throws Exception {
        NativeFS srcFolderFS = NativeFS.from((File)this.importSourceDirectory).build();
        RWTransactionRef t = TransactionContext.retrieveWrite();
        Object filter = this.activationOptions.meaningsToImport != null ? new RelFileFilter(){

            public boolean accept(ReadOnlyFS fs, RelFile file) throws IOException {
                if (fs.isDirectory(file)) {
                    return true;
                }
                String meaningId = FilenameUtils.removeExtension((String)file.getLeafName());
                return BundleActivator.this.activationOptions.meaningsToImport.containsKey(meaningId) && BundleActivator.this.activationOptions.meaningsToImport.get(meaningId) != false;
            }
        } : new RelFileFilter(){

            public boolean accept(ReadOnlyFS fs, RelFile file) {
                return true;
            }
        };
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)srcFolderFS, RelFile.global((String)"meanings")).to((ReadWriteFS)t, "meanings").filter(filter).run();
        this.basicMeaningsService.invalidateCache();
        this.pubSub.publishAfterTransaction((DSSEvent)new MeaningsFolderChangedEvent());
    }

    public static class UDMConflictWarning
    extends InfoMessage {
        public String udmId;
        public GitModel.FileChange diff;

        public UDMConflictWarning(String udmId, GitModel.FileChange diff) {
            super(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MEANING_CHANGED, udmId);
            this.udmId = udmId;
            this.diff = diff;
        }
    }

    public static class BundleActivationReport
    extends InfoMessage.InfoMessages {
        public boolean neededAMigration;

        public void mergeFrom(InfoMessage.InfoMessages other) {
            super.mergeFrom(other);
            if (other instanceof BundleActivationReport) {
                this.neededAMigration = ((BundleActivationReport)other).neededAMigration;
            }
        }
    }

    static class ScenarioAndPayload {
        Scenario scenario;
        String payload;

        ScenarioAndPayload() {
        }
    }

    static class SQLNotebookWithQueries {
        SQLNotebook notebook;
        SQLNotebooksDAO.QueriesFile queries;

        SQLNotebookWithQueries() {
        }
    }

    static class JupyterNotebook {
        String id;
        byte[] data;

        JupyterNotebook() {
        }
    }
}

