/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.projects.importexport.AgentReviewConnectionsUtils;
import com.dataiku.dip.projects.importexport.AgentToolsConnectionUtils;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.PromptStudioConnectionsUtils;
import com.dataiku.dip.projects.importexport.RetrievableKnowledgeConnectionsUtils;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.SelectableConnectionContainer;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ConnectionRemapper {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    protected AnalysisCRUDService analysisCRUDService;
    @Autowired
    protected TransactionService transactionService;
    private final ProjectRemappingSettings settings;
    private final ApplicationContext appContext;
    private final ExportedProject exportedProject;
    private final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.connections");

    public ConnectionRemapper(AuthCtx authCtx, ApplicationContext appContext, ProjectRemappingSettings settings, ExportedProject ep) {
        this.authCtx = authCtx;
        this.appContext = appContext;
        this.settings = settings;
        this.exportedProject = ep;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private boolean shouldFailOnMissingLLMConnection() {
        return this.shouldFailOnMissingLLMConnection(FeatureRemapVersion.BASE_LLM_CONNECTIONS);
    }

    private boolean shouldFailOnMissingLLMConnection(FeatureRemapVersion feature) {
        return Integer.parseInt(this.exportedProject.generatedWithDSSConfVersion) >= feature.minVersion;
    }

    private boolean shouldFailOnMissingRecipeConnection(RecipeMeta meta) {
        if (meta.getCategoryFlags().isNlp) {
            return this.shouldFailOnMissingLLMConnection(FeatureRemapVersion.BASE_LLM_CONNECTIONS);
        }
        return true;
    }

    private boolean shouldFailOnMissingContainerConnection(ParamsWithSelectableConnection connectionUser) {
        return true;
    }

    private boolean isAllowedMissing(String connectionName) {
        return this.exportedProject.allowedMissingConnections.contains(connectionName);
    }

    public List<InfoMessage> checkRemapNotebook(SQLNotebook input) throws IOException, DKUSecurityException {
        HashSet connection = Sets.newHashSet((Object[])new String[]{input.connection});
        return this.checkRemap(connection, "sql notebook " + input.name, false);
    }

    public List<InfoMessage> checkRemapNotebook(SearchNotebook input) throws IOException, DKUSecurityException {
        HashSet connections = Sets.newHashSet((Object[])new String[]{input.connection});
        return this.checkRemap(connections, "search notebook " + input.name, false);
    }

    public List<InfoMessage> checkRemapDataset(SerializedDataset input) throws IOException, DKUSecurityException {
        String connectionName;
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        if (input.getParams() != null && (connectionName = input.getParams().getConnection()) != null) {
            datasetConnectionNames.add(connectionName);
        }
        return this.checkRemap(datasetConnectionNames, "dataset " + input.name, true);
    }

    public List<InfoMessage> checkRemapStreamingEndpoint(StreamingEndpoint input) throws IOException, DKUSecurityException {
        String connectionName;
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        if (input.getParams() != null && (connectionName = input.getParams().getConnection()) != null) {
            datasetConnectionNames.add(connectionName);
        }
        return this.checkRemap(datasetConnectionNames, "streaming endpoint " + input.id, true);
    }

    public List<InfoMessage> checkRemapSavedModel(File archiveDir, SavedModel sm) throws IOException, DKUSecurityException {
        HashSet<String> connectionNames = new HashSet<String>();
        if (sm.proxyModelConfiguration != null && StringUtils.isNotEmpty((String)sm.proxyModelConfiguration.connection)) {
            connectionNames.add(sm.proxyModelConfiguration.connection);
        }
        for (FullModelId fmi : this.codeEnvUsagesService.listFmisInSavedModel(sm)) {
            connectionNames.addAll(fmi.getUsedConnections());
        }
        String descriptionType = sm.savedModelType.isAgent() ? "agent " : (sm.savedModelType.isRetrievalAugmentedLlm() ? "retrieval augmented llm " : "saved model ");
        return this.checkRemap(connectionNames, descriptionType + sm.id, false);
    }

    public List<InfoMessage> checkRemapManagedFolder(ManagedFolder input) throws IOException, DKUSecurityException {
        String connectionName;
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        if (input.getParams() != null && (connectionName = input.getParams().getConnection()) != null) {
            datasetConnectionNames.add(connectionName);
        }
        return this.checkRemap(datasetConnectionNames, "folder " + input.name, true);
    }

    public List<InfoMessage> checkRemapRecipe(SerializedRecipe input) throws IOException, DKUSecurityException {
        RecipeMeta meta = RecipeRegistry.getMeta(input);
        String payloadOrNull = this.recipesDAO.getPayloadOrNull(input.projectKey, input.name);
        Set<String> recipeConnectionNames = meta.underlyingConnectionNames(input, payloadOrNull);
        return this.checkRemap(recipeConnectionNames, "recipe " + input.name, this.shouldFailOnMissingRecipeConnection(meta));
    }

    public List<InfoMessage> checkRemapScenario(Scenario input) throws IOException, DKUSecurityException {
        return this.checkRemapConnectionContainer(input, input);
    }

    public List<InfoMessage> checkRemapLambdaService(LambdaService input) throws IOException, DKUSecurityException {
        return this.checkRemapConnectionContainer(input, input);
    }

    public List<InfoMessage> checkRemapConnectionContainer(SelectableConnectionContainer input, TaggableObjectsService.TaggableObject taggable) throws IOException, DKUSecurityException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        String objectDescription = taggable.getTaggableType().toHumanReadableString() + " " + taggable.getId();
        for (ParamsWithSelectableConnection connectionUser : input.collectConnectionUsers()) {
            DatasetConnectionUtils.UsedConnection usage = connectionUser.collectConnectionUsage(taggable);
            if (usage == null || StringUtils.isBlank((String)usage.name) || ConnectionsDAO.parseVirtualConnection(usage.name) != null) continue;
            ret.addAll(this.checkRemap(Collections.singleton(usage.name), objectDescription, this.shouldFailOnMissingContainerConnection(connectionUser)));
        }
        return ret;
    }

    public List<InfoMessage> checkRetrievableKnowledge(RetrievableKnowledge rk) throws IOException, DKUSecurityException {
        return this.checkRemap(RetrievableKnowledgeConnectionsUtils.listConnectionNames(rk), "knowledge bank", this.shouldFailOnMissingLLMConnection());
    }

    public List<InfoMessage> checkPromptStudio(PromptStudio ps2) throws IOException, DKUSecurityException {
        return this.checkRemap(PromptStudioConnectionsUtils.listConnectionNames(ps2), "prompt studio", this.shouldFailOnMissingLLMConnection());
    }

    public List<InfoMessage> checkAgentReview(AgentReview ar) throws IOException, DKUSecurityException {
        return this.checkRemap(AgentReviewConnectionsUtils.listConnectionNames(ar), "agent review", this.shouldFailOnMissingLLMConnection());
    }

    public List<InfoMessage> checkAgentTool(AgentTool at) throws IOException, DKUSecurityException {
        return this.checkRemap(AgentToolsConnectionUtils.listConnectionNames(at), "agent tool " + at.name, this.shouldFailOnMissingLLMConnection(FeatureRemapVersion.AGENT_TOOLS));
    }

    public List<InfoMessage> checkRemapMLTask(MLTask mlTask) throws IOException, DKUSecurityException {
        return this.checkRemap(mlTask.getUsedConnections(), "Visual Analysis", this.shouldFailOnMissingLLMConnection());
    }

    public List<InfoMessage> checkRemap(Set<String> connectionNames, String objectDescription, boolean failIfNotFound) throws IOException, DKUSecurityException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        for (String sourceConnectionName : connectionNames) {
            DatasetConnectionUtils.UsedConnection sourceConnection = this.exportedProject.requiredConnections.get(sourceConnectionName);
            if (sourceConnection == null) {
                if (this.isAllowedMissing(sourceConnectionName)) {
                    ret.add(InfoMessage.warningV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CONNECTION, (String)"connection %s is missing", (Object[])new Object[]{sourceConnectionName}));
                    continue;
                }
                if (!failIfNotFound) {
                    logger.infoV("source connection %s is not referenced, skipping check", new Object[]{sourceConnectionName});
                    continue;
                }
                throw ErrorContext.iaef((String)"Inconsistent bundle data: connection %s not referenced", (Object)sourceConnectionName, (Object[])new Object[0]);
            }
            logger.infoV("%s uses source-connection %s (type: %s)", new Object[]{objectDescription, sourceConnection.name, sourceConnection.type});
            ProjectRemappingSettings.ConnectionRemapping remapping = this.settings.getRemappingForConnection(sourceConnectionName);
            if (remapping == null) {
                logger.infoV("source is not remapped, checking it", new Object[0]);
                DSSConnection unremapped = this.connectionsDAO.getConnection(this.authCtx, sourceConnectionName);
                if (unremapped == null) {
                    if (this.isAllowedMissing(sourceConnectionName)) {
                        logger.infoV(" connection %s is missing, but allowed to be missing", new Object[]{sourceConnectionName});
                        continue;
                    }
                    logger.warnV(" connection %s is missing", new Object[]{sourceConnectionName});
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CONNECTION, (String)"Connection missing for %s (not remapped): %s (%s)", (Object[])new Object[]{objectDescription, sourceConnection.name, sourceConnection.type}));
                    continue;
                }
                if (!unremapped.getType().equals(sourceConnection.type)) {
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_BAD_CONNECTION_TYPE, (String)"Invalid connection type for %s: %s. Found %s, expected %s.", (Object[])new Object[]{objectDescription, sourceConnection.name, unremapped.getType(), sourceConnection.type}));
                    continue;
                }
                if (!unremapped.isFreelyUsableBy(this.authCtx)) {
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_BAD_CONNECTION_PERMISSIONS, (String)"Invalid connection for %s : %s (%s) is not freely usable and needs to be remapped.", (Object[])new Object[]{objectDescription, sourceConnection.name, unremapped.getType()}));
                    continue;
                }
                logger.info((Object)"OK");
                continue;
            }
            logger.infoV("Remapped to %s", new Object[]{remapping.target});
            DSSConnection remapped = this.connectionsDAO.getConnection(this.authCtx, remapping.target);
            if (remapped == null) {
                if (this.isAllowedMissing(sourceConnectionName)) {
                    logger.infoV(" connection %s is missing (remapped to %s), but allowed to be missing", new Object[]{sourceConnectionName, remapping.target});
                    continue;
                }
                logger.warnV(" connection %s is missing (remapped to %s)", new Object[]{sourceConnectionName, remapping.target});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CONNECTION, (String)"Connection missing for %s: %s (remapped from %s (%s))", (Object[])new Object[]{objectDescription, remapping.target, sourceConnection.name, sourceConnection.type}));
                continue;
            }
            if (!remapped.getType().equals(sourceConnection.type)) {
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_BAD_CONNECTION_TYPE, (String)"Invalid connection type for %s: %s (remapped from %s). Found %s, expected %s.", (Object[])new Object[]{objectDescription, remapping.target, sourceConnection.name, remapped.getType(), sourceConnection.type}));
                continue;
            }
            if (!remapped.isFreelyUsableBy(this.authCtx)) {
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_BAD_CONNECTION_PERMISSIONS, (String)"Invalid connection for %s : %s (%s) is not freely usable, %s needs to be mapped to a usable connection.", (Object[])new Object[]{objectDescription, remapping.target, remapped.getType(), sourceConnection.name}));
                continue;
            }
            logger.info((Object)"OK");
        }
        return ret;
    }

    public boolean remapNotebook(SearchNotebook input) throws IOException, DKUSecurityException {
        HashSet connections = Sets.newHashSet((Object[])new String[]{input.connection});
        Map<String, String> replacements = this.remap(connections, "search notebook " + input.name, false);
        if (replacements.size() > 0) {
            input.connection = replacements.get(input.connection);
            return true;
        }
        return false;
    }

    public boolean remapNotebook(SQLNotebook input) throws IOException, DKUSecurityException {
        HashSet connection = Sets.newHashSet((Object[])new String[]{input.connection});
        Map<String, String> replacements = this.remap(connection, "sql notebook " + input.name, false);
        if (replacements.size() > 0) {
            input.connection = replacements.get(input.connection);
            return true;
        }
        return false;
    }

    public boolean remapDataset(SerializedDataset input) throws IOException, DKUSecurityException {
        Map<String, String> replacements;
        DatasetHandler.DatasetParams params = input.getParams();
        if (params == null) {
            return false;
        }
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        String connectionName = params.getConnection();
        if (connectionName != null) {
            datasetConnectionNames.add(connectionName);
        }
        if ((replacements = this.remap(datasetConnectionNames, "dataset " + input.name, true)).size() > 0) {
            DatasetConnectionUtils dcu = new DatasetConnectionUtils();
            dcu.replaceConnections(input, replacements);
            return true;
        }
        return false;
    }

    public boolean remapManagedFolder(ManagedFolder input) throws IOException, DKUSecurityException {
        Map<String, String> replacements;
        AbstractFSDatasetHandler.AbstractFSConfig params = input.getParams();
        if (params == null) {
            return false;
        }
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        String connectionName = params.getConnection();
        if (connectionName != null) {
            datasetConnectionNames.add(connectionName);
        }
        if ((replacements = this.remap(datasetConnectionNames, "folder " + input.name, true)).size() > 0) {
            DatasetConnectionUtils dcu = new DatasetConnectionUtils();
            dcu.replaceConnections(input, replacements);
            return true;
        }
        return false;
    }

    public boolean remapStreamingEndpoint(StreamingEndpoint input) throws IOException, DKUSecurityException {
        Map<String, String> replacements;
        StreamingEndpoint.StreamingEndpointParams params = input.getParams();
        if (params == null) {
            return false;
        }
        HashSet<String> datasetConnectionNames = new HashSet<String>();
        String connectionName = params.getConnection();
        if (connectionName != null) {
            datasetConnectionNames.add(connectionName);
        }
        if ((replacements = this.remap(datasetConnectionNames, "streaming endpoint " + input.id, true)).size() > 0) {
            DatasetConnectionUtils dcu = new DatasetConnectionUtils();
            dcu.replaceConnections(input, replacements);
            return true;
        }
        return false;
    }

    public boolean remapSavedModel(SavedModel sm) throws IOException, DKUSecurityException {
        if (sm.savedModelType.savedModelHandlingType == SavedModel.SavedModelHandlingType.EXTERNAL_MLFLOW && sm.proxyModelConfiguration != null && !StringUtils.isEmpty((String)sm.proxyModelConfiguration.connection)) {
            DatasetConnectionUtils dcu = new DatasetConnectionUtils();
            HashSet<String> connectionNames = new HashSet<String>();
            connectionNames.add(sm.proxyModelConfiguration.connection);
            Map<String, String> replacements = this.remap(connectionNames, "SM " + String.valueOf(sm), true);
            if (!replacements.isEmpty()) {
                dcu.replaceConnections(sm, replacements);
                for (FullModelId fmi : this.codeEnvUsagesService.listFmisInSavedModel(sm)) {
                    MLFlowModelVersionInfo mim = fmi.getMLflowImportedModelMetadata();
                    if (!mim.isProxyModel() || !StringUtils.isNotEmpty((String)mim.getProxyModelConnection())) continue;
                    dcu.replaceConnections(mim.proxyModelVersionConfiguration.proxyModelConfiguration, replacements, fmi.toString());
                    fmi.writeMLflowImportedModelMetadata(mim);
                }
                return true;
            }
            return false;
        }
        HashSet<String> connectionNames = new HashSet<String>();
        List<FullModelId> fullModelIdsInSavedModels = this.codeEnvUsagesService.listFmisInSavedModel(sm);
        for (FullModelId fmi : fullModelIdsInSavedModels) {
            connectionNames.addAll(fmi.getUsedConnections());
        }
        Map<String, String> replacements = this.remap(connectionNames, "SM " + String.valueOf(sm), false);
        if (!replacements.isEmpty()) {
            for (FullModelId fmi : fullModelIdsInSavedModels) {
                fmi.remapAndSaveConnections(replacements);
            }
            if (sm.savedModelType.isAgent() || sm.savedModelType.isRetrievalAugmentedLlm()) {
                sm.remapLLmConnections(replacements);
            }
            return true;
        }
        return false;
    }

    public RecipeRemappingResult remapRecipe(SerializedRecipe input) throws IOException, DKUSecurityException {
        String payloadOrNull;
        DatasetConnectionUtils dcu = new DatasetConnectionUtils();
        RecipeMeta meta = RecipeRegistry.getMeta(input);
        Set<String> recipeConnectionNames = meta.underlyingConnectionNames(input, payloadOrNull = this.recipesDAO.getPayloadOrNull(input.projectKey, input.name));
        Map<String, String> replacements = this.remap(recipeConnectionNames, "recipe " + input.name, this.shouldFailOnMissingRecipeConnection(meta));
        if (!replacements.isEmpty()) {
            return RecipeRemappingResult.withRemapping(dcu.replaceConnections(input, payloadOrNull, replacements));
        }
        return RecipeRemappingResult.withoutRemapping();
    }

    public boolean remapScenario(Scenario input) throws IOException, DKUSecurityException {
        return this.remapSelectableConnectionContainer(input, input);
    }

    public boolean remapLambdaService(LambdaService input) throws IOException, DKUSecurityException {
        return this.remapSelectableConnectionContainer(input, input);
    }

    public boolean remapRetrievableKnowledge(RetrievableKnowledge retrievableKnowledge) throws IOException, DKUSecurityException {
        Set<String> connectionNames = RetrievableKnowledgeConnectionsUtils.listConnectionNames(retrievableKnowledge);
        Map<String, String> replacements = this.remap(connectionNames, "retrievable knowledge " + retrievableKnowledge.id, this.shouldFailOnMissingLLMConnection());
        if (!replacements.isEmpty()) {
            RetrievableKnowledgeConnectionsUtils.remapConnections(retrievableKnowledge, replacements);
            return true;
        }
        return false;
    }

    public boolean remapPromptStudio(PromptStudio promptStudio) throws IOException, DKUSecurityException {
        Set<String> connectionNames = PromptStudioConnectionsUtils.listConnectionNames(promptStudio);
        Map<String, String> replacements = this.remap(connectionNames, "prompt studio " + promptStudio.id, this.shouldFailOnMissingLLMConnection());
        if (!replacements.isEmpty()) {
            PromptStudioConnectionsUtils.remapConnections(promptStudio, replacements);
            return true;
        }
        return false;
    }

    public boolean remapAgentReview(AgentReview agentReview) throws IOException, DKUSecurityException {
        Set<String> connectionNames = AgentReviewConnectionsUtils.listConnectionNames(agentReview);
        Map<String, String> replacements = this.remap(connectionNames, "agent review " + agentReview.id, this.shouldFailOnMissingLLMConnection());
        if (!replacements.isEmpty()) {
            AgentReviewConnectionsUtils.remapConnections(agentReview, replacements);
            return true;
        }
        return false;
    }

    public boolean remapAgentTool(AgentTool agentTool) throws IOException, DKUSecurityException {
        Set<String> connectionNames = AgentToolsConnectionUtils.listConnectionNames(agentTool);
        Map<String, String> replacements = this.remap(connectionNames, "agent tool " + agentTool.id, this.shouldFailOnMissingLLMConnection(FeatureRemapVersion.AGENT_TOOLS));
        if (!replacements.isEmpty()) {
            return AgentToolsConnectionUtils.remapConnections(agentTool, replacements);
        }
        return false;
    }

    public void remapAndSaveCompletedVisualAnalysisData(AnalysisCoreParams analysisCoreParams) throws IOException, DKUSecurityException {
        HashSet<String> connectionsToRemap = new HashSet<String>();
        List<FullModelId> fullModelIds = this.analysisCRUDService.listAnalysisCompletedFMI(analysisCoreParams.projectKey, analysisCoreParams.id);
        for (FullModelId fmi : fullModelIds) {
            connectionsToRemap.addAll(fmi.getUsedConnections());
        }
        Map<String, String> replacements = this.remap(connectionsToRemap, "Analysis " + analysisCoreParams.id, this.shouldFailOnMissingLLMConnection());
        if (replacements.isEmpty()) {
            return;
        }
        for (FullModelId fmi : fullModelIds) {
            fmi.remapAndSaveConnections(replacements);
        }
    }

    public boolean remapMLTask(MLTask mlTask) throws IOException, DKUSecurityException {
        Set<String> connectionsToRemap = mlTask.getUsedConnections();
        Map<String, String> replacements = this.remap(connectionsToRemap, "ML Task " + mlTask.id, this.shouldFailOnMissingLLMConnection());
        if (replacements.isEmpty()) {
            return false;
        }
        mlTask.replaceConnections(replacements);
        return true;
    }

    public void remapAndSaveModelEvaluation(FullModelEvaluationId fme) throws IOException, DKUSecurityException {
        Set<String> connectionsToRemap = fme.getUsedConnections();
        Map<String, String> replacements = this.remap(connectionsToRemap, "Model evaluation  " + fme.getId(), this.shouldFailOnMissingLLMConnection());
        fme.remapAndSaveConnections(replacements);
    }

    private boolean remapSelectableConnectionContainer(SelectableConnectionContainer input, TaggableObjectsService.TaggableObject taggable) throws IOException, DKUSecurityException {
        DatasetConnectionUtils dcu = new DatasetConnectionUtils();
        HashMap<String, String> replacements = new HashMap<String, String>();
        String objectDescription = taggable.getTaggableType().toHumanReadableString() + " " + taggable.getId();
        for (ParamsWithSelectableConnection connectionUser : input.collectConnectionUsers()) {
            DatasetConnectionUtils.UsedConnection usage = connectionUser.collectConnectionUsage(taggable);
            if (usage == null || StringUtils.isBlank((String)usage.name) || ConnectionsDAO.parseVirtualConnection(usage.name) != null) continue;
            replacements.putAll(this.remap(Collections.singleton(usage.name), objectDescription, this.shouldFailOnMissingContainerConnection(connectionUser)));
        }
        if (!replacements.isEmpty()) {
            dcu.replaceConnections(input, taggable, replacements);
            return true;
        }
        return false;
    }

    public Map<String, String> remap(Set<String> connectionNames, String objectDescription, boolean failIfNoSource) throws IOException, DKUSecurityException {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (String sourceConnectionName : connectionNames) {
            DatasetConnectionUtils.UsedConnection sourceConnection = this.exportedProject.requiredConnections.get(sourceConnectionName);
            if (sourceConnection == null) {
                if (this.isAllowedMissing(sourceConnectionName)) continue;
                if (failIfNoSource) {
                    throw ErrorContext.iaef((String)"Inconsistent bundle data: connection %s not referenced", (Object)sourceConnectionName, (Object[])new Object[0]);
                }
            }
            logger.infoV("%s uses source-connection %s", new Object[]{objectDescription, sourceConnectionName});
            ProjectRemappingSettings.ConnectionRemapping remapping = this.settings.getRemappingForConnection(sourceConnectionName);
            if (remapping == null) {
                logger.infoV("source is not remapped, checking it", new Object[0]);
                DSSConnection unremapped = this.connectionsDAO.getConnection(this.authCtx, sourceConnectionName);
                if (unremapped == null) {
                    if (this.isAllowedMissing(sourceConnectionName)) {
                        logger.infoV(" connection %s is missing, but allowed to be missing", new Object[]{sourceConnectionName});
                        continue;
                    }
                    logger.warnV(" connection %s is missing", new Object[]{sourceConnectionName});
                    throw ErrorContext.iaef((String)"Missing connection %s for %s", (Object)sourceConnectionName, (Object[])new Object[]{objectDescription});
                }
                if (sourceConnection == null) {
                    logger.infoV("source connection type unknown, using %s of type %s", new Object[]{unremapped.name, unremapped.type});
                    continue;
                }
                if (!unremapped.getType().equals(sourceConnection.type)) {
                    throw ErrorContext.iaef((String)"Invalid connection type for %s: found %s, expected %s", (Object)sourceConnection.name, (Object[])new Object[]{unremapped.getType(), sourceConnection.type});
                }
                if (!unremapped.isFreelyUsableBy(this.authCtx)) {
                    throw ErrorContext.iaef((String)"Invalid connection for %s : %s (%s) is not freely usable and needs to be remapped.", (Object)objectDescription, (Object[])new Object[]{sourceConnection.name, unremapped.getType()});
                }
                logger.infoV("connection type %s is correct", new Object[]{sourceConnection.type});
                continue;
            }
            DSSConnection remapped = this.connectionsDAO.getConnection(this.authCtx, remapping.target);
            if (remapped == null) {
                if (this.isAllowedMissing(sourceConnectionName)) {
                    logger.infoV(" connection %s is missing (remapped to %s), but allowed to be missing", new Object[]{sourceConnectionName, remapping.target});
                    continue;
                }
                logger.warnV(" connection %s is missing (remapped to %s)", new Object[]{sourceConnectionName, remapping.target});
                throw ErrorContext.iaef((String)"Missing connection %s (remapped to %s)", (Object)sourceConnectionName, (Object[])new Object[]{remapping.target});
            }
            if (sourceConnection == null) {
                logger.infoV("source connection type unknown, using %s of type %s", new Object[]{remapped.name, remapped.type});
            } else {
                if (!remapped.getType().equals(sourceConnection.type)) {
                    throw ErrorContext.iaef((String)"Invalid connection type for %s: found %s, expected %s", (Object)sourceConnection.name, (Object[])new Object[]{remapped.getType(), sourceConnection.type});
                }
                if (!remapped.isFreelyUsableBy(this.authCtx)) {
                    throw ErrorContext.iaef((String)"Invalid connection for %s : %s (%s) is not freely usable and needs to be mapped to an usable connection.", (Object)objectDescription, (Object[])new Object[]{sourceConnection.name, remapped.getType()});
                }
                logger.infoV("connection type %s is correct", new Object[]{sourceConnection.type});
            }
            replacements.put(remapping.source, remapping.target);
        }
        return replacements;
    }

    private static enum FeatureRemapVersion {
        BASE_LLM_CONNECTIONS(12600),
        AGENT_TOOLS(13500);

        private final int minVersion;

        private FeatureRemapVersion(int minVersion) {
            this.minVersion = minVersion;
        }
    }

    public static class RecipeRemappingResult {
        RecipePayloadParams payloadParams;
        boolean wasRemapped;

        private RecipeRemappingResult(boolean wasRemapped, RecipePayloadParams payloadParams) {
            this.wasRemapped = wasRemapped;
            this.payloadParams = payloadParams;
        }

        public static RecipeRemappingResult withRemapping(RecipePayloadParams payloadParams) {
            return new RecipeRemappingResult(true, payloadParams);
        }

        public static RecipeRemappingResult withoutRemapping() {
            return new RecipeRemappingResult(false, null);
        }
    }
}

