/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureHistoryService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.nodeclients.ProjectDeployerClientProxyUser;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundlePreparator;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectBundleExporter;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectBundleCreatedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignBundlesService
extends AbstractBundleService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureHistoryService futureHistoryService;
    @Autowired
    private LicenseEnforcementService licenseService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.projects.import");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validBundleIdExists(String projectKey, String bundleId) {
        File bundleFolder = this.getBundleDirectory(projectKey, bundleId);
        if (bundleFolder.isDirectory() && Objects.requireNonNull(bundleFolder.list()).length > 0) {
            return true;
        }
        DesignBundlesService designBundlesService = this;
        synchronized (designBundlesService) {
            for (FutureHistoryService.FutureHistoryItem fhi : this.futureHistoryService.getAllByPrefix(DesignBundlesService.futureHistoryPrefix(projectKey))) {
                if (!bundleId.equals(fhi.context.get("bundleId")) || fhi.storedError != null || fhi.lastResponse.aborted) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonBundleUtils.BundleInfoList listAvailable(String projectKey) throws IOException {
        CommonBundleUtils.BundleInfoList ret = new CommonBundleUtils.BundleInfoList();
        File bundlesFolder = ApplicationConfigurator.getFile((String[])new String[]{"prepared_bundles", projectKey});
        if (!bundlesFolder.isDirectory()) {
            return ret;
        }
        for (File candidate : bundlesFolder.listFiles()) {
            File bundleFile;
            if (!candidate.isDirectory() || !(bundleFile = DKUFileUtils.getWithin((File)candidate, (String[])new String[]{"dss-bundle-" + projectKey + "-" + candidate.getName() + ".zip"})).isFile()) continue;
            CommonBundleUtils.ExportedBundleSummary eb = new CommonBundleUtils.ExportedBundleSummary();
            eb.state = CommonBundleUtils.BundleState.BUILT;
            new CommonBundleUtils().summarizeFromArchive(bundleFile, eb);
            this.addPublishedBundleState(eb);
            ret.bundles.add(eb);
        }
        DesignBundlesService designBundlesService = this;
        synchronized (designBundlesService) {
            for (FutureHistoryService.FutureHistoryItem fhi : this.futureHistoryService.getAllByPrefix(DesignBundlesService.futureHistoryPrefix(projectKey))) {
                CommonBundleUtils.ExportedBundleSummary ab = new CommonBundleUtils.ExportedBundleSummary();
                ab.bundleId = fhi.context.get("bundleId");
                ab.futureItem = fhi;
                ab.state = fhi.storedError != null ? CommonBundleUtils.BundleState.FAILED : (fhi.lastResponse.aborted ? CommonBundleUtils.BundleState.ABORTED : CommonBundleUtils.BundleState.BUILDING);
                ret.bundles.add(ab);
            }
        }
        return ret;
    }

    public CommonBundleUtils.BundleDetails getBundleDetails(String projectKey, String bundleId) throws Exception {
        File bundleFile = this.getBundleArchive(projectKey, bundleId);
        return CommonBundleUtils.getDetailsFromArchive(bundleFile);
    }

    @Override
    public File getBundleArchive(String projectKey, String bundleId) {
        return DKUFileUtils.getWithin((File)this.getBundleDirectory(projectKey, bundleId), (String[])new String[]{this.getBundleTag(projectKey, bundleId) + ".zip"});
    }

    @Override
    public File getBundleDirectory(String projectKey, String bundleId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"prepared_bundles", projectKey, bundleId});
    }

    public BundleExporterSettings getBundleExporterSettings(String projectKey) throws IOException {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        if (sp.bundleExporterSettings == null) {
            return new BundleExporterSettings();
        }
        return sp.bundleExporterSettings;
    }

    public void saveBundleExporterSettings(String projectKey, BundleExporterSettings settings) throws Exception {
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        sp.bundleExporterSettings = settings;
        this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
    }

    public BundlePreparator.BundlePreparationResult prepareBundle_NT(String projectKey) throws Exception {
        BundlePreparator preparator = new BundlePreparator(projectKey);
        return preparator.run();
    }

    public FutureResponse<BundlePreparator.BundlePreparationResult> startPrepareBundle_NT(AuthCtx user, String projectKey) throws Exception {
        PreparationFutureThread pft = new PreparationFutureThread(user, projectKey);
        return this.futureService.runFuture(pft, 1000L, new TypeToken<FutureResponse<BundlePreparator.BundlePreparationResult>>(){});
    }

    public static FuturePayload buildPrepareFuturePayload(String projectKey) {
        FuturePayload fp = new FuturePayload();
        fp.action = "prepare";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, ITaggingService.TaggableType.PROJECT.name()).withPart("bundles"));
        fp.displayName = "Prepare bundle export of " + projectKey;
        return fp;
    }

    private void exportBundle_NT(String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, ExportedProject.ExportUserInfo userInfo, boolean evaluateProjectStandardsChecks, AuthCtx user) throws Exception {
        SerializedProject sp;
        try (Transaction t = this.transactionService.beginRead();){
            sp = this.projectsService.getMandatory(projectKey);
        }
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features = this.licenseService.getFeaturesStatus();
        if (!features.bundlesAllowed) {
            throw new LicenseRestrictionException("Bundles are not enabled in your license");
        }
        if (sp.bundleExporterSettings == null) {
            sp.bundleExporterSettings = new BundleExporterSettings();
        }
        this.deleteFailedBundle(projectKey, bundleId);
        File bundleFolder = this.getBundleDirectory(projectKey, bundleId);
        if (bundleFolder.isDirectory()) {
            throw ErrorContext.iaef((String)"Bundle %s already exists for project %s", (Object)bundleId, (Object[])new Object[]{projectKey});
        }
        DKUFileUtils.mkdirs((File)bundleFolder);
        if (evaluateProjectStandardsChecks && !this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed) {
            evaluateProjectStandardsChecks = false;
            logger.warn((Object)"Project standards check requested, but this feature is not permitted by your current license. Disabling functionality.");
        }
        File targetArchive = DKUFileUtils.getWithin((File)bundleFolder, (String[])new String[]{"dss-bundle-" + projectKey + "-" + bundleId + ".zip"});
        ProjectBundleExporter bundleExporter = new ProjectBundleExporter(user, sp.bundleExporterSettings, null, userInfo, projectKey, bundleId, designNodeInstallId, designNodeId, designNodeUrl, targetArchive, evaluateProjectStandardsChecks);
        bundleExporter.export();
        logger.info((Object)"done");
        String tag = this.getBundleTag(projectKey, bundleId);
        String message = "Created Bundle for project " + projectKey + ": " + bundleId;
        this.projectsGitService.addProjectTag_NT(user, projectKey, tag, message, null);
        this.pubSub.publish((DSSEvent)new ProjectBundleCreatedEvent(projectKey, bundleId));
    }

    public FutureResponse<ProjectBundleExporter.BundleExportReport> startExportBundle_NT(String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, ExportedProject.ExportUserInfo userInfo, boolean evaluateProjectStandardsChecks, AuthCtx user) throws Exception {
        if (!bundleId.matches("^[a-zA-Z0-9_-]+$")) {
            throw ErrorContext.iaef((String)"Bundle ID is invalid: %s", (Object)bundleId, (Object[])new Object[0]);
        }
        this.futureHistoryService.removeWithPrefix(DesignBundlesService.futureHistoryPrefix(projectKey));
        DirectExportFutureThread pft = new DirectExportFutureThread(user, projectKey, bundleId, designNodeInstallId, designNodeId, designNodeUrl, userInfo, evaluateProjectStandardsChecks);
        FutureResponse<ProjectBundleExporter.BundleExportReport> futureResponse = this.futureService.runFuture(pft, 0L, new TypeToken<FutureResponse<ProjectBundleExporter.BundleExportReport>>(){});
        this.futureHistoryService.register(DesignBundlesService.futureHistoryKey(projectKey, bundleId), futureResponse, "bundleId", bundleId);
        return futureResponse;
    }

    private static FuturePayload buildExportFuturePayload(String projectKey, String bundleId, boolean direct) {
        FuturePayload fp = new FuturePayload();
        fp.action = "export_bundle";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, bundleId, ITaggingService.TaggableType.PROJECT.name(), null).withPart("bundles"));
        fp.withExtra("direct", (Object)direct);
        fp.displayName = "Export bundle " + projectKey + "/" + bundleId;
        return fp;
    }

    private void exportBundleWithPreparation_NT(String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, BundlePreparator.BundlePreparationResult result, boolean evaluateProjectStandardsChecks, AuthCtx user) throws Exception {
        SerializedProject sp;
        Validate.notNull((Object)result.exporterSettings);
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus features = this.licenseService.getFeaturesStatus();
        if (!features.bundlesAllowed) {
            throw new LicenseRestrictionException("Bundles are not enabled in your license");
        }
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(user);){
            sp = this.projectsService.getMandatory(projectKey);
            if (sp.bundleExporterSettings == null || !JSON.jsonEquals((Object)sp.bundleExporterSettings, (Object)result.exporterSettings)) {
                sp.bundleExporterSettings = result.exporterSettings;
                this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
                rwt.commit("Updated bundle exporter settings");
            }
        }
        this.deleteFailedBundle(projectKey, bundleId);
        File bundleFolder = this.getBundleDirectory(projectKey, bundleId);
        if (bundleFolder.isDirectory()) {
            throw ErrorContext.iaef((String)"Bundle %s already exists for project %s", (Object)bundleId, (Object[])new Object[]{projectKey});
        }
        DKUFileUtils.mkdirs((File)bundleFolder);
        if (evaluateProjectStandardsChecks && !this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed) {
            evaluateProjectStandardsChecks = false;
            logger.warn((Object)"Project standards check requested, but this feature is not permitted by your current license. Disabling functionality.");
        }
        File targetArchive = DKUFileUtils.getWithin((File)bundleFolder, (String[])new String[]{"dss-bundle-" + projectKey + "-" + bundleId + ".zip"});
        ProjectBundleExporter bundleExporter = new ProjectBundleExporter(user, sp.bundleExporterSettings, result.changelog, result.exportUserInfo, projectKey, bundleId, designNodeInstallId, designNodeId, designNodeUrl, targetArchive, evaluateProjectStandardsChecks);
        bundleExporter.export();
        logger.info((Object)"done");
        String tag = this.getBundleTag(projectKey, bundleId);
        String message = "Created Bundle for project " + projectKey + ": " + bundleId;
        this.projectsGitService.addProjectTag_NT(user, projectKey, tag, message, null);
        this.pubSub.publish((DSSEvent)new ProjectBundleCreatedEvent(projectKey, bundleId));
    }

    public FutureResponse<ProjectBundleExporter.BundleExportReport> startExportBundleWithPreparation_NT(String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, BundlePreparator.BundlePreparationResult result, boolean evaluateProjectStandardsChecks, AuthCtx user) throws Exception {
        if (!bundleId.matches("^[a-zA-Z0-9_-]+$")) {
            throw ErrorContext.iaef((String)"Bundle ID is invalid: %s", (Object)bundleId, (Object[])new Object[0]);
        }
        this.futureHistoryService.removeWithPrefix(DesignBundlesService.futureHistoryPrefix(projectKey));
        BundleExportFutureThread pft = new BundleExportFutureThread(user, projectKey, bundleId, designNodeInstallId, designNodeId, designNodeUrl, result, evaluateProjectStandardsChecks);
        FutureResponse<ProjectBundleExporter.BundleExportReport> futureResponse = this.futureService.runFuture(pft, 0L, new TypeToken<FutureResponse<ProjectBundleExporter.BundleExportReport>>(){});
        this.futureHistoryService.register(DesignBundlesService.futureHistoryKey(projectKey, bundleId), futureResponse, "bundleId", bundleId);
        return futureResponse;
    }

    public void deleteAllForProject(String projectKey) throws IOException {
        File folder = ApplicationConfigurator.getFile((String[])new String[]{"prepared_bundles", projectKey});
        if (folder.isDirectory()) {
            DKUFileUtils.forceDelete((File)folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFailedBundle(String projectKey, String bundleId) throws Exception {
        DesignBundlesService designBundlesService = this;
        synchronized (designBundlesService) {
            FutureHistoryService.FutureHistoryItem fhi = this.futureHistoryService.getSingleByPrefix(DesignBundlesService.futureHistoryKey(projectKey, bundleId));
            if (fhi.storedError != null || fhi.lastResponse.aborted) {
                this.futureHistoryService.removeWithPrefix(DesignBundlesService.futureHistoryKey(projectKey, bundleId));
            }
        }
        this.deleteEmptyBundleFolder(projectKey, bundleId);
    }

    public void deleteEmptyBundleFolder(String projectKey, String bundleId) throws IOException {
        File bundleDirectory = this.getBundleDirectory(projectKey, bundleId);
        if (bundleDirectory.isDirectory() && Objects.requireNonNull(bundleDirectory.list()).length == 0) {
            DKUFileUtils.forceDelete((File)bundleDirectory);
            logger.infoV("Delete aborted bundle %s folder in project %s", new Object[]{bundleId, projectKey});
        }
    }

    private File getPublishInfoFile(String projectKey, String bundleId) {
        return DKUApp.getFile((File)this.getBundleDirectory(projectKey, bundleId), (String[])new String[]{"publish-info.json"});
    }

    private void addPublishedBundleState(CommonBundleUtils.ExportedBundleSummary ret) throws IOException {
        File publishInfoFile = this.getPublishInfoFile(ret.exportManifest.originalProjectKey, ret.bundleId);
        if (publishInfoFile.exists()) {
            ret.publishedBundleState = (CommonBundleUtils.PublishedBundleState)JSON.parseFile((File)publishInfoFile, CommonBundleUtils.PublishedBundleState.class);
        }
    }

    public CommonBundleUtils.PublishedBundleState writePublishedBundleState(PublishedPackageInfo publishedPackageInfo, String designProjectKey, String publishedProjectKey, String bundleId, AuthCtx authCtx) throws IOException {
        CommonBundleUtils.PublishedBundleState pbs = new CommonBundleUtils.PublishedBundleState();
        pbs.publishedOn = publishedPackageInfo.publishedOn;
        pbs.publishedBy = authCtx.getIdentifier();
        pbs.publishedProjectKey = publishedProjectKey;
        JSON.prettyToFile((Object)pbs, (File)this.getPublishInfoFile(designProjectKey, bundleId));
        return pbs;
    }

    public CommonBundleUtils.PublishedBundleState publishBundle(String designProjectKey, @Nullable String publishedProjectKey, String bundleId, AuthCtx authCtx) throws IOException, UnauthorizedException {
        PublishedPackageInfo packageInfo;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        publishedProjectKey = StringUtils.isNotBlank((String)publishedProjectKey) ? publishedProjectKey : designProjectKey;
        logger.infoV("Publishing bundle %s to project %s on Project Deployer (Design node project %s)", new Object[]{bundleId, publishedProjectKey, designProjectKey});
        File bundleArchive = this.getBundleArchive(designProjectKey, bundleId);
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Project Deployer support is disabled");
            }
            case LOCAL: {
                try (FileInputStream is = new FileInputStream(bundleArchive);){
                    packageInfo = ((PublishedProjectsService)SpringUtils.getBean(PublishedProjectsService.class)).publishBundleFromStream_NT_Check(authCtx, publishedProjectKey, is);
                    break;
                }
            }
            case REMOTE: {
                try (ProjectDeployerClientProxyUser client = new ProjectDeployerClientProxyUser(ref, authCtx);){
                    packageInfo = client.publishBundle(publishedProjectKey, bundleArchive);
                    break;
                }
            }
            default: {
                throw ErrorContext.iaef((String)"Invalid mode for Project Deployer: %s", (Object)((Object)ref.mode), (Object[])new Object[0]);
            }
        }
        return this.writePublishedBundleState(packageInfo, designProjectKey, publishedProjectKey, bundleId, authCtx);
    }

    private static String futureHistoryPrefix(String projectKey) {
        return "dku.bundles.export." + projectKey;
    }

    private static String futureHistoryKey(String projectKey, String bundleId) {
        return "dku.bundles.export." + projectKey + "." + bundleId;
    }

    private class PreparationFutureThread
    extends SimpleFutureThread<BundlePreparator.BundlePreparationResult> {
        private String projectKey;
        private final FuturePayload futurePayload;

        public PreparationFutureThread(AuthCtx owner, String projectKey) {
            super(owner);
            this.projectKey = projectKey;
            this.futurePayload = DesignBundlesService.buildPrepareFuturePayload(projectKey);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public BundlePreparator.BundlePreparationResult compute() throws Exception {
            return DesignBundlesService.this.prepareBundle_NT(this.projectKey);
        }
    }

    public class DirectExportFutureThread
    extends SimpleFutureThread<ProjectBundleExporter.BundleExportReport> {
        private String projectKey;
        private String bundleId;
        private String designNodeInstallId;
        private String designNodeId;
        private String designNodeUrl;
        private final FuturePayload futurePayload;
        private final ExportedProject.ExportUserInfo userInfo;
        private final boolean evaluateProjectStandardsChecks;

        DirectExportFutureThread(AuthCtx user, String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, ExportedProject.ExportUserInfo userInfo, boolean evaluateProjectStandardsChecks) {
            super(user);
            this.projectKey = projectKey;
            this.bundleId = bundleId;
            this.designNodeInstallId = designNodeInstallId;
            this.designNodeId = designNodeId;
            this.designNodeUrl = designNodeUrl;
            this.futurePayload = DesignBundlesService.buildExportFuturePayload(projectKey, bundleId, true);
            this.userInfo = userInfo;
            this.evaluateProjectStandardsChecks = evaluateProjectStandardsChecks;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ProjectBundleExporter.BundleExportReport compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Building bundle", (double)17.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                DesignBundlesService.this.exportBundle_NT(this.projectKey, this.bundleId, this.designNodeInstallId, this.designNodeId, this.designNodeUrl, this.userInfo, this.evaluateProjectStandardsChecks, this.owner);
                DesignBundlesService.this.futureHistoryService.removeWithPrefix(DesignBundlesService.futureHistoryKey(this.projectKey, this.bundleId));
            }
            return new ProjectBundleExporter.BundleExportReport();
        }
    }

    public class BundleExportFutureThread
    extends SimpleFutureThread<ProjectBundleExporter.BundleExportReport> {
        private String projectKey;
        private String bundleId;
        private String designNodeInstallId;
        private String designNodeId;
        private String designNodeUrl;
        private BundlePreparator.BundlePreparationResult preparationResult;
        private boolean evaluateProjectStandardsChecks;
        private final FuturePayload futurePayload;

        BundleExportFutureThread(AuthCtx user, String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, BundlePreparator.BundlePreparationResult preparationResult, boolean evaluateProjectStandardsChecks) {
            super(user);
            this.projectKey = projectKey;
            this.bundleId = bundleId;
            this.designNodeInstallId = designNodeInstallId;
            this.designNodeId = designNodeId;
            this.designNodeUrl = designNodeUrl;
            this.preparationResult = preparationResult;
            this.evaluateProjectStandardsChecks = evaluateProjectStandardsChecks;
            this.futurePayload = DesignBundlesService.buildExportFuturePayload(projectKey, bundleId, false);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public ProjectBundleExporter.BundleExportReport compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Building bundle", (double)17.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                DesignBundlesService.this.exportBundleWithPreparation_NT(this.projectKey, this.bundleId, this.designNodeInstallId, this.designNodeId, this.designNodeUrl, this.preparationResult, this.evaluateProjectStandardsChecks, this.owner);
                DesignBundlesService.this.futureHistoryService.removeWithPrefix(DesignBundlesService.futureHistoryKey(this.projectKey, this.bundleId));
            }
            return new ProjectBundleExporter.BundleExportReport();
        }
    }
}

