/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.export.output.ExportToStream;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectExporterBase;
import com.dataiku.dip.projects.importexport.model.BundleChangelog;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.projects.ProjectSummaryService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipReadFS;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectBundleExporter
extends ProjectExporterBase {
    public static final int EXPORT_STEP_COUNT = 17;
    public static final String PROJECT_STANDARDS_REPORT_FILENAME = "project-standards-bundle-report.json";
    private static final int DEFAULT_EXPORT_MAX_SIZE_MB = 20000;
    private final File targetArchive;
    private final BundleExporterSettings exporterSettings;
    private final BundleChangelog changelog;
    private final String bundleId;
    private final String designNodeInstallId;
    private final String designNodeId;
    private final String designNodeUrl;
    private final ExportedProject.ExportUserInfo userInfo;
    private final boolean evaluateProjectStandardsChecks;
    private final BundleContentSummary contentSummary = new BundleContentSummary();
    @Autowired
    private ProjectSummaryService projectSummaryService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.projects.export");

    public ProjectBundleExporter(AuthCtx authCtx, BundleExporterSettings exporterSettings, BundleChangelog changelog, ExportedProject.ExportUserInfo userInfo, String projectKey, String bundleId, String designNodeInstallId, String designNodeId, String designNodeUrl, File targetArchive, boolean evaluateProjectStandardsChecks) throws IOException {
        super(authCtx);
        this.changelog = changelog;
        this.exporterSettings = exporterSettings;
        this.userInfo = userInfo;
        this.projectKey = projectKey;
        this.designNodeInstallId = designNodeInstallId;
        this.designNodeId = designNodeId;
        this.designNodeUrl = designNodeUrl;
        this.targetArchive = targetArchive;
        this.bundleId = bundleId;
        this.evaluateProjectStandardsChecks = evaluateProjectStandardsChecks;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public BundleExportReport getReport() {
        return new BundleExportReport();
    }

    public void export() throws Exception {
        File targetArchiveTmp;
        try (Transaction t = this.transactionService.beginRead();){
            this.customPolicyHooksRegistry.onPreProjectExport(this.authCtx, this.projectKey, this.exporterSettings.exportOptions);
        }
        ExportedProject ep = new ExportedProject();
        ep.originalProjectKey = this.projectKey;
        ep.designNodeInstallId = this.designNodeInstallId;
        ep.designNodeId = this.designNodeId;
        ep.designNodeUrl = this.designNodeUrl;
        ep.bundleId = this.bundleId;
        ep.exportedWithOptions = (ProjectExportOptions)JSON.deepCopy((Object)this.exporterSettings.exportOptions);
        ep.generatedWithDSSVersion = ApplicationConfigurator.getDSSVersion().product_version;
        ep.generatedWithDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        ep.exportUserInfo = this.userInfo == null ? new ExportedProject.ExportUserInfo() : this.userInfo;
        ep.exportUserInfo.exportedBy = this.authCtx.getIdentifier();
        ep.exportUserInfo.exportedOn = DKUDateUtils.isoFormatLocalNow();
        if (this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed) {
            ep.projectStandardsSkipped = !this.evaluateProjectStandardsChecks;
        }
        long maxFileSizeMB = DKUApp.getParams().getLongParam("dku.exports.projectBundle.maxSizeMB", 20000L);
        File archiveWithoutProjectStandardsTmp = new File(this.targetArchive.getParent(), this.targetArchive.getName() + ".tmp");
        try (FileOutputStream fileOutputStream = new FileOutputStream(archiveWithoutProjectStandardsTmp, false);
             ExportToStream.MonitoredOutputStream monitoredStream = new ExportToStream.MonitoredOutputStream(fileOutputStream, maxFileSizeMB);
             ZipWriteFS zipWriteFS = new ZipWriteFS((OutputStream)((Object)monitoredStream));){
            logger.info((Object)"Exporting config ...");
            this.targetZipFS = zipWriteFS;
            try (Transaction t = this.transactionService.beginRead();
                 FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Exporting config");){
                ep.exportedWithOptions.includedCodeStudios.addAll(this.gatherIncludedCodeStudiosUsedByWebapps_T());
                RelFileFilter filter = this.makeConfigCopyFilter(ep.exportedWithOptions.includedCodeStudios).and(this.makeConfigCopyExcludeEditableDatasetsFilter()).and(this.makeConfigCopyIncludeNotebook(ep.exportedWithOptions.exportNotebooks));
                this.exportConfig(filter, ep.exportedWithOptions.exportNotebooks && !ep.exportedWithOptions.exportNotebooksWithOutputs, true, false);
                this.exportUserDefinedMeanings();
                this.contentSummary.configContent = this.projectSummaryService.computeConfigContent(this.projectKey);
                this.gatherUsedConnections(ep, null);
                this.gatherUsedCodeEnvs(ep, null, ep.exportedWithOptions.exportNotebooks);
                this.gatherUsedContainerExecConfs(ep, null);
                this.gatherInstalledPlugins(ep);
                this.gatherCodeStudioTemplates_T(ep);
                ProjectFlowGraph projectGraph = this.graphService.getProjectGraphWithOrphansUnsafe(this.projectKey, false);
                this.gatherUsedForeignObjects(projectGraph, ep);
            }
            FutureProgress.updateState((double)1.0);
            this.exportSavedModelsData(ep.exportedWithOptions.includedSavedModels, this.contentSummary, null, ep.exportedWithOptions.exportSavedModelsRequiredVersions);
            FutureProgress.updateState((double)2.0);
            this.exportModelEvaluationStoresData(ep.exportedWithOptions.includedModelEvaluationStores, this.contentSummary, null);
            FutureProgress.updateState((double)3.0);
            this.exportDatasetsData(ep.exportedWithOptions.includedDatasetsData, ep.exportedWithOptions.exportDatasetResources, this.contentSummary, null);
            FutureProgress.updateState((double)4.0);
            this.exportManagedFoldersData(ep.exportedWithOptions.includedManagedFolders, this.contentSummary, null);
            FutureProgress.updateState((double)5.0);
            this.exportCodeStudiosData(ep.exportedWithOptions.includedCodeStudios, this.contentSummary, null);
            FutureProgress.updateState((double)6.0);
            this.exportKnowledgeBankData(ep.exportedWithOptions.includedKnowledgeBanks, this.contentSummary, null);
            FutureProgress.updateState((double)7.0);
            this.exportLabelingTasksData(ep.exportedWithOptions.includedLabelingTasks, this.contentSummary, null);
            FutureProgress.updateState((double)8.0);
            this.exportTimelines();
            FutureProgress.updateState((double)9.0);
            this.exportWikiData();
            FutureProgress.updateState((double)10.0);
            if (ep.exportedWithOptions.exportProjectResources) {
                this.exportProjectResources();
            }
            FutureProgress.updateState((double)11.0);
            if (ep.exportedWithOptions.exportNotebooks && ep.exportedWithOptions.exportNotebooksWithOutputs) {
                this.exportNotebooksWithOutputs();
            }
            FutureProgress.updateState((double)12.0);
            this.exportCodeEnvs(ep);
            if (ep.exportedWithOptions.exportInsightsData) {
                this.contentSummary.insightsData = true;
                this.exportInsightsData();
            }
            FutureProgress.updateState((double)13.0);
            this.exportPromptStudioHistories(ep.exportedWithOptions.includedPromptStudiosHistories, this.contentSummary, null);
            FutureProgress.updateState((double)14.0);
            if (ep.exportedWithOptions.exportAgentReviews) {
                this.exportAgentReviewsTestsData();
            }
            FutureProgress.updateState((double)15.0);
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Creating export archive");){
                logger.info((Object)"Finalizing bundle export ...");
                ep.actualContent = this.contentSummary;
                this.targetZipFS.writeObject("export-manifest.json", (Object)ep);
                if (this.changelog != null) {
                    this.targetZipFS.writeObject("changelog.json", (Object)this.changelog);
                }
            }
        }
        catch (Exception e) {
            DKUFileUtils.delete((File)archiveWithoutProjectStandardsTmp);
            this.throwIfExportTooLarge(e);
            throw e;
        }
        if (this.evaluateProjectStandardsChecks) {
            targetArchiveTmp = this.runProjectStandards(archiveWithoutProjectStandardsTmp);
        } else {
            logger.info((Object)"Not computing Project Standards Check on bundle.");
            targetArchiveTmp = archiveWithoutProjectStandardsTmp;
        }
        FutureProgress.updateState((double)16.0);
        try {
            FileUtils.moveFile((File)targetArchiveTmp, (File)this.targetArchive);
        }
        catch (Exception e) {
            DKUFileUtils.delete((File)targetArchiveTmp);
            DKUFileUtils.delete((File)this.targetArchive);
            throw e;
        }
        FutureProgress.updateState((double)17.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File runProjectStandards(File archiveWithoutProjectStandardsTmp) throws Exception {
        logger.infoV("Running project standards checks on project %s", new Object[]{this.projectKey});
        File targetArchiveTmp = new File(this.targetArchive.getParent(), this.targetArchive.getName() + ".with-report.tmp");
        try {
            ProjectStandardsService projectStandardsService = (ProjectStandardsService)SpringUtils.getBean(ProjectStandardsService.class);
            FutureResponse<ProjectStandardsRunReport> finalResponse = projectStandardsService.runAndWait_NT(this.authCtx, this.projectKey, null);
            ProjectStandardsRunReport report = (ProjectStandardsRunReport)finalResponse.result;
            logger.traceV("Project standards run report: %s", new Object[]{JSON.prettyLog((Object)report)});
            this.addProjectStandardsReport(archiveWithoutProjectStandardsTmp, report, targetArchiveTmp);
            logger.debugV("Added project standards report to tmp archive at %s", new Object[]{targetArchiveTmp.getAbsolutePath()});
            projectStandardsService.saveLastReport(report);
            logger.debugV("Report from bundle has also been saved in project %s", new Object[]{report.projectKey});
        }
        finally {
            DKUFileUtils.delete((File)archiveWithoutProjectStandardsTmp);
        }
        return targetArchiveTmp;
    }

    public void addProjectStandardsReport(File archiveWithoutProjectStandardsTmp, ProjectStandardsRunReport report, @Nonnull File tmpArchiveWithReport) throws Exception {
        long maxFileSizeMB = DKUApp.getParams().getLongParam("dku.exports.projectBundle.maxSizeMB", 20000L);
        try (ZipReadFS zipReadFS = new ZipReadFS(archiveWithoutProjectStandardsTmp);
             FileOutputStream targetArchiveOutputStream = new FileOutputStream(tmpArchiveWithReport);
             ExportToStream.MonitoredOutputStream monitoredStream = new ExportToStream.MonitoredOutputStream(targetArchiveOutputStream, maxFileSizeMB);
             ZipWriteFS zipWriteFS = new ZipWriteFS((OutputStream)((Object)monitoredStream));){
            logger.info((Object)"Adding project standards run report to bundle archive...");
            FSUtils.newRecursiveCopy().from((ReadOnlyFS)zipReadFS).to((ReadWriteFS)zipWriteFS).run();
            zipWriteFS.writeObject(PROJECT_STANDARDS_REPORT_FILENAME, (Object)report);
        }
        catch (Exception e) {
            DKUFileUtils.delete((File)tmpArchiveWithReport);
            this.throwIfExportTooLarge(e);
            throw e;
        }
    }

    private long exportUserDefinedMeanings() throws IOException {
        RelFile src = new RelFile(new String[]{"config", "meanings"});
        RelFile tgt = new RelFile(new String[]{"meanings"});
        if (this.dataDirFS.isDirectory(src)) {
            this.zipDirectory(src, tgt);
            return FSUtils.calculateSize((ReadOnlyFS)this.targetZipFS, (RelFile)tgt);
        }
        this.targetZipFS.makeDirectory(tgt);
        return 0L;
    }

    public static class BundleExportReport {
    }
}

