/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.queries;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.debug.DebugSleeper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.hive.Hiveserver2LogSniffer;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.SynapseSQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.hproxy.utils.HiveUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class SQLQueryRuntime {
    private final SQLConnectionProvider.SQLConnectionData connectionData;
    private final AuthCtx authCtx;
    private final String projectKey;
    private final QueryParams queryDesc;
    private final boolean ownsTheConnection;
    private SQLConnectionProvider.SQLConnectionWrapper conn;
    private StatementState[] stmts;
    private ComputeResourceUsage mainStatementCRU;
    private int selectStmtIndex;
    private List<String> warningMessages = new ArrayList<String>();
    private int maxRows;
    private QueryBunch queryBunch;
    private Statement currentStatement;
    private Hiveserver2LogSniffer logSniffer;
    private final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
    private final List<Object> parameterValues;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql.runtime");

    @Nullable
    public ComputeResourceUsage getMainStatementCRU() {
        return this.mainStatementCRU;
    }

    public SQLQueryRuntime(String projectKey, QueryParams queryDesc, List<Object> paramValues, AuthCtx authCtx) throws IOException, DKUSecurityException, SQLException {
        this(queryDesc, paramValues, SQLConnectionProvider.getConnectionData_NT(authCtx, projectKey, queryDesc), authCtx, projectKey);
    }

    public SQLQueryRuntime(QueryParams queryDesc, List<Object> paramValues, SQLConnectionProvider.SQLConnectionData connectionData, AuthCtx authCtx, String projectKey) {
        this.queryDesc = queryDesc;
        this.connectionData = connectionData;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.ownsTheConnection = true;
        this.parameterValues = paramValues;
        if (connectionData.getDialect().needsToHaveTrailingSemicolonsRemoved()) {
            this.queryDesc.sql = HiveUtils.removeTrailingSemicolons((String)this.queryDesc.sql);
        }
    }

    public SQLQueryRuntime(QueryParams queryDesc, List<Object> paramValues, SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, AuthCtx authCtx, String projectKey) {
        this.queryDesc = queryDesc;
        this.connectionData = connectionData;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.ownsTheConnection = false;
        this.parameterValues = paramValues;
        this.conn = conn;
        if (connectionData.getDialect().needsToHaveTrailingSemicolonsRemoved()) {
            this.queryDesc.sql = HiveUtils.removeTrailingSemicolons((String)this.queryDesc.sql);
        }
    }

    public SQLQueryRuntime(QueryBunch queryBunch, SQLConnectionProvider.SQLConnectionData connectionData, AuthCtx authCtx, String projectKey) {
        this.queryDesc = new QueryParams();
        this.queryBunch = queryBunch;
        this.connectionData = connectionData;
        this.ownsTheConnection = true;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.parameterValues = null;
    }

    private void cancelStatement(Statement stmt, String text) throws SQLException {
        logger.info((Object)("Cancelling statement:" + String.valueOf(stmt) + " (" + text + ")"));
        DebugSleeper.sleepUninterruptible((String)"sql.query.abort");
        stmt.cancel();
    }

    public void cancel() throws SQLException {
        if (this.logSniffer != null) {
            try {
                this.logSniffer.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Unable to stop log sniffing", (Throwable)e);
            }
            this.logSniffer = null;
        }
        if (this.stmts != null) {
            for (StatementState stmt : this.stmts) {
                if (stmt.pstmt != null) {
                    this.cancelStatement(stmt.pstmt, stmt.text);
                }
                if (stmt.stmt == null) continue;
                this.cancelStatement(stmt.stmt, stmt.text);
            }
            if (this.connectionData.getType() == ConnectionUtils.SQLConnectionType.MYSQL) {
                SQLQueryRecipeUtils.killMySQLConnection(this.connectionData, this.conn, this.authCtx, this.projectKey);
            }
        }
    }

    public void init(int maxRows) throws SQLException, DKUSecurityException, InterruptedException {
        if (this.ownsTheConnection) {
            this.conn = SQLConnectionProvider.newConnection(this.connectionData, this.authCtx, this.projectKey);
        }
        if (this.queryDesc.querySettings.statementsOutOfTransaction) {
            SQLUtils.unsafeSetAutoCommit(this.conn, true);
            if (this.connectionData.getDialect() instanceof SynapseSQLDialect) {
                SQLUtils.safeExec(this.conn, "ROLLBACK TRANSACTION");
            }
        }
        this.maxRows = maxRows;
        String[] sqlStatements = null;
        int selectStatementIndex = -1;
        if (this.queryBunch != null) {
            ArrayList allSqls = Lists.newArrayList();
            allSqls.addAll(this.queryBunch.preQueries);
            allSqls.add(this.queryBunch.query);
            allSqls.addAll(this.queryBunch.postQueries);
            sqlStatements = allSqls.toArray(new String[0]);
            selectStatementIndex = this.queryBunch.preQueries.size();
            logger.info((Object)("Received " + sqlStatements.length + " parts and the index of the select is " + selectStatementIndex));
        } else {
            String sql = this.queryDesc.sql;
            logger.infoV("Will execute, limit=%s parseMode=%s execMode=%s sql=%s", new Object[]{this.queryDesc.querySettings.addLimitToStatement, this.queryDesc.querySettings.statementsParseMode, this.queryDesc.querySettings.statementsExecutionMode, sql});
            switch (this.queryDesc.querySettings.statementsParseMode) {
                case SPLIT: {
                    sqlStatements = this.queryDesc.sqlStatements;
                    Splitter sqlSplitter = new Splitter(this.connectionData.getDialect().getSemicolonExclusionPortionFinders());
                    if (sqlStatements == null) {
                        sqlStatements = sqlSplitter.split(sql);
                    }
                    selectStatementIndex = SQLUtils.findLastSelectStatement(sqlStatements, sqlSplitter);
                    logger.info((Object)("Found " + sqlStatements.length + " parts and the index of the select is " + selectStatementIndex));
                    break;
                }
                case RAW: {
                    sqlStatements = new String[]{sql};
                    selectStatementIndex = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported parse mode " + String.valueOf((Object)this.queryDesc.querySettings.statementsParseMode));
                }
            }
        }
        int n = this.selectStmtIndex = selectStatementIndex >= 0 ? selectStatementIndex : sqlStatements.length - 1;
        if (maxRows > 0 && this.queryDesc.querySettings.addLimitToStatement) {
            sqlStatements[this.selectStmtIndex] = this.connectionData.getDialect().getLimitedQuery(sqlStatements[this.selectStmtIndex], maxRows);
        }
        this.stmts = new StatementState[sqlStatements.length];
        for (int j = 0; j < sqlStatements.length; ++j) {
            logger.info((Object)("Statement part " + j + (j == this.selectStmtIndex ? " (select)" : "") + " ='" + sqlStatements[j] + "'"));
            this.stmts[j] = new StatementState(sqlStatements[j]);
        }
    }

    private void setCurrentStatement(Statement s) throws InterruptedException {
        if (this.logSniffer != null) {
            this.logSniffer.stop();
            this.logSniffer = null;
        }
        this.currentStatement = s;
        if (s != null && Hiveserver2LogSniffer.canSniff(s, this.connectionData)) {
            this.logSniffer = new Hiveserver2LogSniffer(s);
            this.logSniffer.startTailingAndRedirecting(this.logTailBuilder, (DKUtils.LineSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeAllStatementsUpToSelect() throws SQLException, InterruptedException {
        try {
            switch (this.queryDesc.querySettings.statementsExecutionMode) {
                case PREPARED: {
                    for (int i = 0; i < this.selectStmtIndex; ++i) {
                        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[i].text);
                        cru.reportStartNoFail();
                        try {
                            logger.info((Object)("Executing pre-statement: " + this.stmts[i].text));
                            this.stmts[i].pstmt = SQLUtils.getProperlyStreamablePreparedStatement(this.connectionData, this.conn, this.stmts[i].text);
                            this.setCurrentStatement(this.stmts[i].pstmt);
                            if (this.stmts[i].pstmt.execute()) {
                                this.closeResultSet(this.stmts[i].pstmt);
                            }
                            this.addWarnings(this.stmts[i].pstmt);
                            continue;
                        }
                        finally {
                            cru.reportCompleteNoFail();
                            this.setCurrentStatement(null);
                            this.closePrepared(i);
                        }
                    }
                    logger.info((Object)("Executing main statement: " + this.stmts[this.selectStmtIndex].text));
                    this.stmts[this.selectStmtIndex].pstmt = SQLUtils.getProperlyStreamablePreparedStatement(this.connectionData, this.conn, this.stmts[this.selectStmtIndex].text);
                    if (this.maxRows > 0) {
                        SQLUtils.setMaxRows(this.stmts[this.selectStmtIndex].pstmt, this.maxRows);
                    }
                    if (this.parameterValues != null && this.parameterValues.size() > 0) {
                        PreparedStatement ps2 = this.stmts[this.selectStmtIndex].pstmt;
                        for (int i = 0; i < this.parameterValues.size(); ++i) {
                            Object pv = this.parameterValues.get(i);
                            logger.debug((Object)("  Set pv=" + String.valueOf(pv) + " for " + (i + 1) + " type: " + String.valueOf(pv == null ? null : pv.getClass())));
                            if (pv == null) {
                                ps2.setString(i + 1, null);
                                continue;
                            }
                            if (pv instanceof Double) {
                                ps2.setDouble(i + 1, (Double)pv);
                                continue;
                            }
                            if (pv instanceof Long) {
                                ps2.setLong(i + 1, (Long)pv);
                                continue;
                            }
                            if (pv instanceof Number) {
                                ps2.setDouble(i + 1, ((Number)pv).doubleValue());
                                continue;
                            }
                            if (pv instanceof Boolean) {
                                ps2.setBoolean(i + 1, (Boolean)pv);
                                continue;
                            }
                            ps2.setString(i + 1, pv.toString());
                        }
                    }
                    this.mainStatementCRU = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[this.selectStmtIndex].text);
                    this.mainStatementCRU.reportStartNoFail();
                    try {
                        this.setCurrentStatement(this.stmts[this.selectStmtIndex].pstmt);
                        long beforeStatementExecution = System.currentTimeMillis();
                        boolean ret = this.stmts[this.selectStmtIndex].pstmt.execute();
                        long afterStatementExecution = System.currentTimeMillis();
                        this.mainStatementCRU.sqlQuery.statementExecutionTime = afterStatementExecution - beforeStatementExecution;
                        logger.info((Object)("Main statement has executed, ret=" + ret + ", time=" + (afterStatementExecution - beforeStatementExecution)));
                        boolean bl = ret;
                        return bl;
                    }
                    finally {
                        this.setCurrentStatement(null);
                    }
                }
                case UNPREPARED: {
                    for (int i = 0; i < this.selectStmtIndex; ++i) {
                        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[i].text);
                        cru.reportStartNoFail();
                        try {
                            logger.info((Object)("Executing pre-statement: " + this.stmts[i].text));
                            this.stmts[i].stmt = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.conn);
                            this.setCurrentStatement(this.stmts[i].stmt);
                            if (this.stmts[i].stmt.execute(this.stmts[i].text)) {
                                this.closeResultSet(this.stmts[i].stmt);
                            }
                            this.addWarnings(this.stmts[i].stmt);
                            continue;
                        }
                        finally {
                            cru.reportCompleteNoFail();
                            this.setCurrentStatement(null);
                            this.closeUnprepared(i);
                        }
                    }
                    logger.info((Object)("Executing main statement: " + this.stmts[this.selectStmtIndex].text));
                    this.stmts[this.selectStmtIndex].stmt = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.conn);
                    if (this.maxRows > 0) {
                        SQLUtils.setMaxRows(this.stmts[this.selectStmtIndex].stmt, this.maxRows);
                    }
                    this.mainStatementCRU = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[this.selectStmtIndex].text);
                    this.mainStatementCRU.reportStartNoFail();
                    try {
                        this.setCurrentStatement(this.stmts[this.selectStmtIndex].stmt);
                        long beforeStatementExecution = System.currentTimeMillis();
                        boolean ret = this.stmts[this.selectStmtIndex].stmt.execute(this.stmts[this.selectStmtIndex].text);
                        long afterStatementExecution = System.currentTimeMillis();
                        this.mainStatementCRU.sqlQuery.statementExecutionTime = afterStatementExecution - beforeStatementExecution;
                        logger.info((Object)("Main statement has executed, ret=" + ret + ", time=" + (afterStatementExecution - beforeStatementExecution)));
                        boolean bl = ret;
                        return bl;
                    }
                    finally {
                        this.setCurrentStatement(null);
                    }
                }
            }
            throw new Error("unreachable");
        }
        catch (SQLException e) {
            throw ExceptionUtils.newSQLExceptionWithNestedMessages((SQLException)e);
        }
    }

    private void addWarnings(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            for (SQLWarning nextWarning = statement.getWarnings(); nextWarning != null; nextWarning = nextWarning.getNextWarning()) {
                this.warningMessages.add(nextWarning.getMessage());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to fetch SQL query warnings ", (Throwable)e);
        }
    }

    private void closeResultSet(Statement statement) throws SQLException {
        if (statement == null) {
            return;
        }
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            resultSet.close();
        }
    }

    private void closePrepared(int i) throws SQLException {
        if (this.stmts[i].pstmt != null) {
            this.stmts[i].pstmt.close();
            this.stmts[i].pstmt = null;
        }
    }

    private void closeUnprepared(int i) throws SQLException {
        if (this.stmts[i].stmt != null) {
            this.stmts[i].stmt.close();
            this.stmts[i].stmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAllStatementsAfterSelect() throws SQLException, InterruptedException {
        try {
            switch (this.queryDesc.querySettings.statementsExecutionMode) {
                case PREPARED: {
                    for (int i = this.selectStmtIndex + 1; i < this.stmts.length; ++i) {
                        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[i].text);
                        cru.reportStartNoFail();
                        try {
                            logger.info((Object)("Executing post-statement: " + this.stmts[i].text));
                            this.stmts[i].pstmt = SQLUtils.getProperlyStreamablePreparedStatement(this.connectionData, this.conn, this.stmts[i].text);
                            this.setCurrentStatement(this.stmts[i].pstmt);
                            this.stmts[i].pstmt.execute();
                            continue;
                        }
                        finally {
                            cru.reportCompleteNoFail();
                            this.setCurrentStatement(null);
                            this.closePrepared(i);
                        }
                    }
                    break;
                }
                case UNPREPARED: {
                    for (int i = this.selectStmtIndex + 1; i < this.stmts.length; ++i) {
                        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(this.conn, this.stmts[this.selectStmtIndex].text);
                        cru.reportStartNoFail();
                        try {
                            logger.info((Object)("Executing post-statement: " + this.stmts[i].text));
                            this.stmts[i].stmt = SQLUtils.getProperlyStreamableStatement(this.connectionData, this.conn);
                            this.setCurrentStatement(this.stmts[i].stmt);
                            this.stmts[i].stmt.execute(this.stmts[i].text);
                            continue;
                        }
                        finally {
                            cru.reportCompleteNoFail();
                            this.setCurrentStatement(null);
                            this.closePrepared(i);
                        }
                    }
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw ExceptionUtils.newSQLExceptionWithNestedMessages((SQLException)e);
        }
    }

    private Statement getSelectedStatement() {
        if (SQLNotebookQuery.QueryStatementsExecutionMode.PREPARED.equals((Object)this.queryDesc.querySettings.statementsExecutionMode)) {
            return this.stmts[this.selectStmtIndex].pstmt;
        }
        return this.stmts[this.selectStmtIndex].stmt;
    }

    public SQLQueryIterator iterator(String filter) throws SQLException, InterruptedException {
        boolean hasResults = this.executeAllStatementsUpToSelect();
        SQLQueryIterator it = new SQLQueryIterator();
        if (hasResults) {
            it.rs = this.getSelectedStatement().getResultSet();
            it.meta = it.rs.getMetaData();
            it.filter = filter;
        }
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogTail() {
        Statement s = this.currentStatement;
        if (s != null) {
            DKUtils.SmartLogTailBuilder smartLogTailBuilder = this.logTailBuilder;
            synchronized (smartLogTailBuilder) {
                return Joiner.on((String)"\n").join((Iterable)this.logTailBuilder.get().getLines());
            }
        }
        return null;
    }

    public Map<String, String> getExtraHiveInfo() {
        if (this.logSniffer != null) {
            HashMap extras = Maps.newHashMap();
            if (StringUtils.isNotBlank((String)this.logSniffer.hiveQueryId)) {
                extras.put("hiveQueryId", this.logSniffer.hiveQueryId);
            }
            if (StringUtils.isNotBlank((String)this.logSniffer.applicationId)) {
                extras.put("applicationId", this.logSniffer.applicationId);
            }
            if (StringUtils.isNotBlank((String)this.logSniffer.jobId)) {
                extras.put("jobId", this.logSniffer.jobId);
            }
            return extras;
        }
        return null;
    }

    public QueryRunResult getPage(int matchingRowsToSkip, int rowsToReturn, String filter) throws Exception {
        return this.getPage(matchingRowsToSkip, rowsToReturn, Long.MAX_VALUE, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryRunResult getPage(int matchingRowsToSkip, int rowsToReturn, long sizeLimit, String filter) throws Exception {
        QueryRunResult result = new QueryRunResult();
        SQLDialect dialect = this.connectionData.getDialect();
        try (ResultSet resultSet = null;
             FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Executing sql query", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            block29: {
                boolean mainHasResults = this.executeAllStatementsUpToSelect();
                if (mainHasResults) {
                    resultSet = this.getSelectedStatement().getResultSet();
                    state.increment(1.0);
                    ResultSetMetaData meta = resultSet.getMetaData();
                    Schema schema = SchemaReader.metadataToSchema(this.connectionData.getDialect(), meta, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
                    int l = meta.getColumnCount();
                    for (int i = 1; i <= l; ++i) {
                        SchemaColumn schemaColumn = (SchemaColumn)schema.columns.get(i - 1);
                        result.columns.add(new QueryRunResult.ScriptRunResultColumn(schemaColumn.getName(), meta.getColumnTypeName(i), schemaColumn.getType(), meta.getColumnType(i)));
                    }
                    int skippedMatching = 0;
                    long currentSize = 0L;
                    boolean warned = false;
                    while (true) {
                        if (!resultSet.next()) {
                            logger.info((Object)("Result set has no more rows (returned " + result.totalRows + ")"));
                            break block29;
                        }
                        ++result.totalRows;
                        if (result.totalRows % 1000L == 0L) {
                            logger.info((Object)("Enumerated " + result.totalRows + " rows"));
                            FutureProgressState.checkInterrupt();
                        }
                        if (result.rows.size() > rowsToReturn || currentSize > sizeLimit) {
                            if (warned) continue;
                            warned = true;
                            String warning = result.rows.size() > rowsToReturn ? "the maximum number of lines allowed : " + rowsToReturn : "the maximum memory size allowed : " + sizeLimit;
                            logger.warn((Object)String.format("Result set truncated as it has a reached %s", warning));
                            continue;
                        }
                        boolean rowMatches = false;
                        if (filter == null) {
                            rowMatches = true;
                        } else {
                            for (int i = 1; i <= l; ++i) {
                                if (resultSet.getString(i) == null || !resultSet.getString(i).toLowerCase().contains(filter)) continue;
                                rowMatches = true;
                                break;
                            }
                        }
                        if (!rowMatches || skippedMatching < matchingRowsToSkip) continue;
                        if (result.rows.size() > rowsToReturn) {
                            assert (false);
                            continue;
                        }
                        String[] row = new String[l];
                        for (int i = 1; i <= l; ++i) {
                            row[i - 1] = dialect.getValueAsDSSString(resultSet, meta.getColumnType(i), i, (SchemaColumn)schema.columns.get(i - 1), true, false, DateTimeZone.UTC);
                        }
                        currentSize += SQLQueryRuntime.computeMemorySize(row);
                        result.rows.add(row);
                    }
                }
                try {
                    result.updatedRows = this.getSelectedStatement().getUpdateCount();
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get update count for non-select: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            this.addWarnings(this.getSelectedStatement());
            result.success = true;
            result.warningMessages = this.warningMessages;
            result.totalRowsClipped = result.totalRows == (long)this.maxRows;
            result.hasResultset = true;
            result.successMessage = dialect.extractStatistics(resultSet);
            if (this.mainStatementCRU != null && this.mainStatementCRU.sqlQuery != null) {
                this.mainStatementCRU.sqlQuery.fetchedRowCount = result.totalRows;
            }
        }
        return result;
    }

    public static long computeMemorySize(String[] array) {
        long size = 4L + 4L * (long)array.length;
        for (String str : array) {
            if (str == null) continue;
            size += 28L + 2L * (long)str.length();
        }
        return size;
    }

    public SQLDialect getDialect() {
        return this.connectionData.getDialect();
    }

    public ResultSet getResultSet() throws Exception {
        if (this.executeAllStatementsUpToSelect()) {
            return this.getSelectedStatement().getResultSet();
        }
        throw new IllegalArgumentException("The trigger's query doesn't produce results.");
    }

    public void close(boolean commit, boolean rethrowFromPostStatements) throws Exception {
        Exception postStatementsException;
        block16: {
            logger.debug((Object)"Closing SQL Query runtime");
            postStatementsException = null;
            try {
                if (this.logSniffer != null) {
                    this.logSniffer.stop();
                    this.logSniffer = null;
                }
                if (this.stmts == null) break block16;
                if (this.stmts[this.selectStmtIndex].pstmt != null) {
                    logger.trace((Object)"Closing main statement");
                    this.stmts[this.selectStmtIndex].pstmt.close();
                }
                if (this.mainStatementCRU != null) {
                    this.mainStatementCRU.reportCompleteNoFail();
                }
                if (commit) {
                    logger.trace((Object)"Executing post-statements");
                    try {
                        this.executeAllStatementsAfterSelect();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed query after select ", (Throwable)e);
                        postStatementsException = e;
                    }
                }
                this.stmts = null;
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close SQL statement", (Throwable)e);
            }
        }
        if (commit) {
            logger.trace((Object)"Commiting the DB transaction");
            SQLDialect dialect = this.connectionData.getDialect();
            if (dialect.supportsCommitAndRollback()) {
                try {
                    this.conn.commit();
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to commit SQL connection", (Throwable)e);
                }
            }
        }
        if (this.ownsTheConnection && this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close SQL connection", (Throwable)e);
            }
        }
        if (rethrowFromPostStatements && postStatementsException != null) {
            throw postStatementsException;
        }
    }

    static class StatementState {
        String text;
        Statement stmt;
        PreparedStatement pstmt;

        StatementState(String text) {
            this.text = text;
        }
    }

    public class SQLQueryIterator
    implements RowInputStream {
        private ResultSet rs;
        private ResultSetMetaData meta;
        private String filter;
        private ColumnFactory cf;
        private RowFactory rf = new StreamRowFactory();
        private List<Column> columns = new ArrayList<Column>();
        private Schema schema = new Schema();

        public void init(ColumnFactory cf) throws SQLException {
            this.cf = cf;
            if (this.meta != null) {
                this.schema = SchemaReader.metadataToSchema(SQLQueryRuntime.this.connectionData.getDialect(), this.meta, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
                for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
                    this.columns.add(this.cf.column(((SchemaColumn)this.schema.getColumns().get(i - 1)).getName()));
                }
            }
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Row next() throws SQLException {
            boolean rowMatches;
            if (this.rs == null) {
                return null;
            }
            block0: do {
                if (!this.rs.next()) {
                    return null;
                }
                rowMatches = false;
                if (this.filter == null) {
                    rowMatches = true;
                    continue;
                }
                for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
                    if (this.rs.getString(i) == null || !this.rs.getString(i).toLowerCase().contains(this.filter)) continue;
                    rowMatches = true;
                    continue block0;
                }
            } while (!rowMatches);
            Row r = this.rf.row();
            for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
                r.put(this.columns.get(i - 1), this.rs.getString(i));
            }
            return r;
        }
    }
}

