/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.server.services.DataLineageService;
import com.google.common.base.Preconditions;

public interface MLRecipeDataLineage {
    default public void checkInputArguments(DataLineageService.SerializedGraphNodes predecessors, String recipeType) {
        Preconditions.checkArgument((predecessors.datasetsByFullName.size() == 1 ? 1 : 0) != 0, (Object)(recipeType + " recipe can have only one input dataset"));
        Preconditions.checkArgument((predecessors.savedModels.size() == 1 ? 1 : 0) != 0, (Object)(recipeType + " recipe can have only one input model"));
        Preconditions.checkArgument((boolean)SavedModel.SavedModelType.DSS_MANAGED.equals((Object)predecessors.savedModels.get((int)0).savedModelType), (Object)(String.valueOf((Object)predecessors.savedModels.get((int)0).savedModelType) + " saved model type is not supported"));
    }

    default public boolean shouldIncludeInLineage(FeaturePreprocessingParams featurePreprocessingParams, ModelDetailsBase details) {
        if (details instanceof TimeseriesForecastingModelDetails && !((TimeseriesForecastingModelDetails)details).supportsExternalFeatures()) {
            return featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TARGET) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TIME) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER);
        }
        return featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.INPUT) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TIME) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.WEIGHT) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TIMESERIES_IDENTIFIER) || featurePreprocessingParams.role.equals((Object)FeaturePreprocessingParams.Role.TARGET) && details instanceof TimeseriesForecastingModelDetails;
    }
}

