/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AthenaConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.NonWritableConnection;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.connections.StreamingConnection;
import com.dataiku.dip.connections.TwitterConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.exec.pig.PigRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuilder;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.i18n.BackendTranslationService;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.ManagedDatasetConnection;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagedDatasetsCreationService {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ComputableFromRefService cfrService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private GeneralSettingsDAO generalSettingsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private IPermissionsService permissionsService;
    private static volatile boolean alreadyPrintedFullReasonForNoParquetAndORC;
    private static DKULogger logger;

    private void handlePartitioning(String projectKey, SerializedRecipe recipe, CreationOptions ret, String lang) throws IOException {
        PartitioningScheme scheme;
        if (recipe != null) {
            for (SerializedRecipe.InputRole ir : recipe.getInputsUnsafe().values()) {
                for (SerializedRecipe.RecipeInput ri : ir.items) {
                    ManagedFolder folder;
                    Dataset dataset;
                    FlowComputable fc = this.cfrService.get(recipe.projectKey, ri.ref);
                    if (fc.getType() == FlowComputable.FCType.DATASET && (dataset = ((FlowDataset)fc).getMandatoryUnsafe(this.datasetsDAO)).getPartitioningSchema().isPartitioned()) {
                        String label = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.SAME_AS", "Same as " + ri.ref, "object", ri.ref);
                        logger.warn((Object)label);
                        ret.inputPartitionings.add(new PartitioningOption("copy:dataset:" + dataset.getFullName(), label));
                    }
                    if (fc.getType() != FlowComputable.FCType.MANAGED_FOLDER || !(folder = ((FlowManagedFolder)fc).getManagedFolder()).getPartitioningSchema().isPartitioned()) continue;
                    String smartLabel = StringUtils.equals((String)projectKey, (String)folder.projectKey) ? folder.name : folder.getFullName();
                    String label = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.SAME_AS", "Same as " + smartLabel, "object", smartLabel);
                    ret.inputPartitionings.add(new PartitioningOption("copy:folder:" + folder.getFullName(), label));
                }
            }
        }
        HashMultimap map = HashMultimap.create();
        for (SerializedDataset sds : this.datasetsDAO.listUnsafe(projectKey)) {
            if (sds.partitioning == null || !(scheme = sds.partitioning).isPartitioned()) continue;
            map.put((Object)scheme, (Object)sds);
        }
        for (ManagedFolder mf : this.managedFolderDAO.listUnsafe(projectKey)) {
            if (mf.partitioning == null || !(scheme = mf.partitioning).isPartitioned()) continue;
            map.put((Object)scheme, (Object)mf);
        }
        for (PartitioningScheme scheme2 : map.keySet()) {
            String label;
            String fullName;
            String label2;
            ArrayList coll = Lists.newArrayList(map.get((Object)scheme2).iterator());
            Collections.sort(coll, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    int va = a instanceof SerializedDataset ? 0 : 1;
                    int vb = b instanceof SerializedDataset ? 0 : 1;
                    return va - vb;
                }
            });
            Object first = coll.get(0);
            int datasetCount = 0;
            int folderCount = 0;
            for (Object o : coll) {
                datasetCount += o instanceof SerializedDataset ? 1 : 0;
                folderCount += o instanceof ManagedFolder ? 1 : 0;
            }
            ArrayList objectCounts = Lists.newArrayList();
            if (datasetCount == 1) {
                objectCounts.add(this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.ONE_DATASET", "1 dataset", new Object[0]));
            } else if (datasetCount > 1) {
                label2 = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.DATASETS", datasetCount + " datasets", "count", String.valueOf(datasetCount));
                objectCounts.add(label2);
            }
            if (folderCount == 1) {
                objectCounts.add(this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.ONE_FOLDER", "1 folder", new Object[0]));
            } else if (folderCount > 1) {
                label2 = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.FOLDERS", folderCount + " folders", "count", String.valueOf(folderCount));
                objectCounts.add(label2);
            }
            String counts = Joiner.on((String)this.translationService.translateNoContext(lang, "GLOBAL.AND_SEPARATOR", " and ", new Object[0])).join((Iterable)objectCounts);
            if (first instanceof SerializedDataset) {
                SerializedDataset sds = (SerializedDataset)first;
                fullName = sds.projectKey + "." + sds.name;
                label = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.SAME_AS_SMALL", scheme2.describe() + " (same as " + counts + ")", BackendTranslationService.toMap("column", scheme2.describe(), "counts", counts));
                ret.projectPartitionings.add(new PartitioningOption("copy:dataset:" + fullName, label));
                continue;
            }
            if (!(first instanceof ManagedFolder)) continue;
            ManagedFolder mf = (ManagedFolder)first;
            fullName = mf.projectKey + "." + mf.id;
            label = this.translationService.translateNoContext(lang, "MANAGED_DATASETS_CREATION_SERVICE.PARTITIONING.SAME_AS_SMALL", scheme2.describe() + " (same as " + counts + ")", BackendTranslationService.toMap("column", scheme2.describe(), "counts", counts));
            ret.projectPartitionings.add(new PartitioningOption("copy:folder:" + fullName, label));
        }
    }

    private void addAllSQLConnections(AuthCtx authCtx, CreationOptions ret) throws IOException {
        for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
            if (!c2.allowManagedDatasets || !c2.isProperSQL() || !c2.isFreelyUsableBy(authCtx) || c2 instanceof AthenaConnection) continue;
            ConnectionOption co2 = new ConnectionOption();
            co2.id = c2.name;
            co2.connectionName = c2.name;
            co2.connectionDisplayName = c2.name;
            co2.connectionDescription = c2.description;
            co2.connectionType = c2.getType();
            ret.connections.add(co2);
        }
    }

    private void addAllConnections(AuthCtx authCtx, String projectKey, CreationOptions ret, Set<String> onlyIfTypes, RecipeMeta rm2, boolean forFolders, boolean forStreamingEndpoints) throws IOException {
        for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
            DSSConnection.DkuConnectionParams params;
            boolean allowed;
            if (!c2.isADataStoringConnection()) {
                logger.trace(() -> "Connection is not a data storage connection, reject: " + String.valueOf(c2));
                continue;
            }
            if (c2 instanceof StreamingConnection && !forStreamingEndpoints) {
                logger.trace(() -> "Connection not usable for datasets or folders, reject: " + String.valueOf(c2));
                continue;
            }
            if (forStreamingEndpoints && !(c2 instanceof StreamingConnection)) {
                logger.trace(() -> "Connection not usable for streaming endpoints, reject: " + String.valueOf(c2));
                continue;
            }
            if (!c2.allowWrite) {
                logger.trace(() -> "no write options: reject: " + String.valueOf(c2));
                continue;
            }
            boolean bl = allowed = forFolders ? c2.allowManagedFolders : c2.allowManagedDatasets;
            if (!allowed || !c2.isFreelyUsableBy(authCtx)) {
                logger.trace(() -> "no managed options: reject: " + String.valueOf(c2));
                continue;
            }
            if (!forFolders && c2 instanceof NonWritableConnection) {
                logger.trace(() -> "get options: reject: " + String.valueOf(c2));
                continue;
            }
            if (c2 instanceof AthenaConnection || c2 instanceof DatabricksConnection && forFolders && ((DatabricksConnection)c2).getProviderTypes().isEmpty()) continue;
            if (c2 instanceof DatabricksVolumeConnection && !forFolders) {
                logger.trace(() -> "only for managed folders: reject: " + String.valueOf(c2));
                continue;
            }
            ConnectionOption co2 = new ConnectionOption();
            co2.id = c2.name;
            co2.connectionName = c2.name;
            co2.connectionDisplayName = c2.name;
            co2.connectionDescription = c2.description;
            co2.connectionType = c2.getType();
            if (!forStreamingEndpoints ? onlyIfTypes != null && !onlyIfTypes.contains(c2.getType()) : onlyIfTypes != null && !onlyIfTypes.contains(c2.getType().toLowerCase())) continue;
            if (c2 instanceof AbstractSQLConnection) {
                params = ((AbstractSQLConnection)c2).getParams();
                co2.canOverrideSQLCatalog = params.namingRule.canOverrideCatalogInManagedDatasetCreation;
                co2.unoverridenSQLCatalog = params.namingRule.catalog;
                co2.canOverrideSQLSchema = params.namingRule.canOverrideSchemaInManagedDatasetCreation;
                co2.unoverridenSQLSchema = params.namingRule.schemaName;
                Params p = ((AbstractSQLConnection)c2).getDkuPropertiesAsParams();
                co2.canFetchCatalogs = p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true);
                co2.canFetchSchemas = p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true);
            }
            if (c2 instanceof IcebergConnection) {
                params = ((IcebergConnection)c2).getParams();
                co2.canOverrideIcebergNamespace = ((IcebergConnection.Params)params).canOverrideDefaultNamespaceInManagedDatasetCreation;
                co2.unoverridenIcebergNamespace = ((IcebergConnection.Params)params).defaultNamespaceInManagedDatasetCreation;
            }
            co2.formats.addAll(this.getFormats(c2, rm2));
            String preferredFormats = this.getDefaultCreationSettings((String)projectKey).preferedStorageFormats;
            if (StringUtils.isNotBlank((String)preferredFormats)) {
                ArrayList pref = Lists.newArrayList((Object[])preferredFormats.split(","));
                final ArrayList<String> cpref = new ArrayList<String>();
                for (String p : pref) {
                    cpref.add(p.trim());
                }
                Collections.sort(co2.formats, new Comparator<FormatOption>(){

                    @Override
                    public int compare(FormatOption o1, FormatOption o2) {
                        int pi1 = cpref.indexOf(o1.id.toString());
                        int pi2 = cpref.indexOf(o2.id.toString());
                        if (pi1 == -1 && pi2 == -1) {
                            return 0;
                        }
                        if (pi1 == -1 && pi2 >= 0) {
                            return 1;
                        }
                        if (pi1 >= 0 && pi2 == -1) {
                            return -1;
                        }
                        return Integer.compare(pi1, pi2);
                    }
                });
            }
            if (c2 instanceof FSProviderizableConnection) {
                co2.fsProviderTypes = ((FSProviderizableConnection)((Object)c2)).getProviderTypes();
            }
            ret.connections.add(co2);
        }
    }

    public Collection<? extends FormatOption> getFormats(DSSConnection c2, RecipeMeta rm2) {
        ArrayList<FormatOption> formats = new ArrayList<FormatOption>();
        if (c2 instanceof HDFSConnection) {
            if (PigRecipeMeta.META == rm2) {
                formats.add(new FormatOption(FormatOptionId.CSV_NOQUOTING_NOGZIP_FORPIG, "CSV (Pig compatible)"));
            } else if (ImpalaRecipeMeta.META == rm2) {
                formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Hive compatible)"));
                formats.add(new FormatOption(FormatOptionId.PARQUET_HIVE, "Parquet"));
                formats.add(new FormatOption(FormatOptionId.CSV_NOQUOTING_NOGZIP_FORPIG, "CSV (Pig compatible)"));
            } else {
                formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Hive compatible)"));
                formats.add(new FormatOption(FormatOptionId.PARQUET_HIVE, "Parquet"));
                formats.add(new FormatOption(FormatOptionId.ORC, "ORC"));
                formats.add(new FormatOption(FormatOptionId.AVRO, "Avro"));
                formats.add(new FormatOption(FormatOptionId.CSV_NOQUOTING_NOGZIP_FORPIG, "CSV (Pig compatible)"));
            }
        } else if (c2 instanceof EC2Connection) {
            formats.add(new FormatOption(FormatOptionId.CSV_EXCEL_GZIP, "CSV (Redshift-sync compatible)"));
            if (((EC2Connection)c2).params.metastoreSynchronizationMode != HDFSConnection.HiveSynchronizationMode.NO_SYNC) {
                formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Metastore compatible)"));
            }
            String scheme = ((EC2Connection)c2).getHDFSScheme();
            this.addHdfsableFormats(formats, scheme);
        } else if (c2 instanceof GCSConnection) {
            formats.add(new FormatOption(FormatOptionId.CSV_EXCEL_GZIP_BIGQUERY, "CSV (BigQuery-sync compatible)"));
            if (((GCSConnection)c2).params.metastoreSynchronizationMode != HDFSConnection.HiveSynchronizationMode.NO_SYNC) {
                formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Metastore compatible)"));
            }
            String scheme = ((GCSConnection)c2).getHDFSScheme();
            this.addHdfsableFormats(formats, scheme);
        } else if (c2 instanceof AzureConnection) {
            formats.add(new FormatOption(FormatOptionId.CSV_EXCEL_GZIP, "CSV (Snowflake-sync compatible)"));
            if (((AzureConnection)c2).params.metastoreSynchronizationMode != HDFSConnection.HiveSynchronizationMode.NO_SYNC) {
                formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Metastore compatible)"));
            }
            String scheme = ((AzureConnection)c2).getHDFSScheme();
            this.addHdfsableFormats(formats, scheme);
        } else if (c2 instanceof DatabricksVolumeConnection) {
            formats.add(new FormatOption(FormatOptionId.CSV_EXCEL_GZIP, "CSV (Databricks-sync compatible)"));
            formats.add(new FormatOption(FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE, "CSV (Metastore compatible)"));
            this.addHdfsableFormats(formats, null);
        } else if (c2 instanceof KafkaConnection) {
            formats.add(new FormatOption(FormatOptionId.JSON, "JSON"));
            formats.add(new FormatOption(FormatOptionId.AVRO, "Kafka Avro"));
            formats.add(new FormatOption(FormatOptionId.STRING, "Text"));
        } else if (c2 instanceof SQSConnection) {
            formats.add(new FormatOption(FormatOptionId.JSON, "JSON"));
            formats.add(new FormatOption(FormatOptionId.STRING, "Text"));
        } else if (c2.isFSLike()) {
            formats.add(new FormatOption(FormatOptionId.CSV_UNIX_GZIP, "CSV"));
        }
        return formats;
    }

    private void addHdfsableFormats(List<FormatOption> formats, String scheme) {
        formats.add(new FormatOption(FormatOptionId.CSV_UNIX_GZIP, "CSV"));
        formats.add(new FormatOption(FormatOptionId.AVRO, "Avro"));
        try {
            Class fsClass;
            if (StringUtils.isNotBlank((String)scheme) && (fsClass = FileSystem.getFileSystemClass((String)scheme, (Configuration)new Configuration())) != null) {
                formats.add(new FormatOption(FormatOptionId.PARQUET_HIVE, "Parquet"));
                formats.add(new FormatOption(FormatOptionId.ORC, "ORC"));
            }
        }
        catch (Throwable e) {
            if (alreadyPrintedFullReasonForNoParquetAndORC) {
                logger.debug((Object)("Can't use Parquet or ORC: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            logger.debug((Object)"Can't use Parquet or ORC", e);
            alreadyPrintedFullReasonForNoParquetAndORC = true;
        }
    }

    private boolean putConnectionFirst(List<ConnectionOption> list, String name) {
        boolean didIt = false;
        ListIterator<ConnectionOption> it = list.listIterator();
        while (it.hasNext()) {
            ConnectionOption co2 = it.next();
            if (!co2.connectionName.equals(name)) continue;
            it.remove();
            list.add(0, co2);
            didIt = true;
            break;
        }
        return didIt;
    }

    private boolean putManagedDatasetConnectionFirst(List<ManagedDatasetConnection> list, String name) {
        boolean didIt = false;
        ListIterator<ManagedDatasetConnection> it = list.listIterator();
        while (it.hasNext()) {
            ManagedDatasetConnection co2 = it.next();
            if (!co2.name.equals(name)) continue;
            it.remove();
            list.add(0, co2);
            didIt = true;
            break;
        }
        return didIt;
    }

    private boolean putConnectionTypeFirst(List<ConnectionOption> list, DSSConnection connection) {
        return this.putConnectionTypeFirst(list, connection.type);
    }

    private boolean putConnectionTypeFirst(List<ConnectionOption> list, String connectionType) {
        boolean didIt = false;
        ListIterator<ConnectionOption> it = list.listIterator();
        ArrayList<ConnectionOption> toAdd = new ArrayList<ConnectionOption>();
        while (it.hasNext()) {
            ConnectionOption co2 = it.next();
            if (!co2.connectionType.equals(connectionType)) continue;
            toAdd.add(co2);
            it.remove();
            didIt = true;
        }
        list.addAll(0, toAdd);
        return didIt;
    }

    private void addAllCustomFSProviders(AuthCtx authCtx, CreationOptions ret) throws DKUSecurityException {
        for (String fsProviderType : CustomFSProviderBuildersRegistry.getTypes()) {
            CustomFSProviderBuilder<? extends LoadedFSProvider<? extends CustomFSProviderDesc>> builder = CustomFSProviderBuildersRegistry.get(fsProviderType);
            LoadedFSProvider<? extends CustomFSProviderDesc> fsProviderDesc = builder.getLoaded();
            if (!this.permissionsService.hasPluginPrivilege(authCtx, fsProviderDesc.ownerPluginId, Privileges.PluginLevelPrivilegeType.COMPONENTS_VIEWER)) continue;
            ConnectionOption co2 = new ConnectionOption();
            co2.id = fsProviderType;
            co2.connectionType = "Plugin " + fsProviderDesc.getOwnerPluginId();
            co2.connectionName = "@virtual(" + fsProviderType + "):" + fsProviderType;
            co2.connectionDisplayName = StringUtils.defaultIfBlank((String)(((CustomFSProviderDesc)fsProviderDesc.desc).meta == null ? null : ((CustomFSProviderDesc)fsProviderDesc.desc).meta.label), (String)((CustomFSProviderDesc)fsProviderDesc.desc).id);
            co2.connectionDescription = ((CustomFSProviderDesc)fsProviderDesc.desc).meta == null ? null : ((CustomFSProviderDesc)fsProviderDesc.desc).meta.description;
            co2.fsProviderTypes = Lists.newArrayList((Object[])new String[]{fsProviderType});
            co2.formats.add(new FormatOption(FormatOptionId.CSV_UNIX_GZIP, "CSV"));
            ret.connections.add(co2);
        }
    }

    public FormatOptionId getDefaultFormatOption(DSSConnection targetConnection) {
        if (targetConnection instanceof HDFSConnection) {
            return FormatOptionId.CSV_ESCAPING_NOGZIP_FORHIVE;
        }
        if (targetConnection instanceof EC2Connection) {
            return FormatOptionId.CSV_EXCEL_GZIP;
        }
        if (targetConnection instanceof GCSConnection) {
            return FormatOptionId.CSV_EXCEL_GZIP_BIGQUERY;
        }
        if (targetConnection.isFSLike()) {
            return FormatOptionId.CSV_UNIX_GZIP;
        }
        return null;
    }

    public GeneralSettingsDAO.AbstractDefaultDatasetCreationSettings getDefaultCreationSettings(String projectKey) throws DSSInternalErrorException {
        try {
            GeneralSettingsDAO.ProjectDefaultDatasetCreationSettings pd = this.projectsDAO.getMandatoryUnsafe((String)projectKey).settings.datasetsCreationSettings;
            if (pd.useGlobal) {
                return this.generalSettingsService.getUnsafeAutoTXN().defaultDatasetCreationSettings;
            }
            return pd;
        }
        catch (IOException e) {
            throw new DSSInternalErrorException("Failed to read config", (Throwable)e);
        }
    }

    public boolean allowUploadsWithoutConnection() throws DSSInternalErrorException {
        try {
            return this.generalSettingsService.getUnsafeAutoTXN().defaultDatasetCreationSettings.allowUploadsWithoutConnection;
        }
        catch (IOException e) {
            throw new DSSInternalErrorException("Failed to read config", (Throwable)e);
        }
    }

    public CreationOptions getOptionsForRecipe(@Nonnull SerializedRecipe protoRecipe, String forOutputRole, AuthCtx authCtx, boolean forDatasets, boolean forFolders, boolean forStreamingEndpoints, boolean forModelEvaluationStores, String lang) throws IOException {
        String connectionName;
        SerializedDataset sd;
        String ref;
        Preconditions.checkNotNull((Object)protoRecipe, (Object)"Recipe must not be null");
        logger.infoV("Get managed options recipeType=%s outputRole=%s forDatasets=%s forFolders=%s forStreamingEndpoints=%s", new Object[]{protoRecipe.type, forOutputRole, forDatasets, forFolders, forStreamingEndpoints});
        CreationOptions ret = new CreationOptions();
        RecipeMeta meta = RecipeRegistry.getMeta(protoRecipe);
        RecipeDesc recipeDesc = meta.getRecipeDesc();
        String favType = null;
        RecipeDesc.IORoleDef role = null;
        for (RecipeDesc.IORoleDef r : recipeDesc.outputRoles) {
            if (!r.name.equals(forOutputRole)) continue;
            role = r;
            break;
        }
        if (role == null) {
            throw ErrorContext.iaef((String)"Role not found: %s", (Object)forOutputRole, (Object[])new Object[0]);
        }
        if (role.mustBeSQL) {
            if (forDatasets) {
                this.addAllSQLConnections(authCtx, ret);
            }
        } else if (StringUtils.isNotBlank((String)role.mustBeStrictlyType)) {
            this.addAllConnections(authCtx, protoRecipe.projectKey, ret, Sets.newHashSet((Object[])new String[]{role.mustBeStrictlyType}), meta, forFolders, forStreamingEndpoints);
        } else if (role.acceptedTypes != null) {
            this.addAllConnections(authCtx, protoRecipe.projectKey, ret, Sets.newHashSet(role.acceptedTypes), meta, forFolders, forStreamingEndpoints);
        } else if (meta == ImpalaRecipeMeta.META) {
            this.addAllConnections(authCtx, protoRecipe.projectKey, ret, null, meta, forFolders, forStreamingEndpoints);
            favType = "HDFS";
        } else {
            this.addAllConnections(authCtx, protoRecipe.projectKey, ret, null, meta, forFolders, forStreamingEndpoints);
        }
        final String favType2 = favType;
        Collections.sort(ret.connections, new Comparator<ConnectionOption>(){

            @Override
            public int compare(ConnectionOption arg0, ConnectionOption arg1) {
                int score1;
                int score0 = arg0.connectionType.equals(favType2) ? 1 : 0;
                int n = score1 = arg1.connectionType.equals(favType2) ? 1 : 0;
                if (score1 != score0) {
                    return score1 - score0;
                }
                String a = (arg0.connectionType + arg0.connectionName).toLowerCase();
                String b = (arg1.connectionType + arg1.connectionName).toLowerCase();
                return a.compareTo(b);
            }
        });
        Map<String, SerializedRecipe.InputRole> inputs = protoRecipe.getInputsUnsafe();
        boolean pushedToBeginning = false;
        if (inputs != null) {
            for (String r : inputs.keySet()) {
                if (protoRecipe.getInputsForRole(r).size() <= 0) continue;
                ref = protoRecipe.getInputsForRole((String)r).get((int)0).ref;
                if (!this.cfrService.existsAsDatasetUnsafe(protoRecipe.projectKey, ref)) {
                    logger.trace(() -> "Recipe input " + ref + " is not a dataset, cannot bring its connection at the beginning.");
                    continue;
                }
                try {
                    sd = this.cfrService.getAsDatasetUnsafe(protoRecipe.projectKey, ref);
                    connectionName = sd.getParams().getConnection();
                    if (!StringUtils.isNotBlank((String)connectionName)) continue;
                    pushedToBeginning |= this.putConnectionFirst(ret.connections, connectionName);
                    break;
                }
                catch (Exception ex) {
                    logger.trace(() -> "Recipe input " + ref + " is not a dataset, cannot bring its connection at the beginning.");
                }
            }
        }
        if (!pushedToBeginning) {
            logger.trace((Object)"Trying to push type to beginning");
            if (inputs != null) {
                for (String r : inputs.keySet()) {
                    if (protoRecipe.getInputsForRole(r).size() <= 0) continue;
                    ref = protoRecipe.getInputsForRole((String)r).get((int)0).ref;
                    if (!this.cfrService.existsAsDatasetUnsafe(protoRecipe.projectKey, ref)) {
                        logger.trace(() -> "Recipe input " + ref + " is not a dataset, cannot bring its connection at the beginning.");
                        continue;
                    }
                    try {
                        sd = this.cfrService.getAsDatasetUnsafe(protoRecipe.projectKey, ref);
                        connectionName = sd.getParams().getConnection();
                        if (StringUtils.isNotBlank((String)connectionName)) {
                            if (ConnectionsDAO.parseVirtualConnection(connectionName) == null) {
                                DSSConnection conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
                                pushedToBeginning |= this.putConnectionTypeFirst(ret.connections, conn);
                                break;
                            }
                            ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
                            pushedToBeginning |= this.putConnectionTypeFirst(ret.connections, "HDFS");
                            break;
                        }
                        if (!BuiltinFSDatasets.FILES_IN_FOLDER_META.getType().equals(sd.type)) continue;
                        pushedToBeginning |= this.putConnectionTypeFirst(ret.connections, BuiltinFSDatasets.FS_META.getType());
                    }
                    catch (Exception ex) {
                        logger.trace(() -> "Recipe input " + ref + " is not a dataset, cannot bring its connection at the beginning.", (Throwable)ex);
                    }
                }
            }
        }
        GeneralSettingsDAO.AbstractDefaultDatasetCreationSettings datasetCreationSettings = this.getDefaultCreationSettings(protoRecipe.projectKey);
        if (!pushedToBeginning && !StringUtils.isBlank((String)datasetCreationSettings.preferedConnection)) {
            this.putConnectionFirst(ret.connections, datasetCreationSettings.preferedConnection);
        }
        if (StringUtils.isNotBlank((String)datasetCreationSettings.forcedPreferedConnection)) {
            this.putConnectionFirst(ret.connections, datasetCreationSettings.forcedPreferedConnection);
        }
        this.handlePartitioning(protoRecipe.projectKey, protoRecipe, ret, lang);
        return ret;
    }

    public CreationOptions getOptionsNoContext(AuthCtx authCtx, String projectKey, boolean forDatasets, boolean forFolders, boolean forStreamingEndpoints, boolean forModelEvaluationStores, String lang) throws IOException, DKUSecurityException {
        CreationOptions ret = new CreationOptions();
        this.addAllConnections(authCtx, projectKey, ret, null, null, forFolders, forStreamingEndpoints);
        if (forFolders) {
            this.addAllCustomFSProviders(authCtx, ret);
        }
        this.handlePartitioning(projectKey, null, ret, lang);
        return ret;
    }

    private ManagedDatasetConnection makeManagedDatasetConnectionForUploadable(AuthCtx authCtx, DSSConnection c2) {
        if (!this.canUploadDatasetsOnConnection(c2, authCtx)) {
            return null;
        }
        ManagedDatasetConnection mdc = new ManagedDatasetConnection();
        mdc.name = c2.name;
        mdc.description = c2.description;
        mdc.type = c2.getType();
        mdc.sql = false;
        mdc.fsProviderTypes = Lists.newArrayList();
        for (String fsProviderType : ((FSProviderizableConnection)((Object)c2)).getProviderTypes()) {
            try {
                DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(fsProviderType);
                if (!(meta instanceof BuiltinFSDatasets.FSDatasetMeta)) continue;
                mdc.fsProviderTypes.add(fsProviderType);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get meta of dataset type " + fsProviderType), (Throwable)e);
            }
        }
        if (mdc.fsProviderTypes.size() == 0) {
            return null;
        }
        return mdc;
    }

    public ManagedUploadableConnectionsResponse listManagedUploadableConnections(AuthCtx authCtx, String projectKey) throws IOException {
        ManagedUploadableConnectionsResponse ret = new ManagedUploadableConnectionsResponse();
        GeneralSettingsDAO.AbstractDefaultDatasetCreationSettings datasetCreationSettings = this.getDefaultCreationSettings(projectKey);
        for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
            ManagedDatasetConnection mdc = this.makeManagedDatasetConnectionForUploadable(authCtx, c2);
            if (mdc == null) continue;
            ret.connections.add(mdc);
        }
        Collections.sort(ret.connections, new Comparator<ManagedDatasetConnection>(){

            @Override
            public int compare(ManagedDatasetConnection a, ManagedDatasetConnection b) {
                return StringUtils.defaultIfBlank((String)a.name, (String)"").compareTo(StringUtils.defaultIfBlank((String)b.name, (String)""));
            }
        });
        if (this.allowUploadsWithoutConnection()) {
            ManagedDatasetConnection mdc = new ManagedDatasetConnection();
            mdc.fsProviderTypes = Lists.newArrayList((Object[])new String[]{null});
            mdc.name = "Default (in " + ApplicationConfigurator.productShortName() + " data dir.)";
            ret.connections.add(0, mdc);
        }
        if (StringUtils.isNotBlank((String)datasetCreationSettings.preferedUploadConnection)) {
            this.putManagedDatasetConnectionFirst(ret.connections, datasetCreationSettings.preferedUploadConnection);
        }
        return ret;
    }

    private Set<String> listDatasetTypeCreatableFromConnections(Collection<DSSConnection> connections, AuthCtx authCtx) {
        HashSet<String> result = new HashSet<String>();
        for (DSSConnection c2 : connections) {
            FSProviderizableConnection fspConnection;
            List<String> providersTypes;
            if (c2 instanceof StreamingConnection || !c2.isFreelyUsableBy(authCtx)) continue;
            if (!result.contains("UploadedFiles") && this.makeManagedDatasetConnectionForUploadable(authCtx, c2) != null) {
                result.add("UploadedFiles");
            }
            if (c2.allowManagedDatasets) {
                result.add("managed");
            }
            if (DatasetHandlerFactory.hasParamsClass(c2.getMainManagedDatasetType())) {
                result.add(c2.getMainManagedDatasetType());
            }
            if (c2 instanceof SharePointOnlineConnection) {
                result.add(SharePointOnlineListDatasetHandler.META.getType());
            }
            if (!(c2 instanceof FSProviderizableConnection) || (providersTypes = (fspConnection = (FSProviderizableConnection)((Object)c2)).getProviderTypes()) == null) continue;
            result.addAll(providersTypes);
            if (!c2.allowManagedFolders) continue;
            result.add("managed_folder");
            if (!c2.getType().equals("Filesystem") && !c2.getType().equals("HDFS")) continue;
            result.add("CachedHTTP");
        }
        return result;
    }

    public CreatableDatasetTypes listCreatableDatasetTypes(AuthCtx authCtx, String projectKey) throws IOException {
        Collection<DSSConnection> connections = this.connectionsDAO.listUnsafe().values();
        Collection personalConnections = connections.stream().filter(c2 -> authCtx != null && authCtx.getIdentifier().equals(c2.owner)).collect(Collectors.toList());
        Set<String> fromAllConnections = this.listDatasetTypeCreatableFromConnections(connections, authCtx);
        Set<String> fromPersonalConnections = this.listDatasetTypeCreatableFromConnections(personalConnections, authCtx);
        if (fromAllConnections.contains("Filesystem")) {
            for (DSSConnection c3 : connections) {
                if (c3 instanceof StreamingConnection || !c3.isFreelyUsableBy(authCtx) || !(c3 instanceof TwitterConnection)) continue;
                fromAllConnections.add("Twitter");
                if (authCtx == null || !authCtx.getIdentifier().equals(c3.owner)) continue;
                fromPersonalConnections.add("Twitter");
            }
        }
        HashSet<String> outsideOfConnections = new HashSet<String>();
        if (!CustomFSProviderBuildersRegistry.getTypes().isEmpty()) {
            outsideOfConnections.add("managed_folder");
            outsideOfConnections.add("FilesInFolder");
        }
        if (this.allowUploadsWithoutConnection()) {
            outsideOfConnections.add("UploadedFiles");
        }
        if (HiveConfigurator.isHiveInstalled()) {
            outsideOfConnections.add(BuiltinSQLDatasets.HIVE_META.getType());
        }
        outsideOfConnections.add("HTTP");
        outsideOfConnections.add("JobsDB");
        outsideOfConnections.add("StatsDB");
        outsideOfConnections.add(InlineDatasetHandler.META.getType());
        outsideOfConnections.add("model_evaluation_store");
        outsideOfConnections.add("FilesInFolder");
        outsideOfConnections.add("ExperimentsDB");
        outsideOfConnections.add("Sample");
        outsideOfConnections.add("ForeignDataset");
        outsideOfConnections.add("search_and_import");
        outsideOfConnections.add("connection_explorer");
        outsideOfConnections.add("import_from_catalog");
        outsideOfConnections.add("import_from_datacatalog");
        outsideOfConnections.add("import_from_data_collection");
        outsideOfConnections.add("import_dss_item");
        outsideOfConnections.add("import_from_feature_store");
        outsideOfConnections.add("import_from_alation");
        return new CreatableDatasetTypes(fromAllConnections, fromPersonalConnections, outsideOfConnections);
    }

    public static void setFormat(Dataset dataset, FormatOptionId formatOptionId) {
        switch (formatOptionId) {
            case AVRO: {
                dataset.setFormatType("avro");
                AvroFormatConfig afc = new AvroFormatConfig();
                afc.avroCompressionMethod = AvroFormatConfig.AvroCompressionMethod.SNAPPY;
                dataset.setFormatParams(afc);
                break;
            }
            case CSV_ESCAPING_NOGZIP_FORHIVE: {
                ManagedDatasetsHelper.setStandardCSVEscapeOnly(dataset);
                dataset.getFormatParamsAs(CSVFormatConfig.class).arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.hive;
                dataset.getFormatParamsAs(CSVFormatConfig.class).dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.HIVE;
                break;
            }
            case CSV_UNIX_GZIP: {
                ManagedDatasetsHelper.setStandardCSVUNIX(dataset);
                dataset.getFormatParamsAs(CSVFormatConfig.class).compress = "gz";
                break;
            }
            case CSV_EXCEL_GZIP: {
                ManagedDatasetsHelper.setStandardCSVExcel(dataset);
                dataset.getFormatParamsAs(CSVFormatConfig.class).compress = "gz";
                break;
            }
            case CSV_EXCEL_GZIP_BIGQUERY: {
                ManagedDatasetsHelper.setStandardCSVExcel(dataset);
                dataset.getFormatParamsAs(CSVFormatConfig.class).compress = "gz";
                dataset.getFormatParamsAs(CSVFormatConfig.class).dateSerializationFormat = CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC;
                break;
            }
            case ORC: {
                dataset.setFormatType("orcfile");
                dataset.setFormatParams(new ORCFileFormatConfig());
                break;
            }
            case PARQUET_HIVE: {
                dataset.setFormatType("parquet");
                ParquetFormatConfig pfc = new ParquetFormatConfig();
                pfc.parquetFlavor = ParquetFormatConfig.Flavor.HIVE;
                dataset.setFormatParams(pfc);
                break;
            }
            case CSV_NOQUOTING_NOGZIP_FORPIG: {
                ManagedDatasetsHelper.setStandardCSVNoEscape(dataset);
                break;
            }
        }
    }

    public Dataset prepare(AuthCtx authCtx, String projectKey, String name, ManagedDatasetCreationSettings settings) throws Exception {
        String outputDatasetType;
        DatasetUtils.checkName(name);
        DSSConnection c2 = null;
        if (!settings.inlineDataset) {
            c2 = this.connectionsDAO.getMandatoryConnection(authCtx, settings.connectionId);
            outputDatasetType = c2.getMainManagedDatasetType();
        } else {
            outputDatasetType = "Inline";
        }
        if (c2 instanceof FSProviderizableConnection && settings.typeOptionId != null) {
            outputDatasetType = settings.typeOptionId;
        }
        Partitionable copyPartitioningFrom = this.getPartitionableFromPartitioningOptionId(projectKey, settings.partitioningOptionId);
        DatasetHandler.DatasetMeta<?, ?> outputDatasetMeta = DatasetHandlerFactory.getMeta(outputDatasetType);
        Dataset outputDataset = new Dataset();
        outputDataset.setFullName(projectKey + "." + name);
        outputDataset.getModel().name = name;
        outputDataset.getModel().projectKey = projectKey;
        outputDatasetMeta.fillManagedDatasetParams(outputDataset, c2, settings.specificSettings);
        outputDataset.setSchema(new Schema());
        outputDataset.getModel().readWriteOptions.preserveOrder = settings.preserveOrder;
        GeneralSettingsDAO.AbstractDefaultDatasetCreationSettings defaultCreationSettings = this.getDefaultCreationSettings(projectKey);
        logger.info((Object)("Using creation settings: " + JSON.log((Object)defaultCreationSettings)));
        outputDataset.getModel().flowOptions.virtualizable = defaultCreationSettings.virtualizable;
        if (copyPartitioningFrom != null && copyPartitioningFrom.getPartitioningSchema().isPartitioned()) {
            ManagedDatasetsHelper.copyPartitioning(this.datasetsDAO, copyPartitioningFrom, outputDataset);
        }
        return outputDataset;
    }

    public Dataset prepareCopyPartitioning(AuthCtx authCtx, String projectKey, String name, ManagedDatasetCreationSettings settings) throws Exception {
        DatasetUtils.checkName(name);
        DSSConnection c2 = this.connectionsDAO.getMandatoryConnection(authCtx, settings.connectionId);
        String outputDatasetType = c2.getMainManagedDatasetType();
        if (c2 instanceof FSProviderizableConnection && settings.typeOptionId != null) {
            outputDatasetType = settings.typeOptionId;
        }
        Partitionable copyPartitioningFrom = this.getPartitionableFromPartitioningOptionId(projectKey, settings.partitioningOptionId);
        DatasetHandler.DatasetMeta<?, ?> outputDatasetMeta = DatasetHandlerFactory.getMeta(outputDatasetType);
        Dataset outputDataset = new Dataset();
        outputDataset.setFullName(projectKey + "." + name);
        outputDatasetMeta.fillManagedDatasetParams(outputDataset, c2, settings.specificSettings);
        outputDataset.setSchema(new Schema());
        outputDataset.getModel().readWriteOptions.preserveOrder = settings.preserveOrder;
        GeneralSettingsDAO.AbstractDefaultDatasetCreationSettings defaultCreationSettings = this.getDefaultCreationSettings(projectKey);
        logger.info((Object)("Using creation settings: " + JSON.log((Object)defaultCreationSettings)));
        outputDataset.getModel().flowOptions.virtualizable = defaultCreationSettings.virtualizable;
        if (copyPartitioningFrom != null && copyPartitioningFrom.getPartitioningSchema().isPartitioned()) {
            ManagedDatasetsHelper.copyPartitioning(this.datasetsDAO, copyPartitioningFrom, outputDataset);
        }
        return outputDataset;
    }

    private Partitionable getPartitionableFromPartitioningOptionId(String projectKey, String partitioningOptionId) throws IOException {
        Partitionable copyPartitioningFrom = null;
        if (partitioningOptionId != null && partitioningOptionId.startsWith("copy:dataset:")) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, partitioningOptionId.replace("copy:dataset:", ""));
            copyPartitioningFrom = this.datasetAccessService.getMandatory(loc);
        } else if (partitioningOptionId != null && partitioningOptionId.startsWith("copy:folder:")) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, partitioningOptionId.replace("copy:folder:", ""));
            copyPartitioningFrom = (Partitionable)this.managedFolderDAO.getMandatoryUnsafe(loc);
        } else if (partitioningOptionId != null && partitioningOptionId.startsWith("copy:")) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, partitioningOptionId.replace("copy:", ""));
            copyPartitioningFrom = this.datasetAccessService.getMandatory(loc);
        }
        return copyPartitioningFrom;
    }

    public SerializedDataset create(AuthCtx authCtx, String projectKey, String name, ManagedDatasetCreationSettings settings) throws Exception {
        Dataset outputDataset = this.prepareCopyPartitioning(authCtx, projectKey, name, settings);
        SerializedDataset sds = outputDataset.serialize();
        logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sds)));
        DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
        this.datasetSaveService.create(projectKey, sds, dsCtx, authCtx);
        if (settings.markCreatedAsBuilt) {
            this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(sds));
        }
        this.flowZonesService.attachObjectToZone(settings.zone, projectKey, sds, true);
        return sds;
    }

    private boolean canUploadDatasetsOnConnection(DSSConnection c2, AuthCtx liu) {
        if (!c2.allowWrite) {
            return false;
        }
        if (!c2.allowManagedDatasets && !c2.allowManagedFolders) {
            return false;
        }
        if (!c2.isFreelyUsableBy(liu)) {
            return false;
        }
        return c2 instanceof FSProviderizableConnection;
    }

    static {
        logger = DKULogger.getLogger((String)"dku.formats");
    }

    public static class CreationOptions {
        public List<ConnectionOption> connections = new ArrayList<ConnectionOption>();
        public List<PartitioningOption> inputPartitionings = new ArrayList<PartitioningOption>();
        public List<PartitioningOption> projectPartitionings = new ArrayList<PartitioningOption>();
    }

    static class PartitioningOption {
        String id;
        String label;

        PartitioningOption() {
        }

        PartitioningOption(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }

    public static class ConnectionOption {
        public String id;
        public String connectionName;
        public String connectionDisplayName;
        public String connectionDescription;
        public String connectionType;
        public List<String> fsProviderTypes;
        public List<FormatOption> formats = new ArrayList<FormatOption>();
        public boolean canOverrideSQLCatalog;
        public String unoverridenSQLCatalog;
        public boolean canOverrideSQLSchema;
        public String unoverridenSQLSchema;
        public boolean canFetchCatalogs = true;
        public boolean canFetchSchemas = true;
        public boolean canOverrideIcebergNamespace;
        public String unoverridenIcebergNamespace;
    }

    public static class FormatOption {
        FormatOptionId id;
        String label;

        FormatOption() {
        }

        FormatOption(FormatOptionId id, String label) {
            this.id = id;
            this.label = label;
        }
    }

    public static enum FormatOptionId {
        CSV_ESCAPING_NOGZIP_FORHIVE,
        CSV_UNIX_GZIP,
        CSV_EXCEL_GZIP,
        CSV_EXCEL_GZIP_BIGQUERY,
        CSV_NOQUOTING_NOGZIP_FORPIG,
        PARQUET_HIVE,
        AVRO,
        ORC,
        JSON,
        STRING;

    }

    public static class ManagedUploadableConnectionsResponse {
        public List<ManagedDatasetConnection> connections = new ArrayList<ManagedDatasetConnection>();
    }

    public class CreatableDatasetTypes {
        Set<String> fromAllConnections;
        Set<String> fromPersonalConnections;
        Set<String> outsideOfConnections;

        public CreatableDatasetTypes(Set<String> fromAllConnections, Set<String> fromPersonalConnections, Set<String> outsideOfConnections) {
            this.fromAllConnections = fromAllConnections;
            this.fromPersonalConnections = fromPersonalConnections;
            this.outsideOfConnections = outsideOfConnections;
        }
    }

    public static class ManagedDatasetCreationSettings {
        public String connectionId;
        public String partitioningOptionId;
        public String typeOptionId;
        public boolean inlineDataset;
        public boolean preserveOrder;
        public String zone;
        public boolean markCreatedAsBuilt;
        public ManagedDatasetCreationSpecificSettings specificSettings = new ManagedDatasetCreationSpecificSettings();
    }

    public static class ManagedDatasetCreationSpecificSettings {
        public FormatOptionId formatOptionId;
        public String overrideSQLCatalog;
        public String overrideSQLSchema;
        public String overrideIcebergNamespace;
    }
}

