/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.dataflow.pipeline.NotImplementedRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class RecipeMeta {
    public abstract String getType();

    public abstract Class<? extends RecipeParams> paramsClass();

    public abstract boolean hasJsonPayload();

    public abstract RecipeRunner buildRunner(JobActivity var1) throws Exception;

    public abstract RecipeStatusComputer buildStatusComputer(SerializedRecipe var1, String var2) throws Exception;

    public abstract RecipeDesc getRecipeDesc();

    public RecipeDesc getRecipeDesc(String lang) {
        return this.getRecipeDesc();
    }

    public boolean isContinuous() {
        return false;
    }

    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new GenericRecipeCreator(authCtx, this);
    }

    public abstract RecipeCategoryFlags getCategoryFlags();

    public boolean usesDefaultLifecycleHook() {
        return true;
    }

    public OutputSchemaComputability getOutputSchemasComputability() {
        return OutputSchemaComputability.NONE;
    }

    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        throw new NotImplementedException();
    }

    public boolean isInputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
        throw new IllegalArgumentException(String.format("Rules for availability of input role %s not implemented", role.name));
    }

    public boolean isOutputRoleAvailableForPayload(RecipeDesc.IORoleDef role, String payload) {
        throw new IllegalArgumentException(String.format("Rules for availability of output role %s not implemented", role.name));
    }

    public static RecipeStatusComputer defaultStatusComputer(final String engineType, final String engineLabel, final String variant, final String variantLabel, final String label) {
        return new RecipeStatusComputer(null, null){

            @Override
            public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
                return this.fastStatusIgnorePartitions(authCtx);
            }

            @Override
            public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) {
                RecipeEngineStatus engineRecipeStatus = new RecipeEngineStatus(engineType, engineLabel, variant, variantLabel, label);
                return RecipeStatus.buildSingleEngine(engineRecipeStatus);
            }
        };
    }

    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, @Nullable String payload) {
        return Collections.emptySet();
    }

    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, @Nullable String payload, Map<String, String> replacements) {
        return null;
    }

    public boolean isGenerator() {
        return false;
    }

    public GeneratorEvaluator getGeneratorEvaluator(SerializedRecipe serializedRecipe) {
        throw new IllegalArgumentException("Not a generator recipe");
    }

    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_SPARK, "Cannot get spark configuration for recipe type " + sr.type);
    }

    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_SPARK, "Cannot set spark configuration for recipe type " + sr.type);
    }

    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_CHANGE_ENGINE, "Cannot change engine for recipe type " + sr.type);
    }

    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Impala is not a valid engine for recipe type " + sr.type);
    }

    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Hive is not a valid engine for recipe type " + sr.type);
    }

    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Hive is not a valid engine for recipe type " + sr.type);
    }

    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Spark is not a valid engine for recipe type " + sr.type);
    }

    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return null;
    }

    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        return payload;
    }

    public void updateImplicitIOBeforeSave(String projectKey, SerializedRecipe sr, String payload) {
    }

    public ContainerExecSelection getContainerExecSelection(SerializedRecipe sr, String payload) {
        if (sr.params instanceof ParamsWithContainerizable) {
            return ((ParamsWithContainerizable)((Object)sr.params)).getContainerSelection();
        }
        return null;
    }

    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new NotImplementedRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    public void prepareForSave(SerializedRecipe recipe, PasswordEncryptionService cryptoService) {
    }

    public String preparePayloadForSave(String payload) throws ParseException {
        return JSON.pretty((Object)new JSONParser().parse(payload));
    }

    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) throws Exception {
        throw new NotImplementedException("Column relations not implemented yet for recipe type: " + this.getType());
    }

    public RecipeLineage getBestGuessRecipeLineage(@Nonnull DataLineageService.SerializedGraphNodes predecessors, @Nonnull DataLineageService.SerializedGraphNodes successors) {
        RecipeLineage recipeLineage = new RecipeLineage();
        if (predecessors.datasetsByFullName.isEmpty() || successors.datasetsByFullName.isEmpty()) {
            recipeLineage.setUncertain(true);
            return recipeLineage;
        }
        predecessors.datasetsByFullName.forEach((predecessorFullName, predecessor) -> {
            Schema predecessorSchema = predecessor.getSchema();
            successors.datasetsByFullName.forEach((successorFullName, successor) -> {
                Schema successorSchema = successor.getSchema();
                DatasetPairLineage datasetPairLineage = new DatasetPairLineage((String)predecessorFullName, predecessorSchema, (String)successorFullName, successorSchema);
                datasetPairLineage.initializeDirectColumnRelations();
                recipeLineage.setDatasetPairLineage((String)predecessorFullName, (String)successorFullName, datasetPairLineage);
            });
        });
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    @Nonnull
    protected SerializedDataset getSerializedDataset(@Nonnull Map<String, SerializedDataset> datasetsByFullName, @Nonnull String datasetFullName) {
        SerializedDataset sd = datasetsByFullName.get(datasetFullName);
        if (sd == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, this.getType() + " recipe: Failed to fetch serialized dataset " + datasetFullName);
        }
        return sd;
    }

    public static enum OutputSchemaComputability {
        RELIABLE_STATIC,
        RELIABLE_DYNAMIC,
        EXPENSIVE,
        NONE;

    }

    public static class RecipeCategoryFlags {
        public boolean isSpark;
        public boolean isVisualSQL;
        public boolean isML;
        public boolean isPlugin;
        public boolean isUserCode;
        public boolean isNlp;
        public boolean isVisualRecipe;

        public RecipeCategoryFlags withSpark() {
            this.isSpark = true;
            return this;
        }

        public RecipeCategoryFlags withVisualSQL() {
            this.isVisualSQL = true;
            return this;
        }

        public RecipeCategoryFlags withML() {
            this.isML = true;
            return this;
        }

        public RecipeCategoryFlags withPlugin() {
            this.isPlugin = true;
            return this;
        }

        public RecipeCategoryFlags withUserCode() {
            this.isUserCode = true;
            return this;
        }

        public RecipeCategoryFlags withVisualRecipe() {
            this.isVisualRecipe = true;
            return this;
        }

        public RecipeCategoryFlags withNlp() {
            this.isNlp = true;
            return this;
        }
    }
}

