/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.impala.ImpalaQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ImpalaRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;

    public ImpalaRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        ImpalaRecipeStatusRequest request = (ImpalaRecipeStatusRequest)JSON.parse((String)requestData, ImpalaRecipeStatusRequest.class);
        ImpalaRecipeStatus ret = null;
        try (Transaction t = this.transactionService.beginRead();){
            ret = this.fastStatusIgnorePartitions(authCtx);
        }
        if (request != null) {
            ImpalaQueryRecipeTester tester = new ImpalaQueryRecipeTester();
            AbstractSQLQueryRecipeTester.SQLQueryValidationResult res = (AbstractSQLQueryRecipeTester.SQLQueryValidationResult)tester.startValidate_NT(this.recipe, this.payload, request.run, request.targetPartitionSpec, authCtx).call();
            ret.schemaResult = res.schemaResult;
            ret.substitutionVariables = res.substitutionVariables;
            if (StringUtils.isNotBlank((String)res.substitutedQuery) && !res.substitutedQuery.equals(this.payload)) {
                ret.substitutedCode = res.substitutedQuery;
            }
            ret.topLevelMessages.mergeFrom(res.messages);
            ret.runResult = res.runResult;
        }
        return ret;
    }

    @Override
    public ImpalaRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ImpalaRecipeStatus ret = new ImpalaRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("IMPALA", "Impala", null, null, "Impala");
        return ret;
    }

    public static class ImpalaRecipeStatusRequest
    extends CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest {
        public boolean run;
    }

    public static class ImpalaRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
        public QueryRunResult runResult;
    }
}

