/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.scala;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.ClusterDependentKernelHandle;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.LoggableCommand;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ScalaKernelHandle
extends ClusterDependentKernelHandle {
    public static final long START_TIMEOUT = 30000L;
    private AutoDelete tmpDir;
    private AutoDelete localDir;
    private APITicketService.ExpirableTicket ticket;

    public ScalaKernelHandle(String sekId, String key) {
        super("scala", sekId, key);
    }

    public static List<SimpleKeyValue> makeConf(SparkSettings sparkSettings) throws IOException, DKUSecurityException {
        SparkOverrideConfig sparkConf = new SparkOverrideConfig();
        if ("default".equals(sparkSettings.configForSEK)) {
            logger.info((Object)"Default spark conf, setting spark.master and spark.local.dir");
            sparkConf.conf.add(new SimpleKeyValue("spark.master", "local[1]"));
        } else {
            sparkConf.inheritConf = sparkSettings.configForSEK;
        }
        return SparkJobHelper.composeConf((AuthCtx)DSSAuthCtx.newNone(), "__DKU_ANY_PROJECT__", sparkSettings, sparkConf, new HashMap<String, String>());
    }

    @Override
    protected ProcessBuilder getProcessBuilder(ClusterSettings clusterSettings) throws Exception {
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        List<SimpleKeyValue> conf = ScalaKernelHandle.makeConf(sparkSettings);
        if ("default".equals(sparkSettings.configForSEK)) {
            this.localDir = DSSTempUtils.getTempFolder((String)"scala-kernel", (String)"local");
            conf.add(new SimpleKeyValue("spark.local.dir", this.localDir.getCanonicalPath()));
        }
        SparkSubmitHelper helper = SparkSubmitHelper.build("__dku__", DSSAuthCtx.newNone(), sparkSettings, hadoopSettings, null, null);
        LoggableCommand args = helper.toCommand((SparkSubmitJob)helper.makeClassJob("scala-kernel", true, conf, "com.dataiku.dip.sek.ScalaKernelMain", new String[0]));
        logger.info((Object)("Execute spark-submit:\n" + args.getLogString()));
        this.tmpDir = DSSTempUtils.getTempFolder((String)"scala-kernel", (String)"run");
        ProcessBuilder pb = new ProcessBuilder(args.getCommands());
        for (SimpleKeyValue var : sparkSettings.environmentVariables) {
            pb.environment().put(var.key, var.value);
        }
        pb.environment().put("DKU_SEK_ID", this.getKernelId());
        this.ticket = ((APITicketService)SpringUtils.getBean(APITicketService.class)).createExpiringTicket((AuthCtx)DSSAuthCtx.newNone(), "Spark validation", null);
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return pb;
    }

    @Override
    protected List<AutoCloseable> getProcessResourcesToClose() {
        ArrayList ret = Lists.newArrayList();
        if (this.tmpDir != null) {
            ret.add(this.tmpDir);
        }
        if (this.localDir != null) {
            ret.add(this.localDir);
        }
        if (this.ticket != null) {
            ret.add(this.ticket);
        }
        return ret;
    }

    @Override
    protected File getRunDir() {
        return this.tmpDir;
    }

    @Override
    protected void ping() throws Exception {
        this.getAPIClient().postFormToStringV("/scala/ping", new Object[0]);
    }

    @Override
    protected void tryThrowingError() throws Exception {
        File errorFile = new File((File)this.tmpDir, "error.json");
        if (errorFile.exists() && errorFile.length() > 0L) {
            SerializedError err = null;
            try {
                err = (SerializedError)JSON.parseFile((File)new File((File)this.tmpDir, "error.json"), SerializedError.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (err != null) {
                throw new APIError.SerializedErrorException(err);
            }
        }
        logger.error((Object)"Could not retrieve Spark training error details");
    }
}

