/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.scala;

import com.dataiku.dip.cluster.ClusterDependentKernelsManager;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.recipes.code.scala.IScalaKernelsManager;
import com.dataiku.dip.recipes.code.scala.ScalaKernelHandle;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ScalaKernelsManager
extends ClusterDependentKernelsManager<ScalaKernelHandle>
implements IScalaKernelsManager {
    @Override
    public String getPrefix() {
        return "scala";
    }

    @Override
    protected ScalaKernelHandle instantiateKernel(String kernelId, String key) {
        return new ScalaKernelHandle(kernelId, key);
    }

    @Override
    protected String getKey(ClusterSettings clusterSettings) {
        try {
            SparkSettings sparkSettings = clusterSettings.getSparkSettings();
            List<SimpleKeyValue> conf = ScalaKernelHandle.makeConf(sparkSettings);
            TreeMap pairs = Maps.newTreeMap();
            StringBuilder sb = new StringBuilder();
            for (SimpleKeyValue simpleKeyValue : conf) {
                pairs.put(simpleKeyValue.key, simpleKeyValue.value);
            }
            for (SimpleKeyValue simpleKeyValue : sparkSettings.environmentVariables) {
                pairs.put(simpleKeyValue.key, simpleKeyValue.value);
            }
            if (StringUtils.isNotBlank((String)sparkSettings.sparkHome)) {
                pairs.put("DKU_SPARK_HOME", sparkSettings.sparkHome);
            }
            for (Map.Entry entry : pairs.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append("\t");
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            return DKUtils.md5Base64((String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute key for scala kernel, using default", (Throwable)e);
            return "default";
        }
    }
}

