/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.scala;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeJobDef;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.customcode.SparkCustomCodeRecipeParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.utils.JSON;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkScalaRecipeJobDefBuilder {
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final LoadedCustomCodeRecipeDesc desc;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private CustomCodeRecipesService customCodeRecipeService;
    @Autowired
    private JobAuthCtxService authCtxService;

    public SparkScalaRecipeJobDefBuilder(JobActivity activity) {
        this(activity, null);
    }

    public SparkScalaRecipeJobDefBuilder(JobActivity activity, @Nullable LoadedCustomCodeRecipeDesc pluginDesc) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.desc = pluginDesc;
    }

    public SparkScalaRecipeJobDef build() throws Exception {
        FlowDatasetRef fdr;
        SparkScalaRecipeJobDef jobDef = new SparkScalaRecipeJobDef();
        String projectKey = this.recipe.getProjectKey();
        boolean useGlobalMetastore = false;
        jobDef.projectKey = projectKey;
        jobDef.flowSpec = EnvironmentStash.buildNoAppendFlowSpec(this.activity, projectKey, this.datasetsDAO);
        HashMap<String, String> flowVariables = new HashMap<String, String>();
        FlowVariables.addPartitioningVariables(this.authCtxService.getAuthCtx(), flowVariables, this.activity.getSubgraph(), this.datasetsDAO);
        jobDef.flowVariables = JSON.json(flowVariables);
        for (FlowDataset in : this.activity.getSubgraph().getSourceDatasets()) {
            fdr = SparkRecipeUtils.getInputFlowDatasetRef(in, new InputDatasetsReadParams(), useGlobalMetastore, this.recipe, this.activity, this.datasetsDAO);
            jobDef.inputs.add(fdr);
        }
        for (FlowDataset out : this.activity.getSubgraph().getTargetsDatasets()) {
            fdr = SparkRecipeUtils.getOutputFlowDatasetRef(out, projectKey, this.activity, this.datasetsDAO);
            jobDef.outputs.add(fdr);
        }
        if (this.desc != null) {
            jobDef.isCustomRecipe = true;
            jobDef.code = this.customCodeRecipeService.getCode(this.desc.recipeType);
            SparkCustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SparkCustomCodeRecipeParams.class);
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customCodeRecipeService.getExpandedPluginSettings(this.desc.recipeType, this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), params.customConfig);
            jobDef.customRecipeConfig = JSON.json((Object)expandedPluginSettings.config);
            jobDef.customRecipePluginConfig = JSON.json((Object)expandedPluginSettings.pluginConfig);
            String resourceFolder = this.customCodeRecipeService.getResourceFolder(this.desc.recipeType);
            if (resourceFolder != null && resourceFolder.length() > 0) {
                jobDef.pluginResourceFolder = resourceFolder;
            }
        } else {
            jobDef.isCustomRecipe = false;
            jobDef.code = this.recipesDAO.getPayloadOrNull(projectKey, this.recipe.getName());
        }
        return jobDef;
    }
}

