/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class PySparkRecipeRunner
extends AbstractSparkBasedRecipeRunner
implements RecipeRunnerWithPayload {
    private String code;
    private final PySparkRecipeMeta.PySparkRecipeParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.pyspark");

    public PySparkRecipeRunner(JobActivity activity) {
        super(activity);
        this.params = RecipeRegistry.getParamsAs(activity, PySparkRecipeMeta.PySparkRecipeParams.class);
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    protected File prepareWrapper(File processRunDir) throws Exception {
        String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/python-exec-wrapper.py");
        File wrapperFile = new File(processRunDir, "python-exec-wrapper.py");
        DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
        return wrapperFile;
    }

    @Override
    public void run() throws Exception {
        CodeEnvSelector envSelector = new CodeEnvSelector();
        String envName = envSelector.selectForPythonRecipe(this.recipe.getProjectKey(), RecipeRegistry.getParamsAs((JobActivity)this.activity, PySparkRecipeMeta.PySparkRecipeParams.class).envSelection);
        this.runPySpark("PySpark", envName, this.params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "script.py");
                logger.info((Object)("Dumping Pyspark script to " + String.valueOf(tmpScriptData)));
                FileUtils.writeStringToFile((File)tmpScriptData, (String)PySparkRecipeRunner.this.code);
                File wrapperFile = PySparkRecipeRunner.this.prepareWrapper(runDir);
                T job = helper.makePyJob("DSS (Py): " + PySparkRecipeRunner.this.activity.id(), effectiveConf, wrapperFile.getAbsolutePath(), tmpScriptData.getAbsolutePath());
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return PySparkRecipeRunner.this.params.sparkConfig;
            }

            @Override
            public List<String> getWritablePaths() {
                return Lists.newArrayList((Object[])new String[]{"error.json"});
            }
        }, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_SPARK_RECIPE);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }
}

