/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeJobDef;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkSQLQueryJobDefBuilder {
    private final JobActivity activity;
    private final FlowRecipe recipe;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private VariablesService variablesService;
    private static final Logger logger = Logger.getLogger((String)"dku.spark.sparksql");

    public SparkSQLQueryJobDefBuilder(JobActivity activity) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
    }

    public SparkSQLQueryRecipeJobDef buildJobDef(String finalQuery, boolean overwriteOutputSchema, boolean useGlobalMetastore, InputDatasetsReadParams readParams) throws IOException {
        SparkSQLQueryRecipeJobDef serialized = new SparkSQLQueryRecipeJobDef();
        this.setupInputs(readParams, serialized, useGlobalMetastore);
        FlowDataset out = this.activity.getSubgraph().getSingleTargetDataset();
        this.setupOutput(finalQuery, serialized, out, SparkSQLQueryJobDefBuilder.findWriteMode(out.getOrNull(this.datasetsDAO), this.recipe.getModel()));
        serialized.writeSchema = overwriteOutputSchema;
        serialized.useGlobalMetastore = useGlobalMetastore;
        if (useGlobalMetastore) {
            serialized.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (serialized.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                serialized.metastoreDatabase = "";
            }
        }
        return serialized;
    }

    public SparkSQLQueryRecipeJobDef buildJobDef(Map<String, String> finalQueries, boolean overwriteOutputSchema, boolean useGlobalMetastore, InputDatasetsReadParams readParams) throws IOException {
        SparkSQLQueryRecipeJobDef serialized = new SparkSQLQueryRecipeJobDef();
        this.setupInputs(readParams, serialized, useGlobalMetastore);
        for (FlowDataset out : this.activity.getSubgraph().getTargetsDatasets()) {
            String finalQuery = finalQueries.get(out.getFullName());
            if (StringUtils.isNotBlank((String)finalQuery)) {
                this.setupOutput(finalQuery, serialized, out, SparkSQLQueryJobDefBuilder.findWriteMode(out.getOrNull(this.datasetsDAO), this.recipe.getModel()));
                continue;
            }
            logger.info((Object)("Output without query, ignoring: " + out.getFullName()));
        }
        serialized.writeSchema = overwriteOutputSchema;
        serialized.useGlobalMetastore = useGlobalMetastore;
        if (useGlobalMetastore) {
            serialized.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (serialized.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                serialized.metastoreDatabase = "";
            }
        }
        return serialized;
    }

    public static Output.WriteMode findWriteMode(Dataset ds, SerializedRecipe model) throws IOException {
        if (ds == null || !DeltaFormat.META.getType().equals(ds.getFormatType())) {
            return Output.WriteMode.OVERWRITE;
        }
        for (SerializedRecipe.RecipeOutput output : model.getFlatOutputs()) {
            if (!DatasetLocUtils.DatasetLoc.resolveSmart(model.projectKey, output.ref).equals(ds.getLoc())) continue;
            return output.getWriteMode();
        }
        return Output.WriteMode.OVERWRITE;
    }

    private void setupOutput(String finalQuery, SparkSQLQueryRecipeJobDef serialized, FlowDataset out, Output.WriteMode writeMode) {
        SparkSQLDialect dialect = new SparkSQLDialect();
        Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
        String[] statementSqls = splitter.split(finalQuery);
        int selectStatementIndex = SQLUtils.findLastSelectStatement(statementSqls, splitter);
        logger.info((Object)("Found " + statementSqls.length + " parts and the index of the select is " + selectStatementIndex));
        String outputFullName = out.getFullName();
        String outputPartition = this.activity.getSubgraph().getTargetPartition(out).id();
        if (selectStatementIndex < 0) {
            logger.info((Object)"Select not found, cancelling split");
            serialized.outputs.add(new SparkSQLQueryRecipeJobDef.SparkSQLQueryRecipeOutputDef(outputFullName, outputPartition, finalQuery, writeMode));
        } else {
            int i;
            for (i = 0; i < selectStatementIndex; ++i) {
                serialized.preQueries.add(statementSqls[i]);
            }
            for (i = selectStatementIndex + 1; i < statementSqls.length; ++i) {
                serialized.postQueries.add(statementSqls[i]);
            }
            serialized.outputs.add(new SparkSQLQueryRecipeJobDef.SparkSQLQueryRecipeOutputDef(outputFullName, outputPartition, statementSqls[selectStatementIndex], writeMode));
        }
    }

    private void setupInputs(InputDatasetsReadParams readParams, SparkSQLQueryRecipeJobDef serialized, boolean useGlobalMetastore) throws IOException {
        serialized.readParams = (InputDatasetsReadParams)JSON.deepCopy((Object)readParams);
        for (FlowDataset in : this.activity.getSubgraph().getSourceDatasets()) {
            FlowDatasetRef fdr = SparkRecipeUtils.getInputFlowDatasetRef(in, serialized.readParams, useGlobalMetastore, this.recipe, this.activity, this.datasetsDAO);
            serialized.inputs.add(fdr);
        }
    }

    public String buildFinalQuery(String originalQuery) throws IOException, CodedException, DKUSecurityException {
        HashMap<String, String> variables = new HashMap<String, String>();
        FlowVariables.addPartitioningVariables(this.authCtxService.getAuthCtx(), variables, this.activity.getSubgraph(), this.datasetsDAO);
        FlowVariables.addWhereClauseVariables(variables, this.activity.getSubgraph(), this.datasetsDAO, new SparkSQLDialect());
        String query = originalQuery;
        String finalQuery = FlowVariables.substitute(variables, query);
        finalQuery = this.variablesService.getForProject(this.recipe.getProjectKey()).expand(finalQuery);
        return finalQuery;
    }
}

