/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSQLQueryInternalRunner
extends AbstractSQLQueryLikeRecipeRunner {
    @Autowired
    protected DatasetWritingService datasetWritingService;
    protected RecipeRunnableSubgraph subgraph;
    protected boolean overwriteTargetSchema;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sql");

    public AbstractSQLQueryInternalRunner(JobActivity activity, boolean overwriteTargetSchema) {
        super(((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey());
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.overwriteTargetSchema = overwriteTargetSchema;
    }

    protected abstract RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaResult(AuthCtx var1, Dataset var2, SQLConnectionProvider.SQLConnectionData var3, SQLConnectionProvider.SQLConnectionWrapper var4, String var5) throws Exception;

    protected void handleSchemaOverwrite(Dataset targetDataset, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, QueryBunch queryBunch, boolean addPreAndPostQueries) throws Exception {
        String checkedQuery;
        logger.info((Object)"Checking output schema");
        if (addPreAndPostQueries) {
            StringBuilder script = new StringBuilder();
            String eol = System.getProperty("line.separator");
            for (String query : queryBunch.preQueries) {
                script.append(query);
                script.append(eol).append(";").append(eol);
            }
            script.append(queryBunch.query);
            script.append(eol).append(";").append(eol);
            for (String query : queryBunch.postQueries) {
                script.append(query);
                script.append(eol).append(";").append(eol);
            }
            checkedQuery = script.toString();
        } else {
            checkedQuery = queryBunch.query;
        }
        try {
            RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult = this.getSchemaResult(TransactionContext.retrieveWrite().getUser(), targetDataset, connData, conn, checkedQuery);
            if (schemaResult.totalIncompatibilities > 0) {
                logger.info((Object)"Overriding the schema of the dataset");
                this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), targetDataset.getDatasetLoc(), schemaResult.computables.get((int)0).newSchema, false, null);
                KernelSession.propagateSchemaToJekOrBackend(targetDataset.getFullName(), schemaResult.computables.get((int)0).newSchema);
                targetDataset.setSchema(schemaResult.computables.get((int)0).newSchema);
            }
        }
        catch (AbstractSQLQueryRecipeTester.FatalPartitioningError e) {
            throw new IllegalArgumentException(e.describe());
        }
    }

    protected void runRegularToDatasetWithOW(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData, QueryBunch queryBunch) throws Exception {
        logger.info((Object)"Running as regular stream mode");
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        DateTimeZone assumedTz = DateTimeZone.UTC;
        if (DatasetInspector.isSQL(targetDataset)) {
            String timezoneId = targetDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(targetDataset.getProjectKey()).getAssumedJavaTzForUnknownTz();
            assumedTz = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
        }
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, this.recipeProjectKey);){
            Statement stmt;
            for (String query : queryBunch.preQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            try (Statement stmt2 = SQLUtils.getProperlyStreamableStatement(connData, conn);){
                if (this.overwriteTargetSchema) {
                    this.handleSchemaOverwrite(targetDataset, connData, conn, queryBunch, false);
                }
                ProcessorOutput out = SQLQueryRecipeUtils.buildProcessorOutput(authCtx, targetDataset, targetPartition, this.activity, (ColumnFactory)cf, (RowFactory)rf);
                this.executeCancellableStatement(conn, stmt2, queryBunch.query);
                ResultSet rs2 = stmt2.getResultSet();
                ResultSetMetaData meta = rs2.getMetaData();
                ArrayList<Column> columns = new ArrayList<Column>();
                ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
                for (SchemaColumn sc : targetDataset.getSchema().getColumns()) {
                    columns.add(cf.column(sc.getName()));
                    schemaColumns.add(new SchemaColumn(sc).withTimestampNoTzAsDate(sc.timestampNoTzAsDate && !targetDataset.isManaged()));
                }
                logger.info((Object)"Starting to emit output data");
                int rows = 0;
                while (rs2.next()) {
                    if (this.abortNotified) {
                        throw new ActivityAbortedException();
                    }
                    SQLQueryRecipeUtils.streamSingleRow(connData, columns, schemaColumns, rs2, meta, (RowFactory)rf, out, assumedTz, true);
                    if (++rows % 10000 != 0) continue;
                    logger.infoV("Emitted %d rows", new Object[]{rows});
                }
                out.lastRowEmitted();
            }
            catch (Exception e) {
                logger.error((Object)"Query failed", (Throwable)e);
                throw e;
            }
            for (String query : queryBunch.postQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            if (connData.getDialect().supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Query failed", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void run() throws Exception {
        throw new Error();
    }
}

