/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class SQLQueryRecipeTester
extends AbstractSQLQueryRecipeTester {
    public SQLQueryRecipeTester() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected SQLConnectionProvider.SQLConnectionData getConnectionDataFromConnection_NT(AuthCtx authCtx, String projectKey, String sourceConnection) throws IOException, SQLException, DKUSecurityException {
        return SQLConnectionProvider.getConnectionData_NT(authCtx, projectKey, sourceConnection);
    }

    @Override
    protected String getRecipeType() {
        return "sql_query";
    }

    @Override
    protected String getRecipeDisplayName() {
        return "SQL query";
    }

    @Override
    protected String getSQLDatasetConnectionName(AuthCtx authCtx, Dataset ds) {
        return DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, ds);
    }

    @Override
    protected void validateSourceDatasets(List<Dataset> sourceDatasets, AuthCtx liu) throws IllegalArgumentException {
        for (Dataset dataset : sourceDatasets) {
            if (DatasetInspector.isSQLAble(liu, dataset)) continue;
            throw ErrorContext.iaef((String)"Input dataset %s cannot be used as input of this recipe", (Object)dataset.getName(), (Object[])new Object[0]);
        }
    }

    @Override
    protected InfoMessage.InfoMessages getFullSqlRecommendation(SerializedRecipe recipe, String mainConnection) throws IOException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (SQLQueryRecipeUtils.getAllDatasetStream(recipe).map(ds -> ds.type).allMatch(Lists.newArrayList((Object[])new String[]{BuiltinFSDatasets.S3_META.getType(), BuiltinSQLDatasets.ATHENA_META.getType()})::contains)) {
            messages.withInfo((InfoMessage.MessageCode)RecipeCodes.INFO_RECIPE_NO_FAST_PATH, "Results from Athena to S3 are streamed through DSS.");
        } else if (SQLQueryRecipeUtils.getAllDatasetStream(recipe).map(dataset -> dataset.type).distinct().count() == 1L && SQLQueryRecipeUtils.getTargetConnectionStream(recipe).noneMatch(connection -> connection.equals(mainConnection))) {
            messages.withInfo((InfoMessage.MessageCode)RecipeCodes.INFO_RECIPE_POTENTIAL_FAST_PATH, "If the output dataset connection has access to all inputs, selecting it as the main connection will enable fast-path.");
        }
        return messages;
    }

    @Override
    protected boolean checkConnectionsMismatch(Set<String> connections, SerializedRecipe recipe) {
        SQLQueryRecipeMeta.SQLQueryRecipeParams params = (SQLQueryRecipeMeta.SQLQueryRecipeParams)recipe.params;
        return !params.allowMultipleConnections && connections.size() > 1;
    }

    @Override
    public String getMainConnection(SerializedRecipe recipe, AuthCtx liu) throws IOException {
        return SQLQueryRecipeUtils.getMainConnection(recipe, liu);
    }

    @Override
    protected boolean willRunInFullSQL(AuthCtx authCtx, String mainConnection, Dataset outputDataset, String query, SerializedRecipe recipe) {
        return SQLQueryRecipeUtils.runsInSQLMode(mainConnection, outputDataset, query);
    }
}

