/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class RecipeConfigUtils {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    protected ProjectsDAO projectsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.engines");

    public RecipeConfigUtils() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public RecipeEnginesPreferenceConfig getResolvedPreferenceConfig(String projectKey, String recipeType, RecipeEnginesPreferenceConfig recipeConfig) {
        Validate.notNull((Object)projectKey);
        Validate.notNull((Object)recipeType);
        try {
            RecipeEnginesPreferenceConfig global = this.generalSettingsDAO.getUnsafe().recipeEnginesPreferences;
            RecipeEnginesPreferenceConfig project = this.projectsDAO.getMandatoryUnsafe_NoTag((String)projectKey).settings.recipeEnginesPreferences;
            RecipeEnginesPreferenceConfig pplusg = project.mergeWithParent(global);
            RecipeEnginesPreferenceConfig ret = null;
            ret = recipeConfig != null ? recipeConfig.mergeWithParent(pplusg) : pplusg;
            if (logger.isTraceEnabled()) {
                logger.traceV("Resolved preferences projectKey=%s recipeType=%s global=%s project=%s pplusg=%s recipe=%s resolved=%s", new Object[]{projectKey, recipeType, JSON.log((Object)global), JSON.log((Object)project), JSON.log((Object)pplusg), JSON.log((Object)recipeConfig), JSON.log((Object)ret)});
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read recipe preferences", e);
        }
    }
}

