/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRecipe;
import com.dataiku.dip.plugin.ExecutionContext;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeParams;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomJavaRecipeRunner
implements FlowRunnable,
RecipeRunner,
AbortableRecipeRunner {
    @Autowired
    private CustomCodeRecipesService service;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    protected DatasetWritingService datasetWritingService;
    private final JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private final FlowRecipe recipe;
    private CustomCodeRecipeParams params;
    private CustomRecipe remoteRecipe;
    private static Logger logger = Logger.getLogger((String)"dku.flow.customjava");

    public CustomJavaRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
        CustomCodeRecipeMeta meta = (CustomCodeRecipeMeta)RecipeRegistry.getMeta(this.activity);
        LoadedCustomCodeRecipeDesc desc = meta.getPluginDesc();
        this.params = RecipeRegistry.getParamsAs(this.activity, CustomCodeRecipeParams.class);
        logger.info((Object)("Instantiate plugin dataset of type " + desc.getType()));
        ClassLoader classLoader = this.service.getClassloader(desc.getType());
        if (StringUtils.isBlank((String)desc.desc.recipeClass)) {
            throw new Exception("Incorrect custom recipe : no java class specified");
        }
        logger.info((Object)("Create recipe of class " + desc.desc.recipeClass));
        this.remoteRecipe = (CustomRecipe)new PluginClazzLoader(classLoader).loadClazz(desc.desc.recipeClass);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(desc.getType(), this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.params.customConfig);
        JsonObject pluginConfig = expandedPluginSettings.pluginConfig;
        JsonObject config = expandedPluginSettings.config;
        String resourceFolder = this.service.getResourceFolder(desc.recipeType);
        this.remoteRecipe.init(this.recipe.getProjectKey(), config, pluginConfig, resourceFolder);
    }

    @Override
    public void run() throws Exception {
        try (CustomRecipeBackendClient backendClient = new CustomRecipeBackendClient();){
            CustomRecipeExecutionContext context = new CustomRecipeExecutionContext();
            this.remoteRecipe.run((ExecutionContext)context, (BackendClient)backendClient);
        }
    }

    @Override
    public void notifyBeforeAborting() {
        this.remoteRecipe.abort();
    }

    private class CustomRecipeBackendClient
    implements BackendClient,
    AutoCloseable {
        private TicketBasedIntercomAPIClient apiClient;
        private String ticketSecret;

        public CustomRecipeBackendClient() {
            this.ticketSecret = CustomJavaRecipeRunner.this.apiTicketService.getSingleTicket().getSecret();
            this.apiClient = new TicketBasedIntercomAPIClient("http://localhost:" + Integer.parseInt(System.getenv("DKU_BACKEND_PORT")), null, this.ticketSecret);
        }

        public JsonElement executePost(String url, Object ... form) throws Exception {
            return (JsonElement)this.apiClient.postFormToJSON(url, JsonElement.class, form);
        }

        public JsonElement executePost(String url, Object data) throws Exception {
            return (JsonElement)this.apiClient.postObject(url, JsonElement.class, data);
        }

        public JsonElement executeGet(String url) throws Exception {
            return (JsonElement)this.apiClient.get(url, JsonElement.class);
        }

        public JsonElement executeGet(String url, Object ... form) throws Exception {
            return (JsonElement)this.apiClient.getForm(url, JsonElement.class, form);
        }

        public String getTicket() {
            return this.ticketSecret;
        }

        public Object getAuthCtx() {
            return CustomJavaRecipeRunner.this.authCtxService.getAuthCtx();
        }

        @Override
        public void close() throws Exception {
            this.apiClient.close();
        }
    }

    private class CustomRecipeExecutionContext
    implements ExecutionContext {
        private CustomRecipeExecutionContext() {
        }

        public String getRecipeName() {
            return CustomJavaRecipeRunner.this.recipe.getName();
        }

        public File getTempFolder(String prefix) throws IOException {
            return FlowJobUtils.getTmpFolder("custom-java-recipe", prefix);
        }

        public List<ExecutionContext.InputInfo> getInputs() throws IOException {
            ArrayList infos = Lists.newArrayList();
            for (Map.Entry<String, SerializedRecipe.InputRole> inputRole : CustomJavaRecipeRunner.this.recipe.getModel().getInputsUnsafe().entrySet()) {
                String role = inputRole.getKey();
                for (SerializedRecipe.RecipeInput input : inputRole.getValue().items) {
                    FlowComputable computable = CustomJavaRecipeRunner.this.computableFromRefService.get(CustomJavaRecipeRunner.this.recipe.getProjectKey(), input.ref);
                    infos.add(new FlowComputableInputInfo(role, computable, CustomJavaRecipeRunner.this.subgraph.getSourcePartitions(computable)));
                }
            }
            return infos;
        }

        public List<ExecutionContext.OutputInfo> getOutputs() throws IOException {
            ArrayList infos = Lists.newArrayList();
            for (Map.Entry<String, SerializedRecipe.OutputRole> outputRole : CustomJavaRecipeRunner.this.recipe.getModel().getOutputsUnsafe().entrySet()) {
                String role = outputRole.getKey();
                for (SerializedRecipe.RecipeOutput output : outputRole.getValue().items) {
                    FlowComputable computable = CustomJavaRecipeRunner.this.computableFromRefService.get(CustomJavaRecipeRunner.this.recipe.getProjectKey(), output.ref);
                    infos.add(new FlowComputableOutputInfo(role, computable, CustomJavaRecipeRunner.this.subgraph.getTargetPartition(computable), output.getWriteMode()));
                }
            }
            return infos;
        }

        public List<ExecutionContext.InputInfo> getInputsForRole(String role) throws IOException {
            ArrayList infos = Lists.newArrayList();
            for (SerializedRecipe.RecipeInput input : CustomJavaRecipeRunner.this.recipe.getModel().getInputsForRole(role)) {
                FlowComputable computable = CustomJavaRecipeRunner.this.computableFromRefService.get(CustomJavaRecipeRunner.this.recipe.getProjectKey(), input.ref);
                infos.add(new FlowComputableInputInfo(role, computable, CustomJavaRecipeRunner.this.subgraph.getSourcePartitions(computable)));
            }
            return infos;
        }

        public List<ExecutionContext.OutputInfo> getOutputsForRole(String role) throws IOException {
            ArrayList infos = Lists.newArrayList();
            for (SerializedRecipe.RecipeOutput output : CustomJavaRecipeRunner.this.recipe.getModel().getOutputsForRole(role)) {
                FlowComputable computable = CustomJavaRecipeRunner.this.computableFromRefService.get(CustomJavaRecipeRunner.this.recipe.getProjectKey(), output.ref);
                infos.add(new FlowComputableOutputInfo(role, computable, CustomJavaRecipeRunner.this.subgraph.getTargetPartition(computable), output.getWriteMode()));
            }
            return infos;
        }

        public void runSQLInConnection(String sql, ExecutionContext.InputOutputInfo io) throws IOException, SQLException, DKUSecurityException, InterruptedException {
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(io.getProjectKey(), io.getId());
            FlowComputable computable = null;
            boolean isSource = false;
            for (FlowComputable flowComputable : CustomJavaRecipeRunner.this.subgraph.getSources()) {
                if (!flowComputable.getFullId().equals(loc.getFullName())) continue;
                computable = flowComputable;
                isSource = true;
            }
            for (FlowComputable flowComputable : CustomJavaRecipeRunner.this.subgraph.getTargets()) {
                if (!flowComputable.getFullId().equals(loc.getFullName())) continue;
                computable = flowComputable;
                isSource = false;
            }
            if (computable == null) {
                throw new IllegalArgumentException("Could not find input or output");
            }
            if (!(computable instanceof FlowDataset)) {
                throw new IllegalArgumentException("Not a dataset");
            }
            FlowDataset flowDataset = (FlowDataset)computable;
            Dataset dataset = flowDataset.getMandatory(CustomJavaRecipeRunner.this.datasetsDAO);
            if (!DatasetInspector.isSQL(dataset)) {
                throw new IllegalArgumentException("Dataset is not SQL");
            }
            logger.info((Object)("Running sql in connection of " + (isSource ? "source" : "target") + " dataset " + loc.getFullName()));
            SQLConnectionProvider.SQLConnectionData connectionData = DatasetInspector.getSQLConnectionForSQLOrHiveDataset(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx(), dataset);
            try (SQLConnectionProvider.SQLConnectionWrapper connection = SQLConnectionProvider.newConnection(connectionData, CustomJavaRecipeRunner.this.authCtxService.getAuthCtx(), CustomJavaRecipeRunner.this.recipe.getProjectKey());
                 Statement st2 = connection.createStatement();){
                st2.execute(sql);
            }
        }
    }

    private class FlowComputableInputOutputInfo
    implements ExecutionContext.InputOutputInfo {
        private final FlowComputable computable;
        private final String role;
        private final AnyLoc loc;
        private final Partitionable partitionable;
        private FSProvider provider;
        private String singleFile;

        FlowComputableInputOutputInfo(String role, FlowComputable computable) throws IOException {
            this.role = role;
            this.computable = computable;
            this.loc = DatasetLocUtils.DatasetLoc.resolveFull(computable.getFullId());
            this.partitionable = computable instanceof FlowPartitionable ? ((FlowPartitionable)((Object)computable)).getPartitioned(CustomJavaRecipeRunner.this.datasetsDAO) : null;
        }

        protected Dataset getAsDataset() {
            if (this.partitionable instanceof Dataset) {
                return (Dataset)this.partitionable;
            }
            throw new IllegalArgumentException("Not a dataset");
        }

        public String getRole() {
            return this.role;
        }

        public String getProjectKey() {
            return this.loc.getProjectKey();
        }

        public String getId() {
            return this.loc.getId();
        }

        public boolean isDataset() {
            return this.computable instanceof FlowDataset;
        }

        public boolean isFolder() {
            return this.computable instanceof FlowManagedFolder;
        }

        public boolean isModel() {
            return this.computable instanceof FlowSavedModel;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitionable != null ? this.partitionable.getPartitioningSchema() : null;
        }

        public boolean hasFSProvider() {
            if (this.partitionable == null) {
                return false;
            }
            if (this.partitionable instanceof ManagedFolder) {
                return true;
            }
            Dataset dataset = (Dataset)this.partitionable;
            return FSProviderFactory.hasProvider(dataset.getType());
        }

        public FSProvider getFSProvider() throws Exception {
            block15: {
                if (this.partitionable == null) {
                    throw new IllegalArgumentException("Only datasets and folders can have a fs provider");
                }
                if (this.partitionable instanceof ManagedFolder) {
                    ManagedFolder folder = (ManagedFolder)this.partitionable;
                    try (ManagedFolderHandler handler = (ManagedFolderHandler)folder.buildHandler(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx());){
                        this.provider = handler.buildOneProvider();
                    }
                }
                Dataset dataset = (Dataset)this.partitionable;
                try (DatasetHandler handler = (DatasetHandler)dataset.buildHandler(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx());){
                    if (handler instanceof AbstractFSDatasetHandler) {
                        AbstractFSDatasetHandler.FSProviderAndPath providerAndSingleFile = ((AbstractFSDatasetHandler)handler).buildOneProvider();
                        this.provider = providerAndSingleFile.provider;
                        this.singleFile = providerAndSingleFile.path;
                        break block15;
                    }
                    throw new IllegalArgumentException("Only fs-like datasets can have a fs provider");
                }
            }
            return this.provider;
        }

        public String getSingleFileInFSProvider() {
            if (this.provider == null) {
                throw new IllegalArgumentException("getFSProvider() must be called first");
            }
            return this.singleFile;
        }

        public boolean isSQLLike() {
            if (this.partitionable instanceof Dataset) {
                Dataset dataset = (Dataset)this.partitionable;
                return DatasetInspector.isSQL(dataset);
            }
            return false;
        }

        public ExecutionContext.SQLLikeTableLocation getSQLInfo() throws IOException, SQLException, DKUSecurityException {
            if (this.partitionable instanceof Dataset) {
                Dataset dataset = (Dataset)this.partitionable;
                final SQLUtils.SQLTable table = DatasetUtils.getResolvedTable(dataset, DatasetInspector.getDSSConnectionForSQLOrHiveDataset(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx(), dataset).getDialect(), true, false);
                return new ExecutionContext.SQLLikeTableLocation(){

                    public String getCatalog() {
                        return table.getCatalog();
                    }

                    public String getTable() {
                        return table.getTable();
                    }

                    public String getSchema() {
                        return table.getSchemaNullIfBlank();
                    }
                };
            }
            throw new IllegalArgumentException("Not a SQL-like dataset");
        }
    }

    private class FlowComputableOutputInfo
    extends FlowComputableInputOutputInfo
    implements ExecutionContext.OutputInfo {
        private final Partition partition;
        private final Output.WriteMode mode;

        FlowComputableOutputInfo(String role, FlowComputable computable, Partition partition, Output.WriteMode mode) throws IOException {
            super(role, computable);
            this.partition = partition;
            this.mode = mode;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Output.WriteMode getWriteMode() {
            return this.mode;
        }

        public OutputWriter pushToDataset() throws Exception {
            try (DatasetHandler handler = (DatasetHandler)this.getAsDataset().buildHandler(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx());){
                OutputWriter outputWriter = handler.buildOutput(this.partition, 0, 1, new WarningsContext()).getWriter(this.mode);
                return outputWriter;
            }
        }

        public void setSchema(Schema schema) throws Exception {
            Dataset dataset = this.getAsDataset();
            CustomJavaRecipeRunner.this.datasetWritingService.writeDatasetSchema(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx(), dataset.getDatasetLoc(), schema, false, null);
            KernelSession.propagateSchemaToJekOrBackend(dataset.getLoc().getFullName(), schema);
            dataset.setSchema(schema);
        }

        public void clear() throws Exception {
            try (DatasetHandler handler = (DatasetHandler)this.getAsDataset().buildHandler(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx());){
                handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.partition}));
            }
        }
    }

    private class FlowComputableInputInfo
    extends FlowComputableInputOutputInfo
    implements ExecutionContext.InputInfo {
        private final List<Partition> partitions;

        FlowComputableInputInfo(String role, FlowComputable computable, List<Partition> partitions) throws IOException {
            super(role, computable);
            this.partitions = partitions;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public void pullFromDataset(ProcessorOutput output, ColumnFactory cf, RowFactory rf) throws Exception {
            UniversalSingleThreadPusher.push(CustomJavaRecipeRunner.this.authCtxService.getAuthCtx(), this.getAsDataset(), output, cf, rf);
        }

        public Schema getSchema() {
            return this.getAsDataset().getSchema();
        }
    }
}

